/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.mixin;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.UseCrossbowEntity;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.item.NotNormalCrossbow;
import com.jerotes.jerotes.item.tool.ItemToolBaseCrossbow;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin
extends ProjectileWeaponItem {
    @Shadow
    private static void m_40928_(ItemStack p_40929_, ItemStack p_40930_) {
    }

    @Shadow
    public static void m_40887_(Level p_40888_, LivingEntity p_40889_, InteractionHand p_40890_, ItemStack p_40891_, float p_40892_, float p_40893_) {
    }

    @Shadow
    public static boolean m_40932_(ItemStack p_40933_) {
        return false;
    }

    @Unique
    private static AbstractArrow jerotes_villager_$getArrow(Level level, LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack2) {
        ArrowItem arrowitem = (ArrowItem)(itemStack2.m_41720_() instanceof ArrowItem ? itemStack2.m_41720_() : Items.f_42412_);
        AbstractArrow abstractarrow = arrowitem.m_6394_(level, itemStack2, livingEntity);
        if (livingEntity instanceof Player) {
            abstractarrow.m_36762_(true);
        }
        abstractarrow.m_36740_(SoundEvents.f_11840_);
        abstractarrow.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
        if (i > 0) {
            abstractarrow.m_36767_((byte)i);
        }
        return abstractarrow;
    }

    public CrossbowItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"shootProjectile"}, at={@At(value="HEAD")}, cancellable=true)
    private static void shootProjectile(Level level, LivingEntity livingEntity, InteractionHand interactionHand, ItemStack itemStack, ItemStack itemStack2, float f, boolean bl, float f2, float f3, float f4, CallbackInfo ci) {
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolBaseCrossbow) {
            ItemToolBaseCrossbow shrapnelLauncher = (ItemToolBaseCrossbow)item;
            shrapnelLauncher.customShootProjectile(level, livingEntity, interactionHand, itemStack, itemStack2, f, bl, f2, f3, f4);
        }
        if (livingEntity instanceof JerotesEntity || MainConfig.AffectsNonThisModEntities) {
            if (!level.f_46443_) {
                AbstractArrow projectile;
                boolean flag = itemStack2.m_150930_(Items.f_42688_);
                if (flag) {
                    projectile = new FireworkRocketEntity(level, itemStack2, (Entity)livingEntity, livingEntity.m_20185_(), livingEntity.m_20188_() - (double)0.15f, livingEntity.m_20189_(), true);
                } else {
                    projectile = CrossbowItemMixin.jerotes_villager_$getArrow(level, livingEntity, itemStack, itemStack2);
                    if (bl || f4 != 0.0f) {
                        projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                }
                if (livingEntity instanceof CrossbowAttackMob) {
                    ItemToolBaseCrossbow itemToolBaseCrossbow;
                    CrossbowAttackMob crossbowattackmob = (CrossbowAttackMob)livingEntity;
                    Item item2 = itemStack.m_41720_();
                    if (item2 instanceof ItemToolBaseCrossbow && (itemToolBaseCrossbow = (ItemToolBaseCrossbow)item2).useBaseShootArrow() && livingEntity.m_217043_().m_188501_() <= itemToolBaseCrossbow.customBaseShootArrowChance(livingEntity) && projectile.m_6095_() == EntityType.f_20548_ && projectile instanceof Arrow) {
                        Arrow arrow = (Arrow)projectile;
                        if (PotionUtils.m_43579_((ItemStack)itemStack2) == Potions.f_43598_) {
                            projectile = itemToolBaseCrossbow.customBaseShootArrow(livingEntity, itemStack);
                            if (bl || f4 != 0.0f) {
                                projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                            }
                        }
                    }
                    crossbowattackmob.m_5811_(Objects.requireNonNull(crossbowattackmob.m_5448_()), itemStack, (Projectile)projectile, f4);
                } else {
                    Vec3 vec3 = livingEntity.m_20289_(1.0f);
                    Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(f4 * ((float)Math.PI / 180)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    Vec3 vec31 = livingEntity.m_20252_(1.0f);
                    Vector3f vector3f = vec31.m_252839_().rotate((Quaternionfc)quaternionf);
                    projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), f2, f3);
                }
                if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && livingEntity.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK)) {
                    itemStack.m_41622_(flag ? 3 : 1, livingEntity, players -> players.m_21190_(interactionHand));
                }
                level.m_7967_((Entity)projectile);
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, f);
            }
            ci.cancel();
        }
    }

    @Inject(method={"loadProjectile"}, at={@At(value="HEAD")}, cancellable=true)
    private static void loadProjectile(LivingEntity p_40863_, ItemStack p_40864_, ItemStack itemStack1, boolean p_40866_, boolean p_40867_, CallbackInfoReturnable<Boolean> cir) {
        if (p_40863_ instanceof UseCrossbowEntity && !MainConfig.MobUseCrossbowShrinkArrow) {
            if (itemStack1.m_41619_()) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            } else {
                ItemStack itemStack2;
                boolean flag;
                boolean bl = flag = p_40867_ && itemStack1.m_41720_() instanceof ArrowItem;
                if (!(flag || p_40867_ || p_40866_)) {
                    int i = Math.min(1, itemStack1.m_41613_());
                    itemStack2 = itemStack1.m_255036_(i);
                    if (itemStack1.m_41619_() && p_40863_ instanceof Player) {
                        ((Player)p_40863_).m_150109_().m_36057_(itemStack1);
                    }
                } else {
                    itemStack2 = itemStack1.m_41777_();
                }
                CrossbowItemMixin.m_40928_(p_40864_, itemStack2);
                cir.setReturnValue((Object)true);
                cir.cancel();
            }
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void use(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemToolBaseCrossbow crossbow;
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolBaseCrossbow && (crossbow = (ItemToolBaseCrossbow)item).useCustomUse()) {
            cir.setReturnValue(crossbow.customUse(level, player, interactionHand));
        }
        if ((item = itemStack.m_41720_()) instanceof ItemToolBaseCrossbow) {
            ItemToolBaseCrossbow itemToolBaseCrossbow = (ItemToolBaseCrossbow)item;
            if (CrossbowItemMixin.m_40932_(itemStack)) {
                CrossbowItemMixin.m_40887_(level, (LivingEntity)player, interactionHand, itemStack, itemToolBaseCrossbow.m_40945_(itemStack), 1.0f);
                if (ItemToolBaseCrossbow.getBullet(itemStack) > 1) {
                    ItemToolBaseCrossbow.setBullet(itemStack, ItemToolBaseCrossbow.getBullet(itemStack) - 1);
                    int n = itemToolBaseCrossbow.mobUseCooldownTick(itemStack);
                    if (n > 4) {
                        player.m_36335_().m_41524_(itemStack.m_41720_(), n);
                    }
                } else {
                    ItemToolBaseCrossbow.setBullet(itemStack, 0);
                    ItemToolBaseCrossbow.m_40884_((ItemStack)itemStack, (boolean)false);
                }
                cir.setReturnValue((Object)InteractionResultHolder.m_19096_((Object)itemStack));
            }
        }
    }

    @Inject(method={"clearChargedProjectiles"}, at={@At(value="HEAD")}, cancellable=true)
    private static void clearChargedProjectiles(ItemStack itemStack, CallbackInfo ci) {
        if (itemStack.m_41720_() instanceof ItemToolBaseCrossbow && ItemToolBaseCrossbow.getBullet(itemStack) > 1) {
            ci.cancel();
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void appendHoverText(ItemStack itemStack, Level p_40881_, List<Component> p_40882_, TooltipFlag p_40883_, CallbackInfo ci) {
        if (itemStack.m_41720_() instanceof NotNormalCrossbow) {
            ci.cancel();
        }
    }
}

