/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.mixin;

import com.jerotes.jerotes.item.ItemBeastArmor;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Horse.class})
public abstract class HorseMixin
extends AbstractHorse {
    @Unique
    private static final UUID ARMOR_TOUGHNESS_MODIFIER_UUID = UUID.fromString("5b87399a-c768-4ea5-a08f-4b36e7fa1d34");
    @Unique
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("12c0b1a0-18c1-4047-a6b6-f71dc7fe87ee");

    protected HorseMixin(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"setArmorEquipment"}, at={@At(value="TAIL")})
    private void setArmorEquipment(ItemStack itemStack, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            double n3;
            ItemBeastArmor armor;
            double n2;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22120_(ARMOR_TOUGHNESS_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof ItemBeastArmor && (n2 = (armor = (ItemBeastArmor)item).getToughness()) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22118_(new AttributeModifier(ARMOR_TOUGHNESS_MODIFIER_UUID, "War Beast Armor toughness bonus", n2, AttributeModifier.Operation.ADDITION));
            }
            if ((item = itemStack.m_41720_()) instanceof ItemBeastArmor && (n3 = (armor = (ItemBeastArmor)item).getKnockbackResistance() * 0.1) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "War Beast Armor knockback resistance bonus", n3, AttributeModifier.Operation.ADDITION));
            }
        }
    }
}

