/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.mixin;

import com.jerotes.jerotes.entity.JerotesChangeLivingEntity;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import com.jerotes.jerotes.network.JerotesSpearRushAttackPacket;
import com.jerotes.jerotes.network.PacketHandler;
import com.jerotes.jerotes.util.EntityFactionFind;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements JerotesChangeLivingEntity {
    @Shadow
    protected int f_20936_;
    @Shadow
    protected ItemStack f_20935_;
    @Nullable
    protected Object2LongMap<Entity> recentKineticEnemiesJerotes;

    protected LivingEntityMixin(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Shadow
    public abstract int m_21212_();

    @Shadow
    protected abstract void m_8095_();

    @Shadow
    public abstract InteractionHand m_7655_();

    @Override
    public boolean canAddPassengerJerotes(Entity entity) {
        return this.m_7310_(entity);
    }

    @Override
    public boolean wasRecentlyStabbedJerotes(Entity entity) {
        if (this.recentKineticEnemiesJerotes == null) {
            return false;
        }
        if (this.recentKineticEnemiesJerotes.containsKey((Object)entity)) {
            return this.m_9236_().m_46467_() - this.recentKineticEnemiesJerotes.getLong((Object)entity) < 10L;
        }
        return false;
    }

    @Override
    public void rememberStabbedEntityJerotes(Entity entity) {
        if (this.recentKineticEnemiesJerotes != null) {
            this.recentKineticEnemiesJerotes.put((Object)entity, this.m_9236_().m_46467_());
        }
    }

    @Inject(method={"startUsingItem"}, at={@At(value="TAIL")})
    private void startUsingItem(InteractionHand p_21159_, CallbackInfo ci) {
        if (!this.m_9236_().m_5776_() && this.f_20935_.m_41720_() instanceof ItemToolBaseSpearBase) {
            this.recentKineticEnemiesJerotes = new Object2LongOpenHashMap();
        }
    }

    @Inject(method={"updateUsingItem"}, at={@At(value="HEAD")})
    private void updateUsingItem(ItemStack itemStack, CallbackInfo ci) {
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolBaseSpearBase) {
            ItemToolBaseSpearBase itemToolBaseSpearBase = (ItemToolBaseSpearBase)item;
            if (this.m_9236_().m_5776_()) {
                PacketHandler.sendToServer(new JerotesSpearRushAttackPacket(itemStack, this.m_21212_(), ((LivingEntity)this).m_19879_()));
            }
        }
    }

    @Inject(method={"getVisibilityPercent"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVisibilityPercent(Entity entity, CallbackInfoReturnable<Double> cir) {
        if (entity != null && this.m_21023_((MobEffect)JerotesMobEffects.CLOAKING.get())) {
            int cloakingLevel = Objects.requireNonNull(this.m_21124_((MobEffect)JerotesMobEffects.CLOAKING.get())).m_19564_() + 1;
            if (this.m_20270_(entity) > (float)(48 - cloakingLevel * 8)) {
                cir.setReturnValue((Object)0.0);
            }
        }
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canAttack(LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction(self, livingEntity)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

