/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.spell;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.forge.JerotesUseSpellEvent;
import com.jerotes.jerotes.init.JerotesMobEffectTags;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.spell.MagicType;
import com.jerotes.jerotes.spell.SpellFind;
import com.jerotes.jerotes.spell.SpellRegistry;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MagicSpell {
    public int spellLevel;
    public LivingEntity caster;
    public Entity target;
    public MagicType magicType;
    public MagicType magicType2;
    public String spellId;
    public ParticleOptions spellDisplayParticle;
    public SoundEvent spellSound;

    public MagicSpell(int spellLevel, LivingEntity caster, Entity target, MagicType magicType, MagicType magicType2, String spellId, ParticleOptions spellDisplayParticle) {
        this.spellLevel = spellLevel;
        this.caster = caster;
        this.target = target;
        this.magicType = magicType;
        this.magicType2 = magicType2;
        this.spellId = spellId;
        this.spellDisplayParticle = spellDisplayParticle;
    }

    public MagicSpell(int spellLevel, LivingEntity caster, Entity target, MagicType magicType, MagicType magicType2, String spellId, ParticleOptions spellDisplayParticle, SoundEvent spellSound) {
        this(spellLevel, caster, target, magicType, magicType2, spellId, spellDisplayParticle);
        this.spellSound = spellSound;
    }

    public boolean spellUse() {
        boolean bl;
        if (!this.canUse()) {
            return false;
        }
        Level level = this.getCaster().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(this.getSpellDisplayParticle(), this.caster.m_20185_(), this.caster.m_20191_().f_82292_ + 0.5, this.caster.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.getSound() != null && this.getCaster() != null && this.canUse()) {
            this.getCaster().m_5496_(this.getSound(), EntityAndItemFind.isBoss(this.getCaster().m_6095_()) ? 5.0f : (this.getCaster() instanceof EliteEntity ? 2.0f : 1.0f) * this.getSoundLevel(), 1.0f);
        }
        this.getCaster().m_9236_().m_9598_().m_175515_(Registries.f_256929_).m_206058_(JerotesMobEffectTags.REMOVE_AFTER_SPELL).forEach(effect -> {
            if (this.getCaster().m_21023_((MobEffect)effect.get()) && !this.getCaster().m_9236_().m_5776_()) {
                this.getCaster().m_21195_((MobEffect)effect.get());
            }
        });
        this.getCaster().getPersistentData().m_128359_("jerotes_last_magic", this.getSpellModId() + "_" + this.getSpellId());
        this.getCaster().getPersistentData().m_128347_("jerotes_spell_cooldown", Math.max(2.0, this.caster.getPersistentData().m_128459_("jerotes_spell_cooldown")));
        if (!this.canEffect()) {
            return false;
        }
        if (this.baseSpellLevel() > this.spellLevel) {
            this.spellLevel = this.baseSpellLevel();
        }
        if (bl = this.spellFindUse()) {
            this.spellAfterUse();
        }
        return bl;
    }

    public boolean spellFindUse() {
        return false;
    }

    public void spellAfterUse() {
    }

    public boolean canUse() {
        return this.getCaster() == null || !(this.getCaster().getPersistentData().m_128459_("jerotes_spell_cooldown") > 0.0);
    }

    public boolean canEffect() {
        LivingEntity livingEntity2;
        Object object;
        JerotesUseSpellEvent event = new JerotesUseSpellEvent(this.getCaster(), this.getTarget(), this.getSpellLevel());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        this.caster = event.getCaster();
        this.target = event.getTarget();
        this.spellLevel = event.getLevel();
        if (this.canBeBreak() && !this.isHelp() && (object = this.getTarget()) instanceof LivingEntity && (livingEntity2 = (LivingEntity)object).m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) && this.getCaster() != this.getTarget() && this.getCaster().m_20270_(this.getTarget()) <= 32.0f && (!MainConfig.SameFactionAvoidDamage || !AttackFind.SameFactionAvoidDamage((Entity)this.getCaster(), livingEntity2)) && Objects.requireNonNull(livingEntity2.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get())).m_19564_() + 1 >= this.getSpellLevel()) {
            SpellRegistry.getSpellTypeById(this.getSpellModId() + "_" + this.getSpellId()).stop(this.getCaster(), Objects.requireNonNull(livingEntity2.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get())).m_19564_() + 1, false);
            if (!livingEntity2.m_9236_().m_5776_()) {
                livingEntity2.m_21195_((MobEffect)JerotesMobEffects.COUNTERSPELL.get());
            }
            livingEntity2.m_6674_(InteractionHand.MAIN_HAND);
            SpellFind.Counterspell(livingEntity2);
            return false;
        }
        if (this.canBeBreak()) {
            List list = this.getCaster().m_9236_().m_45976_(LivingEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
            list.removeIf(livingEntity -> !livingEntity.m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) || livingEntity == this.getCaster());
            list.removeIf(livingEntity -> AttackFind.FindCanNotAttack(livingEntity, (Entity)this.getCaster()));
            list.removeIf(livingEntity -> {
                Mob mob;
                return livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() != this.getCaster();
            });
            list.removeIf(livingEntity -> {
                if (!(livingEntity instanceof Player)) return false;
                Player player = (Player)livingEntity;
                if (!player.f_20911_) return true;
                if (Main.getTargetedEntity(player, 32.0) == this.getCaster()) return false;
                return true;
            });
            if (!list.isEmpty()) {
                for (LivingEntity target : list) {
                    if (this.isHelp() && target == this.getTarget() || MainConfig.SameFactionAvoidDamage && AttackFind.SameFactionAvoidDamage((Entity)this.getCaster(), target) || Objects.requireNonNull(target.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get())).m_19564_() + 1 < this.getSpellLevel()) continue;
                    if (!target.m_9236_().m_5776_()) {
                        target.m_21195_((MobEffect)JerotesMobEffects.COUNTERSPELL.get());
                    }
                    target.m_6674_(InteractionHand.MAIN_HAND);
                    SpellFind.Counterspell(target);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canBeBreak() {
        return true;
    }

    public int baseSpellLevel() {
        return 1;
    }

    public int getSpellLevel() {
        return Math.max(this.baseSpellLevel(), this.spellLevel);
    }

    public int getSpellAccuracy() {
        LivingEntity livingEntity;
        if (this.getCaster() != null && this.getCaster() instanceof Player) {
            return 0;
        }
        if (this.getCaster() != null && (livingEntity = this.getCaster()) instanceof SpellUseEntity) {
            SpellUseEntity spellUse = (SpellUseEntity)livingEntity;
            return Math.max(0, -spellUse.getSpellLevel() + 3);
        }
        return Math.max(0, -this.getSpellLevel() + 3);
    }

    public LivingEntity getCaster() {
        return this.caster;
    }

    public Entity getTarget() {
        return this.target;
    }

    public String getSpellModId() {
        return "jerotes";
    }

    public String getSpellId() {
        return this.spellId;
    }

    public Component getSpellName() {
        return Component.m_237115_((String)("spell." + this.getSpellModId() + "." + this.getSpellId()));
    }

    public Component getSpellDesc() {
        return Component.m_237115_((String)("spell." + this.getSpellModId() + "." + this.getSpellId() + ".desc"));
    }

    public ParticleOptions getSpellDisplayParticle() {
        return this.spellDisplayParticle;
    }

    public MagicType getMagicType() {
        return this.magicType;
    }

    public MagicType getMagicType2() {
        return this.magicType2;
    }

    public SoundEvent getSound() {
        return this.spellSound;
    }

    public float getSoundLevel() {
        return 1.0f;
    }

    public boolean isMelee() {
        return false;
    }

    public boolean isHelp() {
        return false;
    }

    public boolean canUseTargetNone() {
        return false;
    }

    public float shouldBeSelf() {
        return 0.8f;
    }

    public float getSpellDistance() {
        return 64.0f;
    }

    public boolean canUseToEntity(Entity entity) {
        return true;
    }

    public boolean mobUseInCombat() {
        return true;
    }

    public int playerUseCooldownTick(Player player) {
        if (this.getMagicType2() == MagicType.MAIN) {
            return 120;
        }
        if (this.getMagicType2() == MagicType.ADD) {
            return 120;
        }
        return 120;
    }
}

