/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.spell;

import com.jerotes.jerotes.entity.magic.MagicMissile.MagicMissileEntity;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.network.JerotesPlayerData;
import com.jerotes.jerotes.spell.SpellType;
import com.jerotes.jerotes.util.Main;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jerotes")
public class SpellFindUseEvent {
    public static int GetMainSpellUseCoolDownTick(Player player) {
        return ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).MainSpellUseCoolDownTick;
    }

    public static int GetMainSpellUseCoolDownTickMax(Player player) {
        return ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).MainSpellUseCoolDownTickMax;
    }

    public static int GetAddSpellUseCoolDownTick(Player player) {
        return ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).AddSpellUseCoolDownTick;
    }

    public static int GetAddSpellUseCoolDownTickMax(Player player) {
        return ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).AddSpellUseCoolDownTickMax;
    }

    public static int GetMainMainSpellTargetLevel(Player player) {
        return ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).MainSpellTargetLevel;
    }

    public static int GetAddSpellTargetLevel(Player player) {
        return ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).AddSpellTargetLevel;
    }

    @SubscribeEvent
    public static void SpellTick(LivingEvent.LivingTickEvent event) {
        LivingEntity caster = event.getEntity();
        if (caster == null) {
            return;
        }
        Main.persistentDataDoubleReduceToZero(caster, "jerotes_spell_cooldown", true);
        if (caster instanceof Player) {
            Player player = (Player)caster;
            if (SpellFindUseEvent.GetMainSpellUseCoolDownTick(player) > SpellFindUseEvent.GetMainSpellUseCoolDownTickMax(player)) {
                player.getCapability(JerotesPlayerData.CAPABILITY, null).ifPresent(capability -> capability.setMainSpellUseCoolDownTickMax(SpellFindUseEvent.GetMainSpellUseCoolDownTick(player)));
            }
            if (SpellFindUseEvent.GetAddSpellUseCoolDownTick(player) > SpellFindUseEvent.GetAddSpellUseCoolDownTickMax(player)) {
                player.getCapability(JerotesPlayerData.CAPABILITY, null).ifPresent(capability -> capability.setAddSpellUseCoolDownTickMax(SpellFindUseEvent.GetAddSpellUseCoolDownTick(player)));
            }
            if (SpellFindUseEvent.GetMainSpellUseCoolDownTick(player) > 0) {
                if (!player.m_9236_().m_5776_()) {
                    ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).syncPlayerVariables((Entity)player);
                }
                player.getCapability(JerotesPlayerData.CAPABILITY, null).ifPresent(capability -> capability.setMainSpellUseCoolDownTick(SpellFindUseEvent.GetMainSpellUseCoolDownTick(player) - 1));
            } else if (SpellFindUseEvent.GetMainSpellUseCoolDownTickMax(player) != 0) {
                if (!player.m_9236_().m_5776_()) {
                    ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).syncPlayerVariables((Entity)player);
                }
                player.getCapability(JerotesPlayerData.CAPABILITY, null).ifPresent(capability -> capability.setMainSpellUseCoolDownTickMax(0));
            }
            if (SpellFindUseEvent.GetAddSpellUseCoolDownTick(player) > 0) {
                if (!player.m_9236_().m_5776_()) {
                    ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).syncPlayerVariables((Entity)player);
                }
                player.getCapability(JerotesPlayerData.CAPABILITY, null).ifPresent(capability -> capability.setAddSpellUseCoolDownTick(SpellFindUseEvent.GetAddSpellUseCoolDownTick(player) - 1));
            } else if (SpellFindUseEvent.GetAddSpellUseCoolDownTickMax(player) != 0) {
                if (!player.m_9236_().m_5776_()) {
                    ((JerotesPlayerData.PlayerVariables)player.getCapability(JerotesPlayerData.CAPABILITY, null).orElse((Object)new JerotesPlayerData.PlayerVariables())).syncPlayerVariables((Entity)player);
                }
                player.getCapability(JerotesPlayerData.CAPABILITY, null).ifPresent(capability -> capability.setAddSpellUseCoolDownTickMax(0));
            }
        }
        Main.persistentDataDoubleReduceToZero(caster, "jerotes_fire_absorption", true);
        Main.persistentDataDoubleReduceToZero(caster, "jerotes_freeze_absorption", true);
        Main.persistentDataDoubleReduceToZero(caster, "jerotes_lightning_absorption", true);
        if (caster.getPersistentData().m_128459_("jerotes_magic_missile") > 0.0) {
            Level level;
            caster.getPersistentData().m_128347_("jerotes_magic_missile", caster.getPersistentData().m_128459_("jerotes_magic_missile") - 1.0);
            caster.getPersistentData().m_128347_("jerotes_spell_cooldown", Math.max(2.0, caster.getPersistentData().m_128459_("jerotes_spell_cooldown")));
            if (caster.getPersistentData().m_128459_("jerotes_magic_missile") % 3.0 == 0.0 && (level = caster.m_9236_()) instanceof ServerLevel) {
                LivingEntity livingEntity;
                ServerLevel serverLevel = (ServerLevel)level;
                int spellLevelDamage = caster.getPersistentData().m_128451_("jerotes_magic_missile_spellLevelDamage");
                UUID targetUUID = caster.getPersistentData().m_128342_("jerotes_magic_missile_target");
                Entity entity = serverLevel.m_8791_(targetUUID);
                if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) || livingEntity.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()).m_19564_() + 1 < spellLevelDamage) {
                    float spellLevelAccuracy = caster.getPersistentData().m_128457_("jerotes_magic_missile_spellLevelAccuracy");
                    int count = caster.getPersistentData().m_128451_("jerotes_magic_missile_count");
                    float distance = caster.getPersistentData().m_128457_("jerotes_magic_missile_distance");
                    for (int i = 0; i < count; ++i) {
                        Mob mob;
                        if (caster instanceof Mob && (mob = (Mob)caster).m_5448_() != null) {
                            mob.m_21391_((Entity)mob.m_5448_(), 360.0f, 360.0f);
                        }
                        double d2 = caster.m_20154_().f_82479_;
                        double d3 = caster.m_20154_().f_82480_;
                        double d4 = caster.m_20154_().f_82481_;
                        MagicMissileEntity spell = new MagicMissileEntity(spellLevelDamage, (Level)serverLevel, caster, d2, d3, d4);
                        spell.m_6034_(caster.m_20185_(), caster.m_20227_(0.7), caster.m_20189_());
                        spell.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_() - (float)(count - 1) * distance / 2.0f + (float)i * distance, 0.0f, 1.0f, spellLevelAccuracy);
                        spell.m_5602_((Entity)caster);
                        if (serverLevel.m_8791_(targetUUID) != null && serverLevel.m_8791_(targetUUID) != caster) {
                            spell.setTarget(serverLevel.m_8791_(targetUUID));
                        }
                        serverLevel.m_7967_((Entity)spell);
                    }
                    if (!caster.m_20067_()) {
                        caster.m_5496_(JerotesSounds.MAGIC_MAGIC_MISSILE, 1.0f, 1.0f);
                    }
                }
            }
        } else if (caster.getPersistentData().m_128423_("jerotes_magic_missile") != null) {
            Main.persistentDataRemove(caster, "jerotes_magic_missile");
            Main.persistentDataRemove(caster, "jerotes_magic_missile_spellLevelDamage");
            Main.persistentDataRemove(caster, "jerotes_magic_missile_target");
            Main.persistentDataRemove(caster, "jerotes_magic_missile_spellLevelAccuracy");
            Main.persistentDataRemove(caster, "jerotes_magic_missile_count");
            Main.persistentDataRemove(caster, "jerotes_magic_missile_distance");
        }
    }

    @SubscribeEvent
    public static void CasterDeath(LivingDeathEvent event) {
        LivingEntity caster = event.getEntity();
        if (caster == null) {
            return;
        }
        Main.persistentDataRemove(caster, "jerotes_main_spell_cooldown");
        Main.persistentDataRemove(caster, "jerotes_add_spell_cooldown");
        Main.persistentDataRemove(caster, "jerotes_main_spell_cooldown_max");
        Main.persistentDataRemove(caster, "jerotes_add_spell_cooldown_max");
        Main.persistentDataRemove(caster, "jerotes_fire_absorption");
        Main.persistentDataRemove(caster, "jerotes_freeze_absorption");
        Main.persistentDataRemove(caster, "jerotes_lightning_absorption");
        SpellType.stops(caster, 10, true);
    }
}

