/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.spell;

import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesParticleTypes;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.spell.MagicSpell;
import com.jerotes.jerotes.spell.MagicType;
import com.jerotes.jerotes.spell.SpellFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;

public class SpellList {
    public static MagicSpell MagicMissile(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "magic_missile", (ParticleOptions)JerotesParticleTypes.MAGIC_MISSILE_DISPLAY.get(), JerotesSounds.MAGIC_MAGIC_MISSILE){

            @Override
            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return SpellFind.MagicMissile(this.getCaster(), (Entity)((entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster()), this.getSpellLevel(), this.getSpellAccuracy(), 1, 1.0f, 3 + this.getSpellLevel(), this.getCaster() instanceof Player);
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell PoisonBreath(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "poison_breath", (ParticleOptions)JerotesParticleTypes.POISON_BREATH_DISPLAY.get(), JerotesSounds.MAGIC_POISON_BREATH){

            @Override
            public boolean spellFindUse() {
                return SpellFind.PoisonBreath(this.getCaster(), this.getTarget(), 2 * this.getSpellLevel(), this.getSpellLevel() * 2, this.getSpellLevel() * 6, this.getSpellLevel(), this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }
        };
    }

    public static MagicSpell RayofSickness(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "ray_of_sickness", (ParticleOptions)JerotesParticleTypes.RAY_OF_SICKNESS_DISPLAY.get(), JerotesSounds.MAGIC_RAY_OF_SICKNESS){

            @Override
            public boolean spellFindUse() {
                return SpellFind.RayofSickness(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel() * 4, this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }
        };
    }

    public static MagicSpell RayofEnfeeblement(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "ray_of_enfeeblement", (ParticleOptions)JerotesParticleTypes.RAY_OF_ENFEEBLEMENT_DISPLAY.get(), JerotesSounds.MAGIC_RAY_OF_ENFEEBLEMENT){

            @Override
            public boolean spellFindUse() {
                return SpellFind.RayofEnfeeblement(this.getCaster(), this.getTarget(), this.getSpellLevel() * 6, this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public int baseSpellLevel() {
                return 2;
            }
        };
    }

    public static MagicSpell LightningBolt(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "lightning_bolt", (ParticleOptions)JerotesParticleTypes.LIGHTNING_BOLT_DISPLAY.get(), JerotesSounds.MAGIC_LIGHTNING_BOLT){

            @Override
            public boolean spellFindUse() {
                return SpellFind.LightningBolt(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell ViciousMockery(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "vicious_mockery", (ParticleOptions)JerotesParticleTypes.VICIOUS_MOCKERY_DISPLAY.get(), JerotesSounds.MAGIC_VICIOUS_MOCKERY){

            @Override
            public boolean spellFindUse() {
                return SpellFind.ViciousMockery(this.getCaster(), this.getTarget(), this.getSpellLevel());
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public float getSpellDistance() {
                return 32.0f;
            }
        };
    }

    public static MagicSpell HoldPerson(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "hold_person", (ParticleOptions)JerotesParticleTypes.HOLD_PERSON_DISPLAY.get(), JerotesSounds.MAGIC_HOLD_PERSON){

            @Override
            public boolean spellFindUse() {
                return SpellFind.HoldPerson(this.getCaster(), this.getTarget(), this.getSpellLevel() * 6, 1, Math.max(1, this.getSpellLevel() - 1));
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public int baseSpellLevel() {
                return 2;
            }

            @Override
            public float getSpellDistance() {
                return 32.0f;
            }

            @Override
            public boolean canUseToEntity(Entity entity) {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && EntityFactionFind.isHumanoid(livingEntity = (LivingEntity)entity) && super.canUseToEntity(entity);
            }
        };
    }

    public static MagicSpell BestowCurse(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "bestow_curse", (ParticleOptions)JerotesParticleTypes.BESTOW_CURSE_DISPLAY.get(), JerotesSounds.MAGIC_BESTOW_CURSE){

            @Override
            public boolean spellFindUse() {
                return SpellFind.BestowCurse(this.getCaster(), this.getTarget(), this.getSpellLevel() * 6, this.getSpellLevel());
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public int baseSpellLevel() {
                return 3;
            }

            @Override
            public boolean isMelee() {
                return true;
            }

            @Override
            public float getSpellDistance() {
                return 6.0f;
            }
        };
    }

    public static MagicSpell PhantasmalKiller(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "phantasmal_killer", (ParticleOptions)JerotesParticleTypes.PHANTASMAL_KILLER_DISPLAY.get(), JerotesSounds.MAGIC_PHANTASMAL_KILLER){

            @Override
            public boolean spellFindUse() {
                return SpellFind.PhantasmalKiller(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel() * 6, this.getSpellLevel());
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public int baseSpellLevel() {
                return 4;
            }

            @Override
            public float getSpellDistance() {
                return 32.0f;
            }

            @Override
            public boolean canUseToEntity(Entity entity) {
                LivingEntity livingEntity;
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)JerotesMobEffects.PHANTASMAL_KILLER.get()) && Objects.requireNonNull(livingEntity.m_21124_((MobEffect)JerotesMobEffects.PHANTASMAL_KILLER.get())).m_19564_() >= this.getSpellLevel() - 1) {
                    return false;
                }
                return super.canUseToEntity(entity);
            }
        };
    }

    public static MagicSpell Eyebite(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "eyebite", (ParticleOptions)JerotesParticleTypes.EYEBITE_DISPLAY.get(), JerotesSounds.MAGIC_EYEBITE){

            @Override
            public boolean spellFindUse() {
                return SpellFind.Eyebite(this.getCaster(), this.getTarget(), this.getSpellLevel() * 6, this.getSpellLevel());
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public int baseSpellLevel() {
                return 6;
            }

            @Override
            public float getSpellDistance() {
                return 32.0f;
            }
        };
    }

    public static MagicSpell FireAbsorption(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.ADD, "fire_absorption", (ParticleOptions)JerotesParticleTypes.FIRE_ABSORPTION_DISPLAY.get(), JerotesSounds.MAGIC_FIRE_ABSORPTION){

            @Override
            public boolean spellFindUse() {
                return !this.caster.m_9236_().m_5776_() && this.caster.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get(), this.getSpellLevel() * 6 * 20, this.getSpellLevel() - 1));
            }

            @Override
            public float getSpellDistance() {
                return 2.0f;
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null && this.getCaster().m_21023_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get()) && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get())).m_19564_() >= this.getSpellLevel() - 1 && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get())).m_19557_() > 120 && !(this.getCaster() instanceof Player)) {
                    return false;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell FreezeAbsorption(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.ADD, "freeze_absorption", (ParticleOptions)JerotesParticleTypes.FREEZE_ABSORPTION_DISPLAY.get(), JerotesSounds.MAGIC_FREEZE_ABSORPTION){

            @Override
            public boolean spellFindUse() {
                return !this.caster.m_9236_().m_5776_() && this.caster.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get(), this.getSpellLevel() * 6 * 20, this.getSpellLevel() - 1));
            }

            @Override
            public float getSpellDistance() {
                return 2.0f;
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null && this.getCaster().m_21023_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get()) && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get())).m_19564_() >= this.getSpellLevel() - 1 && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get())).m_19557_() > 120 && !(this.getCaster() instanceof Player)) {
                    return false;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell LightningAbsorption(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.ADD, "lightning_absorption", (ParticleOptions)JerotesParticleTypes.LIGHTNING_ABSORPTION_DISPLAY.get(), JerotesSounds.MAGIC_LIGHTNING_ABSORPTION){

            @Override
            public boolean spellFindUse() {
                return !this.caster.m_9236_().m_5776_() && this.caster.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get(), this.getSpellLevel() * 6 * 20, this.getSpellLevel() - 1));
            }

            @Override
            public float getSpellDistance() {
                return 2.0f;
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null && this.getCaster().m_21023_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get()) && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get())).m_19564_() >= this.getSpellLevel() - 1 && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get())).m_19557_() > 120 && !(this.getCaster() instanceof Player)) {
                    return false;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell CureWounds(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "cure_wounds", (ParticleOptions)JerotesParticleTypes.CURE_WOUNDS_DISPLAY.get(), JerotesSounds.MAGIC_CURE_WOUNDS){

            @Override
            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return SpellFind.CureWounds(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel());
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public boolean canUseTargetNone() {
                return true;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public float getSpellDistance() {
                return 6.0f;
            }

            @Override
            public float shouldBeSelf() {
                return 0.7f;
            }

            @Override
            public boolean mobUseInCombat() {
                return false;
            }

            @Override
            public boolean canUseToEntity(Entity entity) {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21223_() < livingEntity.m_21233_() && livingEntity.m_6336_() != MobType.f_21641_ && !EntityFactionFind.isMachine(livingEntity) && !EntityFactionFind.isConstruct(livingEntity) && super.canUseToEntity(entity);
            }
        };
    }

    public static MagicSpell MistyStep(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.ADD, "misty_step", (ParticleOptions)JerotesParticleTypes.MISTY_STEP_DISPLAY.get(), JerotesSounds.MAGIC_MISTY_STEP){

            @Override
            public boolean spellFindUse() {
                return SpellFind.MistyStep(this.getCaster(), 30, 16, this.getCaster() instanceof Player);
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public float getSpellDistance() {
                return 30.0f;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null && !this.getCaster().m_20096_() && !Main.isInFluid(this.getCaster())) {
                    return false;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell MirrorImage(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "mirror_image", (ParticleOptions)JerotesParticleTypes.MIRROR_IMAGE_DISPLAY.get(), JerotesSounds.MAGIC_MIRROR_IMAGE){

            @Override
            public boolean spellFindUse() {
                return SpellFind.MirrorImage(this.getCaster(), 3, this.getSpellLevel());
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public float getSpellDistance() {
                return 2.0f;
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public int baseSpellLevel() {
                return 2;
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null) {
                    if (this.getCaster().getPersistentData().m_128423_("jerotes_has_mirror_image_1_tick") != null && this.getCaster().getPersistentData().m_128459_("jerotes_has_mirror_image_1_tick") > 0.0) {
                        return false;
                    }
                    if (this.getCaster().getPersistentData().m_128423_("jerotes_has_mirror_image_2_tick") != null && this.getCaster().getPersistentData().m_128459_("jerotes_has_mirror_image_2_tick") > 0.0) {
                        return false;
                    }
                    if (this.getCaster().getPersistentData().m_128423_("jerotes_has_mirror_image_3_tick") != null && this.getCaster().getPersistentData().m_128459_("jerotes_has_mirror_image_3_tick") > 0.0) {
                        return false;
                    }
                    return super.canUse();
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell InvisiblePassage(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.ADD, "invisible_passage", (ParticleOptions)JerotesParticleTypes.INVISIBLE_PASSAGE_DISPLAY.get(), JerotesSounds.MAGIC_INVISIBLE_PASSAGE){

            @Override
            public boolean spellFindUse() {
                return !this.caster.m_9236_().m_5776_() && this.caster.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get(), this.getSpellLevel() * 24 * 20, this.getSpellLevel() - 1, false, false));
            }

            @Override
            public float getSpellDistance() {
                return 2.0f;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null && this.getCaster().m_21023_((MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get()) && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get())).m_19564_() >= this.getSpellLevel() - 1 && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get())).m_19557_() > 120 && !(this.getCaster() instanceof Player)) {
                    return false;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell Counterspell(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.ADD, "counterspell", (ParticleOptions)JerotesParticleTypes.COUNTERSPELL_DISPLAY.get(), JerotesSounds.MAGIC_COUNTERSPELL){

            @Override
            public boolean spellFindUse() {
                return !this.caster.m_9236_().m_5776_() && this.caster.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.COUNTERSPELL.get(), 240, this.getSpellLevel() - 1));
            }

            @Override
            public float getSpellDistance() {
                return 2.0f;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean canBeBreak() {
                return false;
            }

            @Override
            public int baseSpellLevel() {
                return 3;
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null && this.getCaster().m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get())).m_19564_() >= this.getSpellLevel() - 1 && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get())).m_19557_() > 120 && !(this.getCaster() instanceof Player)) {
                    return false;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell MagicAbsorption(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.ADD, "magic_absorption", (ParticleOptions)JerotesParticleTypes.MAGIC_ABSORPTION_DISPLAY.get(), JerotesSounds.MAGIC_MAGIC_ABSORPTION){

            @Override
            public boolean spellFindUse() {
                return !this.caster.m_9236_().m_5776_() && this.caster.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.MAGIC_ABSORPTION.get(), this.getSpellLevel() * 3 * 20, this.getSpellLevel() - 1));
            }

            @Override
            public float getSpellDistance() {
                return 2.0f;
            }

            @Override
            public boolean isHelp() {
                return true;
            }

            @Override
            public String getSpellModId() {
                return "jerotes";
            }

            @Override
            public boolean canUse() {
                if (this.getCaster() != null && this.getCaster().m_21023_((MobEffect)JerotesMobEffects.MAGIC_ABSORPTION.get()) && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.MAGIC_ABSORPTION.get())).m_19564_() >= this.getSpellLevel() - 1 && Objects.requireNonNull(this.getCaster().m_21124_((MobEffect)JerotesMobEffects.MAGIC_ABSORPTION.get())).m_19557_() > 120 && !(this.getCaster() instanceof Player)) {
                    return false;
                }
                return super.canUse();
            }
        };
    }
}

