/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.util;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BasePartEntity;
import com.jerotes.jerotes.entity.JerotesFallingBlock;
import com.jerotes.jerotes.item.AAExplorationEye;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.world.inventory.MobInventoryGUIMenu;
import com.jerotes.jerotes.world.inventory.SuchInventoryMenu;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Main {
    public static double luck(LivingEntity livingEntity) {
        return livingEntity.m_21051_(Attributes.f_22286_) != null ? livingEntity.m_21133_(Attributes.f_22286_) : 0.0;
    }

    public static boolean isOtherScoping(LivingEntity player) {
        return player.m_6117_() && player.m_21211_().m_41720_() instanceof AAExplorationEye;
    }

    public static void openMobInventoryGui(final ServerPlayer serverPlayer, final LivingEntity livingEntity, final boolean bl, final boolean bl2, final boolean canUseMainHand, final boolean canUseOffHand, final boolean canUseHelmet, final boolean canUseChestplate, final boolean canUseLeggings, final boolean canUseBoots) {
        List<String> list;
        if (!livingEntity.m_6084_()) {
            return;
        }
        String string = EntityFactionFind.getFindFaction(livingEntity);
        String string2 = "jerotes";
        if (!EntityFactionFind.getTrueFaction(livingEntity).isEmpty()) {
            string = EntityFactionFind.getTrueFaction(livingEntity);
        }
        if (!(list = EntityFactionFind.getAllFindFaction(livingEntity, true)).contains(string) && !string.equals(EntityFactionFind.getFindFaction(livingEntity)) && AttackFind.getOwnerTrue((Entity)livingEntity) == null) {
            string2 = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)livingEntity.m_6095_())).m_135827_();
        }
        if (!EntityFactionFind.getTrueMobTypeNameModId(livingEntity).isEmpty()) {
            string2 = EntityFactionFind.getTrueMobTypeNameModId(livingEntity);
        }
        if (AttackFind.getOwnerTrue((Entity)livingEntity) != null && list.contains(EntityFactionFind.getTrueFaction(AttackFind.getOwnerTrue((Entity)livingEntity))) && !list.contains(EntityFactionFind.getTrueMobTypeNameModId(AttackFind.getOwnerTrue((Entity)livingEntity)))) {
            string2 = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)AttackFind.getOwnerTrue((Entity)livingEntity).m_6095_())).m_135827_();
        }
        if (!livingEntity.getPersistentData().m_128461_("jerotes_mob_faction").isEmpty()) {
            string = livingEntity.getPersistentData().m_128461_("jerotes_mob_faction");
        }
        if (!livingEntity.getPersistentData().m_128461_("jerotes_mob_faction_mod_id").isEmpty()) {
            string2 = livingEntity.getPersistentData().m_128461_("jerotes_mob_faction_mod_id");
        }
        final String finalString = string;
        final String finalString2 = string2;
        serverPlayer.openMenu(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"mob_inventory_gui");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                packetBuffer.m_130064_(serverPlayer.m_20183_());
                packetBuffer.writeByte(0);
                packetBuffer.m_130130_(livingEntity.m_19879_());
                packetBuffer.m_130070_(finalString);
                packetBuffer.m_130070_(finalString2);
                return new MobInventoryGUIMenu(id, inventory, packetBuffer, bl, bl2, canUseMainHand, canUseOffHand, canUseHelmet, canUseChestplate, canUseLeggings, canUseBoots);
            }
        }, buf -> {
            buf.m_130064_(serverPlayer.m_20183_());
            buf.writeByte(0);
            buf.m_130130_(livingEntity.m_19879_());
            buf.m_130070_(finalString);
            buf.m_130070_(finalString2);
        });
    }

    public static void openSuchInventoryGui(ServerPlayer serverPlayer, final LivingEntity livingEntity) {
        if (!livingEntity.m_6084_()) {
            return;
        }
        serverPlayer.openMenu(new MenuProvider(){

            public Component m_5446_() {
                return livingEntity.m_5446_();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                packetBuffer.m_130130_(livingEntity.m_19879_());
                return new SuchInventoryMenu(id, inventory, packetBuffer);
            }
        }, buf -> buf.m_130130_(livingEntity.m_19879_()));
    }

    public static void destroyRides(Mob mob) {
        Entity entity = mob.m_20202_();
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            if (mob.m_5912_()) {
                mob.m_6674_(InteractionHand.MAIN_HAND);
                mob.m_8127_();
                mob.m_19998_((ItemLike)boat.m_38369_());
                boat.m_146870_();
            }
        }
        if ((entity = mob.m_20202_()) instanceof Minecart) {
            Minecart minecart = (Minecart)entity;
            if (mob.m_20202_().m_6095_() == EntityType.f_20469_ && mob.m_5912_()) {
                mob.m_6674_(InteractionHand.MAIN_HAND);
                mob.m_8127_();
                mob.m_19998_((ItemLike)Items.f_42449_);
                minecart.m_146870_();
            }
        }
    }

    public static int randomReach(RandomSource randomSource, int n, int n2) {
        if (n2 < n) {
            n = n2;
        }
        return randomSource.m_216339_(n, n2 + 1);
    }

    public static void sweepAttack(Entity entity) {
        double d = -Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180)));
        double d2 = Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180)));
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, entity.m_20185_() + d, entity.m_20227_(0.5), entity.m_20189_() + d2, 0, d, 0.0, d2, 0.0);
        }
    }

    public static boolean isInFluid(LivingEntity livingEntity) {
        return livingEntity.isInFluidType();
    }

    public static void addEffectMax(LivingEntity livingEntity, LivingEntity livingEntity2, MobEffect mobEffect, int n, int n2, boolean bl, boolean bl2, int max) {
        if (!livingEntity.m_9236_().f_46443_) {
            if (livingEntity.m_21023_(mobEffect) && Objects.requireNonNull(livingEntity.m_21124_(mobEffect)).m_19564_() <= n2 && Objects.requireNonNull(livingEntity.m_21124_(mobEffect)).m_19557_() < max) {
                livingEntity.m_147207_(new MobEffectInstance(mobEffect, Objects.requireNonNull(livingEntity.m_21124_(mobEffect)).m_19564_() + n, n2, bl, bl2), (Entity)livingEntity2);
            } else {
                livingEntity.m_147207_(new MobEffectInstance(mobEffect, max, n2, bl, bl2), (Entity)livingEntity2);
            }
        }
    }

    public static boolean canSee(Entity target, Entity self) {
        float f = 0.0f;
        float f1 = -self.m_6080_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        Vec3 vec3 = new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
        Vec3 object = target.m_20318_(0.5f);
        Vec3 vec32 = object.m_82505_(self.m_20182_());
        vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
        return vec32.m_82526_(vec3) < 0.0;
    }

    public static boolean canSee(Vec3 target, Entity self) {
        float f = 0.0f;
        float f1 = -self.m_6080_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        Vec3 vec3 = new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
        Vec3 vec32 = target.m_82505_(self.m_20182_());
        vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
        return vec32.m_82526_(vec3) < 0.0;
    }

    public static boolean canSee(LivingEntity target, Vec3 self) {
        if (self != null) {
            Vec3 lookingVector = target.m_20252_(1.0f);
            Vec3 attackAngleVector = self.m_82546_(target.m_20182_()).m_82541_();
            double horizontalDot = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_).m_82526_(new Vec3(lookingVector.f_82479_, 0.0, lookingVector.f_82481_));
            double verticalDot = attackAngleVector.f_82480_ * lookingVector.f_82480_;
            return horizontalDot < -0.5 && verticalDot < -0.5;
        }
        return false;
    }

    public static boolean canSeeAngle(Entity see, Vec3 beSeen, double angleThreshold) {
        float f = 0.0f;
        float f1 = -see.m_6080_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        Vec3 vec3 = new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
        Vec3 vec32 = beSeen.m_82505_(see.m_20182_());
        vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
        return vec32.m_82526_(vec3) < -1.0 + angleThreshold / 180.0;
    }

    public static boolean hasLineOfSightEntity(Entity target, Entity self) {
        if (target.m_9236_() != self.m_9236_()) {
            return false;
        }
        Vec3 vec3 = new Vec3(self.m_20185_(), self.m_20188_(), self.m_20189_());
        Vec3 vec32 = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        if (vec32.m_82554_(vec3) > 128.0) {
            return false;
        }
        return self.m_9236_().m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, self)).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean hasLineOfSightPos(Vec3 vec3, Entity self) {
        Vec3 vec32 = new Vec3(self.m_20185_(), self.m_20188_(), self.m_20189_());
        if (vec3.m_82554_(vec32) > 128.0) {
            return false;
        }
        return self.m_9236_().m_45547_(new ClipContext(vec32, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, self)).m_6662_() == HitResult.Type.MISS;
    }

    public static Entity getTargetedEntityBase(Player player, double maxDistance, boolean bl) {
        Level world = player.m_9236_();
        Vec3 startVec = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f).m_82490_(maxDistance);
        Vec3 endVec = startVec.m_82549_(lookVec);
        AABB searchBox = new AABB(startVec, endVec).m_82400_(1.0);
        List entities = world.m_6249_((Entity)player, searchBox, entity -> entity.m_6087_() && entity != player);
        Entity closestEntity = null;
        double closestDistance = maxDistance;
        for (Entity entity2 : entities) {
            double distance;
            AABB entityBox = entity2.m_20191_().m_82400_(0.5);
            Optional optionalHit = entityBox.m_82371_(startVec, endVec);
            if (!optionalHit.isPresent() || !((distance = startVec.m_82554_((Vec3)optionalHit.get())) < closestDistance) || bl && (entity2.m_20145_() || !player.m_142582_(entity2))) continue;
            closestDistance = distance;
            closestEntity = entity2;
        }
        return closestEntity;
    }

    public static Entity getTargetedEntity(Player player, double maxDistance) {
        return Main.getTargetedEntity(player, maxDistance, false);
    }

    public static Entity getTargetedEntity(Player player, double maxDistance, boolean bl) {
        Entity entity = Main.getTargetedEntityBase(player, maxDistance, bl);
        if (bl && entity != null && entity.m_20145_()) {
            return null;
        }
        if (bl && entity != null && !player.m_142582_(entity)) {
            return null;
        }
        return entity;
    }

    static boolean isLookingAtMe(LivingEntity livingEntity, LivingEntity self) {
        ItemStack itemStack = livingEntity.m_6844_(EquipmentSlot.HEAD);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            itemStack = (ItemStack)player.m_150109_().f_35975_.get(3);
        }
        if (itemStack.m_150930_(Blocks.f_50143_.m_5456_())) {
            return false;
        }
        if (self instanceof EnderMan) {
            Player player;
            EnderMan enderMan = (EnderMan)self;
            if (livingEntity instanceof Player && ForgeHooks.shouldSuppressEnderManAnger((EnderMan)enderMan, (Player)(player = (Player)livingEntity), (ItemStack)itemStack)) {
                return false;
            }
        }
        Vec3 vec3 = livingEntity.m_20252_(1.0f).m_82541_();
        Vec3 vec32 = new Vec3(self.m_20185_() - livingEntity.m_20185_(), self.m_20188_() - livingEntity.m_20188_(), self.m_20189_() - livingEntity.m_20189_());
        double d = vec32.m_82553_();
        double d2 = vec3.m_82526_(vec32 = vec32.m_82541_());
        if (d2 > 1.0 - 0.025 / d) {
            return livingEntity.m_142582_((Entity)self);
        }
        return false;
    }

    public static void updatePart(@Nullable BasePartEntity part, @NotNull LivingEntity parent) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                Level level;
                if (part == null || !((level = parent.m_9236_()) instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (!parent.m_213877_()) break block7;
            }
            return;
        }
        if (!part.shouldContinuePersisting()) {
            UUID uuid = part.m_20148_();
            Entity existing = serverLevel.m_8791_(uuid);
            if (existing != null && existing != part) {
                while (serverLevel.m_8791_(uuid) != null) {
                    uuid = Mth.m_216261_((RandomSource)parent.m_217043_());
                }
            }
            part.m_20084_(uuid);
            serverLevel.m_7967_((Entity)part);
        }
        part.setParent((Entity)parent);
    }

    public static float mobWidth(Entity entity) {
        return (float)((entity.m_20191_().m_82362_() + entity.m_20191_().m_82385_()) / 2.0);
    }

    public static float mobHeight(Entity entity) {
        return (float)entity.m_20191_().m_82376_();
    }

    public static boolean mobSizeFind(Entity entity, float average, float max) {
        return !(Main.mobWidth(entity) >= max || Main.mobHeight(entity) >= max || Main.mobWidth(entity) >= average && Main.mobHeight(entity) >= average);
    }

    public static boolean mobSizeSmall(Entity entity) {
        return Main.mobSizeFind(entity, 0.75f, 1.75f);
    }

    public static boolean mobSizeMedium(Entity entity) {
        return Main.mobSizeFind(entity, 1.75f, 3.5f) && !Main.mobSizeSmall(entity);
    }

    public static boolean mobSizeLarge(Entity entity) {
        return Main.mobSizeFind(entity, 3.5f, 6.0f) && !Main.mobSizeSmall(entity) && !Main.mobSizeMedium(entity);
    }

    public static boolean mobSizeGiant(Entity entity) {
        return !Main.mobSizeSmall(entity) && !Main.mobSizeMedium(entity) && !Main.mobSizeLarge(entity);
    }

    public static AABB blockDestroyAABB(Mob mob) {
        AABB aABB = mob.m_20191_();
        if (mob.m_21573_().m_26570_() != null) {
            if ((double)mob.m_21573_().m_26570_().m_77406_().m_123342_() - mob.m_20186_() > 1.0) {
                aABB = mob.m_20191_().m_82386_(0.0, 1.0, 0.0);
            } else if ((double)mob.m_21573_().m_26570_().m_77406_().m_123342_() - mob.m_20186_() < -1.0) {
                aABB = mob.m_20191_().m_82386_(0.0, -1.0, 0.0);
            }
        }
        return aABB;
    }

    public static boolean BlockDestroy(Mob mob, float destroy) {
        if (!mob.m_9236_().f_46443_) {
            OwnableEntity ownables;
            OwnableEntity ownable;
            boolean bl1;
            boolean bl = mob.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && MainConfig.MobDestroyBlock;
            boolean bl2 = bl1 = mob instanceof OwnableEntity && (ownable = (OwnableEntity)mob).m_269323_() != null && MainConfig.TamedMobDestroyBlock || !(mob instanceof OwnableEntity) || (ownables = (OwnableEntity)mob).m_269323_() == null;
            if (bl && bl1) {
                AABB aABB = Main.blockDestroyAABB(mob);
                boolean bl22 = false;
                for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aABB.f_82288_), (int)Mth.m_14107_((double)aABB.f_82289_), (int)Mth.m_14107_((double)aABB.f_82290_), (int)Mth.m_14107_((double)aABB.f_82291_), (int)Mth.m_14107_((double)aABB.f_82292_), (int)Mth.m_14107_((double)aABB.f_82293_))) {
                    boolean bl3;
                    BlockState blockState = mob.m_9236_().m_8055_(blockPos);
                    float block = blockState.m_60800_((BlockGetter)mob.m_9236_(), blockPos);
                    if (blockState.m_60795_() || block >= destroy || block < 0.0f || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)mob, (BlockPos)blockPos, (BlockState)blockState)) continue;
                    if ((blockState.m_204336_(BlockTags.f_278411_) || blockState.m_204336_(BlockTags.f_144274_) || blockState.m_204336_(BlockTags.f_215823_) || blockState.m_204336_(BlockTags.f_13029_) || blockState.m_204336_(BlockTags.f_144266_)) && (double)mob.m_217043_().m_188501_() > 0.005) {
                        bl3 = mob.m_9236_().m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                        if (!bl3) continue;
                        bl22 = true;
                        continue;
                    }
                    bl3 = mob.m_9236_().m_46953_(blockPos, true, (Entity)mob);
                    if (!bl3) continue;
                    bl22 = true;
                }
                return bl22;
            }
        }
        return false;
    }

    public static BlockPos findSpawnPositionNear(LevelReader levelReader, BlockPos blockPos, int n) {
        BlockPos blockPos2 = blockPos.m_7494_();
        for (int i = 0; i < 128; ++i) {
            int n4 = blockPos.m_123341_() + RandomSource.m_216327_().m_188503_(n * 2) - n;
            BlockPos blockPos3 = new BlockPos(n4, blockPos.m_123342_() + RandomSource.m_216327_().m_188503_(n), blockPos.m_123343_() + RandomSource.m_216327_().m_188503_(n * 2) - n).m_7494_().m_7494_().m_7494_();
            BlockState blockState = levelReader.m_8055_(blockPos3);
            if (!blockState.m_60795_()) continue;
            blockPos2 = blockPos3;
            break;
        }
        return blockPos2;
    }

    public static BlockPos findSpawnPositionNearFill(LevelReader levelReader, BlockPos blockPos, int n) {
        if (levelReader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelReader;
            PoiManager poiManager = serverLevel.m_8904_();
            Optional optional = poiManager.m_27186_(holder -> holder.m_203565_(PoiTypes.f_218061_), blockPos1 -> true, blockPos, n, PoiManager.Occupancy.ANY);
            BlockPos blockPos3 = optional.orElse(blockPos);
            return Main.findSpawnPositionNear((LevelReader)serverLevel, blockPos3, n);
        }
        return Main.findSpawnPositionNear(levelReader, blockPos, n);
    }

    public static BlockPos findSpawnPositionNearFillOnBlock(LevelReader levelReader, BlockPos blockPos, int n) {
        BlockPos blockPos2 = Main.findSpawnPositionNearFill(levelReader, blockPos, n);
        if (levelReader.m_8055_(new BlockPos(blockPos2.m_123341_(), blockPos2.m_123342_() - 1, blockPos2.m_123343_())).m_60795_()) {
            for (int i = 0; i < n * 4; ++i) {
                if (levelReader.m_8055_(new BlockPos(blockPos2.m_123341_(), blockPos2.m_123342_() - i, blockPos2.m_123343_())).m_60795_()) continue;
                return new BlockPos(blockPos2.m_123341_(), blockPos2.m_123342_() - i + 1, blockPos2.m_123343_());
            }
        }
        return blockPos2;
    }

    public static BlockPos findSpawnPositionNearFill(LivingEntity entity, int n) {
        return Main.findSpawnPositionNearFill((LevelReader)entity.m_9236_(), entity.m_20183_(), n);
    }

    public static BlockPos findSpawnPositionNearFillOnBlock(LivingEntity entity, int n) {
        return Main.findSpawnPositionNearFillOnBlock((LevelReader)entity.m_9236_(), entity.m_20183_(), n);
    }

    public static void spawnFallingBlockByPos(ServerLevel level, BlockPos pos, float fallingFactor) {
        Random random = new Random();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        fallingFactor = random.nextBoolean() ? (fallingFactor += (float)(0.4 + random.nextGaussian() * 0.2)) : (fallingFactor -= (float)Mth.m_14008_((double)(0.2 + random.nextGaussian() * 0.2), (double)0.2, (double)((double)fallingFactor - 0.1)));
        if (!block.m_60795_() && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_280555_()) {
            JerotesFallingBlock fallingBlock = new JerotesFallingBlock((Level)level, block, (float)(0.32 + (double)fallingFactor * 0.2));
            fallingBlock.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static void spawnFallingBlockByPos(ServerLevel level, BlockPos pos) {
        RandomSource random = RandomSource.m_216327_();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        if (!block.m_60795_() && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_280555_()) {
            JerotesFallingBlock fallingBlock = new JerotesFallingBlock((Level)level, (double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5, block, 10);
            fallingBlock.m_5997_(0.0, 0.2 + random.m_188583_() * 0.2, 0.0);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static void spawnFallingBlockByPosChance(ServerLevel level, BlockPos pos, float chance) {
        RandomSource random = RandomSource.m_216327_();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        if (!block.m_60795_() && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_280555_() && level.m_213780_().m_188501_() <= chance) {
            JerotesFallingBlock fallingBlock = new JerotesFallingBlock((Level)level, (double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5, block, 10);
            fallingBlock.m_5997_(0.0, 0.2 + random.m_188583_() * 0.2, 0.0);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static void spawnMinecraftFallingBlockByPos(ServerLevel level, BlockPos pos) {
        RandomSource random = RandomSource.m_216327_();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        if (!block.m_60795_() && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_280555_()) {
            FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)level, (BlockPos)new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()), (BlockState)block);
            fallingBlock.f_31943_ = false;
            fallingBlock.m_5997_(0.0, 0.2 + random.m_188583_() * 0.2, 0.0);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static Vec3 adjustPositionForSolidHit(BlockHitResult hitResult, Vec3 startPos, Vec3 viewVector, double maxDistance) {
        double distance;
        Vec3 adjustedPos = hitResult.m_82450_();
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Direction hitDirection = hitResult.m_82434_();
            adjustedPos = adjustedPos.m_82492_((double)hitDirection.m_122429_() * 0.1, (double)hitDirection.m_122430_() * 0.1, (double)hitDirection.m_122431_() * 0.1);
        }
        return (distance = startPos.m_82554_(adjustedPos)) > maxDistance ? startPos.m_82549_(viewVector.m_82490_(maxDistance)) : adjustedPos;
    }

    public static BlockPos findSafePosition(ServerLevel level, Vec3 targetPos) {
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos((int)targetPos.f_82479_, (int)targetPos.f_82480_, (int)targetPos.f_82481_);
        BlockPos solidPos = Main.findSolidGround(level, basePos);
        if (solidPos != null) {
            return solidPos;
        }
        BlockPos fluidPos = Main.findFluidPosition(level, basePos);
        return fluidPos;
    }

    public static BlockPos findSolidGround(ServerLevel level, BlockPos.MutableBlockPos pos) {
        int maxDownSearch = 10;
        BlockPos.MutableBlockPos currentPos = pos.m_122032_().m_122173_(Direction.DOWN);
        for (int i = 0; i < maxDownSearch && currentPos.m_123342_() >= level.m_141937_(); ++i) {
            if (Main.isSolidWalkable(level, (BlockPos)currentPos)) {
                return currentPos.m_7494_().m_7949_();
            }
            currentPos.m_122173_(Direction.DOWN);
        }
        for (int r = 1; r <= 2; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, 0, z);
                    if (!Main.isSolidWalkable(level, checkPos)) continue;
                    return checkPos.m_7494_().m_7949_();
                }
            }
        }
        return null;
    }

    public static boolean isSolidWalkable(ServerLevel level, BlockPos pos) {
        BlockState floor = level.m_8055_(pos);
        BlockState feet = level.m_8055_(pos.m_7494_());
        BlockState head = level.m_8055_(pos.m_6630_(2));
        return floor.m_280555_() && feet.m_60795_() && head.m_60795_();
    }

    public static BlockPos findFluidPosition(ServerLevel level, BlockPos.MutableBlockPos pos) {
        int maxDownSearch = 5;
        BlockPos.MutableBlockPos currentPos = pos.m_122032_();
        for (int i = 0; i < maxDownSearch; ++i) {
            BlockState state = level.m_8055_((BlockPos)currentPos);
            if (state.m_60819_().m_76178_()) {
                currentPos.m_122173_(Direction.DOWN);
                continue;
            }
            if (state.m_60819_().m_76186_() >= 8 && level.m_8055_(currentPos.m_7494_()).m_60795_()) {
                return currentPos.m_7494_().m_7949_();
            }
            currentPos.m_122173_(Direction.DOWN);
        }
        return null;
    }

    public static void persistentDataDoubleReduceToZero(LivingEntity livingEntity, String string, boolean clear) {
        if (livingEntity.getPersistentData().m_128459_(string) > 0.0) {
            livingEntity.getPersistentData().m_128347_(string, livingEntity.getPersistentData().m_128459_(string) - 1.0);
        } else if (clear && livingEntity.getPersistentData().m_128423_(string) != null) {
            livingEntity.getPersistentData().m_128473_(string);
        }
    }

    public static void persistentDataDoubleAddTo(LivingEntity livingEntity, String string, double d) {
        if (livingEntity.getPersistentData().m_128459_(string) < d) {
            livingEntity.getPersistentData().m_128347_(string, livingEntity.getPersistentData().m_128459_(string) + 1.0);
        }
    }

    public static void persistentDataRemove(LivingEntity livingEntity, String string) {
        if (livingEntity.getPersistentData().m_128423_(string) != null) {
            livingEntity.getPersistentData().m_128473_(string);
        }
    }

    public static boolean isCanNotMoveTag(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null) {
            return compoundTag.m_128471_("JerotesCanNotMove");
        }
        return false;
    }

    public static boolean isCanNotMove(ItemStack itemStack) {
        return itemStack.getEnchantmentLevel(Enchantments.f_44975_) > 0 || Main.isCanNotMoveTag(itemStack);
    }

    public static boolean isTrusted(LivingEntity entity, LivingEntity target, boolean onlyYou) {
        try {
            CompoundTag compoundTag = entity.m_20240_(new CompoundTag());
            if (!onlyYou && compoundTag.m_128471_("Trusting")) {
                return true;
            }
            if (compoundTag.m_128425_("Trusted", 9)) {
                ListTag trustedList = compoundTag.m_128437_("Trusted", 11);
                UUID targetUuid = target.m_20148_();
                for (Tag tag : trustedList) {
                    if (tag == null || tag.m_7060_() != 11) continue;
                    try {
                        UUID uuid = NbtUtils.m_129233_((Tag)tag);
                        if (!targetUuid.equals(uuid)) continue;
                        return true;
                    }
                    catch (Exception e) {
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

