/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.util;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpawnRules {
    public static boolean checkSurfaceWaterSpawnRules(EntityType<? extends Mob> mob, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        int i = levelAccessor.m_5736_();
        int j = i - 13;
        return blockPos.m_123342_() >= j && blockPos.m_123342_() <= i && levelAccessor.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && levelAccessor.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public static boolean NeutralSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean BatSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && SpawnRules.checkBatSpawnRules(entityType, levelAccessor, mobSpawnType, blockPos, randomSource);
    }

    public static boolean checkBatSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (blockPos.m_123342_() >= levelAccessor.m_5736_()) {
            return false;
        }
        int n = levelAccessor.m_46803_(blockPos);
        int n2 = 4;
        if (SpawnRules.isHalloween()) {
            n2 = 7;
        } else if (randomSource.m_188499_()) {
            return false;
        }
        if (n > randomSource.m_188503_(n2)) {
            return false;
        }
        return Bat.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean isHalloween() {
        LocalDate $$0 = LocalDate.now();
        int $$1 = $$0.get(ChronoField.DAY_OF_MONTH);
        int $$2 = $$0.get(ChronoField.MONTH_OF_YEAR);
        return $$2 == 10 && $$1 >= 20 || $$2 == 11 && $$1 <= 3;
    }

    public static boolean CarvedSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean AnimalSpawn(int num, double area, EntityType<? extends Animal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Animal.m_218104_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean WaterAnimalSpawn(int num, double area, EntityType<? extends WaterAnimal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && WaterAnimal.m_218282_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean WaterMobSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && SpawnRules.checkSurfaceWaterSpawnRules(entityType, levelAccessor, mobSpawnType, blockPos, randomSource);
    }

    public static boolean DarkMonsterSpawn(int num, double area, EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = serverLevelAccessor.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Monster.m_219013_(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean DarisorderSpawn(int num, double area, EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = serverLevelAccessor.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Monster.m_219013_(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean GlowSquidSpawn(int num, double area, EntityType<? extends Mob> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = serverLevelAccessor.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && blockPos.m_123342_() <= serverLevelAccessor.m_5736_() - 33 && serverLevelAccessor.m_45524_(blockPos, 0) == 0 && serverLevelAccessor.m_8055_(blockPos).m_60713_(Blocks.f_49990_);
    }

    public static boolean LightMonsterSpawn(int num, double area, EntityType<? extends Monster> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Monster.m_219019_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean NPCSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean WaterNPCSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && SpawnRules.checkSurfaceWaterSpawnRules(entityType, levelAccessor, mobSpawnType, blockPos, randomSource);
    }
}

