/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.alchemy;

import com.jerotes.jerotes.alchemy.effect.AAAAlchemyEffect;
import com.jerotes.jerotes.alchemy.effect.AAANullAlchemyEffect;
import com.jerotes.jerotes.alchemy.forge.JerotesAlchemyMaterialConflictEvent;
import com.jerotes.jerotes.alchemy.forge.JerotesAlchemyMaterialEffectEvent;
import com.jerotes.jerotes.alchemy.forge.JerotesAlchemySpecialEvent;
import com.jerotes.jerotes.entity.SpellUseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class Alchemy {
    public static boolean isSpecialResult(ItemStack material1, ItemStack material2, ItemStack material3, ItemStack material4, ItemStack material5) {
        JerotesAlchemySpecialEvent event = new JerotesAlchemySpecialEvent(material1, material2, material3, material4, material5);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isSpecial();
    }

    public static int getResultType(int needCount, ItemStack material1, ItemStack material2, ItemStack material3, ItemStack material4, ItemStack material5) {
        boolean material5Not;
        int count = 0;
        if (!material1.m_41619_()) {
            ++count;
        }
        if (!material2.m_41619_()) {
            ++count;
        }
        if (!material3.m_41619_()) {
            ++count;
        }
        if (!material4.m_41619_()) {
            ++count;
        }
        if (!material5.m_41619_()) {
            ++count;
        }
        if (count < needCount) {
            return 5;
        }
        JerotesAlchemyMaterialEffectEvent event1 = new JerotesAlchemyMaterialEffectEvent(material1);
        JerotesAlchemyMaterialEffectEvent event2 = new JerotesAlchemyMaterialEffectEvent(material2);
        JerotesAlchemyMaterialEffectEvent event3 = new JerotesAlchemyMaterialEffectEvent(material3);
        JerotesAlchemyMaterialEffectEvent event4 = new JerotesAlchemyMaterialEffectEvent(material4);
        JerotesAlchemyMaterialEffectEvent event5 = new JerotesAlchemyMaterialEffectEvent(material5);
        MinecraftForge.EVENT_BUS.post((Event)event1);
        MinecraftForge.EVENT_BUS.post((Event)event2);
        MinecraftForge.EVENT_BUS.post((Event)event3);
        MinecraftForge.EVENT_BUS.post((Event)event4);
        MinecraftForge.EVENT_BUS.post((Event)event5);
        int material1MaxCount = event1.getMaxCount();
        int material2MaxCount = event2.getMaxCount();
        int material3MaxCount = event3.getMaxCount();
        int material4MaxCount = event4.getMaxCount();
        int material5MaxCount = event5.getMaxCount();
        ItemStack[] materials = new ItemStack[]{material1, material2, material3, material4, material5};
        int[] materialCounts = new int[]{1, 1, 1, 1, 1};
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i].m_41619_()) continue;
            for (int j = i + 1; j < materials.length; ++j) {
                if (materials[j].m_41619_() || !ItemStack.m_41656_((ItemStack)materials[i], (ItemStack)materials[j])) continue;
                int n = i;
                materialCounts[n] = materialCounts[n] + 1;
                int n2 = j;
                materialCounts[n2] = materialCounts[n2] + 1;
            }
        }
        if (materialCounts[0] > material1MaxCount && !material1.m_41619_() || materialCounts[1] > material2MaxCount && !material2.m_41619_() || materialCounts[2] > material3MaxCount && !material3.m_41619_() || materialCounts[3] > material4MaxCount && !material4.m_41619_() || materialCounts[4] > material5MaxCount && !material5.m_41619_()) {
            return 1;
        }
        boolean material1Not = event1.getEffectCount() <= 0 && !material1.m_41619_();
        boolean material2Not = event2.getEffectCount() <= 0 && !material2.m_41619_();
        boolean material3Not = event3.getEffectCount() <= 0 && !material3.m_41619_();
        boolean material4Not = event4.getEffectCount() <= 0 && !material4.m_41619_();
        boolean bl = material5Not = event5.getEffectCount() <= 0 && !material5.m_41619_();
        if (material1Not || material2Not || material3Not || material4Not || material5Not) {
            return 0;
        }
        JerotesAlchemyMaterialConflictEvent event11 = new JerotesAlchemyMaterialConflictEvent(material1);
        JerotesAlchemyMaterialConflictEvent event12 = new JerotesAlchemyMaterialConflictEvent(material2);
        JerotesAlchemyMaterialConflictEvent event13 = new JerotesAlchemyMaterialConflictEvent(material3);
        JerotesAlchemyMaterialConflictEvent event14 = new JerotesAlchemyMaterialConflictEvent(material4);
        JerotesAlchemyMaterialConflictEvent event15 = new JerotesAlchemyMaterialConflictEvent(material5);
        MinecraftForge.EVENT_BUS.post((Event)event11);
        MinecraftForge.EVENT_BUS.post((Event)event12);
        MinecraftForge.EVENT_BUS.post((Event)event13);
        MinecraftForge.EVENT_BUS.post((Event)event14);
        MinecraftForge.EVENT_BUS.post((Event)event15);
        if (event11.isConflictWith(material2) && !material2.m_41619_() || event11.isConflictWith(material3) && !material3.m_41619_() || event11.isConflictWith(material4) && !material4.m_41619_() || event11.isConflictWith(material5) && !material5.m_41619_() || event12.isConflictWith(material1) && !material1.m_41619_() || event12.isConflictWith(material3) && !material3.m_41619_() || event12.isConflictWith(material4) && !material4.m_41619_() || event12.isConflictWith(material5) && !material5.m_41619_() || event13.isConflictWith(material1) && !material1.m_41619_() || event13.isConflictWith(material2) && !material2.m_41619_() || event13.isConflictWith(material4) && !material4.m_41619_() || event13.isConflictWith(material5) && !material5.m_41619_() || event14.isConflictWith(material1) && !material1.m_41619_() || event14.isConflictWith(material2) && !material2.m_41619_() || event14.isConflictWith(material3) && !material3.m_41619_() || event14.isConflictWith(material5) && !material5.m_41619_() || event15.isConflictWith(material1) && !material1.m_41619_() || event15.isConflictWith(material2) && !material2.m_41619_() || event15.isConflictWith(material3) && !material3.m_41619_() || event15.isConflictWith(material4) && !material4.m_41619_()) {
            return 4;
        }
        if (Alchemy.isSpecialResult(material1, material2, material3, material4, material5)) {
            return 3;
        }
        return 2;
    }

    public static int getResultLevel(Entity entity, int madeCount, int getResultType, int specialLevel, boolean spellLevelBonus, boolean madeCountBonus, boolean mustBeSpecialLevel) {
        int level = 1;
        if (entity instanceof SpellUseEntity) {
            SpellUseEntity spellUse = (SpellUseEntity)entity;
            if (spellLevelBonus) {
                level += (int)((float)spellUse.getSpellLevel() / 2.0f);
            }
        }
        if (madeCountBonus) {
            level += madeCount;
        }
        if (getResultType == 3) {
            level = mustBeSpecialLevel ? specialLevel : Math.max(specialLevel, level);
        }
        return level;
    }

    private static boolean isValidAlchemyEffect(AAAAlchemyEffect effect) {
        return effect != null && !(effect instanceof AAANullAlchemyEffect);
    }

    public static List<AAAAlchemyEffect> findCommonEffectsWithMaxValues(ItemStack material1, ItemStack material2, ItemStack material3, ItemStack material4, ItemStack material5) {
        ArrayList<List<AAAAlchemyEffect>> allEffects = new ArrayList<List<AAAAlchemyEffect>>();
        if (!material1.m_41619_()) {
            List<AAAAlchemyEffect> effects1 = Alchemy.getValidEffectsFromMaterial(material1);
            allEffects.add(effects1);
        }
        if (!material2.m_41619_()) {
            List<AAAAlchemyEffect> effects2 = Alchemy.getValidEffectsFromMaterial(material2);
            allEffects.add(effects2);
        }
        if (!material3.m_41619_()) {
            List<AAAAlchemyEffect> effects3 = Alchemy.getValidEffectsFromMaterial(material3);
            allEffects.add(effects3);
        }
        if (!material4.m_41619_()) {
            List<AAAAlchemyEffect> effects4 = Alchemy.getValidEffectsFromMaterial(material4);
            allEffects.add(effects4);
        }
        if (!material5.m_41619_()) {
            List<AAAAlchemyEffect> effects5 = Alchemy.getValidEffectsFromMaterial(material5);
            allEffects.add(effects5);
        }
        if (allEffects.isEmpty()) {
            return new ArrayList<AAAAlchemyEffect>();
        }
        Map<String, AAAAlchemyEffect> commonEffects = Alchemy.findCommonEffects(allEffects);
        return new ArrayList<AAAAlchemyEffect>(commonEffects.values());
    }

    private static List<AAAAlchemyEffect> getValidEffectsFromMaterial(ItemStack material) {
        AAAAlchemyEffect[] effects;
        JerotesAlchemyMaterialEffectEvent event = new JerotesAlchemyMaterialEffectEvent(material);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ArrayList<AAAAlchemyEffect> validEffects = new ArrayList<AAAAlchemyEffect>();
        for (AAAAlchemyEffect effect : effects = new AAAAlchemyEffect[]{event.getEffect1(), event.getEffect2(), event.getEffect3(), event.getEffect4(), event.getEffect5()}) {
            if (!Alchemy.isValidAlchemyEffect(effect)) continue;
            validEffects.add(effect);
        }
        return validEffects;
    }

    private static Map<String, AAAAlchemyEffect> findCommonEffects(List<List<AAAAlchemyEffect>> allEffects) {
        HashMap<Class, List> effectOccurrences = new HashMap<Class, List>();
        for (List<AAAAlchemyEffect> materialEffects : allEffects) {
            for (AAAAlchemyEffect effect : materialEffects) {
                Class<?> effectClass = effect.getClass();
                effectOccurrences.computeIfAbsent(effectClass, k -> new ArrayList()).add(effect);
            }
        }
        HashMap<String, AAAAlchemyEffect> commonEffects = new HashMap<String, AAAAlchemyEffect>();
        for (Map.Entry entry : effectOccurrences.entrySet()) {
            List effects = (List)entry.getValue();
            if (effects.size() < 2) continue;
            Object bestEffect = null;
            int maxLevel = -1;
            int maxTime = -1;
            for (AAAAlchemyEffect effect : effects) {
                int level = effect.getLevel();
                int time = effect.getTime();
                if (level <= maxLevel && (level != maxLevel || time <= maxTime)) continue;
                maxLevel = level;
                maxTime = time;
                bestEffect = effect;
            }
            if (bestEffect == null) continue;
            commonEffects.put(bestEffect.getClass().getSimpleName(), (AAAAlchemyEffect)bestEffect);
        }
        return commonEffects;
    }

    public static ItemStack resultPotion(Entity entity, boolean sendMessage, ItemStack material1, ItemStack material2, ItemStack material3, ItemStack material4, ItemStack material5) {
        int resultType = Alchemy.getResultType(3, material1, material2, material3, material4, material5);
        if (resultType == 0) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (sendMessage) {
                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"alchemy.jerotes.message_0"));
                }
            }
            return Items.f_41852_.m_7968_();
        }
        if (resultType == 1) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (sendMessage) {
                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"alchemy.jerotes.message_1"));
                }
            }
            return Items.f_41852_.m_7968_();
        }
        if (resultType == 5) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (sendMessage) {
                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"alchemy.jerotes.message_5"));
                }
            }
            return Items.f_41852_.m_7968_();
        }
        if (resultType == 4) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (sendMessage) {
                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"alchemy.jerotes.message_4"));
                }
            }
            entity.m_9236_().m_254849_(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
            return Items.f_41852_.m_7968_();
        }
        if (resultType == 2 || resultType == 3) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (sendMessage) {
                    if (resultType == 2) {
                        serverPlayer.m_213846_((Component)Component.m_237115_((String)"alchemy.jerotes.message_2"));
                    }
                    if (resultType == 3) {
                        serverPlayer.m_213846_((Component)Component.m_237115_((String)"alchemy.jerotes.message_3"));
                    }
                }
            }
            int madeCount = 0;
            int level = Alchemy.getResultLevel(entity, madeCount, resultType, 1, true, true, false);
            List<AAAAlchemyEffect> commonEffects = Alchemy.findCommonEffectsWithMaxValues(material1, material2, material3, material4, material5);
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42589_);
            ArrayList<MobEffectInstance> collection = new ArrayList<MobEffectInstance>();
            MutableComponent component = Component.m_237115_((String)"item.minecraft.potion");
            for (AAAAlchemyEffect effect : commonEffects) {
                collection.add(new MobEffectInstance(effect.getMobEffect(), effect.getMobEffectTick(effect.getTime(), level), effect.getMobEffectLevel(effect.getLevel(), level)));
                component = Component.m_237113_((String)"").m_7220_(effect.getMobEffect().m_19482_()).m_7220_((Component)component);
            }
            PotionUtils.m_43552_((ItemStack)itemStack, collection);
            itemStack.m_41714_((Component)Component.m_237115_((String)"alchemy.jerotes.base").m_130946_(" ").m_7220_((Component)component));
            return itemStack;
        }
        return Items.f_41852_.m_7968_();
    }
}

