/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.client.gui;

import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.network.MobInventoryInventoryPacket;
import com.jerotes.jerotes.network.MobInventoryMeleeOrRangePacket;
import com.jerotes.jerotes.network.MobSendEffectsPacket;
import com.jerotes.jerotes.network.PacketHandler;
import com.jerotes.jerotes.network.SendMobInventoryPacket;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotes.world.inventory.MobInventoryGUIMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class MobInventoryGUIScreen
extends AbstractContainerScreen<MobInventoryGUIMenu> {
    private final Player player;
    public static final ResourceLocation YES = new ResourceLocation("jerotes", "textures/gui/sprites/container/mob_inventory/yes.png");
    public static final ResourceLocation SLOT = new ResourceLocation("jerotes", "textures/gui/sprites/container/mob_inventory/slot.png");
    public static final ResourceLocation NO = new ResourceLocation("jerotes", "textures/gui/sprites/container/mob_inventory/no.png");
    public static final ResourceLocation EFFECT = new ResourceLocation("jerotes", "textures/gui/sprites/container/mob_inventory/effect.png");
    public static final ResourceLocation SHARE = new ResourceLocation("jerotes", "textures/gui/sprites/container/mob_inventory/share.png");
    public static final ResourceLocation LOCK = new ResourceLocation("jerotes", "textures/gui/sprites/container/mob_inventory/lock.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("jerotes", "textures/gui/container/mob_inventory_gui.png");
    private static final ResourceLocation TEXTURE_INVENTORY = new ResourceLocation("jerotes", "textures/gui/container/mob_inventory_gui_inventory.png");

    public MobInventoryGUIScreen(MobInventoryGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.player = container.player;
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics p_282802_, int p_275688_, int p_275245_, int p_275535_, float p_275604_, float p_275546_, LivingEntity p_275689_) {
        float f = (float)Math.atan(p_275604_ / 40.0f);
        float f1 = (float)Math.atan(p_275546_ / 40.0f);
        InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)p_282802_, (int)p_275688_, (int)p_275245_, (int)p_275535_, (float)f, (float)f1, (LivingEntity)p_275689_);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ((MobInventoryGUIMenu)this.f_97732_).boundEntity;
        if (entity instanceof LivingEntity) {
            ArrayList<Component> tooltip;
            int textHeight;
            int textWidth;
            int textY;
            int textX;
            double spellLevelLevel;
            MutableComponent attribute;
            Object add;
            Mob mob;
            LivingEntity livingEntity = (LivingEntity)entity;
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)((this.f_96543_ - this.f_97726_) / 2 + 33), (int)((this.f_96544_ - this.f_97727_) / 2 + 54), (int)17, (float)((float)((this.f_96543_ - this.f_97726_) / 2 + 33) - (float)mouseX), (float)((float)((this.f_96544_ - this.f_97727_) / 2 + 75 - 50 - 9) - (float)mouseY), (LivingEntity)livingEntity);
            if (!((MobInventoryGUIMenu)this.f_97732_).isCanUseMainHand() || Main.isCanNotMove(livingEntity.m_6844_(EquipmentSlot.MAINHAND))) {
                guiGraphics.m_280163_(LOCK, this.f_97735_ + 8, this.f_97736_ + 62, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (!((MobInventoryGUIMenu)this.f_97732_).isCanUseOffHand() || Main.isCanNotMove(livingEntity.m_6844_(EquipmentSlot.OFFHAND))) {
                guiGraphics.m_280163_(LOCK, this.f_97735_ + 26, this.f_97736_ + 62, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (!((MobInventoryGUIMenu)this.f_97732_).isCanUseHelmet() || Main.isCanNotMove(livingEntity.m_6844_(EquipmentSlot.HEAD))) {
                guiGraphics.m_280163_(LOCK, this.f_97735_ + 62, this.f_97736_ + 8, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (!((MobInventoryGUIMenu)this.f_97732_).isCanUseChestplate() || Main.isCanNotMove(livingEntity.m_6844_(EquipmentSlot.CHEST))) {
                guiGraphics.m_280163_(LOCK, this.f_97735_ + 62, this.f_97736_ + 26, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (!((MobInventoryGUIMenu)this.f_97732_).isCanUseLeggings() || Main.isCanNotMove(livingEntity.m_6844_(EquipmentSlot.LEGS))) {
                guiGraphics.m_280163_(LOCK, this.f_97735_ + 62, this.f_97736_ + 44, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (!((MobInventoryGUIMenu)this.f_97732_).isCanUseBoots() || Main.isCanNotMove(livingEntity.m_6844_(EquipmentSlot.FEET))) {
                guiGraphics.m_280163_(LOCK, this.f_97735_ + 62, this.f_97736_ + 62, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            Component name = livingEntity.m_7755_();
            if (livingEntity instanceof OwnableEntity) {
                OwnableEntity ownable = (OwnableEntity)livingEntity;
                LivingEntity livingOwner = null;
                if (ownable.m_269323_() != null) {
                    livingOwner = ownable.m_269323_();
                } else {
                    List list = livingEntity.m_9236_().m_45976_(Mob.class, livingEntity.m_20191_().m_82377_(64.0, 64.0, 64.0));
                    for (Mob owner : list) {
                        if (owner == null || owner.m_20148_() != ownable.m_21805_()) continue;
                        livingOwner = owner;
                        break;
                    }
                }
                if (livingOwner != null) {
                    name = Component.m_237113_((String)"").m_7220_(livingEntity.m_7755_()).m_130946_("(").m_7220_(livingOwner.m_7755_()).m_130946_(")");
                }
            }
            int nameColor = 0x262626;
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5912_()) {
                nameColor = 6816515;
            }
            this.drawCenteredString(guiGraphics, this.f_96547_, name, this.f_97735_ + 80, this.f_97736_ + 8, this.f_97735_ + 167, this.f_97736_ + 32, nameColor);
            if (livingEntity instanceof InventoryEntity) {
                InventoryEntity inventory = (InventoryEntity)livingEntity;
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                float scale = 0.75f;
                poseStack.m_85841_(scale, scale, scale);
                Component component1 = inventory.componentInventoryIYes();
                Component component2 = inventory.componentInventoryINo();
                Component component3 = inventory.componentInventoryIIYes();
                Component component4 = inventory.componentInventoryIINo();
                if (inventory.hasCanChangeInventory()) {
                    if (inventory.isCanChangeInventory()) {
                        this.drawCenteredString(guiGraphics, this.f_96547_, component1, (int)((float)(this.f_97735_ + 176 + 8) / scale), (int)((float)(this.f_97736_ + 8) / scale), (int)((float)(this.f_97735_ + 176 + 57) / scale), (int)((float)(this.f_97736_ + 36) / scale), 0x262626);
                    } else {
                        this.drawCenteredString(guiGraphics, this.f_96547_, component2, (int)((float)(this.f_97735_ + 176 + 8) / scale), (int)((float)(this.f_97736_ + 8) / scale), (int)((float)(this.f_97735_ + 176 + 57) / scale), (int)((float)(this.f_97736_ + 36) / scale), 0x262626);
                    }
                }
                if (inventory.hasCanChangeMeleeOrRange()) {
                    if (inventory.isCanChangeMeleeOrRange()) {
                        this.drawCenteredString(guiGraphics, this.f_96547_, component3, (int)((float)(this.f_97735_ + 176 + 8) / scale), (int)((float)(this.f_97736_ + 28) / scale), (int)((float)(this.f_97735_ + 176 + 57) / scale), (int)((float)(this.f_97736_ + 56) / scale), 0x262626);
                    } else {
                        this.drawCenteredString(guiGraphics, this.f_96547_, component4, (int)((float)(this.f_97735_ + 176 + 8) / scale), (int)((float)(this.f_97736_ + 28) / scale), (int)((float)(this.f_97735_ + 176 + 57) / scale), (int)((float)(this.f_97736_ + 56) / scale), 0x262626);
                    }
                }
                poseStack.m_85849_();
                if (((MobInventoryGUIMenu)this.f_97732_).isCanUse()) {
                    if (inventory.hasCanChangeInventory()) {
                        if (inventory.isCanChangeInventory()) {
                            guiGraphics.m_280163_(YES, this.f_97735_ + 176 + 58, this.f_97736_ + 8, 0.0f, 0.0f, 20, 20, 20, 20);
                        } else {
                            guiGraphics.m_280163_(NO, this.f_97735_ + 176 + 58, this.f_97736_ + 8, 0.0f, 0.0f, 20, 20, 20, 20);
                        }
                    }
                    if (inventory.hasCanChangeMeleeOrRange()) {
                        if (inventory.isCanChangeMeleeOrRange()) {
                            guiGraphics.m_280163_(YES, this.f_97735_ + 176 + 58, this.f_97736_ + 28, 0.0f, 0.0f, 20, 20, 20, 20);
                        } else {
                            guiGraphics.m_280163_(NO, this.f_97735_ + 176 + 58, this.f_97736_ + 28, 0.0f, 0.0f, 20, 20, 20, 20);
                        }
                    }
                    if (inventory.hasCanChangeInventory()) {
                        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 176 + 58, this.f_97736_ + 8, 20, 20, 0, 0, 19, new ResourceLocation("jerotes", "container/null"), button -> {
                            button.m_264152_(this.f_97735_ + 176 + 58, this.f_97736_ + 8);
                            if (livingEntity.m_9236_().f_46443_) {
                                PacketHandler.sendToServer(new MobInventoryInventoryPacket(livingEntity.m_19879_()));
                            }
                        }));
                    }
                    if (inventory.hasCanChangeMeleeOrRange()) {
                        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 176 + 58, this.f_97736_ + 28, 20, 20, 0, 0, 19, new ResourceLocation("jerotes", "container/null"), button -> {
                            button.m_264152_(this.f_97735_ + 176 + 58, this.f_97736_ + 8);
                            if (livingEntity.m_9236_().f_46443_) {
                                PacketHandler.sendToServer(new MobInventoryMeleeOrRangePacket(livingEntity.m_19879_()));
                            }
                        }));
                    }
                }
            }
            int leftPosAdd = 82;
            int topPos = 28;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            float scale = 0.6f;
            poseStack.m_85841_(scale, scale, scale);
            if (livingEntity.m_21051_(Attributes.f_22276_) != null && livingEntity.m_21133_(Attributes.f_22276_) != 0.0) {
                add = "(" + livingEntity.m_21172_(Attributes.f_22276_) + ")";
                if (livingEntity.m_21172_(Attributes.f_22276_) == livingEntity.m_21133_(Attributes.f_22276_)) {
                    add = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.max_health").m_130946_(": " + livingEntity.m_21223_() + "/" + livingEntity.m_21133_(Attributes.f_22276_) + (String)add);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            if (livingEntity.m_21051_(Attributes.f_22284_) != null && livingEntity.m_21133_(Attributes.f_22284_) != 0.0) {
                add = "(" + livingEntity.m_21172_(Attributes.f_22284_) + ")";
                if (livingEntity.m_21172_(Attributes.f_22284_) == livingEntity.m_21133_(Attributes.f_22284_)) {
                    add = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.armor").m_130946_(": " + livingEntity.m_21133_(Attributes.f_22284_) + (String)add);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            if (livingEntity.m_21051_(Attributes.f_22285_) != null && livingEntity.m_21133_(Attributes.f_22285_) != 0.0) {
                add = "(" + livingEntity.m_21172_(Attributes.f_22285_) + ")";
                if (livingEntity.m_21172_(Attributes.f_22285_) == livingEntity.m_21133_(Attributes.f_22285_)) {
                    add = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.armor_toughness").m_130946_(": " + livingEntity.m_21133_(Attributes.f_22285_) + (String)add);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            if (livingEntity.m_21051_(Attributes.f_22279_) != null && livingEntity.m_21133_(Attributes.f_22279_) != 0.0) {
                add = "(" + livingEntity.m_21172_(Attributes.f_22279_) + ")";
                if (livingEntity.m_21172_(Attributes.f_22279_) == livingEntity.m_21133_(Attributes.f_22279_)) {
                    add = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.movement_speed").m_130946_(": " + livingEntity.m_21133_(Attributes.f_22279_) + (String)add);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            if (livingEntity.m_21051_(Attributes.f_22280_) != null && livingEntity.m_21133_(Attributes.f_22280_) != 0.0) {
                add = "(" + livingEntity.m_21172_(Attributes.f_22280_) + ")";
                if (livingEntity.m_21172_(Attributes.f_22280_) == livingEntity.m_21133_(Attributes.f_22280_)) {
                    add = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.flying_speed").m_130946_(": " + livingEntity.m_21133_(Attributes.f_22280_) + (String)add);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            if ((spellLevelLevel = ((MobInventoryGUIMenu)this.f_97732_).getSpellLevel()) != 0.0) {
                attribute = Component.m_237115_((String)"message.jerotes.spell_level").m_130946_(": " + spellLevelLevel);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            double attackDamage = ((MobInventoryGUIMenu)this.f_97732_).getAttackDamage() / 100.0;
            double baseAttackDamage = ((MobInventoryGUIMenu)this.f_97732_).getBaseAttackDamage() / 100.0;
            if (livingEntity.m_21051_(Attributes.f_22281_) != null && attackDamage != 0.0) {
                Object add2 = "(" + baseAttackDamage + ")";
                if (baseAttackDamage == attackDamage) {
                    add2 = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.attack_damage").m_130946_(": " + attackDamage + (String)add2);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            double attackKnockback = ((MobInventoryGUIMenu)this.f_97732_).getAttackKnockback() / 1000.0;
            double baseAttackKnockback = ((MobInventoryGUIMenu)this.f_97732_).getBaseAttackKnockback() / 1000.0;
            if (livingEntity.m_21051_(Attributes.f_22282_) != null && attackKnockback != 0.0) {
                Object add3 = "(" + baseAttackKnockback + ")";
                if (baseAttackKnockback == attackKnockback) {
                    add3 = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.attack_knockback").m_130946_(": " + attackKnockback + (String)add3);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
                Objects.requireNonNull(this.f_96547_);
                topPos += (int)(9.0f * scale);
            }
            double knockbackResistance = ((MobInventoryGUIMenu)this.f_97732_).getKnockbackResistance() / 1000.0;
            double baseKnockbackResistance = ((MobInventoryGUIMenu)this.f_97732_).getBaseKnockbackResistance() / 1000.0;
            if (livingEntity.m_21051_(Attributes.f_22278_) != null && knockbackResistance != 0.0) {
                Object add4 = "(" + baseKnockbackResistance + ")";
                if (baseKnockbackResistance == knockbackResistance) {
                    add4 = "";
                }
                attribute = Component.m_237115_((String)"attribute.name.generic.knockback_resistance").m_130946_(": " + knockbackResistance + (String)add4);
                guiGraphics.m_280614_(this.f_96547_, (Component)attribute, (int)((float)(this.f_97735_ + leftPosAdd) / scale), (int)((float)(this.f_97736_ + topPos) / scale), 0x262626, false);
            }
            poseStack.m_85849_();
            String string = ((MobInventoryGUIMenu)this.f_97732_).getMobFaction();
            String string2 = ((MobInventoryGUIMenu)this.f_97732_).getMobFactionModId();
            ResourceLocation faction = new ResourceLocation(string2, "textures/gui/sprites/faction/" + string + ".png");
            if (!string.isEmpty()) {
                guiGraphics.m_280163_(faction, this.f_97735_ + 44, this.f_97736_ + 62, 0.0f, 0.0f, 16, 16, 16, 16);
                textX = this.f_97735_ + 43;
                textY = this.f_97736_ + 61;
                textWidth = 18;
                textHeight = 18;
                if (mouseX >= textX && mouseX <= textX + textWidth && mouseY >= textY && mouseY <= textY + textHeight) {
                    Mob mob2;
                    tooltip = new ArrayList();
                    tooltip.add((Component)Component.m_237115_((String)("message." + string2 + "." + string)).m_130940_(ChatFormatting.GOLD));
                    tooltip.add(livingEntity.m_6095_().m_20676_());
                    String sizeString = "size_medium";
                    if (Main.mobSizeSmall((Entity)livingEntity)) {
                        sizeString = "size_small";
                    } else if (Main.mobSizeMedium((Entity)livingEntity)) {
                        sizeString = "size_medium";
                    } else if (Main.mobSizeLarge((Entity)livingEntity)) {
                        sizeString = "size_large";
                    } else if (Main.mobSizeGiant((Entity)livingEntity)) {
                        sizeString = "size_giant";
                    }
                    tooltip.add((Component)Component.m_237115_((String)("message.jerotes." + sizeString)).m_130940_(ChatFormatting.BLUE));
                    tooltip.add((Component)Component.m_237110_((String)"message.jerotes.width", (Object[])new Object[]{Float.valueOf(Main.mobWidth((Entity)livingEntity))}).m_130940_(ChatFormatting.BLUE));
                    tooltip.add((Component)Component.m_237110_((String)"message.jerotes.height", (Object[])new Object[]{Float.valueOf(Main.mobHeight((Entity)livingEntity))}).m_130940_(ChatFormatting.BLUE));
                    if (((MobInventoryGUIMenu)this.f_97732_).getFireTick() > 0.0) {
                        tooltip.add((Component)Component.m_237110_((String)"message.jerotes.fire", (Object[])new Object[]{((MobInventoryGUIMenu)this.f_97732_).getFireTick() / 20.0}).m_130940_(ChatFormatting.BLUE));
                    }
                    if (((MobInventoryGUIMenu)this.f_97732_).getFreezeTick() > 0.0) {
                        tooltip.add((Component)Component.m_237110_((String)"message.jerotes.freeze", (Object[])new Object[]{((MobInventoryGUIMenu)this.f_97732_).getFreezeTick() / 20.0}).m_130940_(ChatFormatting.BLUE));
                    }
                    if (livingEntity instanceof Mob) {
                        AgeableMob ageableMob;
                        AgeableMob ageableMob2;
                        CompoundTag compoundTag = new CompoundTag();
                        livingEntity.m_7380_(compoundTag);
                        if (compoundTag.m_128423_("Strength") != null) {
                            tooltip.add((Component)Component.m_237110_((String)"message.jerotes.mob_strength", (Object[])new Object[]{compoundTag.m_128423_("Strength")}).m_130940_(ChatFormatting.AQUA));
                        }
                        if (livingEntity instanceof VillagerDataHolder) {
                            VillagerDataHolder villagerDataHolder = (VillagerDataHolder)livingEntity;
                            tooltip.add((Component)Component.m_237110_((String)("entity.minecraft.villager." + villagerDataHolder.m_7141_().m_35571_().f_35600_()), (Object[])new Object[]{compoundTag.m_128423_("Strength")}).m_130940_(ChatFormatting.AQUA));
                        }
                        if (compoundTag.m_128425_("Color", 1)) {
                            String color = "color.minecraft." + DyeColor.m_41053_((int)compoundTag.m_128445_("Color")).m_41065_();
                            MutableComponent component = Component.m_237115_((String)color);
                            tooltip.add((Component)Component.m_237110_((String)"message.jerotes.color", (Object[])new Object[]{component}).m_130940_(ChatFormatting.AQUA));
                        }
                        if ((!(livingEntity instanceof AgeableMob) || (ageableMob2 = (AgeableMob)livingEntity).m_6162_()) && (compoundTag.m_128423_("IsBaby") != null && compoundTag.m_128471_("IsBaby") || livingEntity instanceof AgeableMob && (ageableMob = (AgeableMob)livingEntity).m_6162_() || compoundTag.m_128425_("Age", 3) && compoundTag.m_128451_("Age") < 0)) {
                            tooltip.add((Component)Component.m_237115_((String)"message.jerotes.mob_is_baby").m_130940_(ChatFormatting.AQUA));
                        } else if (livingEntity instanceof AgeableMob) {
                            tooltip.add((Component)Component.m_237115_((String)"message.jerotes.mob_not_baby").m_130940_(ChatFormatting.AQUA));
                        }
                        if (compoundTag.m_128423_("Size") != null) {
                            tooltip.add((Component)Component.m_237110_((String)"message.jerotes.mob_size", (Object[])new Object[]{compoundTag.m_128423_("Size")}).m_130940_(ChatFormatting.AQUA));
                        }
                        if (Main.isTrusted(livingEntity, (LivingEntity)this.player, false)) {
                            tooltip.add((Component)Component.m_237110_((String)"message.jerotes.trust", (Object[])new Object[]{livingEntity.m_7755_(), this.player.m_7755_()}).m_130940_(ChatFormatting.GREEN));
                        }
                    }
                    if (livingEntity instanceof OwnableEntity) {
                        OwnableEntity ownable = (OwnableEntity)livingEntity;
                        Object livingOwner = null;
                        if (ownable.m_269323_() != null) {
                            livingOwner = ownable.m_269323_();
                        } else {
                            List list = livingEntity.m_9236_().m_45976_(Mob.class, livingEntity.m_20191_().m_82377_(64.0, 64.0, 64.0));
                            for (Mob owner : list) {
                                if (owner == null || owner.m_20148_() != ownable.m_21805_()) continue;
                                livingOwner = owner;
                                break;
                            }
                        }
                        if (livingOwner != null) {
                            tooltip.add((Component)Component.m_237110_((String)"message.jerotes.owner", (Object[])new Object[]{livingOwner.m_7755_()}).m_130940_(ChatFormatting.GREEN));
                        }
                    }
                    if (livingEntity instanceof Mob && (mob2 = (Mob)livingEntity).m_5912_()) {
                        tooltip.add((Component)Component.m_237115_((String)"message.jerotes.aggressive").m_130940_(ChatFormatting.RED));
                    }
                    if (livingEntity instanceof NeutralMob) {
                        tooltip.add((Component)Component.m_237115_((String)"message.jerotes.neutral").m_130940_(ChatFormatting.YELLOW));
                    }
                    if (livingEntity instanceof Enemy) {
                        tooltip.add((Component)Component.m_237115_((String)"message.jerotes.enemy").m_130940_(ChatFormatting.RED));
                    }
                    if (livingEntity instanceof EliteEntity) {
                        tooltip.add((Component)Component.m_237115_((String)"message.jerotes.elite").m_130940_(ChatFormatting.AQUA));
                    }
                    if (EntityAndItemFind.isBoss(livingEntity.m_6095_()) || livingEntity instanceof BossEntity) {
                        tooltip.add((Component)Component.m_237115_((String)"message.jerotes.boss").m_130940_(ChatFormatting.DARK_PURPLE));
                    }
                    List<String> stringList = EntityFactionFind.getAllFindFaction(livingEntity);
                    for (String stringType : stringList) {
                        if (stringType == null) continue;
                        tooltip.add((Component)Component.m_237115_((String)("message.jerotes." + stringType)).m_130940_(ChatFormatting.WHITE));
                    }
                    if (livingEntity instanceof JerotesEntity) {
                        JerotesEntity jerotes = (JerotesEntity)livingEntity;
                        jerotes.MobInventoryAddTooltip(tooltip, (LivingEntity)this.player);
                    }
                    if (livingEntity.m_5647_() != null) {
                        tooltip.add((Component)Component.m_237110_((String)"message.jerotes.faction", (Object[])new Object[]{livingEntity.m_5647_().m_5758_()}).m_130940_(livingEntity.m_5647_().m_7414_()));
                    }
                    guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
                }
            }
            textX = this.f_97735_ + 8;
            textY = this.f_97736_ + 8;
            textWidth = 8;
            textHeight = 8;
            if (mouseX >= textX && mouseX <= textX + textWidth && mouseY >= textY && mouseY <= textY + textHeight) {
                tooltip = new ArrayList<Component>();
                tooltip.add((Component)Component.m_237115_((String)"message.jerotes.effect_click").m_130940_(ChatFormatting.DARK_GREEN));
                guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
            }
            guiGraphics.m_280163_(EFFECT, this.f_97735_ + 8, this.f_97736_ + 8, 0.0f, 0.0f, 8, 8, 8, 8);
            this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 8, this.f_97736_ + 8, 8, 8, 0, 0, 7, new ResourceLocation("jerotes", "container/null"), button -> {
                button.m_264152_(this.f_97735_ + 8, this.f_97736_ + 8);
                if (livingEntity.m_9236_().f_46443_) {
                    PacketHandler.sendToServer(new MobSendEffectsPacket(livingEntity.m_19879_()));
                }
            }));
            if (((MobInventoryGUIMenu)this.f_97732_).isCanUse()) {
                textX = this.f_97735_ + 168;
                textY = this.f_97736_ + 1;
                textWidth = 6;
                textHeight = 6;
                if (mouseX >= textX && mouseX <= textX + textWidth && mouseY >= textY && mouseY <= textY + textHeight) {
                    tooltip = new ArrayList();
                    tooltip.add((Component)Component.m_237115_((String)"message.jerotes.share").m_130940_(ChatFormatting.YELLOW));
                    guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
                }
                guiGraphics.m_280163_(SHARE, this.f_97735_ + 168, this.f_97736_ + 1, 0.0f, 0.0f, 6, 6, 6, 6);
                this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 168, this.f_97736_ + 1, 6, 6, 0, 0, 7, new ResourceLocation("jerotes", "container/null"), button -> {
                    button.m_264152_(this.f_97735_ + 168, this.f_97736_ + 1);
                    if (livingEntity.m_9236_().f_46443_) {
                        PacketHandler.sendToServer(new SendMobInventoryPacket(livingEntity.m_19879_()));
                    }
                }));
            }
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidgets(T t) {
        return (T)this.m_142416_(t);
    }

    private void drawCenteredString(GuiGraphics guiGraphics, Font font, Component text, int x1, int y1, int x2, int y2, int color) {
        int textWidth = font.m_92852_((FormattedText)text);
        Objects.requireNonNull(font);
        int textHeight = 9;
        int centerX = x1 + (x2 - x1) / 2 - textWidth / 2;
        int centerY = y1 + (y2 - y1) / 2 - textHeight / 2 - textHeight / 2;
        guiGraphics.m_280614_(font, text, centerX, centerY, color, false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        Entity entity;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        int size = 4;
        if (((MobInventoryGUIMenu)this.f_97732_).boundEntity instanceof LivingEntity && (entity = ((MobInventoryGUIMenu)this.f_97732_).boundEntity) instanceof InventoryEntity) {
            InventoryEntity inventory = (InventoryEntity)entity;
            guiGraphics.m_280163_(TEXTURE_INVENTORY, this.f_97735_ + 176, this.f_97736_, 0.0f, 0.0f, 86, 166, 86, 166);
            container = inventory.mobInventory();
            int inventoryCount = container.m_6643_();
            if (inventoryCount > 20) {
                size = 8;
            }
            int lineCount = (inventoryCount + size - 1) / size;
            int remainder = inventoryCount % size;
            int lastRowSlots = remainder == 0 ? size : remainder;
            for (int height = 0; height < lineCount; ++height) {
                int currentRowSlots = height == lineCount - 1 ? lastRowSlots : size;
                for (int width = 0; width < currentRowSlots; ++width) {
                    guiGraphics.m_280163_(SLOT, this.f_97735_ + 176 + 7 + width * 18, this.f_97736_ + 49 + height * 18, 0.0f, 0.0f, 18, 18, 18, 18);
                }
            }
        } else {
            container = ((MobInventoryGUIMenu)this.f_97732_).boundEntity;
            if (container instanceof AbstractVillager) {
                AbstractVillager abstractVillager = (AbstractVillager)container;
                guiGraphics.m_280163_(TEXTURE_INVENTORY, this.f_97735_ + 176, this.f_97736_, 0.0f, 0.0f, 86, 166, 86, 166);
                container = abstractVillager.m_35311_();
                int inventoryCount = container.m_6643_();
                if (inventoryCount > 20) {
                    size = 8;
                }
                int lineCount = (inventoryCount + size - 1) / size;
                int remainder = inventoryCount % size;
                int lastRowSlots = remainder == 0 ? size : remainder;
                for (int height = 0; height < lineCount; ++height) {
                    int currentRowSlots = height == lineCount - 1 ? lastRowSlots : size;
                    for (int width = 0; width < currentRowSlots; ++width) {
                        guiGraphics.m_280163_(SLOT, this.f_97735_ + 176 + 7 + width * 18, this.f_97736_ + 49 + height * 18, 0.0f, 0.0f, 18, 18, 18, 18);
                    }
                }
            } else {
                container = ((MobInventoryGUIMenu)this.f_97732_).boundEntity;
                if (container instanceof Piglin) {
                    Piglin piglin = (Piglin)container;
                    guiGraphics.m_280163_(TEXTURE_INVENTORY, this.f_97735_ + 176, this.f_97736_, 0.0f, 0.0f, 86, 166, 86, 166);
                    container = piglin.m_35311_();
                    int inventoryCount = container.m_6643_();
                    if (inventoryCount > 20) {
                        size = 8;
                    }
                    int lineCount = (inventoryCount + size - 1) / size;
                    int remainder = inventoryCount % size;
                    int lastRowSlots = remainder == 0 ? size : remainder;
                    for (int height = 0; height < lineCount; ++height) {
                        int currentRowSlots = height == lineCount - 1 ? lastRowSlots : size;
                        for (int width = 0; width < currentRowSlots; ++width) {
                            guiGraphics.m_280163_(SLOT, this.f_97735_ + 176 + 7 + width * 18, this.f_97736_ + 49 + height * 18, 0.0f, 0.0f, 18, 18, 18, 18);
                        }
                    }
                } else {
                    container = ((MobInventoryGUIMenu)this.f_97732_).boundEntity;
                    if (container instanceof Allay) {
                        Allay allay = (Allay)container;
                        guiGraphics.m_280163_(TEXTURE_INVENTORY, this.f_97735_ + 176, this.f_97736_, 0.0f, 0.0f, 86, 166, 86, 166);
                        container = allay.m_35311_();
                        int inventoryCount = container.m_6643_();
                        if (inventoryCount > 20) {
                            size = 8;
                        }
                        int lineCount = (inventoryCount + size - 1) / size;
                        int remainder = inventoryCount % size;
                        int lastRowSlots = remainder == 0 ? size : remainder;
                        for (int height = 0; height < lineCount; ++height) {
                            int currentRowSlots = height == lineCount - 1 ? lastRowSlots : size;
                            for (int width = 0; width < currentRowSlots; ++width) {
                                guiGraphics.m_280163_(SLOT, this.f_97735_ + 176 + 7 + width * 18, this.f_97736_ + 49 + height * 18, 0.0f, 0.0f, 18, 18, 18, 18);
                            }
                        }
                    } else {
                        container = ((MobInventoryGUIMenu)this.f_97732_).boundEntity;
                        if (container instanceof Player) {
                            Player players = (Player)container;
                            guiGraphics.m_280163_(TEXTURE_INVENTORY, this.f_97735_ + 176, this.f_97736_, 0.0f, 0.0f, 86, 166, 86, 166);
                            container = players.m_150109_();
                            int inventoryCount = container.m_6643_();
                            if (inventoryCount > 20) {
                                size = 8;
                            }
                            int lineCount = (inventoryCount + size - 1) / size;
                            int remainder = inventoryCount % size;
                            int lastRowSlots = remainder == 0 ? size : remainder;
                            for (int height = 0; height < lineCount; ++height) {
                                int currentRowSlots = height == lineCount - 1 ? lastRowSlots : size;
                                for (int width = 0; width < currentRowSlots; ++width) {
                                    guiGraphics.m_280163_(SLOT, this.f_97735_ + 176 + 7 + width * 18, this.f_97736_ + 49 + height * 18, 0.0f, 0.0f, 18, 18, 18, 18);
                                }
                            }
                        }
                    }
                }
            }
        }
        RenderSystem.disableBlend();
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_6915_();
            }
            return true;
        }
        return super.m_7933_(key, b, c);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_7856_() {
        super.m_7856_();
    }
}

