/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.client.model;

import com.jerotes.jerotes.client.animation.SpearAnimations;
import com.jerotes.jerotes.compat.tacz.TaczAnimate;
import com.jerotes.jerotes.item.tool.ItemToolBasePike;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class Modelspecial_action<T extends LivingEntity>
extends PlayerModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("jerotes", "special_action"), "main");
    private final ModelPart root;
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart jacket;
    public final ModelPart left_arm;
    public final ModelPart left_sleeve;
    public final ModelPart right_arm;
    public final ModelPart right_sleeve;
    public final ModelPart left_leg;
    public final ModelPart left_pants;
    public final ModelPart right_leg;
    public final ModelPart right_pants;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public Modelspecial_action(ModelPart root) {
        super(root, false);
        this.root = root;
        this.head = root.m_171324_("head");
        this.hat = root.m_171324_("hat");
        this.body = root.m_171324_("body");
        this.jacket = root.m_171324_("jacket");
        this.left_arm = root.m_171324_("left_arm");
        this.left_sleeve = root.m_171324_("left_sleeve");
        this.right_arm = root.m_171324_("right_arm");
        this.right_sleeve = root.m_171324_("right_sleeve");
        this.left_leg = root.m_171324_("left_leg");
        this.left_pants = root.m_171324_("left_pants");
        this.right_leg = root.m_171324_("right_leg");
        this.right_pants = root.m_171324_("right_pants");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("ear", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("cloak", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jacket = partdefinition.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_sleeve = partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_sleeve = partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_pants = partdefinition.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_pants = partdefinition.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6973_(T t, float f, float f2, float f3, float f4, float f5) {
        super.m_6973_(t, f, f2, f3, f4, f5);
    }

    public ModelPart root() {
        return this.root;
    }

    protected void animate(AnimationState state, AnimationDefinition definition, float tickCount) {
        this.animate(state, definition, tickCount, 1.0f);
    }

    protected void animate(AnimationState state, AnimationDefinition definition, float tickCount, float speed) {
        state.m_216974_(tickCount, speed);
        state.m_216979_(animState -> Modelspecial_action.animate(this, definition, animState.m_216981_(), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void animateWalk(AnimationDefinition definition, float swing, float swingAmount, float speed, float scale) {
        long accumulatedTime = (long)(swing * 50.0f * speed);
        float interpolationScale = Math.min(swingAmount * scale, 1.0f);
        Modelspecial_action.animate(this, definition, accumulatedTime, interpolationScale, ANIMATION_VECTOR_CACHE);
    }

    public Optional<ModelPart> getAnyDescendantWithName(String name) {
        return name.equals("root") ? Optional.of(this.root()) : this.root().m_171331_().filter(part -> part.m_233562_(name)).findFirst().map(part -> part.m_171324_(name));
    }

    public static void animate(Modelspecial_action model, AnimationDefinition definition, long accumulatedTime, float scale, Vector3f cache) {
        float f = Modelspecial_action.getElapsedSeconds(definition, accumulatedTime);
        for (Map.Entry entry : definition.f_232257_().entrySet()) {
            Optional<ModelPart> optional = model.getAnyDescendantWithName((String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(modelPart -> list.forEach(animationChannel -> {
                Keyframe[] akeyframe = animationChannel.f_232212_();
                int i = Math.max(0, Mth.m_14049_((int)0, (int)akeyframe.length, i1 -> f <= akeyframe[i1].f_232283_()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.f_232283_();
                float f2 = Mth.m_14036_((float)(f1 / (keyframe1.f_232283_() - keyframe.f_232283_())), (float)0.0f, (float)1.0f);
                keyframe1.f_232285_().m_232222_(cache, f2, akeyframe, i, j, scale);
                animationChannel.f_232211_().m_232247_(modelPart, cache);
            }));
        }
    }

    private static float getElapsedSeconds(AnimationDefinition definition, long accumulatedTime) {
        float f = (float)accumulatedTime / 1000.0f;
        return definition.f_232256_() ? f % definition.f_232255_() : f;
    }

    public static void specialAnim(LivingEntity living, Modelspecial_action modelspecialAction, float limbSwing, float limbSwingAmount, float ageInTicks, float netbipedHeadYaw, float bipedHeadPitch) {
        Modelspecial_action.specialAnim(living, modelspecialAction, modelspecialAction.head, modelspecialAction.right_arm, modelspecialAction.left_arm, modelspecialAction.body, limbSwing, limbSwingAmount, ageInTicks, netbipedHeadYaw, bipedHeadPitch);
    }

    public boolean shouldTaczIdle() {
        return true;
    }

    public static void specialAnim(LivingEntity living, Modelspecial_action model, ModelPart head, ModelPart rightArm, ModelPart leftArm, ModelPart body, float limbSwing, float limbSwingAmount, float ageInTicks, float netbipedHeadYaw, float bipedHeadPitch) {
        ItemToolBaseSpearBase itemToolBaseSpearBase;
        Item item;
        ModelPart mainHand;
        Mob mob;
        ItemStack itemStack = living.m_21205_();
        ItemStack itemStacks = living.m_21206_();
        boolean bl3 = living.m_21256_() > 4;
        boolean bl4 = living.m_6067_();
        if (!(living instanceof Mob) || !(mob = (Mob)living).m_21526_()) {
            mainHand = rightArm;
            ModelPart offHand = leftArm;
        } else {
            mainHand = leftArm;
            ModelPart offHand = rightArm;
        }
        if (living.m_21205_().m_41720_().m_5524_().contains("modern_kinetic_gun") && model.shouldTaczIdle()) {
            if (mainHand == rightArm) {
                rightArm.f_104204_ = -0.1f + head.f_104204_;
                leftArm.f_104204_ = 0.1f + head.f_104204_ + 0.4f;
            } else {
                rightArm.f_104204_ = -0.1f + head.f_104204_ - 0.4f;
                leftArm.f_104204_ = 0.1f + head.f_104204_;
            }
            rightArm.f_104203_ = -1.5707964f + head.f_104203_;
            leftArm.f_104203_ = -1.5707964f + head.f_104203_;
            TaczAnimate.setRotationAnglesHead(living, rightArm, leftArm, body, head, limbSwingAmount);
        }
        if (Modelspecial_action.poseRightArm(model, living)) {
            SpearAnimations.thirdPersonHandUse(rightArm, head, true, living.m_21211_(), model, living);
        }
        if (Modelspecial_action.poseLeftArm(model, living)) {
            SpearAnimations.thirdPersonHandUse(leftArm, head, false, living.m_21211_(), model, living);
        }
        if ((item = living.m_21205_().m_41720_()) instanceof ItemToolBaseSpearBase && !(itemToolBaseSpearBase = (ItemToolBaseSpearBase)item).otherAnimSpear() && !(model.f_102608_ <= 0.0f)) {
            ModelPart modelPart;
            HumanoidArm humanoidarm = Modelspecial_action.m_102856_(living);
            ModelPart modelpart = model.m_102851_(humanoidarm);
            float f = model.f_102608_;
            model.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                modelPart = model.body;
                modelPart.f_104204_ *= -1.0f;
            }
            rightArm.f_104202_ = Mth.m_14031_((float)body.f_104204_) * 5.0f;
            rightArm.f_104200_ = -Mth.m_14089_((float)body.f_104204_) * 5.0f;
            leftArm.f_104202_ = -Mth.m_14031_((float)body.f_104204_) * 5.0f;
            leftArm.f_104200_ = Mth.m_14089_((float)body.f_104204_) * 5.0f;
            modelPart = rightArm;
            modelPart.f_104204_ += body.f_104204_;
            modelPart = leftArm;
            modelPart.f_104204_ += body.f_104204_;
            modelPart = leftArm;
            modelPart.f_104203_ += body.f_104204_;
            SpearAnimations.thirdPersonAttackHand(model, model, living);
        }
        if (living.m_21205_().m_41720_() instanceof ItemToolBasePike) {
            if (living.m_5737_() == HumanoidArm.RIGHT) {
                ItemToolBasePike.animate(rightArm, leftArm, living, false);
                SpearAnimations.thirdPersonHandUse(rightArm, head, true, living.m_21211_(), model, living);
                if (living.m_6117_() && living.m_7655_() == InteractionHand.MAIN_HAND) {
                    float f = 1.0f - (float)Math.min(25, living.m_21252_()) / 25.0f;
                    if (f > 0.0f && (double)f <= 0.4) {
                        float fs = f / 0.4f;
                        rightArm.f_104204_ += fs * 0.35f;
                    } else if ((double)f > 0.4 && (double)f <= 0.5) {
                        float fs = (f - 0.4f) / 0.1f;
                        rightArm.f_104204_ += 0.35f + fs * -0.55f;
                    } else if ((double)f > 0.5) {
                        float fs = 1.0f - (f - 0.5f) / 0.5f;
                        rightArm.f_104204_ += fs * -0.2f;
                    }
                }
            } else {
                ItemToolBasePike.animate(rightArm, leftArm, living, true);
                SpearAnimations.thirdPersonHandUse(leftArm, head, false, living.m_21211_(), model, living);
                if (living.m_6117_() && living.m_7655_() == InteractionHand.MAIN_HAND) {
                    float f = 1.0f - (float)Math.min(25, living.m_21252_()) / 25.0f;
                    if (f > 0.0f && (double)f <= 0.4) {
                        float fs = f / 0.4f;
                        leftArm.f_104204_ -= fs * 0.35f;
                    } else if ((double)f > 0.4 && (double)f <= 0.5) {
                        float fs = (f - 0.4f) / 0.1f;
                        leftArm.f_104204_ -= 0.35f + fs * -0.55f;
                    } else if ((double)f > 0.5) {
                        float fs = 1.0f - (f - 0.5f) / 0.5f;
                        leftArm.f_104204_ -= fs * -0.2f;
                    }
                }
            }
            if (living.m_21205_().m_41720_() instanceof ItemToolBasePike && !(model.f_102608_ <= 0.0f)) {
                HumanoidArm humanoidarm = Modelspecial_action.m_102856_(living);
                ModelPart modelpart = model.m_102851_(humanoidarm);
                float f = model.f_102608_;
                model.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
                if (humanoidarm == HumanoidArm.LEFT) {
                    ModelPart modelPart = model.body;
                    modelPart.f_104204_ *= -1.0f;
                }
                rightArm.f_104202_ = Mth.m_14031_((float)body.f_104204_) * 5.0f;
                rightArm.f_104200_ = -Mth.m_14089_((float)body.f_104204_) * 5.0f;
                leftArm.f_104202_ = -Mth.m_14031_((float)body.f_104204_) * 5.0f;
                leftArm.f_104200_ = Mth.m_14089_((float)body.f_104204_) * 5.0f;
                ModelPart modelPart = rightArm;
                modelPart.f_104204_ += body.f_104204_;
                modelPart = leftArm;
                modelPart.f_104204_ += body.f_104204_;
                modelPart = leftArm;
                modelPart.f_104203_ += body.f_104204_;
                ItemToolBasePike.animateAttack(model, model, living);
            }
        }
    }

    public static HumanoidArm m_102856_(LivingEntity p_102857_) {
        HumanoidArm humanoidarm = p_102857_.m_5737_();
        return p_102857_.f_20912_ == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.m_20828_();
    }

    public static boolean poseRightArm(HumanoidModel<?> humanoidModel, LivingEntity entity) {
        boolean spear;
        boolean bl = spear = humanoidModel.f_102816_ == ItemToolBaseSpearBase.SpearClient.SPEAR_POSE;
        if (!(entity instanceof Player)) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                if (entity.m_21211_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_7655_() == InteractionHand.MAIN_HAND) {
                    spear = true;
                } else if (entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) {
                    spear = false;
                } else if (!(entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) && entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase) {
                    spear = true;
                }
            } else if (entity.m_21211_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_7655_() != InteractionHand.MAIN_HAND) {
                spear = true;
            } else if (entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) {
                spear = true;
            } else if (!(entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase) && entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) {
                spear = true;
            }
        }
        return spear;
    }

    public static boolean poseLeftArm(HumanoidModel<?> humanoidModel, LivingEntity entity) {
        boolean spear;
        boolean bl = spear = humanoidModel.f_102815_ == ItemToolBaseSpearBase.SpearClient.SPEAR_POSE;
        if (!(entity instanceof Player)) {
            if (entity.m_5737_() == HumanoidArm.LEFT) {
                if (entity.m_21211_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_7655_() == InteractionHand.MAIN_HAND) {
                    spear = true;
                } else if (entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) {
                    spear = false;
                } else if (!(entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) && entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase) {
                    spear = true;
                }
            } else if (entity.m_21211_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_7655_() != InteractionHand.MAIN_HAND) {
                spear = true;
            } else if (entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) {
                spear = true;
            } else if (!(entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase) && entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) {
                spear = true;
            }
        }
        return spear;
    }
}

