/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.client.renderer;

import com.jerotes.jerotes.client.layer.HumanSkinEntityBodyLayer;
import com.jerotes.jerotes.client.layer.TruesightLayer;
import com.jerotes.jerotes.client.model.Modelhumanoid_wide_or_slim;
import com.jerotes.jerotes.client.model.Modelhumanoid_wide_or_slim_for_human;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.Mob.HumanEntity;
import com.jerotes.jerotes.entity.Mob.JerotesPlayerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class HumanRenderer
extends HumanoidMobRenderer<HumanEntity, Modelhumanoid_wide_or_slim<HumanEntity>> {
    private static final ResourceLocation NULL_LOCATION = new ResourceLocation("jerotes", "textures/entity/null.png");

    public HumanRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelhumanoid_wide_or_slim(context.m_174023_(Modelhumanoid_wide_or_slim.LAYER_LOCATION)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_(new HumanSkinEntityBodyLayer(this, new Modelhumanoid_wide_or_slim(context.m_174023_(Modelhumanoid_wide_or_slim_for_human.LAYER_LOCATION)), "human"));
        this.m_115326_(new TruesightLayer(this));
    }

    protected void scale(HumanEntity entity, PoseStack poseStack, float f) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
        super.m_7546_((LivingEntity)entity, poseStack, f);
    }

    public void render(HumanEntity humanEntity, float p_117789_, float p_117790_, PoseStack p_117791_, MultiBufferSource p_117792_, int p_117793_) {
        super.m_7392_((Mob)humanEntity, p_117789_, p_117790_, p_117791_, p_117792_, p_117793_);
    }

    public static String sanitizeString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String lowerCase = input.toLowerCase(Locale.ROOT);
        String sanitized = lowerCase.replaceAll("[^a-z0-9_./-]", "_");
        sanitized = sanitized.replaceAll(" ", "_");
        return sanitized;
    }

    private static HumanoidModel.ArmPose getArmPose(HumanEntity p_117795_, InteractionHand p_117796_) {
        HumanoidModel.ArmPose forgeArmPose;
        ItemStack itemstack = p_117795_.m_21120_(p_117796_);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_117795_.m_7655_() == p_117796_ && p_117795_.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && p_117796_ == p_117795_.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useanim == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (useanim == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!p_117795_.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return (forgeArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose((LivingEntity)p_117795_, p_117796_, itemstack)) != null ? forgeArmPose : HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(HumanEntity entity) {
        String string = ChatFormatting.m_126649_((String)entity.m_7755_().getString());
        String slim = "wide";
        if (entity.IsFemale()) {
            slim = "slim";
        }
        if (entity.m_7770_() != null) {
            if (string != null && !string.isEmpty() && MainConfig.HumanCustomNameWide.contains(string)) {
                return new ResourceLocation("jerotes", "textures/entity/custom_skin/" + HumanRenderer.sanitizeString(string) + ".png");
            }
            if (string != null && !string.isEmpty() && MainConfig.HumanCustomNameSlim.contains(string)) {
                return new ResourceLocation("jerotes", "textures/entity/custom_skin/" + HumanRenderer.sanitizeString(string) + ".png");
            }
        }
        if ("Steve".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/steve.png");
        }
        if ("Alex".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/alex.png");
        }
        if ("Ari".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/ari.png");
        }
        if ("Kai".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/kai.png");
        }
        if ("Noor".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/noor.png");
        }
        if ("Sunny".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/sunny.png");
        }
        if ("Zuri".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/zuri.png");
        }
        if ("Efe".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/efe.png");
        }
        if ("Makena".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/makena.png");
        }
        return MainConfig.RandomSkinMobHasUnderTexture ? new ResourceLocation("jerotes", "minecraft:textures/entity/player/" + slim + "/steve.png") : NULL_LOCATION;
    }

    protected boolean shouldShowName(HumanEntity entity) {
        return super.m_6512_((Mob)entity) || entity instanceof JerotesPlayerEntity;
    }
}

