/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.client.renderer;

import com.jerotes.jerotes.client.layer.HumanSkinEntityBodyLayer;
import com.jerotes.jerotes.client.layer.JerotesPlayerItemInHandLayer;
import com.jerotes.jerotes.client.layer.TruesightLayer;
import com.jerotes.jerotes.client.model.Modelhumanoid_wide_or_slim_for_human;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.Mob.HumanEntity;
import com.jerotes.jerotes.entity.Mob.JerotesPlayerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fluids.FluidType;

public class JerotesPlayerRenderer
extends MobRenderer<HumanEntity, Modelhumanoid_wide_or_slim_for_human<HumanEntity>> {
    private static final ResourceLocation NULL_LOCATION = new ResourceLocation("jerotes", "textures/entity/null.png");

    public JerotesPlayerRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelhumanoid_wide_or_slim_for_human(context.m_174023_(Modelhumanoid_wide_or_slim_for_human.LAYER_LOCATION)), 0.5f);
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), 1.0f, 1.0f, 1.0f, context.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new JerotesPlayerItemInHandLayer(this, context.m_234598_()));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_(new HumanSkinEntityBodyLayer(this, new Modelhumanoid_wide_or_slim_for_human(context.m_174023_(Modelhumanoid_wide_or_slim_for_human.LAYER_LOCATION)), "human"));
        this.m_115326_(new TruesightLayer(this));
    }

    protected void scale(HumanEntity entity, PoseStack poseStack, float f) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
        super.m_7546_((LivingEntity)entity, poseStack, f);
    }

    public void render(HumanEntity humanEntity, float p_117789_, float p_117790_, PoseStack p_117791_, MultiBufferSource p_117792_, int p_117793_) {
        super.m_7392_((Mob)humanEntity, p_117789_, p_117790_, p_117791_, p_117792_, p_117793_);
    }

    public static String sanitizeString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String lowerCase = input.toLowerCase(Locale.ROOT);
        String sanitized = lowerCase.replaceAll("[^a-z0-9_./-]", "_");
        sanitized = sanitized.replaceAll(" ", "_");
        return sanitized;
    }

    public static void setModelProperties(Modelhumanoid_wide_or_slim_for_human<?> playermodel, HumanEntity humanEntity) {
        if (humanEntity.m_5833_()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102817_ = humanEntity.m_6047_();
            HumanoidModel.ArmPose humanoidmodel$armpose = JerotesPlayerRenderer.getArmPose(humanEntity, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose humanoidmodel$armpose1 = JerotesPlayerRenderer.getArmPose(humanEntity, InteractionHand.OFF_HAND);
            if (humanoidmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = humanEntity.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (humanEntity.m_5737_() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = humanoidmodel$armpose;
                playermodel.f_102815_ = humanoidmodel$armpose1;
            } else {
                playermodel.f_102816_ = humanoidmodel$armpose1;
                playermodel.f_102815_ = humanoidmodel$armpose;
            }
        }
    }

    protected void setupRotations(HumanEntity p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.m_20998_(p_117806_);
        if (p_117802_.m_21255_()) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f3 = (float)p_117802_.m_21256_() + p_117806_;
            float f2 = Mth.m_14036_((float)(f3 * f3 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.m_21209_()) {
                p_117803_.m_252781_(Axis.f_252529_.m_252977_(f2 * (-90.0f - p_117802_.m_146909_())));
            }
            Vec3 vec3 = p_117802_.m_20252_(p_117806_);
            Vec3 vec31 = p_117802_.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                p_117803_.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f3 = !p_117802_.m_20069_() && !p_117802_.isInFluidType((fluidType, height) -> p_117802_.canSwimInFluidType((FluidType)fluidType)) ? -90.0f : -90.0f - p_117802_.m_146909_();
            float f2 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            p_117803_.m_252781_(Axis.f_252529_.m_252977_(f2));
            if (p_117802_.m_6067_()) {
                p_117803_.m_252880_(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
    }

    public Vec3 getRenderOffset(HumanEntity p_117785_, float p_117786_) {
        return p_117785_.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)p_117785_, p_117786_);
    }

    protected void renderNameTag(HumanEntity p_117808_, Component p_117809_, PoseStack p_117810_, MultiBufferSource p_117811_, int p_117812_) {
        Scoreboard scoreboard;
        Objective objective;
        double d0 = this.f_114476_.m_114471_((Entity)p_117808_);
        p_117810_.m_85836_();
        if (d0 < 100.0 && (objective = (scoreboard = p_117808_.m_9236_().m_6188_()).m_83416_(2)) != null) {
            Score score = scoreboard.m_83471_(p_117808_.m_6302_(), objective);
            super.m_7649_((Entity)p_117808_, (Component)Component.m_237113_((String)Integer.toString(score.m_83400_())).m_7220_(CommonComponents.f_263701_).m_7220_(objective.m_83322_()), p_117810_, p_117811_, p_117812_);
            p_117810_.m_252880_(0.0f, 0.25875f, 0.0f);
        }
        super.m_7649_((Entity)p_117808_, p_117809_, p_117810_, p_117811_, p_117812_);
        p_117810_.m_85849_();
    }

    private static HumanoidModel.ArmPose getArmPose(HumanEntity p_117795_, InteractionHand p_117796_) {
        HumanoidModel.ArmPose forgeArmPose;
        ItemStack itemstack = p_117795_.m_21120_(p_117796_);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_117795_.m_7655_() == p_117796_ && p_117795_.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && p_117796_ == p_117795_.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useanim == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (useanim == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!p_117795_.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return (forgeArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose((LivingEntity)p_117795_, p_117796_, itemstack)) != null ? forgeArmPose : HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(HumanEntity entity) {
        String string = ChatFormatting.m_126649_((String)entity.m_7755_().getString());
        String slim = "wide";
        if (entity.IsFemale()) {
            slim = "slim";
        }
        if (entity.m_7770_() != null) {
            if (string != null && !string.isEmpty() && MainConfig.HumanCustomNameWide.contains(string)) {
                return new ResourceLocation("jerotes", "textures/entity/custom_skin/" + JerotesPlayerRenderer.sanitizeString(string) + ".png");
            }
            if (string != null && !string.isEmpty() && MainConfig.HumanCustomNameSlim.contains(string)) {
                return new ResourceLocation("jerotes", "textures/entity/custom_skin/" + JerotesPlayerRenderer.sanitizeString(string) + ".png");
            }
        }
        if ("Steve".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/steve.png");
        }
        if ("Alex".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/alex.png");
        }
        if ("Ari".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/ari.png");
        }
        if ("Kai".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/kai.png");
        }
        if ("Noor".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/noor.png");
        }
        if ("Sunny".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/sunny.png");
        }
        if ("Zuri".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/zuri.png");
        }
        if ("Efe".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/efe.png");
        }
        if ("Makena".equals(string)) {
            return new ResourceLocation("minecraft:textures/entity/player/" + slim + "/makena.png");
        }
        return MainConfig.RandomSkinMobHasUnderTexture ? new ResourceLocation("jerotes", "minecraft:textures/entity/player/" + slim + "/steve.png") : NULL_LOCATION;
    }

    protected boolean shouldShowName(HumanEntity entity) {
        return super.m_6512_((Mob)entity) || entity instanceof JerotesPlayerEntity;
    }
}

