/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="jerotes", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class MainConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    public static boolean TamedMobHurtByOwnerHasReduce;
    public static boolean TamedMobAttackCreeperAndGhast;
    public static boolean AffectsNonThisModEntities;
    public static int CorrosiveStopDurabilityValue;
    public static boolean ScreenShake;
    public static boolean ShieldCanBreakBaseInGameRule;
    public static boolean ArmorCanBreakBaseInGameRule;
    public static boolean MeleeCanBreakBaseInGameRule;
    public static boolean RangeCanBreakBaseInGameRule;
    public static boolean MagicCanBreakBaseInGameRule;
    public static boolean SameFactionAvoidDamage;
    public static boolean MobDestroyBlock;
    public static boolean TamedMobDestroyBlock;
    public static boolean MobSayQuestionMark;
    public static boolean MobHasShockAback;
    public static boolean MobUseCrossbowShrinkArrow;
    public static boolean MobUseBowShrinkArrow;
    public static boolean MobUseThrowShrinkItem;
    public static boolean MobUseOtherShrinkItem;
    public static boolean InventoryMobAboutItemstackInventoryTick;
    public static boolean RandomSkinMobHasUnderTexture;
    public static List<String> HumanCustomNameWide;
    public static List<String> HumanCustomNameSlim;
    public static List<String> HasPercentageDamage;
    public static List<String> HasDamageCap;
    public static List<String> HasDamageCooldownTick;
    public static double BaseBreakHurtCooldownMultiple;
    public static double BaseAttackPercentage;
    public static double BaseMagicAttackPercentage;
    public static double BaseDamageCap;
    public static double BaseDamageCooldownTick;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    public static void bakeCommonConfig() {
        TamedMobHurtByOwnerHasReduce = (Boolean)MainConfig.COMMON.TamedMobHurtByOwnerHasReduce.get();
        TamedMobAttackCreeperAndGhast = (Boolean)MainConfig.COMMON.TamedMobAttackCreeperAndGhast.get();
        AffectsNonThisModEntities = (Boolean)MainConfig.COMMON.AffectsNonThisModEntities.get();
        CorrosiveStopDurabilityValue = (Integer)MainConfig.COMMON.CorrosiveStopDurabilityValue.get();
        ScreenShake = (Boolean)MainConfig.COMMON.ScreenShake.get();
        ShieldCanBreakBaseInGameRule = (Boolean)MainConfig.COMMON.ShieldCanBreakBaseInGameRule.get();
        ArmorCanBreakBaseInGameRule = (Boolean)MainConfig.COMMON.ArmorCanBreakBaseInGameRule.get();
        MeleeCanBreakBaseInGameRule = (Boolean)MainConfig.COMMON.MeleeCanBreakBaseInGameRule.get();
        RangeCanBreakBaseInGameRule = (Boolean)MainConfig.COMMON.RangeCanBreakBaseInGameRule.get();
        MagicCanBreakBaseInGameRule = (Boolean)MainConfig.COMMON.MagicCanBreakBaseInGameRule.get();
        SameFactionAvoidDamage = (Boolean)MainConfig.COMMON.SameFactionAvoidDamage.get();
        MobSayQuestionMark = (Boolean)MainConfig.COMMON.MobSayQuestionMark.get();
        MobDestroyBlock = (Boolean)MainConfig.COMMON.MobDestroyBlock.get();
        TamedMobDestroyBlock = (Boolean)MainConfig.COMMON.TamedMobDestroyBlock.get();
        MobHasShockAback = (Boolean)MainConfig.COMMON.MobHasShockAback.get();
        MobUseCrossbowShrinkArrow = (Boolean)MainConfig.COMMON.MobUseCrossbowShrinkArrow.get();
        MobUseBowShrinkArrow = (Boolean)MainConfig.COMMON.MobUseBowShrinkArrow.get();
        MobUseThrowShrinkItem = (Boolean)MainConfig.COMMON.MobUseThrowShrinkItem.get();
        MobUseOtherShrinkItem = (Boolean)MainConfig.COMMON.MobUseOtherShrinkItem.get();
        InventoryMobAboutItemstackInventoryTick = (Boolean)MainConfig.COMMON.InventoryMobAboutItemstackInventoryTick.get();
        RandomSkinMobHasUnderTexture = (Boolean)MainConfig.COMMON.RandomSkinMobHasUnderTexture.get();
        HumanCustomNameWide = (List)MainConfig.COMMON.HumanCustomNameWide.get();
        HumanCustomNameSlim = (List)MainConfig.COMMON.HumanCustomNameSlim.get();
        HasPercentageDamage = (List)MainConfig.COMMON.HasPercentageDamage.get();
        HasDamageCap = (List)MainConfig.COMMON.HasDamageCap.get();
        HasDamageCooldownTick = (List)MainConfig.COMMON.HasDamageCooldownTick.get();
        BaseBreakHurtCooldownMultiple = (Double)MainConfig.COMMON.BaseBreakHurtCooldownMultiple.get();
        BaseAttackPercentage = (Double)MainConfig.COMMON.BaseAttackPercentage.get();
        BaseMagicAttackPercentage = (Double)MainConfig.COMMON.BaseMagicAttackPercentage.get();
        BaseDamageCap = (Double)MainConfig.COMMON.BaseDamageCap.get();
        BaseDamageCooldownTick = (Double)MainConfig.COMMON.BaseDamageCooldownTick.get();
    }

    public static void bakeClientConfig() {
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MainConfig.bakeCommonConfig();
        } else if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            MainConfig.bakeClientConfig();
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
        Pair pair1 = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair1.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair1.getRight();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue TamedMobHurtByOwnerHasReduce;
        public final ForgeConfigSpec.BooleanValue TamedMobAttackCreeperAndGhast;
        public final ForgeConfigSpec.BooleanValue AffectsNonThisModEntities;
        public final ForgeConfigSpec.IntValue CorrosiveStopDurabilityValue;
        public final ForgeConfigSpec.BooleanValue ScreenShake;
        public final ForgeConfigSpec.BooleanValue ShieldCanBreakBaseInGameRule;
        public final ForgeConfigSpec.BooleanValue ArmorCanBreakBaseInGameRule;
        public final ForgeConfigSpec.BooleanValue MeleeCanBreakBaseInGameRule;
        public final ForgeConfigSpec.BooleanValue RangeCanBreakBaseInGameRule;
        public final ForgeConfigSpec.BooleanValue MagicCanBreakBaseInGameRule;
        public final ForgeConfigSpec.BooleanValue SameFactionAvoidDamage;
        public final ForgeConfigSpec.BooleanValue MobSayQuestionMark;
        public final ForgeConfigSpec.BooleanValue MobDestroyBlock;
        public final ForgeConfigSpec.BooleanValue TamedMobDestroyBlock;
        public final ForgeConfigSpec.BooleanValue MobHasShockAback;
        public final ForgeConfigSpec.BooleanValue MobUseCrossbowShrinkArrow;
        public final ForgeConfigSpec.BooleanValue MobUseBowShrinkArrow;
        public final ForgeConfigSpec.BooleanValue MobUseThrowShrinkItem;
        public final ForgeConfigSpec.BooleanValue MobUseOtherShrinkItem;
        public final ForgeConfigSpec.BooleanValue InventoryMobAboutItemstackInventoryTick;
        public final ForgeConfigSpec.BooleanValue RandomSkinMobHasUnderTexture;
        public final ForgeConfigSpec.ConfigValue<List<String>> HumanCustomNameWide;
        public final ForgeConfigSpec.ConfigValue<List<String>> HumanCustomNameSlim;
        public final ForgeConfigSpec.ConfigValue<List<String>> HasPercentageDamage;
        public final ForgeConfigSpec.ConfigValue<List<String>> HasDamageCap;
        public final ForgeConfigSpec.ConfigValue<List<String>> HasDamageCooldownTick;
        public final ForgeConfigSpec.DoubleValue BaseBreakHurtCooldownMultiple;
        public final ForgeConfigSpec.DoubleValue BaseAttackPercentage;
        public final ForgeConfigSpec.DoubleValue BaseMagicAttackPercentage;
        public final ForgeConfigSpec.DoubleValue BaseDamageCap;
        public final ForgeConfigSpec.DoubleValue BaseDamageCooldownTick;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push(" ");
            builder.pop();
            builder.push("Tamed Mob");
            this.TamedMobHurtByOwnerHasReduce = builder.comment("Tame Mob Hurt By Owner Has Reduce").define("\u9a6f\u670d\u751f\u7269\u5bf9\u4e3b\u4eba\u5bf9\u81ea\u8eab\u9020\u6210\u7684\u4f24\u5bb3\u62e5\u6709\u51cf\u4f24", true);
            this.TamedMobAttackCreeperAndGhast = builder.comment("Tame Mob Attack Creeper And Ghast").define("\u6a21\u7ec4\u6dfb\u52a0\u7684\u9a6f\u670d\u751f\u7269\u653b\u51fb\u82e6\u529b\u6015[Creeper]\u548c\u6076\u9b42[Ghast]", false);
            this.AffectsNonThisModEntities = builder.comment("Affects Non This Mod Entities").define("\u5f71\u54cd\u975e\u672c\u6a21\u7ec4\u5b9e\u4f53", false);
            builder.pop();
            builder.push("Other");
            this.CorrosiveStopDurabilityValue = builder.comment("Corrosive Stop Durability Value").defineInRange("\u8150\u8680\u4e2d\u6b62\u8010\u4e45\u503c", 8, 0, Integer.MAX_VALUE);
            this.ScreenShake = builder.comment("Screen Shake").define("\u5c4f\u5e55\u6296\u52a8", true);
            this.ShieldCanBreakBaseInGameRule = builder.comment("Shield Can Break Base In Game Rule").define("\u57fa\u7840\u6e38\u620f\u89c4\u5219\u76fe\u724c\u7269\u54c1\u635f\u574f", true);
            this.ArmorCanBreakBaseInGameRule = builder.comment("Armor Can Break Base In Game Rule").define("\u57fa\u7840\u6e38\u620f\u89c4\u5219\u76d4\u7532\u7269\u54c1\u635f\u574f", false);
            this.MeleeCanBreakBaseInGameRule = builder.comment("Melee Can Break Base In Game Rule").define("\u57fa\u7840\u6e38\u620f\u89c4\u5219\u8fd1\u6218\u6b66\u5668\u635f\u574f", false);
            this.RangeCanBreakBaseInGameRule = builder.comment("Range Can Break Base In Game Rule").define("\u57fa\u7840\u6e38\u620f\u89c4\u5219\u8fdc\u7a0b\u6b66\u5668\u635f\u574f", false);
            this.MagicCanBreakBaseInGameRule = builder.comment("Magic Can Break Base In Game Rule").define("\u57fa\u7840\u6e38\u620f\u89c4\u5219\u9b54\u6cd5\u6b66\u5668\u635f\u574f", true);
            this.SameFactionAvoidDamage = builder.comment("Same Faction Avoid Damage").define("\u540c\u9635\u8425\u514d\u4f24", true);
            this.MobSayQuestionMark = builder.comment("Mob Say Question Mark").define("\u751f\u7269\u8bf4\u95ee\u53f7", true);
            this.MobDestroyBlock = builder.comment("Mob Destroy Block").define("\u751f\u7269\u7834\u574f\u65b9\u5757", true);
            this.TamedMobDestroyBlock = builder.comment("Tamed Mob Destroy Block").define("\u9a6f\u670d\u751f\u7269\u7834\u574f\u65b9\u5757", true);
            this.MobHasShockAback = builder.comment("Mob Has Shock Aback").define("\u751f\u7269\u4f1a\u56e0\u4e3a\u9707\u6444\u9003\u79bb", false);
            this.MobUseCrossbowShrinkArrow = builder.comment("Mob Use Crossbow Shrink Arrow").define("\u751f\u7269\u4f7f\u7528\u5f29\u6d88\u8017\u7bad\u77e2", false);
            this.MobUseBowShrinkArrow = builder.comment("Mob Use Bow Shrink Arrow").define("\u751f\u7269\u4f7f\u7528\u5f13\u6d88\u8017\u7bad\u77e2", false);
            this.MobUseThrowShrinkItem = builder.comment("Mob Use Throw Shrink Item").define("\u751f\u7269\u4f7f\u7528\u6295\u63b7\u6d88\u8017\u7269\u54c1", false);
            this.MobUseOtherShrinkItem = builder.comment("Mob Use Other Shrink Item").define("\u751f\u7269\u4f7f\u7528\u5176\u4ed6\u6d88\u8017\u7269\u54c1", false);
            this.InventoryMobAboutItemstackInventoryTick = builder.comment("Inventory Mob About Itemstack Inventory Tick").define("\u5177\u6709\u7269\u54c1\u680f\u751f\u7269\u5173\u4e8e\u80cc\u5305\u8ba1\u65f6\u7684\u7269\u54c1", true);
            this.RandomSkinMobHasUnderTexture = builder.comment("Random Skin Mob Has Under Texture").define("\u968f\u673a\u7eb9\u7406\u751f\u7269\u62e5\u6709\u5e95\u5c42\u7eb9\u7406", false);
            this.HumanCustomNameWide = builder.comment("Human Custom Name Wide").define("\u4eba\u7c7b\u81ea\u5b9a\u4e49\u540d\u79f0\u5bbd\u4f53", (Object)Lists.newArrayList((Object[])new String[]{"Jerotes_"}));
            this.HumanCustomNameSlim = builder.comment("Human Custom Name Slim").define("\u4eba\u7c7b\u81ea\u5b9a\u4e49\u540d\u79f0\u7ec6\u4f53", (Object)Lists.newArrayList((Object[])new String[]{"Sentnes", "Maid"}));
            builder.pop();
            builder.push("Special Combat");
            this.HasPercentageDamage = builder.comment("Has Percentage Damage").define("\u62e5\u6709\u767e\u5206\u6bd4\u4f24\u5bb3", (Object)Lists.newArrayList());
            this.HasDamageCap = builder.comment("Has Damage Cap").define("\u62e5\u6709\u9650\u4f24", (Object)Lists.newArrayList());
            this.HasDamageCooldownTick = builder.comment("Has Damage Cooldown Tick").define("\u62e5\u6709\u65e0\u654c\u5e27", (Object)Lists.newArrayList());
            this.BaseBreakHurtCooldownMultiple = builder.comment("Base Break Hurt Cooldown Multiple").defineInRange("\u57fa\u7840\u65e0\u654c\u5e27\u7834\u9664\u500d\u6570", 5.0, 0.0, Double.MAX_VALUE);
            this.BaseAttackPercentage = builder.comment("Base Attack Percentage : 5.0").defineInRange("\u57fa\u7840\u767e\u5206\u6bd4", 5.0, 0.0, Double.MAX_VALUE);
            this.BaseMagicAttackPercentage = builder.comment("Base Magic Attack Percentage : 5.0").defineInRange("\u57fa\u7840\u9b54\u6cd5\u767e\u5206\u6bd4", 5.0, 0.0, Double.MAX_VALUE);
            this.BaseDamageCap = builder.comment("Base Damage Cap Percentage").defineInRange("\u57fa\u7840\u9650\u4f24\u767e\u5206\u6bd4", 5.0, 0.0, Double.MAX_VALUE);
            this.BaseDamageCooldownTick = builder.comment("Base Damage Cooldown Tick").defineInRange("\u57fa\u7840\u65e0\u654c\u5e27\u5e27\u6570", 20.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
        }
    }
}

