/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.Mob;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.jerotes.jerotes.control.WaterAndGroundMoveControl;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesPlayerBaseEntity;
import com.jerotes.jerotes.entity.Mob.HumanEntity;
import com.jerotes.jerotes.goal.JerotesAddSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIVMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.goal.JerotesMainSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesPikeUseGoal;
import com.jerotes.jerotes.goal.JerotesPlayerFloatGoal;
import com.jerotes.jerotes.goal.JerotesPlayerTargetGoal;
import com.jerotes.jerotes.goal.JerotesRangedBowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedCrossbowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.goal.JerotesShiftKeyDownGoal;
import com.jerotes.jerotes.goal.JerotesSpearUseGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.item.tool.ItemToolBaseDagger;
import com.jerotes.jerotes.item.tool.ItemToolBasePike;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import com.jerotes.jerotes.item.tool.ItemToolBaseThrowingSpearOfJavelin;
import com.jerotes.jerotes.item.tool.ItemToolBaseThrowingSpearOfSpear;
import com.jerotes.jerotes.navigation.WaterAndGroundPathNavigation;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.PartEntity;

public class JerotesPlayerEntity
extends HumanEntity
implements JerotesPlayerBaseEntity {
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)1.8f);
    private static final ImmutableMap<Object, Object> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)Pose.SLEEPING, (Object)f_20910_).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)1.5f)).put((Object)Pose.DYING, (Object)EntityDimensions.m_20398_((float)0.2f, (float)0.2f)).build();
    @Nullable
    private Pose forcedPose;
    private final Abilities abilities = new Abilities();
    public boolean isLandNavigatorType = true;
    public int sprintingCooldown;
    public int mustShieldTick;
    public int canNotAttackTargetTick;

    public JerotesPlayerEntity(EntityType<? extends HumanEntity> type, Level world) {
        super(type, world);
        this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 2.0f;
        this.f_21348_[EquipmentSlot.CHEST.m_20749_()] = 2.0f;
        this.f_21348_[EquipmentSlot.LEGS.m_20749_()] = 2.0f;
        this.f_21348_[EquipmentSlot.FEET.m_20749_()] = 2.0f;
        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
        this.f_21347_[EquipmentSlot.OFFHAND.m_20749_()] = 2.0f;
        this.m_252801_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        builder = builder.m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 3.0);
        builder = builder.m_22268_(Attributes.f_22283_, 4.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new JerotesPlayerFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesShiftKeyDownGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMainSpellAttackGoal((Mob)this, this.getSpellLevel(), 60, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAddSpellAttackGoal((Mob)this, this.getSpellLevel(), 180, 240, 0.5f));
        this.f_21345_.m_25352_(1, new JerotesCombatIMagicAttackGoal<JerotesPlayerEntity>(this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, new JerotesCombatIIMagicAttackGoal<JerotesPlayerEntity>(this, 0.2, true, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, new JerotesCombatIIIMagicAttackGoal<JerotesPlayerEntity>(this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, new JerotesCombatIVMagicAttackGoal<JerotesPlayerEntity>(this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, new JerotesRangedBowAttackGoal<JerotesPlayerEntity>(this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(1, new JerotesRangedCrossbowAttackGoal<JerotesPlayerEntity>(this, 1.0, 15.0f));
        this.f_21345_.m_25352_(1, new JerotesRangedJavelinAttackGoal((RangedAttackMob)this, 1.0, 60, 12.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, new JerotesSpearUseGoal<JerotesPlayerEntity>(this, 1.6, 1.6, 10.0f, 2.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesPikeUseGoal(this, 1.3, true));
        this.f_21345_.m_25352_(1, new JerotesRangedThrowAttackGoal(this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesMeleeAttackGoal(this, 1.4, true, true, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, HumanEntity.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(this, new Class[0]){

            public void m_8056_() {
                super.m_8056_();
                this.f_26138_ = 18000;
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 5, false, false, livingEntity -> EntityFactionFind.isHateFaction((LivingEntity)this, livingEntity)){

            public void m_8056_() {
                super.m_8056_();
                this.f_26138_ = 18000;
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, 10, true, false, arg_0 -> ((JerotesPlayerEntity)this).m_21674_(arg_0)){

            public void m_8056_() {
                super.m_8056_();
                this.f_26138_ = 18000;
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21346_.m_25352_(3, (Goal)new JerotesPlayerTargetGoal<Mob>((Mob)this, Mob.class, false){

            @Override
            public void m_8056_() {
                super.m_8056_();
                this.f_26138_ = 18000;
            }
        });
    }

    @Override
    public boolean beTargetAsPlayer() {
        return true;
    }

    @Override
    public boolean beLookAsPlayer() {
        return true;
    }

    @Override
    public boolean beAnesthetizedAsPlayer() {
        return true;
    }

    @Override
    public boolean usePikeAsPlayer() {
        return true;
    }

    @Override
    public boolean useSpearAsPlayer() {
        return true;
    }

    @Override
    public boolean useBeaconAsPlayer() {
        return true;
    }

    @Override
    public boolean attackDamageSourceAsPlayer() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void useBlockingItem(Mob mob) {
        if (mob.m_9236_().m_5776_()) return;
        if ((mob.m_5448_() == null || !this.getAttackBoundingBox().m_82400_(4.5).m_82381_(mob.m_5448_().m_20191_()) && !mob.m_5448_().m_20191_().m_82400_(4.5).m_82381_(mob.m_20191_())) && this.mustShieldTick <= 0) {
            this.stopUse(mob);
            return;
        }
        if (this.shieldCanUse() && this.notBowCrossbow(mob, InteractionHand.MAIN_HAND) && mob.m_21206_().m_41720_() instanceof ShieldItem && (!mob.m_6117_() || mob.m_21211_().m_41720_() instanceof ShieldItem) && mob.f_20921_ <= 0.0f) {
            if (mob.m_6117_()) return;
            mob.m_6672_(InteractionHand.OFF_HAND);
            this.setMustShieldTick(Math.max(10, this.mustShieldTick));
            return;
        }
        if (this.shieldCanUse() && this.notBowCrossbow(mob, InteractionHand.OFF_HAND) && mob.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ShieldItem && (!mob.m_6117_() || mob.m_21211_().m_41720_() instanceof ShieldItem) && mob.f_20921_ <= 0.0f) {
            if (mob.m_6117_()) return;
            mob.m_6672_(InteractionHand.MAIN_HAND);
            this.setMustShieldTick(Math.max(10, this.mustShieldTick));
            return;
        }
        Item item = mob.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (item instanceof ItemTwoHanded) {
            ItemTwoHanded itemTwoHanded = (ItemTwoHanded)item;
            if (!(mob.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ItemToolBasePike) && itemTwoHanded.canBlock() && mob.m_21206_().m_41619_() && (!mob.m_6117_() || mob.m_21211_().m_41720_() instanceof ItemTwoHanded) && mob.f_20921_ <= 0.0f) {
                if (mob.m_6117_()) return;
                mob.m_6672_(InteractionHand.MAIN_HAND);
                this.setMustShieldTick(Math.max(10, this.mustShieldTick));
                return;
            }
        }
        if ((item = mob.m_21206_().m_41720_()) instanceof ItemTwoHanded) {
            ItemTwoHanded itemTwoHanded = (ItemTwoHanded)item;
            if (!(mob.m_21206_().m_41720_() instanceof ItemToolBasePike) && itemTwoHanded.canBlock() && mob.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && (!mob.m_6117_() || mob.m_21211_().m_41720_() instanceof ItemTwoHanded) && mob.f_20921_ <= 0.0f) {
                if (mob.m_6117_()) return;
                mob.m_6672_(InteractionHand.OFF_HAND);
                this.setMustShieldTick(Math.max(10, this.mustShieldTick));
                return;
            }
        }
        this.stopUse(mob);
    }

    @Override
    public float meleeOrRangeDistance() {
        if (this.canNotAttackTargetTick >= 240) {
            return 1.0f;
        }
        double d = Math.max(0.5, this.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 2.0) + 2.0;
        return (float)d;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12279_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_12277_;
    }

    protected SoundEvent m_5508_() {
        return SoundEvents.f_12278_;
    }

    @Override
    public float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        switch (pose) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f * ((this.m_6162_() ? 0.86f : 1.62f) / 1.62f);
            }
            case CROUCHING: {
                return 1.27f * ((this.m_6162_() ? 0.86f : 1.62f) / 1.62f);
            }
        }
        return 1.62f * ((this.m_6162_() ? 0.86f : 1.62f) / 1.62f);
    }

    public boolean m_142066_() {
        return !this.getAbilities().f_35934_ && super.m_142066_();
    }

    protected boolean m_6046_() {
        return !this.abilities.f_35935_ && super.m_6046_();
    }

    public boolean m_6129_() {
        return !this.abilities.f_35935_;
    }

    protected Vec3 m_5763_(Vec3 vec3, MoverType moverType) {
        if (!this.abilities.f_35935_ && vec3.f_82480_ <= 0.0 && (moverType == MoverType.SELF || moverType == MoverType.PLAYER) && this.isStayingOnGroundSurface() && this.isAboveGround()) {
            double d0 = vec3.f_82479_;
            double d1 = vec3.f_82481_;
            double d2 = 0.05;
            while (d0 != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(d0, (double)(-this.m_274421_()), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(0.0, (double)(-this.m_274421_()), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(d0, (double)(-this.m_274421_()), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            vec3 = new Vec3(d0, vec3.f_82480_, d1);
            return vec3;
        }
        return vec3;
    }

    private boolean isAboveGround() {
        return this.m_20096_() || this.f_19789_ < this.m_274421_() && !this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(0.0, (double)(this.f_19789_ - this.m_274421_()), 0.0));
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    private boolean canFallAtLeast(double d, double d2, double d3) {
        AABB aABB = this.m_20191_();
        return this.m_9236_().m_45756_((Entity)this, new AABB(aABB.f_82288_ + 1.0E-7 + d, aABB.f_82289_ - d3 - 1.0E-7, aABB.f_82290_ + 1.0E-7 + d2, aABB.f_82291_ - 1.0E-7 + d, aABB.f_82289_, aABB.f_82293_ - 1.0E-7 + d2));
    }

    public boolean isSecondaryUseActive() {
        return this.m_6144_();
    }

    protected boolean wantsToStopRiding() {
        return this.m_6144_();
    }

    protected boolean isStayingOnGroundSurface() {
        return this.m_6144_();
    }

    protected void updatePlayerPose() {
        if (!this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
            return;
        }
        Pose pose = this.getDesiredPose();
        Pose pose2 = this.m_5833_() || this.m_20159_() || this.canPlayerFitWithinBlocksAndEntitiesWhen(pose) ? pose : (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING);
        this.m_20124_(pose2);
    }

    protected boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose pose) {
        return this.m_9236_().m_45756_((Entity)this, this.m_6972_(pose).m_20393_(this.m_20182_()).m_82406_(1.0E-7));
    }

    private Pose getDesiredPose() {
        if (this.m_5803_()) {
            return Pose.SLEEPING;
        }
        if (this.m_6069_()) {
            return Pose.SWIMMING;
        }
        if (this.m_21255_()) {
            return Pose.FALL_FLYING;
        }
        if (this.m_21209_()) {
            return Pose.SPIN_ATTACK;
        }
        if (this.m_6144_() && !this.abilities.f_35935_) {
            return Pose.CROUCHING;
        }
        return Pose.STANDING;
    }

    public void setForcedPose(@Nullable Pose pose) {
        this.forcedPose = pose;
    }

    @Nullable
    public Pose getForcedPose() {
        return this.forcedPose;
    }

    public ItemStack m_5584_(Level level, ItemStack itemStack) {
        this.m_5634_(itemStack.getFoodProperties((LivingEntity)this) != null ? (float)Objects.requireNonNull(itemStack.getFoodProperties((LivingEntity)this)).m_38744_() : 1.0f);
        level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12321_, this.m_5720_(), 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        return super.m_5584_(level, itemStack);
    }

    public boolean m_264410_() {
        return true;
    }

    public int m_6078_() {
        return this.abilities.f_35934_ ? 1 : 80;
    }

    public void m_7023_(Vec3 vec3f) {
        double d5;
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        if (this.m_6069_() && !this.m_20159_()) {
            double d4;
            d5 = this.m_20154_().f_82480_;
            double d = d4 = d5 < -0.2 ? 0.085 : 0.06;
            if (d5 <= 0.0 || this.f_20899_ || !this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 1.0 - 0.1), (double)this.m_20189_())).m_60819_().m_76178_()) {
                Vec3 vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82520_(0.0, (d5 - vec3.f_82480_) * d4, 0.0));
            }
        }
        if (this.abilities.f_35935_ && !this.m_20159_()) {
            d5 = this.m_20184_().f_82480_;
            super.m_7023_(vec3f);
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, d5 * 0.6, vec31.f_82481_);
            this.m_183634_();
            this.m_20115_(7, false);
        } else if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3f);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.75));
        } else {
            super.m_7023_(vec3f);
        }
    }

    public boolean m_142535_(float p_150093_, float p_150094_, DamageSource p_150095_) {
        if (this.abilities.f_35936_) {
            return false;
        }
        return super.m_142535_(p_150093_, p_150094_, p_150095_);
    }

    public void m_5844_() {
        if (this.abilities.f_35935_) {
            this.m_20282_(false);
        } else {
            super.m_5844_();
        }
    }

    public void m_7601_(BlockState p_36196_, Vec3 p_36197_) {
        if (!this.abilities.f_35935_) {
            super.m_7601_(p_36196_, p_36197_);
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return !this.abilities.f_35935_ && (!this.m_20096_() || !this.m_20163_()) ? Entity.MovementEmission.ALL : Entity.MovementEmission.NONE;
    }

    public void onUpdateAbilities() {
        if (this.m_5833_()) {
            this.m_21218_();
            this.m_6842_(true);
        } else {
            super.m_8034_();
        }
    }

    public boolean m_6069_() {
        return !this.abilities.f_35935_ && !this.m_5833_() && super.m_6069_();
    }

    public boolean m_6063_() {
        return !this.abilities.f_35935_;
    }

    public void m_7311_(int p_36353_) {
        super.m_7311_(this.abilities.f_35934_ ? Math.min(p_36353_, 1) : p_36353_);
    }

    protected float m_6041_() {
        return !this.abilities.f_35935_ && !this.m_21255_() ? super.m_6041_() : 1.0f;
    }

    protected boolean m_6757_(BlockState p_36262_) {
        return this.abilities.f_35935_ || super.m_6757_(p_36262_);
    }

    protected float m_274460_() {
        if (this.abilities.f_35935_ && !this.m_20159_()) {
            return this.m_20142_() ? this.abilities.m_35942_() * 2.0f : this.abilities.m_35942_();
        }
        return this.m_20142_() ? 0.025999999f : 0.02f;
    }

    @Override
    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        double d = Math.max(0.5, this.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 2.0);
        return aabb1.m_82377_(d, d, d);
    }

    @Override
    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    @Override
    public void setSprintingCooldown(int n) {
        this.sprintingCooldown = n;
    }

    @Override
    public void setCanNotAttackTargetTick(int n) {
        this.canNotAttackTargetTick = n;
    }

    public void setMustShieldTick(int n) {
        this.mustShieldTick = n;
    }

    @Override
    public boolean canEatOrDrinkHand() {
        return true;
    }

    public boolean needHeal() {
        return this.m_5448_() == null && (double)this.m_21223_() <= (double)this.m_21233_() * 0.9 || (double)this.m_21223_() <= (double)this.m_21233_() * 0.5;
    }

    @Override
    public boolean isNotOffHandItem(ItemStack itemStack) {
        return super.isNotOffHandItem(itemStack) || itemStack.m_41720_() == Items.f_42590_;
    }

    @Override
    public boolean howToEatOrDrinkHand(Mob mob, ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof PotionItem && !(itemStack.m_41720_() instanceof ThrowablePotionItem)) {
            if (!(PotionUtils.m_43579_((ItemStack)itemStack) != Potions.f_43611_ && PotionUtils.m_43579_((ItemStack)itemStack) != Potions.f_43610_ || this.m_20094_() <= 0 || this.m_21023_(MobEffects.f_19607_))) {
                return true;
            }
            if (!(PotionUtils.m_43579_((ItemStack)itemStack) != Potions.f_43621_ && PotionUtils.m_43579_((ItemStack)itemStack) != Potions.f_43622_ || this.m_20146_() > 200 || this.m_21023_(MobEffects.f_19608_))) {
                return true;
            }
            if ((PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43623_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43581_) && this.needHeal()) {
                return true;
            }
            if ((PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43587_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43588_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43589_) && this.needHeal() && !this.m_21023_(MobEffects.f_19605_)) {
                return true;
            }
        }
        if (itemStack.m_41614_()) {
            if (itemStack.m_150930_(Items.f_42436_) && (this.needHeal() || this.m_5448_() != null && !this.m_21023_(MobEffects.f_19617_) && !this.m_21023_(MobEffects.f_19606_) && (this.m_20094_() <= 0 || this.m_21023_(MobEffects.f_19607_)))) {
                return true;
            }
            if (itemStack.m_150930_(Items.f_42437_) && (this.needHeal() || this.m_5448_() != null && !this.m_21023_(MobEffects.f_19617_))) {
                return true;
            }
            if (itemStack.getFoodProperties((LivingEntity)this) != null && Objects.requireNonNull(itemStack.getFoodProperties((LivingEntity)this)).m_38749_().isEmpty() && this.needHeal()) {
                return true;
            }
        }
        return false;
    }

    public boolean isCanEatItem(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof PotionItem && !(itemStack.m_41720_() instanceof ThrowablePotionItem)) {
            if (PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43611_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43610_) {
                return true;
            }
            if (PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43621_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43622_) {
                return true;
            }
            if (PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43623_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43581_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43587_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43588_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43589_) {
                return true;
            }
        }
        return itemStack.m_41614_();
    }

    @Override
    public boolean isOffHandItem(ItemStack itemStack) {
        return this.howToEatOrDrinkHand((Mob)this, itemStack);
    }

    public boolean m_7252_(ItemStack itemStack) {
        if (this.isCanEatItem(itemStack)) {
            return true;
        }
        return InventoryEntity.isThrow(this, itemStack) || InventoryEntity.isMeleeWeapon(this, itemStack) || InventoryEntity.isShield(this, itemStack) || InventoryEntity.isPike(this, itemStack) || InventoryEntity.isCrossbow(this, itemStack) || InventoryEntity.isOtherRange(this, itemStack) || InventoryEntity.isBow(this, itemStack) || InventoryEntity.isRangeJavelin(this, itemStack) || InventoryEntity.isHelmet(this, itemStack) || InventoryEntity.isChestplate(this, itemStack) || InventoryEntity.isLeggings(this, itemStack) || InventoryEntity.isBoots(this, itemStack) || InventoryEntity.isMagicItem(this, itemStack);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        InventoryCarrier.m_219611_((Mob)this, (InventoryCarrier)this, (ItemEntity)itemEntity);
    }

    public EntityDimensions m_6972_(Pose p_36166_) {
        return (EntityDimensions)POSES.getOrDefault((Object)p_36166_, (Object)STANDING_DIMENSIONS);
    }

    public ImmutableList<Pose> m_7431_() {
        return ImmutableList.of((Object)Pose.STANDING, (Object)Pose.CROUCHING, (Object)Pose.SWIMMING);
    }

    public Vec3 m_7398_(float f) {
        double d = 0.22 * (this.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        float f2 = Mth.m_14179_((float)(f * 0.5f), (float)this.m_146909_(), (float)this.f_19860_) * ((float)Math.PI / 180);
        float f3 = Mth.m_14179_((float)f, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        if (this.m_21255_() || this.m_21209_()) {
            float f4;
            Vec3 vec3 = this.m_20252_(f);
            Vec3 vec32 = this.m_20184_();
            double d2 = vec32.m_165925_();
            double d3 = vec3.m_165925_();
            if (d2 > 0.0 && d3 > 0.0) {
                double d4 = (vec32.f_82479_ * vec3.f_82479_ + vec32.f_82481_ * vec3.f_82481_) / Math.sqrt(d2 * d3);
                double d5 = vec32.f_82479_ * vec3.f_82481_ - vec32.f_82481_ * vec3.f_82479_;
                f4 = (float)(Math.signum(d5) * Math.acos(d4));
            } else {
                f4 = 0.0f;
            }
            return this.m_20318_(f).m_82549_(new Vec3(d, -0.11, 0.85).m_82535_(-f4).m_82496_(-f2).m_82524_(-f3));
        }
        if (this.m_6067_()) {
            return this.m_20318_(f).m_82549_(new Vec3(d, 0.2, -0.15).m_82496_(-f2).m_82524_(-f3));
        }
        double d6 = this.m_20191_().m_82376_() - 1.0;
        double d7 = this.m_6047_() ? -0.2 : 0.07;
        return this.m_20318_(f).m_82549_(new Vec3(d, d6, d7).m_82524_(-f3));
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.abilities.m_35945_(compoundTag);
        compoundTag.m_128405_("MustShieldTick", this.mustShieldTick);
        compoundTag.m_128405_("SprintingCooldown", this.sprintingCooldown);
        compoundTag.m_128405_("CanNotAttackTargetTick", this.canNotAttackTargetTick);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.abilities.m_35950_(compoundTag);
        this.mustShieldTick = compoundTag.m_128451_("MustShieldTick");
        this.sprintingCooldown = compoundTag.m_128451_("SprintingCooldown");
        this.canNotAttackTargetTick = compoundTag.m_128451_("CanNotAttackTargetTick");
    }

    @Override
    public void m_8119_() {
        if (this.abilities.f_35935_ && !this.m_20159_()) {
            this.m_183634_();
        }
        super.m_8119_();
        this.updatePlayerPose();
    }

    @Override
    public void m_8107_() {
        BlockState blockState;
        List projectiles;
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && this.m_21223_() < this.m_21233_() && this.f_19797_ % 20 == 0) {
            this.m_5634_(1.0f);
        }
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.m_6858_(!(this.sprintingCooldown > 0 || (!this.m_5912_() || this.f_19790_ == this.m_20185_() && this.f_19792_ == this.m_20189_() || this.m_5448_() != null && InventoryEntity.isMeleeWeapon(this, this.m_21205_()) && this.getAttackBoundingBox().m_82406_(0.5).m_82381_(this.m_5448_().m_20191_()) || !(this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82553_() > 0.001) || this.m_6144_() || this.m_5448_() != null && this.m_21574_().m_148306_((Entity)this.m_5448_()) && this.getAttackBoundingBox().m_82400_(0.5).m_82381_(this.m_5448_().m_20191_()) && !this.isInFluidType() && !this.m_20096_() || this.m_6117_() && !(this.m_21211_().m_41720_() instanceof ItemToolBaseSpearBase)) && (this.m_20146_() > 100 || !this.isInFluidType())));
            if (this.sprintingCooldown > 0) {
                this.m_6858_(false);
            }
        }
        this.setSprintingCooldown(Math.max(0, this.sprintingCooldown - 1));
        if (this.m_5448_() != null && !(projectiles = this.m_9236_().m_6443_(Projectile.class, this.m_20191_().m_82400_(6.0), p -> this.isValidProjectile((Projectile)p))).isEmpty()) {
            this.setMustShieldTick(30);
        }
        this.setMustShieldTick(Math.max(0, this.mustShieldTick - 1));
        this.canNotAttackTargetTick = this.m_5448_() != null && !this.m_217066_(this.m_5448_()) && this.m_21574_().m_148306_((Entity)this.m_5448_()) ? Math.min(240, this.canNotAttackTargetTick + (this.m_5448_().m_20186_() > this.m_20186_() + 1.0 || this.m_5448_().m_20186_() < this.m_20186_() - 1.0 ? 4 : 1)) : Math.max(0, this.canNotAttackTargetTick - 1);
        if (this.m_20069_() && this.isLandNavigatorType) {
            this.f_21342_ = new WaterAndGroundMoveControl((Mob)this);
            this.f_21344_ = new WaterAndGroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = false;
        }
        if (!this.m_20069_() && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.isInFluidType() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 6.0f && this.m_6117_() && InventoryEntity.isFoodOrPotion(this, this.m_21211_())) {
            float f1 = this.m_146908_();
            float f2 = this.m_146909_();
            float f3 = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
            float f5 = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
            float f7 = -0.08f;
            this.setSprintingCooldown(10);
            if (this.m_20184_().f_82479_ <= 0.25 && this.m_20184_().f_82481_ <= 0.25) {
                this.m_20256_(this.m_20184_().m_82520_((double)(f3 *= f7 / f6), 0.0, (double)(f5 *= f7 / f6)));
            }
        }
        if (this.m_5448_() != null) {
            if (this.m_20270_((Entity)this.m_5448_()) <= this.meleeOrRangeDistance() && (!(this.m_20270_((Entity)this.m_5448_()) > this.meleeOrRangeDistance() / 2.0f) || this.m_5448_().m_20096_()) && this.canNotAttackTargetTick < 240) {
                Item f2 = this.m_21205_().m_41720_();
                if (f2 instanceof ItemToolBaseThrowingSpearOfJavelin) {
                    ItemToolBaseThrowingSpearOfJavelin itemToolBaseThrowingSpearOfJavelin = (ItemToolBaseThrowingSpearOfJavelin)f2;
                    ItemStack itemStack1 = new ItemStack((ItemLike)itemToolBaseThrowingSpearOfJavelin.getOtherMode());
                    itemStack1.deserializeNBT(this.m_21205_().m_41784_());
                    itemStack1.m_41751_(this.m_21205_().m_41784_());
                    itemStack1.m_41721_(this.m_21205_().m_41773_());
                    this.m_21008_(InteractionHand.MAIN_HAND, itemStack1);
                    this.canNotAttackTargetTick = 0;
                }
            } else {
                Item itemStack1 = this.m_21205_().m_41720_();
                if (itemStack1 instanceof ItemToolBaseThrowingSpearOfSpear) {
                    ItemToolBaseThrowingSpearOfSpear itemToolBaseThrowingSpearOfSpear = (ItemToolBaseThrowingSpearOfSpear)itemStack1;
                    itemStack1 = new ItemStack((ItemLike)itemToolBaseThrowingSpearOfSpear.getOtherMode());
                    itemStack1.deserializeNBT(this.m_21205_().m_41784_());
                    itemStack1.m_41751_(this.m_21205_().m_41784_());
                    itemStack1.m_41721_(this.m_21205_().m_41773_());
                    this.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)itemStack1);
                }
            }
        }
    }

    @Override
    public boolean shouldShiftKeyDown() {
        if (this.m_5448_() != null && (this.m_20270_((Entity)this.m_5448_()) <= this.meleeOrRangeDistance() && (!(this.m_20270_((Entity)this.m_5448_()) > this.meleeOrRangeDistance() / 2.0f) || this.m_5448_().m_20096_()) ? this.m_21205_().m_41720_() instanceof ItemToolBaseThrowingSpearOfJavelin : this.m_21205_().m_41720_() instanceof ItemToolBaseThrowingSpearOfSpear && this.canNotAttackTargetTick > 240)) {
            return true;
        }
        return this.baseShouldShiftKeyDown();
    }

    private boolean isValidProjectile(Projectile projectile) {
        LivingEntity owners;
        LivingEntity owner;
        Entity entity;
        if (projectile instanceof AbstractArrow) {
            AbstractArrow abstractArrow = (AbstractArrow)projectile;
            if (!abstractArrow.f_19812_) {
                return false;
            }
        }
        if ((entity = projectile.m_19749_()) instanceof LivingEntity && (owner = (LivingEntity)entity).m_7307_((Entity)this) || AttackFind.SameFactionAvoidDamage(projectile.m_19749_(), (LivingEntity)this) || AttackFind.SameFactionAvoidDamage((Entity)projectile, (LivingEntity)this) || (entity = projectile.m_19749_()) instanceof LivingEntity && AttackFind.FindCanNotAttack(owners = (LivingEntity)entity, (Entity)this)) {
            return false;
        }
        if (!Main.canSee((Entity)projectile, (Entity)this)) {
            return false;
        }
        if (projectile.m_20096_()) {
            return false;
        }
        Vec3 velocity = projectile.m_20184_();
        if (velocity.m_82556_() < 0.25) {
            return false;
        }
        Vec3 toMob = this.m_20182_().m_82546_(projectile.m_20182_()).m_82541_();
        double angle = velocity.m_82541_().m_82526_(toMob);
        return angle >= 0.7;
    }

    @Override
    public boolean canAttackJump() {
        ItemTwoHanded itemTwoHanded;
        ItemToolBaseDagger itemToolBaseDagger;
        Item item;
        if (InventoryEntity.isBow(this, this.m_21205_())) {
            return false;
        }
        if (InventoryEntity.isSpear(this, this.m_21205_())) {
            return false;
        }
        if (InventoryEntity.isPike(this, this.m_21205_())) {
            return false;
        }
        if (InventoryEntity.isThrow(this, this.m_21205_())) {
            return false;
        }
        if (InventoryEntity.isCrossbow(this, this.m_21205_())) {
            return false;
        }
        if (this.m_5448_() != null && (item = this.m_21205_().m_41720_()) instanceof ItemToolBaseDagger && (itemToolBaseDagger = (ItemToolBaseDagger)item).canShiftKeyDownUse(this.m_5448_())) {
            return false;
        }
        if (InventoryEntity.isOtherRange(this, this.m_21205_())) {
            return false;
        }
        if (this.m_21205_().m_41720_().m_5524_().contains("modern_kinetic_gun")) {
            return false;
        }
        return (!this.m_6117_() || (item = this.m_21211_().m_41720_()) instanceof ItemTwoHanded && (itemTwoHanded = (ItemTwoHanded)item).canBlock() || this.m_21211_().m_41720_() instanceof ShieldItem) && !this.f_20911_;
    }

    @Override
    public void playerJump() {
        super.m_6135_();
    }

    @Override
    public int getAttackSpeed() {
        double d = this.m_21133_(Attributes.f_22283_);
        int n = (int)(20.0 / d);
        return n + (this.m_21205_().m_41619_() ? 7 : 3);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.attack(entity, 1.0f);
        this.canNotAttackTargetTick = 0;
        return true;
    }

    public void attack(Entity entity, float scale) {
        if (entity.m_6097_() && !entity.m_7313_((Entity)this)) {
            float f = (float)this.m_21133_(Attributes.f_22281_);
            float f1 = entity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)MobType.f_21640_);
            float f2 = scale;
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                float i = (float)this.m_21133_(Attributes.f_22282_);
                i += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
                if (this.m_20142_() && flag) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12314_, this.m_5720_(), 1.0f, 1.0f);
                    i += 1.0f;
                    flag1 = true;
                }
                boolean flag2 = flag && this.f_19789_ > 0.0f && !this.m_20096_() && !this.m_6147_() && !this.m_20069_() && !this.m_21023_(MobEffects.f_19610_) && !this.m_20159_() && entity instanceof LivingEntity;
                boolean bl = flag2 = flag2 && !this.m_20142_();
                if (flag2) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag3 = false;
                double d0 = this.f_19787_ - this.f_19867_;
                if (flag && !flag2 && !flag1 && this.m_20096_() && d0 < (double)this.m_6113_()) {
                    ItemStack itemstack = this.m_21120_(InteractionHand.MAIN_HAND);
                    flag3 = itemstack.canPerformAction(ToolActions.SWORD_SWEEP);
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.m_44914_((LivingEntity)this);
                if (entity instanceof LivingEntity) {
                    f4 = ((LivingEntity)entity).m_21223_();
                    if (j > 0 && !entity.m_6060_()) {
                        flag4 = true;
                        entity.m_20254_(1);
                    }
                }
                Vec3 vec3 = entity.m_20184_();
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268464_), (Entity)this);
                boolean flag5 = entity.m_6469_(damageSource, f);
                if (flag5) {
                    Object var19;
                    if (i > 0.0f) {
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).m_147240_((double)(i * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                        } else {
                            entity.m_5997_((double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f), 0.1, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f));
                        }
                        this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                        this.m_6858_(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)this) * f;
                        var19 = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(1.0, 0.25, 1.0)).iterator();
                        while (true) {
                            if (!var19.hasNext()) {
                                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 1.0f, 1.0f);
                                Main.sweepAttack((Entity)this);
                                break;
                            }
                            LivingEntity livingentity = (LivingEntity)var19.next();
                            double entityReachSq = Mth.m_144952_((double)this.getEntityReach());
                            if (livingentity == this || livingentity == entity || this.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(this.m_20280_((Entity)livingentity) < entityReachSq)) continue;
                            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                            livingentity.m_6469_(damageSource, f3);
                        }
                    }
                    if (entity instanceof ServerPlayer && entity.f_19864_) {
                        ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
                        entity.f_19864_ = false;
                        entity.m_20256_(vec3);
                    }
                    if (flag2) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12313_, this.m_5720_(), 1.0f, 1.0f);
                        var19 = this.m_9236_();
                        if (var19 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)var19;
                            serverLevel.m_7726_().m_8394_((Entity)this, (Packet)new ClientboundAnimatePacket(entity, 4));
                        }
                        if (this.m_9236_().m_5776_()) {
                            Minecraft.m_91087_().f_91061_.m_107329_(entity, (ParticleOptions)ParticleTypes.f_123797_);
                        }
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12316_, this.m_5720_(), 1.0f, 1.0f);
                        } else {
                            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12318_, this.m_5720_(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        var19 = this.m_9236_();
                        if (var19 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)var19;
                            serverLevel.m_7726_().m_8394_((Entity)this, (Packet)new ClientboundAnimatePacket(entity, 5));
                        }
                        if (this.m_9236_().m_5776_()) {
                            Minecraft.m_91087_().f_91061_.m_107329_(entity, (ParticleOptions)ParticleTypes.f_123808_);
                        }
                    }
                    this.m_21335_(entity);
                    if (entity instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)entity), (Entity)this);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)this, (Entity)entity);
                    ItemStack itemstack1 = this.m_21205_();
                    Entity entitys = entity;
                    if (entitys instanceof PartEntity) {
                        entitys = ((PartEntity)entity).getParent();
                    }
                    if (!this.m_9236_().f_46443_ && !itemstack1.m_41619_() && entitys instanceof LivingEntity && JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
                        ItemStack hand = this.m_21205_();
                        hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
                    }
                    if (entity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)entity).m_21223_();
                        if (j > 0) {
                            entity.m_20254_(j * 4);
                        }
                        if (this.m_9236_() instanceof ServerLevel && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12315_, this.m_5720_(), 1.0f, 1.0f);
                    if (flag4) {
                        entity.m_20095_();
                    }
                }
            }
        }
    }

    public double getEntityReach() {
        double range = this.self().m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        return range == 0.0 ? 0.0 : range + (double)(this.abilities.f_35937_ ? 3 : 0);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.abilities.f_35934_ && !damageSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        this.f_20891_ = 0;
        if (this.m_21224_()) {
            return false;
        }
        if (this.m_21275_(damageSource)) {
            this.setMustShieldTick(30);
        }
        if (damageSource.m_7986_()) {
            if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                f = 0.0f;
            }
            if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                f = Math.min(f / 2.0f + 1.0f, f);
            }
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                f = f * 3.0f / 2.0f;
            }
        }
        if (f == 0.0f) {
            return false;
        }
        return super.m_6469_(damageSource, f);
    }

    public boolean m_6673_(DamageSource p_36249_) {
        if (super.m_6673_(p_36249_)) {
            return true;
        }
        if (p_36249_.m_269533_(DamageTypeTags.f_268581_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_46121_);
        }
        if (p_36249_.m_269533_(DamageTypeTags.f_268549_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_46122_);
        }
        if (p_36249_.m_269533_(DamageTypeTags.f_268745_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_46123_);
        }
        if (p_36249_.m_269533_(DamageTypeTags.f_268419_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_151485_);
        }
        return false;
    }

    public void m_7822_(byte by) {
        switch (by) {
            case 29: {
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
                break;
            }
            case 30: {
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
                break;
            }
            default: {
                super.m_7822_(by);
            }
        }
    }

    @Override
    public void disableShield() {
        if (this.shieldCoolDown < 100) {
            this.shieldCoolDown = 100;
        }
        this.shieldCanUse = 0;
        if (this.m_21211_().m_41720_() instanceof ShieldItem) {
            this.m_5810_();
        }
    }

    @Override
    public void disableShieldTry() {
    }

    @Override
    public void disableShieldBreak(int tick) {
        if (tick == 0) {
            return;
        }
        if (this.shieldCoolDown < tick) {
            this.shieldCoolDown = tick;
        }
        this.shieldCanUse = 0;
        if (this.m_21211_().m_41720_() instanceof ShieldItem) {
            this.m_5810_();
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType != MobSpawnType.CONVERSION && this.newSpawn == 0) {
            this.setChangeInventoryCooldownTick(20);
            this.setBowLevel(20);
            this.setShieldLevel(3);
        }
        super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        return spawnGroupData;
    }
}

