/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.Mob;

import com.google.common.annotations.VisibleForTesting;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.goal.JerotesMoveToGoal;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.item.tool.ItemToolBasePike;
import com.jerotes.jerotes.util.Main;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class TestEntity
extends PathfinderMob
implements JerotesEntity,
UseShieldEntity {
    private static final EntityDataAccessor<Boolean> IS_MOVE_TO = SynchedEntityData.m_135353_(TestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FEMALE = SynchedEntityData.m_135353_(TestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(TestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHIELD_LEVEL = SynchedEntityData.m_135353_(TestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState armWideScaleAnimationState = new AnimationState();
    public AnimationState armSlimScaleAnimationState = new AnimationState();

    public TestEntity(EntityType<? extends TestEntity> type, Level world) {
        super(type, world);
        this.m_252801_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 1024.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new JerotesMoveToGoal(this, 1.0, true){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && TestEntity.this.isMoveTo();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_ + 0.0625f * f, 0.0f);
    }

    protected float ridingOffset(Entity entity) {
        return -0.7f;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isMoveTo() {
        return (Boolean)this.m_20088_().m_135370_(IS_MOVE_TO);
    }

    public void setMoveTo(boolean bl) {
        this.m_20088_().m_135381_(IS_MOVE_TO, (Object)bl);
    }

    public void setShieldLevel(int n) {
        this.m_20088_().m_135381_(SHIELD_LEVEL, (Object)n);
    }

    public int getShieldLevel() {
        return (Integer)this.m_20088_().m_135370_(SHIELD_LEVEL);
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    @VisibleForTesting
    public void setSize(int n) {
        int n2 = Mth.m_14045_((int)n, (int)1, (int)10000);
        this.f_19804_.m_135381_(ID_SIZE, (Object)n2);
        this.m_20090_();
        this.m_6210_();
    }

    public boolean IsFemale() {
        return (Boolean)this.m_20088_().m_135370_(IS_FEMALE);
    }

    public void setFemale(boolean bl) {
        this.m_20088_().m_135381_(IS_FEMALE, (Object)bl);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Size", this.getSize());
        compoundTag.m_128379_("IsMoveTo", this.isMoveTo());
        compoundTag.m_128379_("IsFemale", this.IsFemale());
        compoundTag.m_128405_("ShieldLevel", this.getShieldLevel());
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.setSize(compoundTag.m_128451_("Size"));
        super.m_7378_(compoundTag);
        this.setMoveTo(compoundTag.m_128471_("IsMoveTo"));
        this.setFemale(compoundTag.m_128471_("IsFemale"));
        this.setShieldLevel(compoundTag.m_128451_("ShieldLevel"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_FEMALE, (Object)false);
        this.m_20088_().m_135372_(IS_MOVE_TO, (Object)false);
        this.m_20088_().m_135372_(ID_SIZE, (Object)180);
        this.m_20088_().m_135372_(SHIELD_LEVEL, (Object)1);
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double d2 = this.m_20186_();
        double d3 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, d2, d3);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ID_SIZE.equals(entityDataAccessor)) {
            this.m_6210_();
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = (float)this.getSize() / 100.0f * 1.62f;
        if (this.m_6162_()) {
            return (float)this.getSize() / 100.0f * 0.86f;
        }
        return height;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_((float)this.getSize() / 100.0f);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        if (sourceentity.m_36341_() && !this.m_5912_()) {
            if (sourceentity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
                Main.openMobInventoryGui(serverPlayer, (LivingEntity)this, true, true, true, true, true, true, true, true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(sourceentity, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.IsFemale()) {
            this.armWideScaleAnimationState.m_216982_(this.f_19797_);
            this.armSlimScaleAnimationState.m_216973_();
        } else {
            this.armSlimScaleAnimationState.m_216982_(this.f_19797_);
            this.armWideScaleAnimationState.m_216973_();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.shieldCanUse() && this.notBowCrossbow((Mob)this, InteractionHand.MAIN_HAND) && this.m_21206_().m_41720_() instanceof ShieldItem && (!this.m_6117_() || this.m_21211_().m_41720_() instanceof ShieldItem)) {
            if (this.m_6117_()) return;
            this.m_6672_(InteractionHand.OFF_HAND);
            return;
        }
        if (this.shieldCanUse() && this.notBowCrossbow((Mob)this, InteractionHand.OFF_HAND) && this.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ShieldItem && (!this.m_6117_() || this.m_21211_().m_41720_() instanceof ShieldItem)) {
            if (this.m_6117_()) return;
            this.m_6672_(InteractionHand.MAIN_HAND);
            return;
        }
        Item item = this.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (item instanceof ItemTwoHanded) {
            ItemTwoHanded itemTwoHanded = (ItemTwoHanded)item;
            if (!(this.m_21205_().m_41720_() instanceof ItemToolBasePike) && itemTwoHanded.canBlock() && this.m_21206_().m_41619_() && (!this.m_6117_() || this.m_21211_().m_41720_() instanceof ItemTwoHanded) && this.f_20921_ <= 0.0f) {
                if (this.m_6117_()) return;
                this.m_6672_(InteractionHand.MAIN_HAND);
                return;
            }
        }
        if ((item = this.m_21206_().m_41720_()) instanceof ItemTwoHanded) {
            ItemTwoHanded itemTwoHanded = (ItemTwoHanded)item;
            if (!(this.m_21206_().m_41720_() instanceof ItemToolBasePike) && itemTwoHanded.canBlock() && this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && (!this.m_6117_() || this.m_21211_().m_41720_() instanceof ItemTwoHanded) && this.f_20921_ <= 0.0f) {
                if (this.m_6117_()) return;
                this.m_6672_(InteractionHand.OFF_HAND);
                return;
            }
        }
        this.stopUse((Mob)this);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        return damageSource.m_269415_().f_268686_().m_269402_();
    }

    private boolean isDisabled(EquipmentSlot equipmentSlot) {
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, f);
        }
        float healthBefore = this.m_21223_();
        if (damageSource.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(damageSource, f);
        }
        if (super.m_6469_(damageSource, f)) {
            float healthAfter = this.m_21223_();
            this.m_6593_((Component)Component.m_237113_((String)String.valueOf(healthBefore - healthAfter)));
            this.m_21153_(this.m_21233_());
        }
        return true;
    }

    @Override
    public boolean shieldCanUse() {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setSize(100);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Override
    public boolean isDamageSourceBlocks(DamageSource damageSource) {
        Vec3 object;
        boolean bl;
        Entity entity = damageSource.m_7640_();
        boolean bl2 = bl = entity instanceof AbstractArrow && ((AbstractArrow)entity).m_36796_() > 0;
        if (!damageSource.m_269533_(DamageTypeTags.f_276146_) && !bl && (object = damageSource.m_7270_()) != null) {
            Vec3 vec3 = this.m_20171_(0.0f, this.m_6080_());
            Vec3 vec32 = object.m_82505_(this.m_20182_());
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
            return vec32.m_82526_(vec3) < 0.0;
        }
        return false;
    }

    @Override
    public void disableShield() {
    }

    @Override
    public void disableShieldTry() {
    }

    @Override
    public void disableShieldBreak(int n) {
    }
}

