/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.arrow;

import com.google.common.collect.Lists;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.entity.arrow.BaseAbstractArrowEntity;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BaseJavelinEntity
extends BaseAbstractArrowEntity {
    public static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(BaseJavelinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(BaseJavelinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack tridentItem = new ItemStack((ItemLike)Items.f_42713_);
    public boolean dealtDamage;
    public int time;
    public int clientSideReturnTridentTickCount;
    public float damage;
    public SoundEvent soundEvent = this.m_7239_();
    public float soundLevel = 1.0f;
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;

    public BaseJavelinEntity(EntityType<? extends AbstractArrow> entityType, Level level, ItemStack itemStack, float damages) {
        super(entityType, level, itemStack);
        this.damage = damages;
    }

    public BaseJavelinEntity(Level level, LivingEntity livingEntity, ItemStack itemStack, EntityType<? extends AbstractArrow> entityType, float damages) {
        super(entityType, livingEntity, level, itemStack);
        this.tridentItem = itemStack.m_41777_();
        if (this.canLoyalty()) {
            this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)itemStack)));
        }
        this.f_19804_.m_135381_(ID_FOIL, (Object)itemStack.m_41790_());
        this.damage = damages;
    }

    public float specialDamage(Entity entity) {
        return 0.0f;
    }

    public boolean canLoyalty() {
        return true;
    }

    public boolean mustLoyalty() {
        return false;
    }

    public boolean mustLoyaltyOnlyToPlayer() {
        return false;
    }

    public boolean customDealtDamage() {
        return false;
    }

    public boolean breakShield() {
        return false;
    }

    public boolean breakShieldOnlyNotLoyalty() {
        return true;
    }

    public boolean canHurtEnderman() {
        return false;
    }

    public void hitUse(Entity entity) {
        if (this.m_9236_() instanceof ServerLevel && this.m_9236_().m_46470_() && this.isChanneling()) {
            LightningBolt lightningBolt;
            BlockPos blockPos = entity.m_20183_();
            if (this.m_9236_().m_45527_(blockPos) && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
                ServerPlayer serverPlayer;
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                Entity entity2 = this.m_19749_();
                lightningBolt.m_20879_(entity2 instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity2) : null);
                this.m_9236_().m_7967_((Entity)lightningBolt);
                this.soundEvent = SoundEvents.f_12521_;
                this.soundLevel = 5.0f;
            }
        }
    }

    public void rebound() {
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
    }

    public void reboundBlock() {
    }

    public DamageSource getDamageSource(Entity entity) {
        return this.m_269291_().m_269525_((Entity)this, (Entity)(this.m_19749_() == null ? this : this.m_19749_()));
    }

    public int basePierce() {
        return 0;
    }

    public byte getPierceLevelBase() {
        return super.m_36796_();
    }

    public byte m_36796_() {
        return (byte)(this.getPierceLevelBase() + this.basePierce());
    }

    protected void m_8097_() {
        super.m_8097_();
        if (this.canLoyalty()) {
            this.m_20088_().m_135372_(ID_LOYALTY, (Object)0);
        }
        this.m_20088_().m_135372_(ID_FOIL, (Object)false);
    }

    public void m_8119_() {
        if (!this.customDealtDamage() && this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (this.canLoyalty()) {
            Entity entity = this.m_19749_();
            byte by = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
            if (by > 0) {
                if ((this.dealtDamage || this.m_36797_()) && entity != null) {
                    if (!this.isAcceptibleReturnOwner()) {
                        if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                            this.m_5552_(this.m_7941_(), 0.1f);
                        }
                        this.m_146870_();
                    } else {
                        this.m_36790_(true);
                        Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                        this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)by, this.m_20189_());
                        if (this.m_9236_().f_46443_) {
                            this.f_19791_ = this.m_20186_();
                        }
                        double d = 0.05 * (double)by;
                        this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d)));
                        if (this.clientSideReturnTridentTickCount == 0) {
                            this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                        }
                        ++this.clientSideReturnTridentTickCount;
                    }
                }
            } else if (this.mustLoyalty() && (this.dealtDamage || this.m_36797_()) && entity != null) {
                if (!this.isAcceptibleReturnOwner() || !(this.m_19749_() instanceof Player) && this.mustLoyaltyOnlyToPlayer()) {
                    if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                        this.m_5552_(this.m_7941_(), 0.1f);
                    }
                    this.m_146870_();
                } else {
                    this.m_36790_(true);
                    Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                    this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.01, this.m_20189_());
                    if (this.m_9236_().f_46443_) {
                        this.f_19791_ = this.m_20186_();
                    }
                    double d = 0.3;
                    this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d)));
                    if (this.clientSideReturnTridentTickCount == 0) {
                        this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                    }
                    ++this.clientSideReturnTridentTickCount;
                }
            }
        }
        super.m_8119_();
    }

    protected boolean m_5603_(Entity p_36743_) {
        if (this.m_19749_() != null && p_36743_ instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)p_36743_;
            if (AttackFind.SameFactionAvoidDamage(this.m_19749_(), livingEntity)) {
                return false;
            }
        }
        if (this.piercingIgnoreEntityIds != null && this.piercingIgnoreEntityIds.size() >= this.m_36796_()) {
            return false;
        }
        return super.m_5603_(p_36743_) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(p_36743_.m_19879_()));
    }

    private void m_36723_() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity == null || !entity.m_6084_()) {
            return false;
        }
        return !(entity instanceof ServerPlayer) || !entity.m_5833_();
    }

    protected ItemStack m_7941_() {
        return this.tridentItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    protected EntityHitResult m_6351_(Vec3 vec3, Vec3 vec32) {
        if (this.dealtDamage) {
            return null;
        }
        return super.m_6351_(vec3, vec32);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        if (this.piercingIgnoreEntityIds != null && this.piercingIgnoreEntityIds.size() >= this.m_36796_()) {
            return;
        }
        Entity entity = this.m_19749_();
        Entity entity2 = entityHitResult.m_82443_();
        float f = this.damage;
        float special = this.specialDamage(entity2);
        if (entity2 instanceof LivingEntity) {
            entity = entity2;
            f += EnchantmentHelper.m_44833_((ItemStack)this.tridentItem, (MobType)((LivingEntity)entity).m_6336_());
        }
        DamageSource damageSource = this.getDamageSource(entity2);
        byte pierce = this.m_36796_();
        if (pierce > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            int count = pierce + 1;
            if (this.piercingIgnoreEntityIds != null && this.piercingIgnoreEntityIds.size() < count) {
                this.piercingIgnoreEntityIds.add(entity2.m_19879_());
            } else {
                this.dealtDamage = true;
            }
        } else {
            this.dealtDamage = true;
        }
        this.soundEvent = this.getDefaultHitSoundEvent();
        boolean deflectTridents = entity2.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("deflects_tridents")));
        if (entity2.m_6469_(damageSource, f + special)) {
            LivingEntity livingEntity;
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                if (this.breakShield() && ((Byte)this.f_19804_.m_135370_(ID_LOYALTY) <= 0 || !this.breakShieldOnlyNotLoyalty()) && livingEntity.m_21211_().m_41720_() instanceof ShieldItem) {
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_36384_(true);
                    } else if (livingEntity instanceof UseShieldEntity) {
                        UseShieldEntity useShieldEntity = (UseShieldEntity)livingEntity;
                        useShieldEntity.disableShield();
                    }
                }
                if (!entity2.m_6084_() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingEntity);
                }
            }
            if (entity2 instanceof LivingEntity && EntityFactionFind.isEnderman(livingEntity = (LivingEntity)entity2) && !this.canHurtEnderman()) {
                return;
            }
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                if (entity instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)entity);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity), (Entity)livingEntity);
                }
                this.m_7761_(livingEntity);
            }
        } else if (deflectTridents && !this.canHurtEnderman()) {
            this.deflect();
            return;
        }
        this.rebound();
        this.soundLevel = 1.0f;
        this.hitUse(entity2);
        this.m_5496_(this.soundEvent, this.soundLevel, 1.0f);
    }

    public void deflect() {
        float f = this.f_19796_.m_188501_() * 360.0f;
        this.m_20256_(this.m_20184_().m_82524_(f * ((float)Math.PI / 180)).m_82490_(0.5));
        this.m_146922_(this.m_146908_() + f);
        this.f_19859_ += f;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.reboundBlock();
        this.m_36723_();
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.tridentItem);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    protected SoundEvent getDefaultHitSoundEvent() {
        return SoundEvents.f_12514_;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("Trident", 10)) {
            this.tridentItem = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Trident"));
        }
        this.dealtDamage = compoundTag.m_128471_("DealtDamage");
        if (this.canLoyalty()) {
            this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.tridentItem)));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("Trident", (Tag)this.tridentItem.m_41739_(new CompoundTag()));
        compoundTag.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        if (this.canLoyalty()) {
            byte by = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
            if (this.mustLoyalty()) {
                if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
                    super.m_6901_();
                }
            } else if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || by <= 0) {
                super.m_6901_();
            }
        } else {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.6f;
    }

    public boolean m_6000_(double d, double d2, double d3) {
        return true;
    }

    public boolean getDealtDamage() {
        return this.dealtDamage;
    }
}

