/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.magic;

import com.google.common.collect.Lists;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.magic.MagicAbout;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.spell.SpellFind;
import com.jerotes.jerotes.util.AttackFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public abstract class MagicAboutThrowEntity
extends ThrowableProjectile
implements ItemSupplier,
MagicAbout {
    private static final EntityDataAccessor<Optional<UUID>> HURT_ID = SynchedEntityData.m_135353_(MagicAboutThrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(MagicAboutThrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Nullable
    private Entity lastHurt;
    @Nullable
    private UUID lastHurtUUID;
    public int life = 0;
    public int lifeOfLastHurt = 0;
    public int spellLevelDamage = 1;
    public int spellLevelMaxDamage = 1;
    public int spellLevelFireTime = 1;
    public int spellLevelFreezeTime = 1;
    public float spellLevelExplode = 1.0f;
    public int spellLevelMainEffectTime = 1;
    public int spellLevelMainEffectLevel = 1;
    public int spellLevelOtherEffectTime = 1;
    public int spellLevelOtherEffectLevel = 1;
    public float spellLevelXZPush = 1.0f;
    public float spellLevelXZPushBase = 1.0f;
    public float spellLevelYPush = 1.0f;
    public float spellLevelYPushBase = 1.0f;
    public int spellLevelHeight = 1;
    public int spellLevelMoveDistance = 1;

    public MagicAboutThrowEntity(EntityType<? extends MagicAboutThrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public MagicAboutThrowEntity(EntityType<? extends MagicAboutThrowEntity> entityType, double d, double d2, double d3, Level level) {
        super(entityType, d, d2, d3, level);
    }

    public MagicAboutThrowEntity(EntityType<? extends MagicAboutThrowEntity> entityType, LivingEntity livingEntity, Level level) {
        super(entityType, livingEntity, level);
    }

    public void setItem(ItemStack itemStack) {
        if (!itemStack.m_150930_(this.getDefaultItem()) || itemStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)itemStack.m_255036_(1));
        }
    }

    protected abstract Item getDefaultItem();

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack itemStack = this.getItemRaw();
        return itemStack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemStack;
    }

    protected boolean m_5603_(Entity p_36743_) {
        if (this.m_19749_() != null && p_36743_ instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)p_36743_;
            if (AttackFind.SameFactionAvoidDamage(this.m_19749_(), livingEntity)) {
                return false;
            }
        }
        return super.m_5603_(p_36743_);
    }

    public void lookAt(Entity entity, float f, float f2) {
        double d1;
        double d0 = entity.m_20185_() - this.m_20185_();
        double d2 = entity.m_20189_() - this.m_20189_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            d1 = livingentity.m_20188_() - this.m_20188_();
        } else {
            d1 = (entity.m_20191_().f_82289_ + entity.m_20191_().f_82292_) / 2.0 - this.m_20188_();
        }
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f3 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f4 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        this.m_146926_(this.rotlerp(this.m_146909_(), f4, f2));
        this.m_146922_(this.rotlerp(this.m_146908_(), f3, f));
    }

    private float rotlerp(float f, float f2, float f3) {
        float f4 = Mth.m_14177_((float)(f2 - f));
        if (f4 > f3) {
            f4 = f3;
        }
        if (f4 < -f3) {
            f4 = -f3;
        }
        return f + f4;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        Entity entity;
        if (entityHitResult.m_82443_() == this.getLastHurt() && !this.canNotHurtLastHurt()) {
            return;
        }
        if (this.isHurt(entityHitResult.m_82443_().m_20148_()) && this.useUUIDFindHurtAndDisable()) {
            return;
        }
        if (entityHitResult.m_82443_() == this.m_19749_()) {
            return;
        }
        if (!(this.isHelp() || entityHitResult.m_82443_() == this.m_19749_() || !((entity = entityHitResult.m_82443_()) instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) || livingEntity.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()).m_19564_() + 1 < this.getSpellLevel() || this.m_19749_() != null && MainConfig.SameFactionAvoidDamage && AttackFind.SameFactionAvoidDamage(this.m_19749_(), livingEntity))) {
            if (!livingEntity.m_9236_().m_5776_()) {
                livingEntity.m_21195_((MobEffect)JerotesMobEffects.COUNTERSPELL.get());
            }
            livingEntity.m_6674_(InteractionHand.MAIN_HAND);
            SpellFind.Counterspell(livingEntity);
            return;
        }
        this.setLastHurt(entityHitResult.m_82443_());
        this.addHurtUUID(entityHitResult.m_82443_().m_20148_());
        super.m_5790_(entityHitResult);
    }

    protected void customHurt(Entity entity) {
        LivingEntity livingEntity;
        if (entity == this.getLastHurt() && !this.canNotHurtLastHurt()) {
            return;
        }
        if (this.isHurt(entity.m_20148_()) && this.useUUIDFindHurtAndDisable()) {
            return;
        }
        if (entity == this.m_19749_()) {
            return;
        }
        if (!(this.isHelp() || entity == this.m_19749_() || !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) || livingEntity.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()).m_19564_() + 1 < this.getSpellLevel() || this.m_19749_() != null && MainConfig.SameFactionAvoidDamage && AttackFind.SameFactionAvoidDamage(this.m_19749_(), livingEntity))) {
            if (!livingEntity.m_9236_().m_5776_()) {
                livingEntity.m_21195_((MobEffect)JerotesMobEffects.COUNTERSPELL.get());
            }
            livingEntity.m_6674_(InteractionHand.MAIN_HAND);
            SpellFind.Counterspell(livingEntity);
            return;
        }
        this.setLastHurt(entity);
        this.addHurtUUID(entity.m_20148_());
    }

    @Nullable
    public Entity getLastHurt() {
        Entity entity;
        if (this.lastHurt == null && this.lastHurtUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.lastHurtUUID)) instanceof Entity) {
            this.lastHurt = entity;
        }
        return this.lastHurt;
    }

    public void setLastHurt(@Nullable Entity lastHurt) {
        this.lastHurt = lastHurt;
        this.lastHurtUUID = lastHurt == null ? null : lastHurt.m_20148_();
    }

    public List<UUID> getHurtUUIDs() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(((Optional)this.f_19804_.m_135370_(HURT_ID)).orElse(null));
        return arrayList;
    }

    public void addHurtUUID(@Nullable UUID uUID) {
        this.f_19804_.m_135381_(HURT_ID, Optional.ofNullable(uUID));
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevelDamage;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        ItemStack itemStack = this.getItemRaw();
        if (!itemStack.m_41619_()) {
            compoundTag.m_128365_("Item", (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        if (this.lastHurtUUID != null) {
            compoundTag.m_128362_("LastHurt", this.lastHurtUUID);
        }
        List<UUID> list = this.getHurtUUIDs();
        ListTag listTag = new ListTag();
        for (UUID uUID : list) {
            if (uUID == null) continue;
            listTag.add((Object)NbtUtils.m_129226_((UUID)uUID));
        }
        compoundTag.m_128365_("Hurt", (Tag)listTag);
        compoundTag.m_128405_("Life", this.life);
        compoundTag.m_128405_("LifeOfLastHurt", this.lifeOfLastHurt);
        compoundTag.m_128405_("SpellLevelDamage", this.spellLevelDamage);
        compoundTag.m_128405_("SpellLevelMaxDamage", this.spellLevelMaxDamage);
        compoundTag.m_128405_("SpellLevelFireTime", this.spellLevelFireTime);
        compoundTag.m_128405_("SpellLevelFreezeTime", this.spellLevelFreezeTime);
        compoundTag.m_128350_("SpellLevelExplode", this.spellLevelExplode);
        compoundTag.m_128405_("SpellLevelMainEffectTime", this.spellLevelMainEffectTime);
        compoundTag.m_128405_("SpellLevelMainEffectLevel", this.spellLevelMainEffectLevel);
        compoundTag.m_128405_("SpellLevelOtherEffectTime", this.spellLevelOtherEffectTime);
        compoundTag.m_128405_("SpellLevelOtherEffectLevel", this.spellLevelOtherEffectLevel);
        compoundTag.m_128350_("SpellLevelXZPush", this.spellLevelXZPush);
        compoundTag.m_128350_("SpellLevelXZPushBase", this.spellLevelXZPushBase);
        compoundTag.m_128350_("SpellLevelYPush", this.spellLevelYPush);
        compoundTag.m_128350_("SpellLevelYPushBase", this.spellLevelYPushBase);
        compoundTag.m_128405_("SpellLevelHeight", this.spellLevelHeight);
        compoundTag.m_128405_("SpellLevelMoveDistance", this.spellLevelMoveDistance);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Item"));
        this.setItem(itemStack);
        if (compoundTag.m_128403_("LastHurt")) {
            this.lastHurtUUID = compoundTag.m_128342_("LastHurt");
        }
        ListTag listTag = compoundTag.m_128437_("Hurt", 11);
        for (Tag tag : listTag) {
            this.addHurtUUID(NbtUtils.m_129233_((Tag)tag));
        }
        this.life = compoundTag.m_128451_("Life");
        this.lifeOfLastHurt = compoundTag.m_128451_("LifeOfLastHurt");
        this.spellLevelDamage = compoundTag.m_128451_("SpellLevelDamage");
        this.spellLevelMaxDamage = compoundTag.m_128451_("SpellLevelMaxDamage");
        this.spellLevelFireTime = compoundTag.m_128451_("SpellLevelFireTime");
        this.spellLevelFreezeTime = compoundTag.m_128451_("SpellLevelFreezeTime");
        this.spellLevelExplode = compoundTag.m_128457_("SpellLevelExplode");
        this.spellLevelMainEffectTime = compoundTag.m_128451_("SpellLevelMainEffectTime");
        this.spellLevelMainEffectLevel = compoundTag.m_128451_("SpellLevelMainEffectLevel");
        this.spellLevelOtherEffectTime = compoundTag.m_128451_("SpellLevelOtherEffectTime");
        this.spellLevelOtherEffectLevel = compoundTag.m_128451_("SpellLevelOtherEffectLevel");
        this.spellLevelXZPush = compoundTag.m_128457_("SpellLevelXZPush");
        this.spellLevelXZPushBase = compoundTag.m_128457_("SpellLevelXZPushBase");
        this.spellLevelYPush = compoundTag.m_128457_("SpellLevelYPush");
        this.spellLevelYPushBase = compoundTag.m_128457_("SpellLevelYPushBase");
        this.spellLevelHeight = compoundTag.m_128451_("SpellLevelHeight");
        this.spellLevelMoveDistance = compoundTag.m_128451_("SpellLevelMoveDistance");
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(HURT_ID, Optional.empty());
    }

    boolean isHurt(UUID uUID) {
        return this.getHurtUUIDs().contains(uUID);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.life >= this.getMaxLife()) {
            this.lastBreak();
            this.m_146870_();
        } else {
            ++this.life;
        }
        if (this.lifeOfLastHurt >= this.timeOfHurtLastHurt()) {
            this.setLastHurt(null);
        } else if (this.getLastHurt() != null) {
            ++this.lifeOfLastHurt;
        }
    }

    public void lastBreak() {
    }

    public abstract int getMaxLife();

    public boolean canNotHurtLastHurt() {
        return true;
    }

    public boolean useUUIDFindHurtAndDisable() {
        return false;
    }

    public int timeOfHurtLastHurt() {
        return 10;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        return false;
    }

    protected float m_7139_() {
        return 0.0f;
    }

    protected float getLiquidInertia() {
        return 1.0f;
    }
}

