/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.magic.Ray;

import com.jerotes.jerotes.entity.magic.MagicAboutEntity;
import com.jerotes.jerotes.entity.magic.Ray.BaseRayEntity;
import com.jerotes.jerotes.init.JerotesEntityType;
import com.jerotes.jerotes.init.JerotesItems;
import com.jerotes.jerotes.init.JerotesParticleTypes;
import com.jerotes.jerotes.util.Main;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class LightningBoltEntity
extends BaseRayEntity {
    public LightningBoltEntity(EntityType<? extends LightningBoltEntity> entityType, Level level) {
        super((EntityType<? extends MagicAboutEntity>)entityType, level);
    }

    public LightningBoltEntity(EntityType<? extends LightningBoltEntity> entityType, double d, double d2, double d3, double d4, double d5, double d6, Level level) {
        this(entityType, level);
        this.m_7678_(d, d2, d3, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 != 0.0) {
            this.xPower = d4 / d7 * 0.1;
            this.yPower = d5 / d7 * 0.1;
            this.zPower = d6 / d7 * 0.1;
        }
    }

    public LightningBoltEntity(int spellLevelDamage, Level level, LivingEntity livingEntity, double d, double d2, double d3) {
        super((EntityType<? extends MagicAboutEntity>)((EntityType)JerotesEntityType.LIGHTNING_BOLT.get()), livingEntity, d, d2, d3, level);
        this.spellLevelDamage = spellLevelDamage;
        this.summonTod = d;
        this.summonTod2 = d2;
        this.summonTod3 = d3;
    }

    @Override
    protected void customHurt(Entity entity) {
        super.customHurt(entity);
        if (!this.m_9236_().m_5776_() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_), (Entity)this, this.m_19749_());
            double noUse = 0.0;
            if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
                noUse = livingEntity.m_21172_(Attributes.f_22279_);
            }
            if ((double)this.f_19796_.m_188501_() > (noUse / 3.0 + 35.0) / 100.0) {
                livingEntity.m_6469_(damageSource, (float)((this.spellLevelDamage + 5) * Main.randomReach(RandomSource.m_216327_(), 1, 6)));
            } else {
                livingEntity.m_6469_(damageSource, (float)((this.spellLevelDamage + 5) * Main.randomReach(RandomSource.m_216327_(), 1, 6)) / 2.0f);
            }
            this.m_5496_(SoundEvents.f_12089_, 10.0f, 1.0f);
        }
    }

    @Override
    public void m_8119_() {
        if (this.isUseful()) {
            List list = this.m_9236_().m_45976_(Entity.class, this.m_20191_());
            for (Entity findEntity : list) {
                this.customHurt(findEntity);
            }
        }
        super.m_8119_();
    }

    @Override
    public boolean canNotHurtLastHurt() {
        return false;
    }

    @Override
    public boolean useUUIDFindHurtAndDisable() {
        return true;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.isUseful()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setUseful(false);
            this.m_146870_();
        }
    }

    @Override
    public BaseRayEntity getRay() {
        return new LightningBoltEntity(this.spellLevelDamage, this.m_9236_(), (LivingEntity)this.m_19749_(), this.summonTod, this.summonTod2, this.summonTod3);
    }

    @Override
    public int getMaxLife() {
        return 40;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return (ParticleOptions)JerotesParticleTypes.LIGHTNING_BOLT.get();
    }

    @Override
    public ItemStack m_7846_() {
        ItemStack itemStack = this.getItemRaw();
        if (this.isUseful()) {
            return itemStack.m_41619_() ? new ItemStack((ItemLike)JerotesItems.LIGHTNING_BLOT.get()) : itemStack;
        }
        return itemStack.m_41619_() ? new ItemStack((ItemLike)Items.f_41852_) : itemStack;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return 1.0f;
    }
}

