/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.event;

import com.jerotes.jerotes.entity.UseDaggerEntity;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.AACreativeClaw;
import com.jerotes.jerotes.item.AAExplorationEye;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.item.tool.ItemToolBaseBandage;
import com.jerotes.jerotes.item.tool.ItemToolBaseDagger;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jerotes")
public class ItemEvent {
    @SubscribeEvent
    public static void addWeaponDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attackBy = event.getSource().m_7639_();
        float amount = event.getAmount();
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        if (entity.m_21205_().m_41720_() instanceof AACreativeClaw || entity.m_21206_().m_41720_() instanceof AACreativeClaw) {
            event.setCanceled(true);
        }
        if (attackBy != null) {
            LivingEntity living;
            ItemStack handItem = null;
            ItemStack otherHandItem = null;
            if (attackBy instanceof LivingEntity) {
                living = (LivingEntity)attackBy;
                handItem = living.m_21205_();
                otherHandItem = living.m_21206_();
                if (!EntityAndItemFind.MeleeDamageFromMainHandNotOffHand(living)) {
                    handItem = living.m_21206_();
                    otherHandItem = living.m_21205_();
                }
            }
            if (!EntityAndItemFind.MeleeDamageFromMainHandNotOffHand(entity)) {
                handItem = entity.m_21206_();
                otherHandItem = entity.m_21205_();
            }
            if (attackBy instanceof LivingEntity) {
                living = (LivingEntity)attackBy;
                if (living.m_21205_().m_41720_() instanceof AACreativeClaw || living.m_21206_().m_41720_() instanceof AACreativeClaw) {
                    if (!entity.m_9236_().m_5776_()) {
                        entity.getPersistentData().m_128347_("jerotesvillage_variant_zsiein_discard", 666666.0);
                    }
                    event.setAmount(amount + Float.MAX_VALUE);
                }
                if ((attackBy instanceof Mob || attackBy instanceof Player) && event.getSource().m_7640_() == living && EntityAndItemFind.isMeleeDamage(event.getSource()) && living.m_21051_(Attributes.f_22281_) != null) {
                    UseDaggerEntity useDaggerEntity;
                    float baseDamage = (float)living.m_21133_(Attributes.f_22281_);
                    if (baseDamage <= 0.0f) {
                        return;
                    }
                    if ((handItem.m_41720_() instanceof ItemToolBaseDagger || living instanceof UseDaggerEntity && (useDaggerEntity = (UseDaggerEntity)living).asUseDagger()) && living.m_6144_()) {
                        ItemToolBaseDagger itemToolBaseDagger;
                        Item item;
                        Mob mob;
                        float damage = 1.5f;
                        if (entity instanceof Mob && !(mob = (Mob)entity).m_5912_() && mob.m_5448_() == null) {
                            damage *= 1.25f;
                        }
                        if (!Main.canSee((Entity)living, (Entity)entity)) {
                            damage *= 1.25f;
                        }
                        if (!living.m_20096_()) {
                            damage *= 0.5f;
                        }
                        if (living.m_21206_().m_41720_() instanceof ItemToolBaseDagger) {
                            damage *= 1.15f;
                        }
                        if (Main.mobSizeSmall((Entity)entity)) {
                            damage *= 1.15f;
                        }
                        if (Main.mobSizeGiant((Entity)entity)) {
                            damage *= 0.75f;
                        }
                        if (entity.m_21223_() >= entity.m_21233_()) {
                            damage *= 1.25f;
                        }
                        if (entity.m_21223_() <= entity.m_21233_() / 5.0f) {
                            damage *= 1.25f;
                        }
                        if (EntityFactionFind.isHumanoid(entity)) {
                            damage *= 1.15f;
                        }
                        if (living.m_20145_()) {
                            damage *= 1.25f;
                        }
                        if (EntityAndItemFind.targetBlindnessTrue(entity)) {
                            damage *= 1.15f;
                        }
                        if (!((item = otherHandItem.m_41720_()) instanceof ItemToolBaseDagger) || (itemToolBaseDagger = (ItemToolBaseDagger)item).canShiftKeyDownDamage(living)) {
                            float newAmount = ItemEvent.DaggerCount(amount * damage, amount);
                            if (Float.isNaN(newAmount) || Float.isInfinite(newAmount)) {
                                newAmount = 0.0f;
                            }
                            event.setAmount(newAmount);
                        }
                    }
                }
            }
        }
    }

    public static float DaggerCount(float fs, float baseDamage) {
        if (baseDamage <= 0.001f) {
            return Math.min(fs, 500.0f);
        }
        float baseMult = fs / baseDamage;
        float softCap = 100.0f;
        float hardCap = 300.0f;
        float maxOutput = 500.0f;
        if (baseDamage > 100.0f) {
            float decay = 0.7f - 0.2f * (baseDamage / 300.0f);
            decay = Math.max(0.3f, decay);
            float scaled = 100.0f * baseMult;
            float bonus = (float)(Math.log(baseDamage + 1.0f) / Math.log(100.0)) * scaled * decay;
            float result = Math.min(Math.max(bonus, scaled), 500.0f + baseDamage * 0.2f);
            return Float.isFinite(result) ? result : 500.0f;
        }
        float result = Math.min(baseDamage * baseMult, 500.0f);
        return Float.isFinite(result) ? result : 500.0f;
    }

    @SubscribeEvent
    public static void addWeaponEffect(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attackBy = event.getSource().m_7639_();
        float amount = event.getAmount();
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        if (entity.m_21205_().m_41720_() instanceof AACreativeClaw || entity.m_21206_().m_41720_() instanceof AACreativeClaw) {
            event.setCanceled(true);
        }
        if (attackBy != null) {
            Item aaExplorationEye;
            Item item;
            LivingEntity living;
            ItemStack handItem = null;
            ItemStack otherHandItem = null;
            if (attackBy instanceof LivingEntity) {
                living = (LivingEntity)attackBy;
                handItem = living.m_21205_();
                otherHandItem = living.m_21206_();
                if (!EntityAndItemFind.MeleeDamageFromMainHandNotOffHand(living)) {
                    handItem = living.m_21206_();
                    otherHandItem = living.m_21205_();
                }
            }
            if (attackBy instanceof LivingEntity && (item = (living = (LivingEntity)attackBy).m_21205_().m_41720_()) instanceof AAExplorationEye) {
                aaExplorationEye = (AAExplorationEye)item;
                event.setCanceled(true);
            }
            if (handItem != null && (aaExplorationEye = handItem.m_41720_()) instanceof ItemSpecialEffect) {
                ItemSpecialEffect specialEffect = (ItemSpecialEffect)aaExplorationEye;
                if (attackBy instanceof LivingEntity) {
                    LivingEntity living2 = (LivingEntity)attackBy;
                    if (EntityAndItemFind.isMeleeDamage(event.getSource()) && living2.m_21051_(Attributes.f_22281_) != null) {
                        float baseDamage = (float)living2.m_21133_(Attributes.f_22281_);
                        if (baseDamage <= 0.0f) {
                            return;
                        }
                        specialEffect.attackUse((Entity)living2, (Entity)entity, amount > 0.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void UseItemTo(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack;
        block5: {
            block4: {
                Player player = event.getEntity();
                Entity entity = event.getTarget();
                itemStack = event.getItemStack();
                if (!(entity instanceof LivingEntity)) break block4;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (player != null) break block5;
            }
            return;
        }
        if (itemStack.m_41720_() instanceof AAExplorationEye) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void TwoHandedUse(LivingHurtEvent event) {
        Item item;
        ItemTwoHanded itemTwoHanded;
        Item item2;
        LivingEntity entity = event.getEntity();
        DamageSource damagesource = event.getSource();
        Entity attackBy = event.getSource().m_7639_();
        if (damagesource == null || entity == null || !entity.m_6084_()) {
            return;
        }
        if (entity.m_21206_().m_41619_() && (item2 = entity.m_21205_().m_41720_()) instanceof ItemTwoHanded && (itemTwoHanded = (ItemTwoHanded)item2).canBlock() && (item = entity.m_21205_().m_41720_()) instanceof ItemSpecialEffect) {
            float newAmount;
            ItemSpecialEffect specialEffect = (ItemSpecialEffect)item;
            float damages = 1.0f;
            if (ItemEvent.isDamageSourceBlocks(damagesource, entity) && entity.m_6117_()) {
                damages -= (float)itemTwoHanded.getBlockReduction() / 100.0f;
                specialEffect.blockUse((Entity)entity, attackBy, damagesource);
            }
            if (!(damages == 1.0f || entity.m_20147_() || entity.m_6673_(damagesource) || entity.m_20067_())) {
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), JerotesSounds.TWOHANDED_BLOCK, entity.m_5720_(), 1.0f, 1.0f);
            }
            if (Float.isNaN(newAmount = event.getAmount() * damages) || Float.isInfinite(newAmount)) {
                newAmount = 0.0f;
            }
            event.setAmount(newAmount);
        }
    }

    public static boolean isDamageSourceBlocks(DamageSource damageSource, LivingEntity entitys) {
        Vec3 object;
        boolean bl;
        Entity entity = damageSource.m_7640_();
        boolean bl2 = bl = entity instanceof AbstractArrow && ((AbstractArrow)entity).m_36796_() > 0;
        if (!damageSource.m_269533_(DamageTypeTags.f_276146_) && !bl && (object = damageSource.m_7270_()) != null) {
            Vec3 vec3 = entitys.m_20252_(0.0f);
            Vec3 vec32 = object.m_82505_(entitys.m_20182_());
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
            return vec32.m_82526_(vec3) < 0.0;
        }
        return false;
    }

    @SubscribeEvent
    public static void hurts(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21211_().m_41720_() instanceof ItemToolBaseBandage) {
            entity.m_5810_();
        }
    }
}

