/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.goal;

import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.JerotesPlayerBaseEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class JerotesMeleeAttackGoal
extends Goal {
    public final PathfinderMob mob;
    public final double speedModifier;
    public final boolean followingTargetEvenIfNotSeen;
    public final boolean canJump;
    public final boolean canFlee;
    public Path path;
    public double pathedTargetX;
    public double pathedTargetY;
    public double pathedTargetZ;
    public int ticksUntilNextPathRecalculation;
    public int ticksUntilNextAttack;
    public int ticksUntilNextJump;
    public int ticksJumpUse;
    public final int attackInterval = 20;
    public long lastCanUseCheck;
    public static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    public int jumpTick = 15;
    public int jumpCooldownTick = 15;
    public int jumpCooldownRandomTick = 20;

    public JerotesMeleeAttackGoal(PathfinderMob pathfinderMob, double d, boolean bl) {
        this.mob = pathfinderMob;
        this.speedModifier = d;
        this.followingTargetEvenIfNotSeen = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.canJump = false;
        this.canFlee = false;
    }

    public JerotesMeleeAttackGoal(PathfinderMob pathfinderMob, double d, boolean bl, boolean canJump, int jumpTick, int jumpCooldownTick, int jumpCooldownRandomTick, boolean canFlee) {
        this.mob = pathfinderMob;
        this.speedModifier = d;
        this.followingTargetEvenIfNotSeen = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.canJump = canJump;
        this.jumpTick = jumpTick;
        this.jumpCooldownTick = jumpCooldownTick;
        this.jumpCooldownRandomTick = jumpCooldownRandomTick;
        this.canFlee = canFlee;
    }

    public JerotesMeleeAttackGoal(PathfinderMob pathfinderMob, double d, boolean bl, boolean canJump, boolean canFlee) {
        this.mob = pathfinderMob;
        this.speedModifier = d;
        this.followingTargetEvenIfNotSeen = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.canJump = canJump;
        this.canFlee = canFlee;
    }

    public boolean m_8036_() {
        long l = this.mob.m_9236_().m_46467_();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.mob.m_217066_(livingEntity);
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingEntity.m_20183_())) {
            return false;
        }
        return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
    }

    public boolean canJump(Mob livingEntity) {
        return this.canJump(livingEntity, false);
    }

    public boolean canJump(Mob livingEntity, boolean bl) {
        JerotesEntity jerotes;
        if (livingEntity.m_217005_()) {
            return false;
        }
        if (livingEntity instanceof JerotesEntity && !(jerotes = (JerotesEntity)livingEntity).canAttackJump()) {
            return false;
        }
        if (livingEntity.m_6147_() || livingEntity.isInFluidType() || livingEntity.m_21023_(MobEffects.f_19610_) || livingEntity.m_20159_()) {
            return false;
        }
        if (!bl) {
            JerotesEntity jerotes2;
            if (livingEntity.m_5448_() == null) {
                return false;
            }
            if (livingEntity instanceof JerotesEntity && (jerotes2 = (JerotesEntity)livingEntity).getAttackBoundingBox() != null && jerotes2.getAttackBoundingBox().m_82400_(0.5).m_82381_(livingEntity.m_5448_().m_20191_())) {
                return livingEntity.m_20096_();
            }
            if (livingEntity.m_20191_().m_82400_(0.5).m_82381_(livingEntity.m_5448_().m_20191_())) {
                return livingEntity.m_20096_();
            }
            return false;
        }
        return true;
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.ticksUntilNextJump = 0;
        this.ticksJumpUse = 0;
    }

    public void m_8041_() {
        InventoryEntity inventoryEntity;
        PathfinderMob pathfinderMob;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null || !((pathfinderMob = this.mob) instanceof InventoryEntity) || !(inventoryEntity = (InventoryEntity)pathfinderMob).isCanChangeMeleeOrRange()) {
            if (!EntitySelector.f_20406_.test(livingEntity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
        }
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof JerotesPlayerBaseEntity) {
            JerotesPlayerBaseEntity jerotesPlayerEntity = (JerotesPlayerBaseEntity)pathfinderMob;
            this.mob.m_21391_((Entity)livingEntity, 360.0f, 360.0f);
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 360.0f, 360.0f);
        } else {
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
        }
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = livingEntity.m_20185_();
            this.pathedTargetY = livingEntity.m_20186_();
            this.pathedTargetZ = livingEntity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
            double d = this.mob.m_20280_((Entity)livingEntity);
            if (d > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.ticksUntilNextJump = Math.max(this.ticksUntilNextJump - 1, 0);
        this.ticksJumpUse = Math.max(this.ticksJumpUse - 1, 0);
        this.checkAndPerformAttack(livingEntity);
        if (this.canFlee) {
            JerotesEntity jerotes;
            boolean flee = this.mob.m_217066_(livingEntity);
            if (livingEntity instanceof JerotesEntity && (jerotes = (JerotesEntity)livingEntity).getAttackBoundingBox() != null) {
                flee = jerotes.getAttackBoundingBox().m_82406_(0.5).m_82381_(livingEntity.m_20191_());
            }
            if (!this.mob.isInFluidType() && !this.mob.m_20096_() || this.ticksJumpUse > 0 || this.mob.f_19789_ <= 0.0f) {
                flee = false;
            }
            if (flee) {
                float f1 = this.mob.m_146908_();
                float f2 = this.mob.m_146909_();
                float f3 = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
                float f5 = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
                float f7 = -0.08f;
                PathfinderMob pathfinderMob2 = this.mob;
                if (pathfinderMob2 instanceof JerotesEntity) {
                    JerotesEntity jerotes2 = (JerotesEntity)pathfinderMob2;
                    jerotes2.setSprintingCooldown(10);
                }
                if (this.mob.m_20184_().f_82479_ <= 0.25 && this.mob.m_20184_().f_82481_ <= 0.25) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_((double)(f3 *= f7 / f6), 0.0, (double)(f5 *= f7 / f6)));
                }
            }
        }
        if (this.canJump && this.canJump((Mob)this.mob, true) && this.mob.m_20096_() && this.mob.m_20142_()) {
            JerotesEntity jerotes;
            boolean jump;
            boolean bl = jump = !this.mob.m_20191_().m_82400_(6.0).m_82381_(livingEntity.m_20191_());
            if (livingEntity instanceof JerotesEntity && (jerotes = (JerotesEntity)livingEntity).getAttackBoundingBox() != null) {
                boolean bl2 = jump = !jerotes.getAttackBoundingBox().m_82400_(3.0).m_82381_(livingEntity.m_20191_());
            }
            if (this.ticksUntilNextJump <= 0 && jump) {
                this.mob.m_21391_((Entity)livingEntity, 360.0f, 360.0f);
                this.mob.m_21563_().m_24960_((Entity)livingEntity, 360.0f, 360.0f);
                PathfinderMob f2 = this.mob;
                if (f2 instanceof JerotesPlayerBaseEntity) {
                    JerotesPlayerBaseEntity jerotesPlayerEntity = (JerotesPlayerBaseEntity)f2;
                    jerotesPlayerEntity.playerJump();
                } else {
                    Vec3 vec3 = this.mob.m_20184_();
                    this.mob.m_20334_(vec3.f_82479_, (double)(0.42f * this.getBlockJumpFactor((LivingEntity)this.mob) + this.getJumpBoostPower((LivingEntity)this.mob)), vec3.f_82481_);
                    float f = this.mob.m_146908_() * ((float)Math.PI / 180);
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f) * 0.2f)));
                    this.mob.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this.mob);
                }
                this.ticksUntilNextJump = this.m_183277_((int)((double)this.jumpCooldownTick * 1.25));
                this.ticksJumpUse = this.m_183277_(this.jumpTick);
            }
        }
    }

    public float getBlockJumpFactor(LivingEntity livingEntity) {
        float f = livingEntity.m_9236_().m_8055_(livingEntity.m_20183_()).m_60734_().m_49964_();
        float f1 = livingEntity.m_9236_().m_8055_(this.getOnPos(livingEntity, 0.500001f)).m_60734_().m_49964_();
        return (double)f == 1.0 ? f1 : f;
    }

    protected BlockPos getOnPos(LivingEntity livingEntity, float p_216987_) {
        if (livingEntity.f_285638_.isPresent()) {
            BlockPos blockpos = (BlockPos)livingEntity.f_285638_.get();
            if (!(p_216987_ > 1.0E-5f)) {
                return blockpos;
            }
            BlockState blockstate = livingEntity.m_9236_().m_8055_(blockpos);
            return (double)p_216987_ <= 0.5 && blockstate.collisionExtendsVertically((BlockGetter)livingEntity.m_9236_(), blockpos, (Entity)livingEntity) ? blockpos : blockpos.m_175288_(Mth.m_14107_((double)(livingEntity.m_20182_().f_82480_ - (double)p_216987_)));
        }
        int i = Mth.m_14107_((double)livingEntity.m_20182_().f_82479_);
        int j = Mth.m_14107_((double)(livingEntity.m_20182_().f_82480_ - (double)p_216987_));
        int k = Mth.m_14107_((double)livingEntity.m_20182_().f_82481_);
        return new BlockPos(i, j, k);
    }

    public float getJumpBoostPower(LivingEntity livingEntity) {
        return livingEntity.m_21023_(MobEffects.f_19603_) ? 0.1f * ((float)livingEntity.m_21124_(MobEffects.f_19603_).m_19564_() + 1.0f) : 0.0f;
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity) {
        if (this.canJump && this.canJump((Mob)this.mob) && this.ticksUntilNextAttack <= 5 && this.ticksUntilNextJump <= 0 && this.mob.m_217066_(livingEntity) && this.mob.m_21574_().m_148306_((Entity)livingEntity)) {
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof JerotesPlayerBaseEntity) {
                JerotesPlayerBaseEntity jerotesPlayerEntity = (JerotesPlayerBaseEntity)pathfinderMob;
                jerotesPlayerEntity.playerJump();
            } else {
                Vec3 vec3 = this.mob.m_20184_();
                this.mob.m_20334_(vec3.f_82479_, (double)(0.42f * this.getBlockJumpFactor((LivingEntity)this.mob) + this.getJumpBoostPower((LivingEntity)this.mob)), vec3.f_82481_);
                if (this.mob.m_20142_()) {
                    float f = this.mob.m_146908_() * ((float)Math.PI / 180);
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f) * 0.2f)));
                }
                this.mob.f_19812_ = true;
                ForgeHooks.onLivingJump((LivingEntity)this.mob);
            }
            this.mob.m_21391_((Entity)livingEntity, 360.0f, 360.0f);
            this.ticksUntilNextJump = this.m_183277_(this.jumpCooldownTick * this.mob.m_217043_().m_188503_(this.jumpCooldownRandomTick));
            this.ticksJumpUse = this.m_183277_(this.jumpTick);
            return;
        }
        if (this.canPerformAttack(livingEntity)) {
            PathfinderMob pathfinderMob;
            this.resetAttackCooldown();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)livingEntity);
            if (this.ticksJumpUse > 0) {
                this.ticksJumpUse = 0;
            }
            if ((pathfinderMob = this.mob) instanceof JerotesEntity) {
                JerotesEntity jerotes = (JerotesEntity)pathfinderMob;
                jerotes.setCanNotAttackTargetTick(0);
            }
        }
    }

    protected void resetAttackCooldown() {
        int n;
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof JerotesPlayerBaseEntity) {
            JerotesPlayerBaseEntity jerotesPlayerEntity = (JerotesPlayerBaseEntity)pathfinderMob;
            n = jerotesPlayerEntity.getAttackSpeed();
        } else {
            n = 20;
        }
        this.ticksUntilNextAttack = this.m_183277_(n);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity livingEntity) {
        if (!this.mob.isInFluidType() && !this.mob.m_20096_() && this.ticksJumpUse > 0 && this.mob.f_19789_ <= 0.0f) {
            return false;
        }
        return this.isTimeToAttack() && this.mob.m_217066_(livingEntity) && this.mob.m_21574_().m_148306_((Entity)livingEntity);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }
}

