/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.goal;

import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.init.JerotesEnchantments;
import com.jerotes.jerotes.item.tool.ItemToolBasePike;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class JerotesPikeUseGoal
extends Goal {
    public final PathfinderMob mob;
    public final double speedModifier;
    public final boolean followingTargetEvenIfNotSeen;
    public Path path;
    public double pathedTargetX;
    public double pathedTargetY;
    public double pathedTargetZ;
    public int ticksUntilNextPathRecalculation;
    public int ticksUntilNextAttack;
    public final int attackInterval = 20;
    public long lastCanUseCheck;
    public static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    public int ticksUntilNextUse;

    public JerotesPikeUseGoal(PathfinderMob pathfinderMob, double d, boolean bl) {
        this.mob = pathfinderMob;
        this.speedModifier = d;
        this.followingTargetEvenIfNotSeen = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean ableToAttack() {
        return InventoryEntity.isPike(this.mob.m_21205_());
    }

    public boolean m_8036_() {
        if (!this.ableToAttack()) {
            return false;
        }
        long l = this.mob.m_9236_().m_46467_();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.mob.m_217066_(livingEntity);
    }

    public boolean m_8045_() {
        if (!this.ableToAttack()) {
            return false;
        }
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingEntity.m_20183_())) {
            return false;
        }
        return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.ticksUntilNextUse = 0;
    }

    public void m_8041_() {
        InventoryEntity inventoryEntity;
        PathfinderMob pathfinderMob;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null || !((pathfinderMob = this.mob) instanceof InventoryEntity) || !(inventoryEntity = (InventoryEntity)pathfinderMob).isCanChangeMeleeOrRange()) {
            if (!EntitySelector.f_20406_.test(livingEntity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
        }
        this.mob.m_21573_().m_26573_();
        this.mob.m_5810_();
    }

    public void m_8037_() {
        block15: {
            ItemToolBasePike itemToolBasePike;
            LivingEntity livingEntity;
            block17: {
                block16: {
                    Mob mobs;
                    livingEntity = this.mob.m_5448_();
                    if (livingEntity == null) {
                        return;
                    }
                    this.ticksUntilNextUse = Math.max(this.ticksUntilNextUse - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                        this.pathedTargetX = livingEntity.m_20185_();
                        this.pathedTargetY = livingEntity.m_20186_();
                        this.pathedTargetZ = livingEntity.m_20189_();
                        this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                        double d = this.mob.m_20280_((Entity)livingEntity);
                        if (d > 1024.0) {
                            this.ticksUntilNextPathRecalculation += 10;
                        } else if (d > 256.0) {
                            this.ticksUntilNextPathRecalculation += 5;
                        }
                        if (!this.mob.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier)) {
                            this.ticksUntilNextPathRecalculation += 15;
                        }
                        this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                    }
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                    this.checkAndPerformAttack(livingEntity, this.mob.m_21205_());
                    Item item = this.mob.m_21205_().m_41720_();
                    if (!(item instanceof ItemToolBasePike)) break block15;
                    itemToolBasePike = (ItemToolBasePike)item;
                    if (livingEntity instanceof Mob && this.isWithinMeleeAttackRange((LivingEntity)(mobs = (Mob)livingEntity), (LivingEntity)this.mob)) break block16;
                    double d = this.mob.m_20270_((Entity)livingEntity);
                    double d2 = itemToolBasePike.effectiveMinRange((Entity)this.mob);
                    double d3 = this.ticksUntilNextAttack > 0 ? (double)1.65f : 1.2;
                    if (!(d < d2 * d3)) break block17;
                }
                if (this.mob.m_20096_()) {
                    float f1 = this.mob.m_146908_();
                    float f2 = this.mob.m_146909_();
                    float f3 = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                    float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
                    float f5 = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                    float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
                    float f7 = -0.135f;
                    PathfinderMob pathfinderMob = this.mob;
                    if (pathfinderMob instanceof JerotesEntity) {
                        JerotesEntity jerotes = (JerotesEntity)pathfinderMob;
                        jerotes.setSprintingCooldown(10);
                    }
                    if (this.mob.m_20184_().f_82479_ <= 0.3 && this.mob.m_20184_().f_82481_ <= 0.3) {
                        this.mob.m_20256_(this.mob.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), 0.0, (double)(f5 *= f7 / f6 * 2.0f)));
                    }
                }
            }
            if (this.mob.m_20270_((Entity)livingEntity) <= itemToolBasePike.effectiveMaxRange((Entity)this.mob) * 0.7f && this.ticksUntilNextUse <= 0) {
                boolean bl3;
                boolean bl1 = ItemToolBasePike.getHitEntitiesAlong((LivingEntity)this.mob, itemToolBasePike, itemToolBasePike.hitboxMargin, entity -> ItemToolBaseSpearBase.canHitEntity((Entity)this.mob, entity)).size() > 3;
                boolean bl2 = (double)this.mob.m_20270_((Entity)livingEntity) < (double)itemToolBasePike.effectiveMinRange((Entity)this.mob) * 1.5;
                boolean bl = bl3 = this.mob.m_217043_().m_188503_(20) == 1;
                if (bl1 || bl2 || bl3) {
                    this.mob.m_6672_(InteractionHand.MAIN_HAND);
                    this.ticksUntilNextUse = this.m_183277_(80);
                }
            }
            if (itemToolBasePike.getEnchantmentLevel(this.mob.m_21205_(), (Enchantment)JerotesEnchantments.LUNGE.get()) > 0 && (double)this.mob.m_20270_((Entity)livingEntity) > (double)itemToolBasePike.effectiveMaxRange((Entity)this.mob) * 1.5 && this.mob.m_217043_().m_188503_(30) == 1) {
                this.checkAndPerformAttackRush(livingEntity, this.mob.m_21205_());
            }
        }
    }

    public double getMeleeAttackRangeSqr(LivingEntity livingEntity, LivingEntity self) {
        return self.m_20205_() * 2.0f * self.m_20205_() * 2.0f + livingEntity.m_20205_();
    }

    public double getPerceivedTargetDistanceSquareForMeleeAttack(LivingEntity livingEntity, LivingEntity self) {
        return Math.max(self.m_20238_(this.getMeleeAttackReferencePosition(livingEntity)), self.m_20238_(livingEntity.m_20182_()));
    }

    protected Vec3 getMeleeAttackReferencePosition(LivingEntity livingEntity) {
        Entity entity = livingEntity.m_20202_();
        if (entity instanceof RiderShieldingMount) {
            RiderShieldingMount ridershieldingmount = (RiderShieldingMount)entity;
            return livingEntity.m_20182_().m_82520_(0.0, ridershieldingmount.m_262813_(), 0.0);
        }
        return livingEntity.m_20182_();
    }

    public boolean isWithinMeleeAttackRange(LivingEntity livingEntity, LivingEntity self) {
        double d0 = this.getPerceivedTargetDistanceSquareForMeleeAttack(livingEntity, self);
        return d0 <= this.getMeleeAttackRangeSqr(livingEntity, self) * (double)1.3f;
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity, ItemStack itemStack) {
        if (this.canPerformAttack(livingEntity, itemStack)) {
            this.resetAttackCooldown();
            this.mob.m_5810_();
            Item item = this.mob.m_21205_().m_41720_();
            if (item instanceof ItemToolBasePike) {
                ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
                itemToolBasePike.attack((LivingEntity)this.mob, EquipmentSlot.MAINHAND);
            } else {
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)livingEntity);
            }
            item = this.mob;
            if (item instanceof JerotesEntity) {
                JerotesEntity jerotes = (JerotesEntity)item;
                jerotes.setCanNotAttackTargetTick(0);
            }
        }
    }

    protected void checkAndPerformAttackRush(LivingEntity livingEntity, ItemStack itemStack) {
        if (this.canPerformAttackRush(livingEntity, itemStack)) {
            this.resetAttackCooldown();
            this.mob.m_5810_();
            Item item = this.mob.m_21205_().m_41720_();
            if (item instanceof ItemToolBasePike) {
                ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
                itemToolBasePike.attack((LivingEntity)this.mob, EquipmentSlot.MAINHAND);
            }
        }
    }

    protected void resetAttackCooldown() {
        Item item = this.mob.m_21205_().m_41720_();
        if (item instanceof ItemToolBasePike) {
            ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
            this.ticksUntilNextAttack = this.m_183277_(itemToolBasePike.swingTimes() * 2 * (this.mob.m_21206_().m_41619_() ? 1 : 2));
        } else {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity livingEntity, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ItemToolBasePike)) {
            return false;
        }
        ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
        if (ItemToolBasePike.getHitEntitiesAlong((LivingEntity)this.mob, itemToolBasePike, itemToolBasePike.hitboxMargin, entity -> {
            Mob mobs;
            return ItemToolBaseSpearBase.canHitEntity((Entity)this.mob, entity) && (entity == livingEntity || entity instanceof Mob && (mobs = (Mob)entity).m_5448_() == this.mob);
        }).isEmpty()) {
            return false;
        }
        return this.isTimeToAttack() && !this.mob.m_6117_();
    }

    protected boolean canPerformAttackRush(LivingEntity livingEntity, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ItemToolBasePike)) {
            return false;
        }
        ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
        return this.isTimeToAttack() && !this.mob.m_6117_();
    }
}

