/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.goal;

import com.jerotes.jerotes.entity.InventoryEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;

public class JerotesRangedBowAttackGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public JerotesRangedBowAttackGoal(T t, double d, int n, float f) {
        this.mob = t;
        this.speedModifier = d;
        this.attackIntervalMin = n;
        this.attackRadiusSqr = f * f;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int p_25798_) {
        this.attackIntervalMin = p_25798_;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && JerotesRangedBowAttackGoal.isHoldingBow(this.mob);
    }

    public static boolean isHoldingBow(Mob mob) {
        Item main = mob.m_21205_().m_41720_();
        Item off = mob.m_21206_().m_41720_();
        float reach = 8.0f;
        if (mob instanceof InventoryEntity) {
            InventoryEntity inventoryEntity = (InventoryEntity)mob;
            reach = inventoryEntity.meleeOrRangeDistance();
        }
        if (InventoryEntity.isMeleeWeapon(mob.m_21205_()) && mob.m_5448_() != null && mob.m_20270_((Entity)mob.m_5448_()) <= reach) {
            return false;
        }
        return main instanceof BowItem || off instanceof BowItem && (mob.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon(mob.m_21205_()));
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && JerotesRangedBowAttackGoal.isHoldingBow(this.mob);
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        InventoryEntity inventoryEntity;
        T t;
        super.m_8041_();
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null || !((t = this.mob) instanceof InventoryEntity) || !(inventoryEntity = (InventoryEntity)t).isCanChangeMeleeOrRange()) {
            this.mob.m_6710_(null);
            this.mob.m_21561_(false);
        } else {
            this.mob.m_21573_().m_26573_();
        }
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean flag1;
            if (!(this.mob.m_21211_().m_41720_() instanceof BowItem)) {
                this.mob.m_5810_();
            }
            double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                Entity entity = this.mob.m_275832_();
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                }
                this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            if (this.mob.m_6117_()) {
                int i;
                if (!flag && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (flag && (i = this.mob.m_21252_()) >= 20) {
                    this.mob.m_5810_();
                    ((RangedAttackMob)this.mob).m_6504_(livingentity, BowItem.m_40661_((int)i));
                    this.attackTime = this.attackIntervalMin;
                }
            }
            if (!(this.mob.m_6117_() && this.mob.m_21211_().m_41720_() instanceof BowItem || --this.attackTime > 0 || this.seeTime < -60)) {
                if (!(this.mob.m_21211_().m_41720_() instanceof BowItem)) {
                    this.mob.m_5810_();
                }
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
            }
        }
    }
}

