/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.goal;

import com.jerotes.jerotes.entity.BaseEntityAbout;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.init.JerotesEnchantments;
import com.jerotes.jerotes.item.tool.ItemToolBasePike;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;

public class JerotesSpearUseGoal<T extends PathfinderMob>
extends Goal {
    private final T mob;
    private final double speedModifierWhenCharging;
    private final double speedModifierWhenRepositioning;
    private final double attackRadiusSqr;
    private final double targetInRangeSqr;
    private static final double MAX_FLEEING_TIME = JerotesSpearUseGoal.m_186073_((int)100);
    private int engageTime = -1;
    private int fleeingTime = -1;
    @Nullable
    private Vec3 awayPos;
    private boolean done = false;
    private boolean canNormalAttack = true;
    public int ticksUntilNextAttack;

    public JerotesSpearUseGoal(T t, double d, double d2, float f, float f2) {
        this.mob = t;
        this.speedModifierWhenCharging = d;
        this.speedModifierWhenRepositioning = d2;
        this.attackRadiusSqr = f * f;
        this.targetInRangeSqr = f2 * f2;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public JerotesSpearUseGoal(T t, double d, double d2, float f, float f2, boolean bl) {
        this.mob = t;
        this.speedModifierWhenCharging = d;
        this.speedModifierWhenRepositioning = d2;
        this.attackRadiusSqr = f * f;
        this.targetInRangeSqr = f2 * f2;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.canNormalAttack = bl;
    }

    public boolean m_8036_() {
        return this.ableToAttack() && (!this.mob.m_6117_() || this.mob.m_21211_().m_41720_() instanceof ShieldItem);
    }

    private boolean ableToAttack() {
        return this.mob.m_5448_() != null && InventoryEntity.isSpear(this.mob.m_21205_());
    }

    private int getKineticWeaponUseDuration() {
        int n = 200;
        Item item = this.mob.m_21205_().m_41720_();
        if (item instanceof ItemToolBaseSpearBase) {
            ItemToolBaseSpearBase itemToolBaseSpearBase = (ItemToolBaseSpearBase)item;
            n = itemToolBaseSpearBase.computeDamageUseDuration();
        }
        return JerotesSpearUseGoal.m_186073_((int)n);
    }

    public boolean m_8045_() {
        return !this.done && this.ableToAttack();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21573_().m_26573_();
        this.mob.m_21561_(false);
        this.engageTime = -1;
        this.fleeingTime = -1;
        this.awayPos = null;
        this.done = false;
        this.mob.m_5810_();
    }

    public void m_8037_() {
        Item item;
        double d;
        ItemToolBaseSpearBase itemToolBaseSpearBase;
        Item item2;
        LivingEntity livingEntity = this.mob.m_5448_();
        double d2 = this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        boolean bl = this.mob.m_20159_();
        Entity entity = this.mob.m_20201_();
        float f = 1.0f;
        if (entity instanceof BaseEntityAbout) {
            BaseEntityAbout baseEntityAbout = (BaseEntityAbout)entity;
            f = baseEntityAbout.chargeSpeedModifierJerotes();
        }
        int n = this.mob.m_20159_() ? 2 : 0;
        this.mob.m_21391_((Entity)livingEntity, 30.0f, 30.0f);
        this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
        if (this.engageTime < 0) {
            if (d2 > this.attackRadiusSqr) {
                this.mob.m_21573_().m_5624_((Entity)livingEntity, (double)f * this.speedModifierWhenRepositioning);
                return;
            }
            this.engageTime = this.getKineticWeaponUseDuration();
            if (this.mob.m_21211_().m_41720_() instanceof ShieldItem) {
                this.mob.m_5810_();
            }
            this.mob.m_6672_(InteractionHand.MAIN_HAND);
            item2 = this.mob.m_21205_().m_41720_();
            if (item2 instanceof ItemToolBaseSpearBase) {
                itemToolBaseSpearBase = (ItemToolBaseSpearBase)item2;
                itemToolBaseSpearBase.makeSound((Entity)this.mob);
            }
        }
        if (this.engageTime > 0) {
            --this.engageTime;
            if (this.engageTime == 0) {
                this.mob.m_5810_();
                d = Math.sqrt(d2);
                this.awayPos = JerotesSpearUseGoal.getPosAway(this.mob, Math.max(0.0, (double)(9 + n) - d), Math.max(1.0, (double)(11 + n) - d), 7, livingEntity.m_20182_());
                this.fleeingTime = 1;
            }
        }
        if (this.fleeingTime > 0) {
            ++this.fleeingTime;
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            if (this.canNormalAttack && (item2 = this.mob.m_21205_().m_41720_()) instanceof ItemToolBaseSpearBase) {
                itemToolBaseSpearBase = (ItemToolBaseSpearBase)item2;
                this.checkAndPerformAttack(livingEntity, this.mob.m_21205_());
            }
            if ((double)this.fleeingTime > MAX_FLEEING_TIME) {
                this.done = true;
                return;
            }
        }
        if (this.awayPos != null) {
            this.mob.m_21573_().m_26519_(this.awayPos.f_82479_, this.awayPos.f_82480_, this.awayPos.f_82481_, (double)f * this.speedModifierWhenRepositioning);
            if (this.mob.m_21573_().m_26571_()) {
                if (this.fleeingTime > 0) {
                    this.done = true;
                    return;
                }
                this.awayPos = null;
            }
        } else {
            this.mob.m_21573_().m_5624_((Entity)livingEntity, (double)f * this.speedModifierWhenCharging);
            if (d2 < this.targetInRangeSqr || this.mob.m_21573_().m_26571_()) {
                d = Math.sqrt(d2);
                this.awayPos = JerotesSpearUseGoal.getPosAway(this.mob, (double)(6 + n) - d, (double)(7 + n) - d, 7, livingEntity.m_20182_());
            }
        }
        if ((item = this.mob.m_21205_().m_41720_()) instanceof ItemToolBasePike) {
            ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
            if (this.canNormalAttack && itemToolBasePike.getEnchantmentLevel(this.mob.m_21205_(), (Enchantment)JerotesEnchantments.LUNGE.get()) > 0 && (double)this.mob.m_20270_((Entity)livingEntity) > (double)itemToolBasePike.effectiveMaxRange((Entity)this.mob) * 1.5 && this.mob.m_217043_().m_188503_(30) == 1) {
                this.checkAndPerformAttackRush(livingEntity, this.mob.m_21205_());
            }
        }
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity, ItemStack itemStack) {
        if (this.canPerformAttack(livingEntity, itemStack)) {
            this.resetAttackCooldown();
            this.mob.m_5810_();
            Object object = this.mob.m_21205_().m_41720_();
            if (object instanceof ItemToolBaseSpearBase) {
                ItemToolBaseSpearBase itemToolBaseSpearBase = (ItemToolBaseSpearBase)object;
                itemToolBaseSpearBase.attack((LivingEntity)this.mob, EquipmentSlot.MAINHAND);
            } else {
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)livingEntity);
            }
            object = this.mob;
            if (object instanceof JerotesEntity) {
                JerotesEntity jerotes = (JerotesEntity)object;
                jerotes.setCanNotAttackTargetTick(0);
            }
        }
    }

    protected void checkAndPerformAttackRush(LivingEntity livingEntity, ItemStack itemStack) {
        if (this.canPerformAttackRush(livingEntity, itemStack)) {
            this.resetAttackCooldown();
            this.mob.m_5810_();
            Item item = this.mob.m_21205_().m_41720_();
            if (item instanceof ItemToolBasePike) {
                ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
                itemToolBasePike.attack((LivingEntity)this.mob, EquipmentSlot.MAINHAND);
            }
        }
    }

    protected void resetAttackCooldown() {
        Item item = this.mob.m_21205_().m_41720_();
        if (item instanceof ItemToolBaseSpearBase) {
            ItemToolBaseSpearBase itemToolBaseSpearBase = (ItemToolBaseSpearBase)item;
            this.ticksUntilNextAttack = this.m_183277_((int)(itemToolBaseSpearBase.swingTimes * 20.0f));
        } else {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity livingEntity, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ItemToolBaseSpearBase)) {
            return false;
        }
        ItemToolBaseSpearBase itemToolBaseSpearBase = (ItemToolBaseSpearBase)item;
        if (ItemToolBaseSpearBase.getHitEntitiesAlong(this.mob, itemToolBaseSpearBase, itemToolBaseSpearBase.hitboxMargin, entity -> ItemToolBaseSpearBase.canHitEntity(this.mob, entity) && entity == livingEntity).isEmpty()) {
            return false;
        }
        return this.isTimeToAttack() && this.mob.m_21574_().m_148306_((Entity)livingEntity) && !this.mob.m_6117_();
    }

    protected boolean canPerformAttackRush(LivingEntity livingEntity, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ItemToolBasePike)) {
            return false;
        }
        ItemToolBasePike itemToolBasePike = (ItemToolBasePike)item;
        return this.isTimeToAttack() && !this.mob.m_6117_();
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }

    @Nullable
    public static Vec3 getPosAway(PathfinderMob pathfinderMob, int n, int n2, Vec3 vec3) {
        return JerotesSpearUseGoal.getPosAway(pathfinderMob, 0.0, n, n2, vec3);
    }

    @Nullable
    public static Vec3 getPosAway(PathfinderMob pathfinderMob, double d, double d2, int n, Vec3 vec3) {
        Vec3 vec32 = pathfinderMob.m_20182_().m_82546_(vec3);
        boolean bl = GoalUtils.m_148442_((PathfinderMob)pathfinderMob, (int)((int)d2));
        return JerotesSpearUseGoal.getPosInDirection(pathfinderMob, d, d2, n, vec32, bl);
    }

    @Nullable
    private static Vec3 getPosInDirection(PathfinderMob pathfinderMob, double d, double d2, int n, Vec3 vec3, boolean bl) {
        return RandomPos.m_148542_((PathfinderMob)pathfinderMob, () -> {
            BlockPos blockPos = JerotesSpearUseGoal.generateRandomDirectionWithinRadians(pathfinderMob.m_217043_(), d, d2, n, 0, vec3.f_82479_, vec3.f_82481_, 1.5707963705062866);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = JerotesSpearUseGoal.generateRandomPosTowardDirection(pathfinderMob, d2, bl, blockPos);
            if (blockPos2 == null) {
                return null;
            }
            return LandRandomPos.m_148518_((PathfinderMob)pathfinderMob, (BlockPos)blockPos2);
        });
    }

    @Nullable
    public static BlockPos generateRandomDirectionWithinRadians(RandomSource randomSource, double d, double d2, int n, int n2, double d3, double d4, double d5) {
        double d6 = Mth.m_14136_((double)d4, (double)d3) - 1.5707963705062866;
        double d7 = d6 + (double)(2.0f * randomSource.m_188501_() - 1.0f) * d5;
        double d8 = Mth.m_14139_((double)Math.sqrt(randomSource.m_188500_()), (double)d, (double)d2) * (double)Mth.f_13994_;
        double d9 = -d8 * Math.sin(d7);
        double d10 = d8 * Math.cos(d7);
        if (Math.abs(d9) > d2 || Math.abs(d10) > d2) {
            return null;
        }
        int n3 = randomSource.m_188503_(2 * n + 1) - n + n2;
        return BlockPos.m_274561_((double)d9, (double)n3, (double)d10);
    }

    @Nullable
    public static BlockPos generateRandomPosTowardDirection(PathfinderMob pathfinderMob, double d, boolean bl, BlockPos blockPos) {
        BlockPos blockPos2 = JerotesSpearUseGoal.generateRandomPosTowardDirection(pathfinderMob, d, pathfinderMob.m_217043_(), blockPos);
        if (GoalUtils.m_148451_((BlockPos)blockPos2, (PathfinderMob)pathfinderMob) || GoalUtils.m_148454_((boolean)bl, (PathfinderMob)pathfinderMob, (BlockPos)blockPos2) || GoalUtils.m_148448_((PathNavigation)pathfinderMob.m_21573_(), (BlockPos)blockPos2)) {
            return null;
        }
        return blockPos2;
    }

    public static BlockPos generateRandomPosTowardDirection(PathfinderMob pathfinderMob, double d, RandomSource randomSource, BlockPos blockPos) {
        double d2 = blockPos.m_123341_();
        double d3 = blockPos.m_123343_();
        if (pathfinderMob.m_21536_() && d > 1.0) {
            BlockPos blockPos2 = pathfinderMob.m_21534_();
            d2 = pathfinderMob.m_20185_() > (double)blockPos2.m_123341_() ? (d2 = d2 - randomSource.m_188500_() * d / 2.0) : (d2 = d2 + randomSource.m_188500_() * d / 2.0);
            d3 = pathfinderMob.m_20189_() > (double)blockPos2.m_123343_() ? (d3 = d3 - randomSource.m_188500_() * d / 2.0) : (d3 = d3 + randomSource.m_188500_() * d / 2.0);
        }
        return BlockPos.m_274561_((double)(d2 + pathfinderMob.m_20185_()), (double)((double)blockPos.m_123342_() + pathfinderMob.m_20186_()), (double)(d3 + pathfinderMob.m_20189_()));
    }
}

