/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.goal;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.util.Main;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class TaczGunAttackGoal<T extends Mob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private float attackRadius;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;
    private int updatePathDelay2;
    private double attackCount;
    private int ammoCount;

    public TaczGunAttackGoal(T t, double d, float f) {
        this.mob = t;
        this.speedModifier = d;
        this.attackRadius = f;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return TaczGunAttackGoal.isHoldingGun(this.mob) && (this.isValidTarget() || !this.hasAmmo() && this.canReload());
    }

    public static boolean isHoldingGun(Mob mob) {
        ItemStack main = mob.m_21205_();
        return !main.m_41619_() && IGun.getIGunOrNull((ItemStack)main) != null;
    }

    public boolean m_8045_() {
        return TaczGunAttackGoal.isHoldingGun(this.mob) && (this.isValidTarget() || !this.hasAmmo() && this.canReload());
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    private boolean canReload() {
        if (!MainConfig.MobUseOtherShrinkItem) {
            return true;
        }
        ItemStack handItem = this.mob.m_21205_();
        Item item = handItem.m_41720_();
        if (item instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)item;
            if (abstractGunItem.useDummyAmmo(handItem) && abstractGunItem.getDummyAmmoAmount(handItem) == 0) {
                handItem.m_41784_().m_128473_("DummyAmmo");
            }
            return abstractGunItem.canReload(this.mob, handItem);
        }
        return false;
    }

    private int getAmmoCount(ItemStack handItem) {
        GunData gunData;
        IGun iGun = IGun.getIGunOrNull((ItemStack)handItem);
        if (iGun != null && (gunData = (GunData)TimelessAPI.getCommonGunIndex((ResourceLocation)iGun.getGunId(handItem)).map(CommonGunIndex::getGunData).orElse(null)) != null) {
            return iGun.useInventoryAmmo(handItem) ? -1 : iGun.getCurrentAmmoCount(handItem) + (iGun.hasBulletInBarrel(handItem) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0);
        }
        return 0;
    }

    private boolean hasAmmo() {
        return this.getAmmoCount(this.mob.m_21120_(InteractionHand.MAIN_HAND)) != 0;
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
        this.crossbowState = CrossbowState.UNCHARGED;
        IGunOperator.fromLivingEntity(this.mob).draw(() -> this.mob.m_21205_());
        IGunOperator.fromLivingEntity(this.mob).getDataHolder().drawTimestamp = System.currentTimeMillis() - 10000L;
    }

    public void m_8041_() {
        InventoryEntity inventoryEntity;
        T t;
        super.m_8041_();
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null || !((t = this.mob) instanceof InventoryEntity) || !(inventoryEntity = (InventoryEntity)t).isCanChangeMeleeOrRange()) {
            this.mob.m_21561_(false);
            this.mob.m_6710_(null);
        } else {
            this.mob.m_21573_().m_26573_();
        }
        this.seeTime = 0;
        if (TaczGunAttackGoal.isHoldingGun(this.mob)) {
            AbstractGunItem abstractGunItem;
            GunData gunData;
            IGunOperator gunOperator = IGunOperator.fromLivingEntity(this.mob);
            gunOperator.cancelReload();
            gunOperator.aim(false);
            IGun iGun = IGun.getIGunOrNull((ItemStack)this.mob.m_21205_());
            if (iGun instanceof AbstractGunItem && (gunData = (GunData)TimelessAPI.getCommonGunIndex((ResourceLocation)(abstractGunItem = (AbstractGunItem)iGun).getGunId(this.mob.m_21205_())).map(CommonGunIndex::getGunData).orElse(null)) != null && gunData.getBolt() == Bolt.MANUAL_ACTION) {
                gunOperator.bolt();
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        block28: {
            GunData gunData;
            IGunOperator gunOperator;
            AbstractGunItem abstractGunItem;
            LivingEntity livingEntity;
            ItemStack handItem;
            block30: {
                block29: {
                    Item retreatPos;
                    handItem = this.mob.m_21205_();
                    livingEntity = this.mob.m_5448_();
                    if (livingEntity == null) {
                        return;
                    }
                    boolean addReach = false;
                    float allReach = Math.max(0.0f, this.attackRadius + (float)addReach);
                    boolean bl3 = this.mob.m_21574_().m_148306_((Entity)livingEntity);
                    boolean bl = this.seeTime > 0;
                    boolean bl4 = bl;
                    if (bl3 != bl) {
                        this.seeTime = 0;
                    }
                    this.seeTime = bl3 ? (this.seeTime = this.seeTime + 1) : (this.seeTime = this.seeTime - 1);
                    double d = this.mob.m_20270_((Entity)livingEntity);
                    boolean bl2 = (d > (double)allReach || this.seeTime < 5) && this.attackDelay == 0;
                    boolean bl5 = bl2;
                    float minDistance = this.crossbowState == CrossbowState.CHARGING ? 8.0f : 3.0f;
                    float currentDistance = this.mob.m_20270_((Entity)livingEntity);
                    if (this.updatePathDelay > 0) {
                        --this.updatePathDelay;
                    }
                    if (this.updatePathDelay2 > 0) {
                        --this.updatePathDelay2;
                    }
                    if (bl2) {
                        if (this.updatePathDelay <= 0 && this.updatePathDelay2 <= 0) {
                            this.mob.m_21573_().m_5624_((Entity)livingEntity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                            this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                        }
                    } else {
                        if (currentDistance >= minDistance && this.updatePathDelay2 <= 0) {
                            this.updatePathDelay = 0;
                            this.mob.m_21573_().m_26573_();
                        }
                        if (currentDistance < minDistance && this.updatePathDelay2 <= 0) {
                            Vec3 awayFromTarget = this.mob.m_20182_().m_82546_(livingEntity.m_20182_()).m_82541_().m_82490_(8.0);
                            retreatPos = this.mob.m_20182_().m_82549_(awayFromTarget);
                            this.mob.m_21573_().m_26519_(retreatPos.f_82479_, retreatPos.f_82480_, retreatPos.f_82481_, this.speedModifier * 1.3);
                            this.updatePathDelay = 40;
                            this.updatePathDelay2 = 40;
                        }
                    }
                    if (this.crossbowState != CrossbowState.CHARGING && (this.updatePathDelay2 <= 0 || ((Mob)this.mob).f_20916_ > 0)) {
                        this.mob.m_21563_().m_24960_((Entity)livingEntity, 360.0f, 360.0f);
                        this.mob.m_21391_((Entity)livingEntity, 360.0f, 360.0f);
                    }
                    if (!TaczGunAttackGoal.isHoldingGun(this.mob) || !((retreatPos = this.mob.m_21205_().m_41720_()) instanceof AbstractGunItem)) break block28;
                    abstractGunItem = (AbstractGunItem)retreatPos;
                    gunOperator = IGunOperator.fromLivingEntity(this.mob);
                    if (this.isValidTarget() && this.canMeleeAttack(gunOperator, livingEntity)) {
                        gunOperator.melee();
                        return;
                    }
                    if (abstractGunItem.isOverheatLocked(handItem)) {
                        this.crossbowState = CrossbowState.UNCHARGED;
                        return;
                    }
                    if (this.crossbowState == CrossbowState.UNCHARGED && this.hasAmmo()) {
                        this.crossbowState = CrossbowState.CHARGED;
                        this.ammoCount = this.getAmmoCount(handItem);
                    } else if (this.crossbowState == CrossbowState.CHARGED && !this.hasAmmo()) {
                        this.crossbowState = CrossbowState.UNCHARGED;
                    }
                    if (this.crossbowState != CrossbowState.UNCHARGED) break block29;
                    if (!bl2 && this.canReload()) {
                        gunOperator.reload();
                        this.crossbowState = CrossbowState.CHARGING;
                    }
                    break block28;
                }
                if (this.crossbowState != CrossbowState.CHARGING) break block30;
                if (!TaczGunAttackGoal.isHoldingGun(this.mob)) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if (gunOperator.getDataHolder().reloadStateType.isReloading()) break block28;
                if (this.hasAmmo()) {
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 10 + this.mob.m_217043_().m_188503_(20);
                    this.ammoCount = this.getAmmoCount(handItem);
                } else {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                T t = this.mob;
                if (!(t instanceof CrossbowAttackMob)) break block28;
                CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)t;
                crossbowAttackMob.m_6136_(false);
                break block28;
            }
            if (this.crossbowState == CrossbowState.CHARGED) {
                if (--this.attackDelay <= 0) {
                    gunOperator.aim(true);
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                    this.attackDelay = 0;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && Main.canSeeAngle(this.mob, livingEntity.m_146892_(), 40.0) && this.mob.m_20270_((Entity)livingEntity) < this.attackRadius * 2.0f && (gunData = (GunData)TimelessAPI.getCommonGunIndex((ResourceLocation)abstractGunItem.getGunId(handItem)).map(CommonGunIndex::getGunData).orElse(null)) != null) {
                this.attackCount += abstractGunItem.getFireMode(handItem) == FireMode.AUTO ? (double)abstractGunItem.getRPM(handItem) / 1200.0 : (double)abstractGunItem.getRPM(handItem) / Math.max(1200.0 * (double)(livingEntity.m_20270_(this.mob) / 8.0f), 2400.0);
                while (this.attackCount >= 1.0) {
                    if (TaczGunAttackGoal.isHoldingGun(this.mob)) {
                        gunOperator.shoot(() -> this.mob.m_146909_(), () -> this.mob.m_6080_());
                        if (gunData.getBolt() == Bolt.MANUAL_ACTION) {
                            gunOperator.bolt();
                        }
                        if (this.ammoCount > 0) {
                            --this.ammoCount;
                        }
                        if (this.ammoCount == 0) {
                            gunOperator.aim(false);
                            this.attackCount = 0.0;
                            this.crossbowState = CrossbowState.UNCHARGED;
                            break;
                        }
                    }
                    this.attackCount -= 1.0;
                }
            }
        }
    }

    private boolean canRun() {
        return this.crossbowState != CrossbowState.CHARGING;
    }

    public boolean canMeleeAttack(IGunOperator gunOperator, LivingEntity target) {
        return System.currentTimeMillis() - gunOperator.getDataHolder().meleeTimestamp > 3000L && this.isValidTarget() && this.getAttackReachSqr(target) >= this.mob.m_20280_((Entity)target);
    }

    public double getAttackReachSqr(LivingEntity target) {
        return (double)this.mob.m_20205_() * 2.0 * (double)this.mob.m_20205_() * 2.0 + (double)target.m_20205_();
    }

    static final class CrossbowState {
        public static final CrossbowState UNCHARGED = new CrossbowState();
        public static final CrossbowState CHARGING = new CrossbowState();
        public static final CrossbowState CHARGED = new CrossbowState();
        public static final CrossbowState READY_TO_ATTACK = new CrossbowState();
        private static final CrossbowState[] $VALUES = CrossbowState.$values();

        CrossbowState() {
        }

        public static CrossbowState[] values() {
            return (CrossbowState[])$VALUES.clone();
        }

        private static CrossbowState[] $values() {
            return new CrossbowState[]{UNCHARGED, CHARGING, CHARGED, READY_TO_ATTACK};
        }
    }
}

