/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jerotes.jerotes.client.animation.SpearAnimations;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.JerotesPlayerBaseEntity;
import com.jerotes.jerotes.entity.Mob.TestEntity;
import com.jerotes.jerotes.entity.ServerPlayerEntity;
import com.jerotes.jerotes.entity.UseSpearSpecialEntity;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.item.ItemSpecialAttack;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.item.MeleeItem;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Ease;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;

public class ItemToolBasePike
extends Item
implements MeleeItem,
ItemSpecialEffect,
Vanishable,
ItemSpecialAttack,
ItemTwoHanded {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    protected static final UUID BASE_ENTITY_REACH_UUID = UUID.fromString("c0b279fb-83be-442f-b062-c577d26065d3");
    protected static final UUID BASE_BLOCK_REACH_UUID = UUID.fromString("2ab44e2a-0eb7-4825-8a10-88709f6e2219");
    public final float selfSpeedDamage;
    public final float targetSpeedDamage;
    public final float specialDamageBase;
    public final float swingTimes;
    public final SoundEvent sound;
    public final SoundEvent hitSound;
    public final SoundEvent sound2;
    public final float minRange;
    public final float maxRange;
    public final float minCreativeRange;
    public final float maxCreativeRange;
    public final float hitboxMargin;
    public final float mobFactor;

    public ItemToolBasePike(Item.Properties properties, float swingTimes, float f, float f2, float specialDamageBase, float selfSpeedDamage, float targetSpeedDamage, float reach, SoundEvent sound, SoundEvent hitSound, SoundEvent sound2, float minRange, float maxRange, float minCreativeRange, float maxCreativeRange, float hitboxMargin, float mobFactor) {
        super(properties);
        this.selfSpeedDamage = selfSpeedDamage;
        this.targetSpeedDamage = targetSpeedDamage;
        this.specialDamageBase = specialDamageBase;
        this.swingTimes = swingTimes;
        this.sound = sound;
        this.hitSound = hitSound;
        this.sound2 = sound2;
        this.minRange = minRange;
        this.maxRange = maxRange - reach;
        this.minCreativeRange = minCreativeRange;
        this.maxCreativeRange = maxCreativeRange - reach;
        this.hitboxMargin = hitboxMargin;
        this.mobFactor = mobFactor;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(f - 1.0f), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)(f2 - 4.0f), AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ENTITY_REACH_UUID, "Tool modifier", (double)reach, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(BASE_BLOCK_REACH_UUID, "Tool modifier", (double)reach, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @Override
    public int getBlockReduction() {
        return 50;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeSound(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity.m_9236_().m_6263_(player, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound, entity.m_5720_(), 1.0f, 1.0f);
        } else {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound, entity.m_5720_(), 1.0f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeSound2(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity.m_9236_().m_6263_(player, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound2, entity.m_5720_(), 1.0f, 1.0f);
        } else {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound2, entity.m_5720_(), 1.0f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeHitSound(Entity entity) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.hitSound, entity.m_5720_(), 1.0f, 1.0f);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return this.defaultModifiers;
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237110_((String)"item.jerotes.pike", (Object[])new Object[]{Float.valueOf(this.selfSpeedDamage), Float.valueOf(this.targetSpeedDamage), Float.valueOf(this.specialDamageBase)}).m_130940_(ChatFormatting.YELLOW));
        list.add((Component)Component.m_237115_((String)"item.jerotes.two_handed_pike").m_130940_(ChatFormatting.YELLOW));
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int count) {
        if (livingEntity.m_21252_() == count) {
            livingEntity.m_5810_();
            this.m_5551_(itemStack, level, livingEntity, count);
        }
        if (livingEntity.m_21252_() == 10) {
            this.specialAttack(livingEntity.m_9236_(), livingEntity);
            if ((livingEntity instanceof JerotesEntity && JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && livingEntity.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK) || livingEntity instanceof Player) && itemStack.m_41763_()) {
                itemStack.m_41622_(1, livingEntity, e -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_36335_().m_41524_((Item)this, 40);
            }
        }
        super.m_5929_(level, livingEntity, itemStack, count);
    }

    public void specialAttack(Level level, LivingEntity livingEntity) {
        this.makeSound2((Entity)livingEntity);
        Level level2 = livingEntity.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            List list = serverLevel.m_45976_(LivingEntity.class, livingEntity.m_20191_().m_82400_((double)(this.effectiveMaxRange((Entity)livingEntity) * 2.0f)));
            for (LivingEntity hurt : list) {
                if (hurt == null || hurt.m_20270_((Entity)livingEntity) > this.effectiveMaxRange((Entity)livingEntity) * 0.7f || !hurt.m_6084_() || AttackFind.FindCanNotAttack(livingEntity, (Entity)hurt) || !Main.canSeeAngle((Entity)livingEntity, hurt.m_146892_(), 80.0) || !hurt.m_142582_((Entity)livingEntity)) continue;
                AttackFind.attackBegin(livingEntity, (Entity)hurt);
                ItemToolBasePike.causeExtraKnockback(livingEntity, (Entity)hurt, 1.0f, hurt.m_20184_());
                AttackFind.attackAfter(livingEntity, (Entity)hurt, this.specialDamageBase, 2.0f, false, 0.0f);
                if (EntityAndItemFind.isNoSpecialKnockback(hurt.m_6095_()) || !Main.mobSizeSmall((Entity)hurt) && !Main.mobSizeMedium((Entity)hurt) && !Main.mobSizeLarge((Entity)hurt)) continue;
                double d = 0.0;
                if (hurt.m_21051_(Attributes.f_22278_) != null) {
                    d = Math.max(livingEntity.m_21133_(Attributes.f_22278_), 1.0);
                }
                double d3 = Math.max(0.0, 1.0 - d) + (double)0.2f;
                float base = (0.15f + 1.0f / livingEntity.m_20270_((Entity)hurt) / 3.0f) * 0.25f;
                hurt.m_6853_(false);
                hurt.m_20256_(hurt.m_20184_().m_82520_(-(livingEntity.m_20185_() - hurt.m_20185_()) * d3 * (double)base, -(livingEntity.m_20186_() - hurt.m_20186_()) * d3 * (double)base + 0.125 * d3 * (double)base, -(livingEntity.m_20189_() - hurt.m_20189_()) * d3 * (double)base));
            }
            Vec3 lookDir = livingEntity.m_20154_().m_82541_();
            Vec3 entityPos = livingEntity.m_20182_().m_82549_(lookDir.m_82490_(0.35));
            double radius = 1.325;
            int particles = 80;
            double heightOffset = livingEntity.m_20227_(0.8) - livingEntity.m_20186_();
            float yaw = livingEntity.m_146908_();
            float pitch = livingEntity.m_146909_();
            for (int i = 0; i < particles; ++i) {
                double angle = Math.toRadians(-90.0 + (double)i * 180.0 / (double)particles);
                double zOffset = radius * Math.cos(angle);
                double xOffset = radius * Math.sin(angle);
                double cosYaw = Math.cos(Math.toRadians(yaw));
                double sinYaw = Math.sin(Math.toRadians(yaw));
                double rotatedX = xOffset * cosYaw - zOffset * sinYaw;
                double rotatedZ = xOffset * sinYaw + zOffset * cosYaw;
                double finalYOffset = heightOffset + Math.sin(Math.toRadians(-pitch)) * zOffset;
                Vec3 particlePos = entityPos.m_82520_(rotatedX, finalYOffset, rotatedZ);
                double speedX = rotatedX * 0.07 + (Math.random() * 0.02 - 0.01);
                double speedY = lookDir.f_82480_ * 0.07 + (Math.random() * 0.02 - 0.01);
                double speedZ = rotatedZ * 0.07 + (Math.random() * 0.02 - 0.01);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0, speedX, speedY, speedZ, 1.0);
            }
        }
    }

    public int m_8105_(ItemStack itemStack) {
        return 40;
    }

    @Override
    public void jerotesSpecialAttackClient(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36334_();
            ItemToolBaseSpearBase.jerotesLungeForwardMaybe((LivingEntity)player);
            this.makeSound((Entity)player);
        }
    }

    @Override
    public void jerotesSpecialAttack(LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        this.attack(livingEntity, equipmentSlot);
    }

    @Override
    public boolean jerotesSpecialAttackNeed(LivingEntity livingEntity) {
        Player player;
        return !(livingEntity instanceof Player && (player = (Player)livingEntity).m_36403_(5.0f) < 1.0f || !livingEntity.m_21206_().m_41619_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41720_() instanceof ItemToolBasePike && (enchantment == Enchantments.f_44981_ || enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44982_ || enchantment instanceof DamageEnchantment)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void attack(LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        float f = livingEntity.m_21051_(Attributes.f_22281_) != null ? (float)livingEntity.m_21133_(Attributes.f_22281_) : 0.0f;
        boolean bl = false;
        for (EntityHitResult entityHitResult : ItemToolBasePike.getHitEntitiesAlong(livingEntity, this, this.hitboxMargin, entity -> ItemToolBaseSpearBase.canHitEntity((Entity)livingEntity, entity))) {
            bl |= this.stabAttack(equipmentSlot, entityHitResult.m_82443_(), f, true, true, true, livingEntity);
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.m_36334_();
        }
        if (!(livingEntity instanceof Player) || !livingEntity.m_9236_().m_5776_()) {
            ItemToolBaseSpearBase.jerotesLungeForwardMaybe(livingEntity);
        }
        if (bl) {
            this.makeHitSound((Entity)livingEntity);
        }
        this.makeSound((Entity)livingEntity);
    }

    public static void animate(ModelPart p_102087_, ModelPart p_102088_, LivingEntity p_102089_, boolean p_102090_) {
        ModelPart $$4 = p_102090_ ? p_102087_ : p_102088_;
        ModelPart $$5 = p_102090_ ? p_102088_ : p_102087_;
        $$4.f_104204_ = p_102090_ ? -0.8f : 0.8f;
        $$5.f_104203_ = $$4.f_104203_ = -0.97079635f;
        float $$8 = 0.5f;
        $$5.f_104204_ = Mth.m_14179_((float)$$8, (float)0.4f, (float)0.85f) * (float)(p_102090_ ? 1 : -1);
        $$5.f_104203_ = Mth.m_14179_((float)$$8, (float)$$5.f_104203_, (float)-1.5707964f);
    }

    public static <T extends HumanoidModel<?>> void animateAttack(HumanoidModel<?> humanoidModel, T t, LivingEntity livingEntity) {
        float f = livingEntity.m_21324_(Minecraft.m_91087_().getPartialTick());
        float f2 = Ease.inOutSine(SpearAnimations.progress(f, 0.0f, 0.05f));
        float f3 = Ease.inQuad(SpearAnimations.progress(f, 0.05f, 0.2f));
        float f4 = Ease.inOutExpo(SpearAnimations.progress(f, 0.4f, 1.0f));
        HumanoidArm humanoidArms = livingEntity.m_5737_();
        HumanoidArm humanoidArm = livingEntity.f_20912_ == InteractionHand.MAIN_HAND ? humanoidArms : humanoidArms.m_20828_();
        humanoidModel.f_102811_.f_104204_ -= humanoidModel.f_102810_.f_104204_;
        humanoidModel.f_102812_.f_104204_ -= humanoidModel.f_102810_.f_104204_;
        SpearAnimations.getArm(humanoidModel, (HumanoidArm)humanoidArm).f_104203_ += (90.0f * f2 - 120.0f * f3 + 30.0f * f4) * ((float)Math.PI / 180);
        humanoidArms = livingEntity.m_5737_().m_20828_();
        humanoidArm = livingEntity.f_20912_ == InteractionHand.MAIN_HAND ? humanoidArms : humanoidArms.m_20828_();
        humanoidModel.f_102811_.f_104204_ -= humanoidModel.f_102810_.f_104204_;
        humanoidModel.f_102812_.f_104204_ -= humanoidModel.f_102810_.f_104204_;
        SpearAnimations.getArm(humanoidModel, (HumanoidArm)humanoidArm).f_104203_ += (90.0f * f2 - 120.0f * f3 + 30.0f * f4) * ((float)Math.PI / 180) * 0.2f;
    }

    public static void thirdPersonAttackItem(float f, PoseStack poseStack, LivingEntity livingEntity) {
        if (f <= 0.0f) {
            return;
        }
        if (f > 0.0f && (double)f <= 0.05) {
            float fs = f / 0.05f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(20.0f * fs));
        } else if ((double)f > 0.05 && (double)f <= 0.2) {
            float fs = (f - 0.05f) / 0.2f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(20.0f - 40.0f * fs));
        } else if ((double)f > 0.2 && (double)f <= 0.4) {
            float fs = 1.0f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(20.0f - 40.0f * fs));
        } else if ((double)f > 0.4) {
            float fs = 1.0f - (f - 0.4f) / 0.6f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-20.0f * fs));
        }
    }

    public boolean stabAttack(EquipmentSlot equipmentSlot, Entity entity, float f, boolean bl, boolean bl2, boolean bl3, LivingEntity self) {
        LivingEntity livingEntity;
        boolean bl5;
        Vec3 attackerVelocity = ItemToolBasePike.getMotion((Entity)self).m_82542_((double)this.selfSpeedDamage, (double)this.selfSpeedDamage, (double)this.selfSpeedDamage);
        Vec3 targetVelocity = ItemToolBasePike.getMotion(entity).m_82542_((double)this.targetSpeedDamage, (double)this.targetSpeedDamage, (double)this.targetSpeedDamage);
        Vec3 relativeVelocity = attackerVelocity.m_82546_(targetVelocity);
        double relativeSpeed = relativeVelocity.m_82553_();
        Vec3 attackDirection = self.m_20154_().m_82541_();
        double attackRelativeSpeed = relativeVelocity.m_82526_(attackDirection);
        Vec3 defenseDirection = attackDirection.m_82548_();
        double defenseRelativeSpeed = relativeVelocity.m_82526_(defenseDirection);
        if (!(self.m_9236_() instanceof ServerLevel)) {
            return false;
        }
        ItemStack equipment = self.m_6844_(equipmentSlot);
        DamageSource damageSource = new DamageSource((Holder)self.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(JerotesDamageTypes.SPEAR), (Entity)self);
        float f2 = f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            f2 += EnchantmentHelper.m_44833_((ItemStack)equipment, (MobType)livingEntity2.m_6336_());
        }
        double speedDamageMultiplier = Math.min(16.0, attackRelativeSpeed / 7.5);
        Vec3 vec3 = entity.m_20184_();
        boolean bl4 = bl2;
        boolean bl6 = bl5 = bl && entity.m_6469_(damageSource, f2 *= (float)(1.0 + speedDamageMultiplier * 0.5));
        if (bl5 && entity instanceof Player) {
            Player player = (Player)entity;
            if (self instanceof TestEntity) {
                TestEntity testEntity = (TestEntity)self;
                player.m_213846_((Component)Component.m_237113_((String)("Attack Base" + (float)(1.0 + speedDamageMultiplier * 0.5))).m_130940_(ChatFormatting.RED));
                player.m_213846_((Component)Component.m_237113_((String)("Attack Relative Speed" + attackRelativeSpeed)).m_130940_(ChatFormatting.RED));
                player.m_213846_((Component)Component.m_237113_((String)("Defense Relative Speed" + defenseRelativeSpeed)).m_130940_(ChatFormatting.RED));
                player.m_213846_((Component)Component.m_237113_((String)("Distance" + player.m_20270_((Entity)testEntity))).m_130940_(ChatFormatting.RED));
            }
        }
        if (bl5 && entity instanceof TestEntity) {
            TestEntity testEntity = (TestEntity)entity;
            if (self instanceof Player) {
                Player player = (Player)self;
                player.m_213846_((Component)Component.m_237113_((String)("Attack Base" + (float)(1.0 + speedDamageMultiplier * 0.5))).m_130940_(ChatFormatting.GREEN));
                player.m_213846_((Component)Component.m_237113_((String)("Attack Relative Speed" + attackRelativeSpeed)).m_130940_(ChatFormatting.GREEN));
                player.m_213846_((Component)Component.m_237113_((String)("Defense Relative Speed" + defenseRelativeSpeed)).m_130940_(ChatFormatting.GREEN));
                player.m_213846_((Component)Component.m_237113_((String)("Distance" + player.m_20270_((Entity)testEntity))).m_130940_(ChatFormatting.GREEN));
            }
        }
        bl4 |= bl5;
        Vec3 oldTarget = entity.m_20184_();
        Vec3 oldSelf = self.m_20184_();
        if (bl5) {
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)self);
            }
            EnchantmentHelper.m_44896_((LivingEntity)self, (Entity)entity);
            AttackFind.attackBegin(self, entity);
        }
        if (attackRelativeSpeed > 4.0) {
            entity.m_6858_(false);
            self.m_6858_(false);
            if (bl3 && entity.m_20159_() && entity.m_20202_() != null && (!(entity instanceof LivingEntity) || !AttackFind.SameFactionAvoidDamage((Entity)self, livingEntity = (LivingEntity)entity))) {
                bl4 = true;
                entity.m_20202_().m_6858_(false);
                entity.m_8127_();
            }
        }
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (self instanceof Player) {
                Player player = (Player)self;
                equipment.m_41640_(livingEntity, player);
            }
        }
        double targetSlowdown = Math.max(0.3, 0.6 - attackRelativeSpeed * 0.02);
        entity.m_20256_(entity.m_20184_().m_82542_(targetSlowdown, targetSlowdown, targetSlowdown));
        if (attackRelativeSpeed > 10.0 && entity instanceof LivingEntity) {
            LivingEntity livingEntity3 = (LivingEntity)entity;
            livingEntity3.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 0, false, false));
        }
        if (bl2) {
            float baseKnockback = 0.4f + this.getKnockback(self, entity, damageSource);
            float speedKnockback = (float)(attackRelativeSpeed * 0.1);
            float totalKnockback = Math.min(baseKnockback + speedKnockback, 2.0f);
            ItemToolBasePike.causeExtraKnockback(self, entity, totalKnockback, oldTarget);
        }
        if (attackRelativeSpeed > 0.0) {
            double recoil = defenseRelativeSpeed * 0.25;
            if (equipment.m_41763_() && (double)equipment.m_41773_() > (double)equipment.m_41776_() * 0.8) {
                recoil *= 1.5;
            }
            recoil = Math.min(recoil, 1.0);
            Vec3 recoilVector = defenseDirection.m_82490_(-recoil * 0.25);
            self.f_19864_ = true;
            self.m_6853_(false);
            self.m_20256_(self.m_20184_().m_82542_(1.0 - recoil, 1.0 - recoil, 1.0 - recoil).m_82549_(recoilVector).m_82542_(0.9, 0.3, 0.9));
        }
        if (oldTarget.m_82553_() > oldSelf.m_82553_() * 8.0) {
            double pushFactor = Math.min(0.15, (oldTarget.m_82553_() - oldSelf.m_82553_() * 8.0) * 0.01);
            self.f_19864_ = true;
            self.m_6853_(false);
            self.m_20256_(self.m_20184_().m_82549_(oldTarget.m_82541_().m_82490_(pushFactor)));
        }
        if (!bl4) {
            return false;
        }
        self.m_21335_(entity);
        if ((self instanceof JerotesEntity && JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && self.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK) || self instanceof Player) && equipment.m_41763_()) {
            int durabilityLoss = 1;
            if (attackRelativeSpeed > 10.0) {
                durabilityLoss = (int)attackRelativeSpeed;
            }
            equipment.m_41622_(durabilityLoss, self, e -> self.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public static Vec3 getKnownMovement(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
            return serverPlayer.jerotesGetKnownMovement();
        }
        LivingEntity livingEntity = entity.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (entity.m_6084_()) {
                return ItemToolBasePike.getKnownMovement((Entity)player);
            }
        }
        return entity.m_20184_();
    }

    public static Vec3 getMotion(Entity entity) {
        UseSpearSpecialEntity useSpearSpecialEntity;
        JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
        if (!(entity instanceof Player || entity instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)entity).usePikeAsPlayer() || entity instanceof UseSpearSpecialEntity && (useSpearSpecialEntity = (UseSpearSpecialEntity)entity).isGetMotionLikePlayer() || !entity.m_20159_())) {
            entity = entity.m_20201_();
        }
        Vec3 vec3 = ItemToolBasePike.getKnownMovement(entity).m_82490_(20.0);
        if (entity.m_20096_()) {
            vec3 = vec3.m_82542_(0.6, 0.0, 0.6);
        }
        double mass = 1.0;
        if (entity instanceof LivingEntity) {
            if (Main.mobSizeGiant(entity)) {
                mass = 4.0;
            }
            if (Main.mobSizeLarge(entity)) {
                mass = 2.0;
            }
            if (Main.mobSizeMedium(entity)) {
                mass = 1.0;
            }
            if (Main.mobSizeSmall(entity)) {
                mass = 0.2;
            }
            if (EntityAndItemFind.isNoSpecialKnockback(entity.m_6095_())) {
                mass = 5.0;
            }
        }
        return vec3.m_82490_(mass);
    }

    public static void causeExtraKnockback(LivingEntity self, Entity entity, float f, Vec3 vec3) {
        UseSpearSpecialEntity useSpearSpecialEntity;
        JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
        if (self instanceof Player || self instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)self).usePikeAsPlayer() || self instanceof UseSpearSpecialEntity && (useSpearSpecialEntity = (UseSpearSpecialEntity)self).isCauseExtraKnockbackPlayer()) {
            if (f > 0.0f) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_147240_((double)f, (double)Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180)))));
                    entity.m_5997_(0.0, 0.05, 0.0);
                } else {
                    entity.m_5997_((double)(-Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))) * f), 0.1, (double)(Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180))) * f));
                }
                self.m_20256_(self.m_20184_().m_82542_(0.8, 1.0, 0.8));
                self.m_6858_(false);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (entity.f_19864_) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
                    entity.f_19864_ = false;
                    entity.m_20256_(vec3);
                }
            }
        } else if (f > 0.0f && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_147240_((double)f, (double)Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180)))));
            self.m_20256_(self.m_20184_().m_82542_(0.6, 1.0, 0.6));
        }
    }

    protected float getKnockback(LivingEntity self, Entity entity, DamageSource damageSource) {
        float f = (float)self.m_21133_(Attributes.f_22282_) + 1.0f;
        Level level = self.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return self.m_21205_().getEnchantmentLevel(Enchantments.f_44980_);
        }
        return f;
    }

    public static Collection<EntityHitResult> getHitEntitiesAlong(LivingEntity livingEntity, ItemToolBasePike itemToolBasePike, float f3, Predicate<Entity> predicate) {
        Vec3 vec3 = ItemToolBaseSpearBase.getHeadLookAngle((Entity)livingEntity);
        Vec3 vec32 = livingEntity.m_146892_();
        Vec3 vec33 = vec32.m_82549_(vec3.m_82490_((double)itemToolBasePike.effectiveMinRange((Entity)livingEntity)));
        double d = ItemToolBaseSpearBase.getKnownMovement((Entity)livingEntity).m_82526_(vec3);
        Vec3 vec34 = vec32.m_82549_(vec3.m_82490_((double)itemToolBasePike.effectiveMaxRange((Entity)livingEntity) + Math.max(0.0, d)));
        return (Collection)ItemToolBasePike.getHitEntitiesAlong(vec33, (Entity)livingEntity, itemToolBasePike, predicate, vec34, f3, ClipContext.Block.COLLIDER, itemToolBasePike.maxRange / 2.0f).map(blockHitResult -> List.of(), collection -> collection);
    }

    public static Either<BlockHitResult, Collection<EntityHitResult>> getHitEntitiesAlong(Vec3 vec3, Entity entity, ItemToolBasePike itemToolBasePike, Predicate<Entity> predicate, Vec3 vec32, float f, ClipContext.Block block, float maxAdd) {
        AABB aABB;
        Collection<EntityHitResult> collection;
        Level level = entity.m_9236_();
        BlockHitResult blockHitResult = ItemToolBaseSpearBase.clipIncludingBorder(new ClipContext(vec3, vec32, block, ClipContext.Fluid.NONE, entity), level);
        if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
            vec32 = blockHitResult.m_82450_();
        }
        if (!(collection = ItemToolBasePike.getManyEntityHitResult(level, entity, itemToolBasePike, vec3, vec32, aABB = AABB.m_165882_((Vec3)vec3, (double)f, (double)f, (double)f).m_82369_(vec32.m_82546_(vec3)).m_82400_(1.0), predicate, f, maxAdd)).isEmpty()) {
            return Either.right(collection);
        }
        return Either.left((Object)blockHitResult);
    }

    public static Collection<EntityHitResult> getManyEntityHitResult(Level level, Entity entity, ItemToolBasePike itemToolBasePike, Vec3 vec32, Vec3 vec33, AABB aABB, Predicate<Entity> predicate, float f, float maxAdd) {
        ArrayList entities;
        ArrayList<EntityHitResult> arrayList = new ArrayList<EntityHitResult>();
        if (level == null || level.m_5776_() || entity == null || vec32 == null || vec33 == null) {
            return arrayList;
        }
        try {
            entities = new ArrayList(level.m_6249_(entity, aABB.m_82400_((double)maxAdd), predicate));
        }
        catch (Exception e) {
            return arrayList;
        }
        for (Entity entity2 : entities) {
            if (entity2 == null || entity2.m_213877_() || !entity2.m_6084_()) continue;
            try {
                Vec3 attackDirection;
                Vec3 targetVelocity;
                Vec3 attackerVelocity = ItemToolBasePike.getMotion(entity).m_82542_((double)itemToolBasePike.selfSpeedDamage, (double)itemToolBasePike.selfSpeedDamage, (double)itemToolBasePike.selfSpeedDamage);
                Vec3 relativeVelocity = attackerVelocity.m_82546_(targetVelocity = ItemToolBasePike.getMotion(entity2).m_82542_((double)itemToolBasePike.targetSpeedDamage, (double)itemToolBasePike.targetSpeedDamage, (double)itemToolBasePike.targetSpeedDamage));
                double attackRelativeSpeed = relativeVelocity.m_82526_(attackDirection = entity.m_20154_().m_82541_());
                boolean canAttack = level.m_6249_(entity, aABB.m_82400_(attackRelativeSpeed), predicate).contains(entity2);
                if (!canAttack) continue;
                AABB aABB2 = entity2.m_20191_().m_82400_((double)f);
                if (aABB2.m_82390_(vec32)) {
                    arrayList.add(new EntityHitResult(entity2, vec32));
                    continue;
                }
                Optional optional = aABB2.m_82371_(vec32, vec33);
                optional.ifPresent(vec3 -> arrayList.add(new EntityHitResult(entity2, vec3)));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public float effectiveMinRange(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_5833_()) {
                return 0.0f;
            }
            return player.m_7500_() ? this.minCreativeRange : this.minRange;
        }
        if (entity instanceof Mob) {
            JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
            Mob mob = (Mob)entity;
            if (entity instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)entity).usePikeAsPlayer()) {
                if (mob.m_5833_()) {
                    return 0.0f;
                }
                return jerotesPlayerBaseEntity.getAbilities() != null && jerotesPlayerBaseEntity.getAbilities().f_35937_ ? this.minCreativeRange : this.minRange;
            }
        }
        return this.minRange * this.mobFactor;
    }

    public float effectiveMaxRange(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return (player.m_7500_() ? this.maxCreativeRange : this.maxRange) + (player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()) != null ? (float)Math.max(0.0, player.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 3.0) : 0.0f);
        }
        if (entity instanceof Mob) {
            JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
            Mob mob = (Mob)entity;
            if (entity instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)entity).usePikeAsPlayer()) {
                return (jerotesPlayerBaseEntity.getAbilities() != null && jerotesPlayerBaseEntity.getAbilities().f_35937_ ? this.maxCreativeRange : this.maxRange) + (mob.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()) != null ? (float)Math.max(0.0, mob.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 3.0) : 0.0f);
            }
        }
        return this.maxRange * this.mobFactor + (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()) != null ? (float)Math.max(0.0, livingEntity.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 3.0) : 0.0f);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new PikeClient());
    }

    public static void firstPersonAttack(float f, PoseStack poseStack, int n, HumanoidArm humanoidArm) {
        if (f > 0.0f && (double)f <= 0.05) {
            float fs = f / 0.05f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-20.0f * fs));
            poseStack.m_252880_(0.0f, 0.0f, 6.0f * fs);
        } else if ((double)f > 0.05 && (double)f <= 0.15) {
            float fs = (f - 0.05f) / 0.1f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-20.0f + 40.0f * fs));
            poseStack.m_252880_(0.0f, 0.0f, 6.0f - 7.0f * fs);
        } else if ((double)f > 0.15 && (double)f <= 0.5) {
            float fs = (f - 0.15f) / 0.35f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(20.0f - 10.0f * fs));
            poseStack.m_85837_(0.0, 0.0, -1.0 + 0.25 * (double)fs);
        } else if ((double)f > 0.5) {
            float fs = 1.0f - (f - 0.5f) / 0.5f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f * fs));
            poseStack.m_85837_(0.0, 0.0, -0.75 * (double)fs);
        }
    }

    @Override
    public int swingTimes() {
        float f = 20.0f * this.swingTimes;
        return (int)f;
    }

    public static class PikeClient
    implements IClientItemExtensions {
        public static final HumanoidModel.ArmPose PIKE_POSE = HumanoidModel.ArmPose.create((String)"JEROTES_PIKE", (boolean)true, (model, entity, arm) -> {});

        public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack stack) {
            if (stack.m_41720_() instanceof ItemToolBaseSpearBase) {
                return PIKE_POSE;
            }
            return HumanoidModel.ArmPose.EMPTY;
        }

        private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProcess) {
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProcess * -0.6f), (double)-0.72f);
        }

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            int dir;
            int n = dir = arm == HumanoidArm.RIGHT ? 1 : -1;
            if (player.m_6117_() && player.m_7655_() == InteractionHand.MAIN_HAND) {
                this.applyItemArmTransform(poseStack, arm, 0.0f);
                float f = 1.0f - (float)Math.min(25, player.m_21252_()) / 25.0f;
                if (f > 0.0f && (double)f <= 0.4) {
                    float fs = f / 0.4f;
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-40.0f * fs * (float)dir));
                } else if ((double)f > 0.4 && (double)f <= 0.5) {
                    float fs = (f - 0.4f) / 0.1f;
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-40.0f * (float)dir + 80.0f * fs * (float)dir));
                } else if ((double)f > 0.5) {
                    float fs = 1.0f - (f - 0.5f) / 0.5f;
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(40.0f * (float)dir * fs * (float)dir));
                }
            } else {
                if (swingProcess > 0.0f && player.m_21206_().m_41619_()) {
                    this.applyItemArmTransform(poseStack, arm, 0.0f);
                    ItemToolBasePike.firstPersonAttack(swingProcess, poseStack, dir, arm);
                    return true;
                }
                this.applyItemArmTransform(poseStack, arm, equipProcess);
            }
            return true;
        }
    }
}

