/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jerotes.jerotes.client.animation.SpearAnimations;
import com.jerotes.jerotes.entity.JerotesChangeLivingEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.JerotesPlayerBaseEntity;
import com.jerotes.jerotes.entity.ServerPlayerEntity;
import com.jerotes.jerotes.entity.UseSpearSpecialEntity;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.init.JerotesEnchantments;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.ItemSpecialAttack;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.MeleeItem;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;

public class ItemToolBaseSpearBase
extends TieredItem
implements ItemSpecialEffect,
MeleeItem,
Vanishable,
ItemSpecialAttack {
    public final float swingTimes;
    public final float hitboxMargin;
    public final int contactCooldownTicks;
    public final int delayTicks;
    public final Optional<Condition> dismountConditions;
    public final Optional<Condition> knockbackConditions;
    public final Optional<Condition> damageConditions;
    public final float forwardMovement;
    public final float damageMultiplier;
    public final SoundEvent sound;
    public final SoundEvent hitSound;
    public final SoundEvent sound2;
    public final SoundEvent hitSound2;
    public final float minRange;
    public final float maxRange;
    public final float mobFactor;
    public final float minCreativeRange;
    public final float maxCreativeRange;
    public final float hitboxMargin2;
    public final boolean dealsKnockback;
    public final boolean dismounts;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ItemToolBaseSpearBase(Tier tier, Item.Properties properties, float damage, float speed, float swingTimes, float hitboxMargin, int contactCooldownTicks, int delayTicks, Optional<Condition> dismountConditions, Optional<Condition> knockbackConditions, Optional<Condition> damageConditions, float forwardMovement, float damageMultiplier, SoundEvent sound, SoundEvent hitSound, SoundEvent sound2, SoundEvent hitSound2, float minRange, float maxRange, float minCreativeRange, float maxCreativeRange, float hitboxMargin2, float mobFactor, boolean dealsKnockback, boolean dismounts) {
        super(tier, properties);
        this.swingTimes = swingTimes;
        this.hitboxMargin = hitboxMargin;
        this.contactCooldownTicks = contactCooldownTicks;
        this.delayTicks = delayTicks;
        this.dismountConditions = dismountConditions;
        this.knockbackConditions = knockbackConditions;
        this.damageConditions = damageConditions;
        this.forwardMovement = forwardMovement;
        this.damageMultiplier = damageMultiplier;
        this.sound = sound;
        this.hitSound = hitSound;
        this.sound2 = sound2;
        this.hitSound2 = hitSound2;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.minCreativeRange = minCreativeRange;
        this.maxCreativeRange = maxCreativeRange;
        this.hitboxMargin2 = hitboxMargin2;
        this.mobFactor = mobFactor;
        this.dealsKnockback = dealsKnockback;
        this.dismounts = dismounts;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(damage + tier.m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return this.defaultModifiers;
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        this.makeSound((Entity)player);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void onUseTickSpecial(Level level, LivingEntity livingEntity, ItemStack itemStack, int count) {
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public static Vec3 getKnownMovement(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
            return serverPlayer.jerotesGetKnownMovement();
        }
        LivingEntity livingEntity = entity.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (entity.m_6084_()) {
                return ItemToolBaseSpearBase.getKnownMovement((Entity)player);
            }
        }
        return entity.m_20184_();
    }

    public static Vec3 getMotion(Entity entity) {
        UseSpearSpecialEntity useSpearSpecialEntity;
        if (!(entity instanceof Player || entity instanceof UseSpearSpecialEntity && (useSpearSpecialEntity = (UseSpearSpecialEntity)entity).isGetMotionLikePlayer() || !entity.m_20159_())) {
            entity = entity.m_20201_();
        }
        Vec3 vec3 = ItemToolBaseSpearBase.getKnownMovement(entity).m_82490_(20.0);
        if (entity.m_20096_()) {
            return vec3.m_193103_(Direction.Axis.Y, 0.0);
        }
        return vec3;
    }

    public boolean m_6777_(BlockState p_43291_, Level p_43292_, BlockPos p_43293_, Player p_43294_) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeSound(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity.m_9236_().m_6263_(player, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound, entity.m_5720_(), 1.0f, 1.0f);
        } else {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound, entity.m_5720_(), 1.0f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeHitSound(Entity entity) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.hitSound, entity.m_5720_(), 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeSound2(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity.m_9236_().m_6263_(player, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound2, entity.m_5720_(), 1.0f, 1.0f);
        } else {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound2, entity.m_5720_(), 1.0f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeHitSound2(Entity entity) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.hitSound2, entity.m_5720_(), 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void makeLocalHitSound(Entity entity) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(this.hitSound, entity.m_5720_(), 1.0f, 1.0f, entity, RandomSource.m_216327_().m_188505_()));
    }

    public int computeDamageUseDuration() {
        return this.delayTicks + this.damageConditions.map(Condition::maxDurationTicks).orElse(0);
    }

    public void damageEntities(ItemStack itemStack, int n, LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
        int n2 = itemStack.m_41779_() - n;
        if (n2 < this.delayTicks) {
            return;
        }
        n2 -= this.delayTicks;
        Vec3 vec3 = livingEntity.m_20154_();
        double d = vec3.m_82526_(ItemToolBaseSpearBase.getMotion((Entity)livingEntity));
        float f = livingEntity instanceof Player ? 1.0f : 0.2f;
        float f2 = f = livingEntity instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)livingEntity).useSpearAsPlayer() ? 0.4f : f;
        if (livingEntity instanceof UseSpearSpecialEntity) {
            UseSpearSpecialEntity useSpearSpecialEntity = (UseSpearSpecialEntity)livingEntity;
            f = useSpearSpecialEntity.getNeedSpeed();
        }
        boolean bl = false;
        for (EntityHitResult entityHitResult : ItemToolBaseSpearBase.getHitEntitiesAlong(livingEntity, this, this.hitboxMargin, entity -> ItemToolBaseSpearBase.canHitEntity((Entity)livingEntity, entity))) {
            boolean bl4;
            JerotesChangeLivingEntity jerotesChangeLivingEntity;
            LivingEntity living;
            Entity entity2 = entityHitResult.m_82443_();
            if (entity2 instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)entity2;
                entity2 = partEntity.getParent();
            }
            if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2) instanceof JerotesChangeLivingEntity && (jerotesChangeLivingEntity = (JerotesChangeLivingEntity)living).wasRecentlyStabbedJerotes(entity2, this.contactCooldownTicks)) continue;
            double d2 = vec3.m_82526_(ItemToolBaseSpearBase.getMotion(entity2));
            double d3 = Math.max(0.0, d - d2);
            if (livingEntity instanceof UseSpearSpecialEntity) {
                UseSpearSpecialEntity useSpearSpecialEntity = (UseSpearSpecialEntity)livingEntity;
                d3 *= (double)useSpearSpecialEntity.getDamageMultiple();
            }
            boolean bl2 = this.dismountConditions.isPresent() && this.dismountConditions.get().test(n2, d, d3, f);
            boolean bl3 = this.knockbackConditions.isPresent() && this.knockbackConditions.get().test(n2, d, d3, f);
            boolean bl5 = bl4 = this.damageConditions.isPresent() && this.damageConditions.get().test(n2, d, d3, f);
            if (livingEntity instanceof JerotesChangeLivingEntity) {
                JerotesChangeLivingEntity jerotesChangeLivingEntity2 = (JerotesChangeLivingEntity)livingEntity;
                jerotesChangeLivingEntity2.rememberStabbedEntityJerotes(entity2);
            }
            float fs = (float)d2 + (float)Mth.m_14107_((double)(d3 * (double)this.damageMultiplier));
            bl |= this.stabAttack(equipmentSlot, entity2, fs, bl4, bl3, bl2, livingEntity);
        }
        if (bl) {
            livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)2);
        }
    }

    public boolean stabAttack(EquipmentSlot equipmentSlot, Entity entity, float f, boolean bl, boolean bl2, boolean bl3, LivingEntity self) {
        LivingEntity livingEntity;
        Level object = self.m_9236_();
        if (!(object instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)object;
        object = self.m_6844_(equipmentSlot);
        DamageSource damageSource = new DamageSource((Holder)self.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(JerotesDamageTypes.SPEAR), (Entity)self);
        float f2 = f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            f2 += EnchantmentHelper.m_44833_((ItemStack)((ItemStack)object), (MobType)livingEntity2.m_6336_());
        }
        Vec3 vec3 = entity.m_20184_();
        boolean bl4 = bl2;
        boolean bl5 = bl && entity.m_6469_(damageSource, f2);
        bl4 |= bl5;
        if (bl2) {
            ItemToolBaseSpearBase.causeExtraKnockback(self, entity, 0.4f + this.getKnockback(self, entity, damageSource), vec3);
        }
        if (bl3 && entity.m_20159_() && (!(entity instanceof LivingEntity) || !AttackFind.SameFactionAvoidDamage((Entity)self, livingEntity = (LivingEntity)entity))) {
            bl4 = true;
            entity.m_8127_();
        }
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (self instanceof Player) {
                Player player = (Player)self;
                ((ItemStack)object).m_41640_(livingEntity, player);
            }
        }
        if (bl5) {
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)self);
            }
            EnchantmentHelper.m_44896_((LivingEntity)self, (Entity)entity);
            AttackFind.attackBegin(self, entity);
        }
        if (!bl4) {
            return false;
        }
        self.m_21335_(entity);
        if ((self instanceof JerotesEntity && JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && self.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK) || self instanceof Player) && self.m_6844_(equipmentSlot).m_41763_()) {
            self.m_6844_(equipmentSlot).m_41622_(1, self, e -> self.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public static void causeExtraKnockback(LivingEntity self, Entity entity, float f, Vec3 vec3) {
        UseSpearSpecialEntity useSpearSpecialEntity;
        JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
        if (self instanceof Player || self instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)self).useSpearAsPlayer() || self instanceof UseSpearSpecialEntity && (useSpearSpecialEntity = (UseSpearSpecialEntity)self).isCauseExtraKnockbackPlayer()) {
            if (f > 0.0f) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_147240_((double)f, (double)Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180)))));
                } else {
                    entity.m_5997_((double)(-Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))) * f), 0.1, (double)(Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180))) * f));
                }
                self.m_20256_(self.m_20184_().m_82542_(0.6, 1.0, 0.6));
                self.m_6858_(false);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (entity.f_19864_) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
                    entity.f_19864_ = false;
                    entity.m_20256_(vec3);
                }
            }
        } else if (f > 0.0f && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_147240_((double)f, (double)Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180)))));
            self.m_20256_(self.m_20184_().m_82542_(0.6, 1.0, 0.6));
        }
    }

    protected float getKnockback(LivingEntity self, Entity entity, DamageSource damageSource) {
        float f = (float)self.m_21133_(Attributes.f_22282_);
        Level level = self.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (float)self.m_21205_().getEnchantmentLevel(Enchantments.f_44980_) / 2.0f;
        }
        return f / 2.0f;
    }

    public static Collection<EntityHitResult> getHitEntitiesAlong(LivingEntity livingEntity, ItemToolBaseSpearBase itemToolBaseSpearBase, float f3, Predicate<Entity> predicate) {
        Vec3 vec3 = ItemToolBaseSpearBase.getHeadLookAngle((Entity)livingEntity);
        Vec3 vec32 = livingEntity.m_146892_();
        Vec3 vec33 = vec32.m_82549_(vec3.m_82490_((double)itemToolBaseSpearBase.effectiveMinRange((Entity)livingEntity)));
        double d = ItemToolBaseSpearBase.getKnownMovement((Entity)livingEntity).m_82526_(vec3);
        Vec3 vec34 = vec32.m_82549_(vec3.m_82490_((double)itemToolBaseSpearBase.effectiveMaxRange((Entity)livingEntity) + Math.max(0.0, d)));
        return (Collection)ItemToolBaseSpearBase.getHitEntitiesAlong(vec33, (Entity)livingEntity, predicate, vec34, f3, ClipContext.Block.COLLIDER).map(blockHitResult -> List.of(), collection -> collection);
    }

    public static Vec3 getHeadLookAngle(Entity entity) {
        return ItemToolBaseSpearBase.calculateViewVector(entity.m_146909_(), entity.m_6080_());
    }

    public static Vec3 calculateViewVector(float p_20172_, float p_20173_) {
        float f = p_20172_ * ((float)Math.PI / 180);
        float f1 = -p_20173_ * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static Either<BlockHitResult, Collection<EntityHitResult>> getHitEntitiesAlong(Vec3 vec3, Entity entity, Predicate<Entity> predicate, Vec3 vec32, float f, ClipContext.Block block) {
        AABB aABB;
        Collection<EntityHitResult> collection;
        Level level = entity.m_9236_();
        BlockHitResult blockHitResult = ItemToolBaseSpearBase.clipIncludingBorder(new ClipContext(vec3, vec32, block, ClipContext.Fluid.NONE, entity), level);
        if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
            vec32 = blockHitResult.m_82450_();
        }
        if (!(collection = ItemToolBaseSpearBase.getManyEntityHitResult(level, entity, vec3, vec32, aABB = AABB.m_165882_((Vec3)vec3, (double)f, (double)f, (double)f).m_82369_(vec32.m_82546_(vec3)).m_82400_(1.0), predicate, f)).isEmpty()) {
            return Either.right(collection);
        }
        return Either.left((Object)blockHitResult);
    }

    public static Collection<EntityHitResult> getManyEntityHitResult(Level level, Entity entity, Vec3 vec32, Vec3 vec33, AABB aABB, Predicate<Entity> predicate, float f) {
        ArrayList entities;
        ArrayList<EntityHitResult> arrayList = new ArrayList<EntityHitResult>();
        if (level == null || level.m_5776_() || entity == null || vec32 == null || vec33 == null) {
            return arrayList;
        }
        try {
            entities = new ArrayList(level.m_6249_(entity, aABB, predicate));
        }
        catch (Exception e) {
            return arrayList;
        }
        for (Entity entity2 : entities) {
            if (entity2 == null || entity2.m_213877_() || !entity2.m_6084_()) continue;
            try {
                AABB aABB2 = entity2.m_20191_().m_82400_((double)f);
                if (aABB2.m_82390_(vec32)) {
                    arrayList.add(new EntityHitResult(entity2, vec32));
                    continue;
                }
                Optional optional = aABB2.m_82371_(vec32, vec33);
                optional.ifPresent(vec3 -> arrayList.add(new EntityHitResult(entity2, vec3)));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public static BlockHitResult clipIncludingBorder(ClipContext clipContext, Level level) {
        BlockHitResult blockHitResult = level.m_45547_(clipContext);
        WorldBorder worldBorder = level.m_6857_();
        if (worldBorder.m_61937_(BlockPos.m_274446_((Position)clipContext.m_45702_())) && !worldBorder.m_61937_(BlockPos.m_274446_((Position)blockHitResult.m_82450_()))) {
            Vec3 vec3 = blockHitResult.m_82450_().m_82546_(clipContext.m_45702_());
            Direction direction = ItemToolBaseSpearBase.getApproximateNearest(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            Vec3 vec32 = ItemToolBaseSpearBase.clampVec3ToBound(blockHitResult.m_82450_(), worldBorder);
            return new BlockHitResult(vec32, direction, BlockPos.m_274446_((Position)vec32), false);
        }
        return blockHitResult;
    }

    public static Vec3 clampVec3ToBound(Vec3 vec3, WorldBorder worldBorder) {
        return ItemToolBaseSpearBase.clampVec3ToBound(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, worldBorder);
    }

    public static Vec3 clampVec3ToBound(double d, double d2, double d3, WorldBorder worldBorder) {
        return new Vec3(Mth.m_14008_((double)d, (double)worldBorder.m_61955_(), (double)(worldBorder.m_61957_() - (double)1.0E-5f)), d2, Mth.m_14008_((double)d3, (double)worldBorder.m_61956_(), (double)(worldBorder.m_61958_() - (double)1.0E-5f)));
    }

    public static Direction getApproximateNearest(double d, double d2, double d3) {
        return ItemToolBaseSpearBase.getApproximateNearest((float)d, (float)d2, (float)d3);
    }

    public static Direction getApproximateNearest(float f, float f2, float f3) {
        Direction direction = Direction.NORTH;
        float f4 = Float.MIN_VALUE;
        for (Direction direction2 : Direction.values()) {
            float f5 = f * (float)direction2.m_122429_() + f2 * (float)direction2.m_122430_() + f3 * (float)direction2.m_122431_();
            if (!(f5 > f4)) continue;
            f4 = f5;
            direction = direction2;
        }
        return direction;
    }

    public static boolean canHitEntity(Entity entity, Entity entity2) {
        LivingEntity living;
        if (!entity2.m_271807_()) {
            return false;
        }
        if (entity instanceof LivingEntity && AttackFind.FindCanNotAttack(living = (LivingEntity)entity, entity2)) {
            return false;
        }
        if (!Main.hasLineOfSightEntity(entity, entity2)) {
            return false;
        }
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            Player livingEntity = (Player)entity2;
            if (entity instanceof Player && !(player = (Player)entity).m_7099_(livingEntity)) {
                return false;
            }
        }
        return !entity.m_20365_(entity2);
    }

    @Override
    public void jerotesSpecialAttackClient(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36334_();
            ItemToolBaseSpearBase.jerotesLungeForwardMaybe((LivingEntity)player);
            this.makeSound2((Entity)player);
        }
    }

    @Override
    public void jerotesSpecialAttack(LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        this.attack(livingEntity, equipmentSlot);
    }

    public void attack(LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        float f = livingEntity.m_21051_(Attributes.f_22281_) != null ? (float)livingEntity.m_21133_(Attributes.f_22281_) : 0.0f;
        boolean bl = false;
        for (EntityHitResult entityHitResult : ItemToolBaseSpearBase.getHitEntitiesAlong(livingEntity, this, this.hitboxMargin2, entity -> ItemToolBaseSpearBase.canHitEntity((Entity)livingEntity, entity))) {
            bl |= this.stabAttack(equipmentSlot, entityHitResult.m_82443_(), f, true, this.dealsKnockback, this.dismounts, livingEntity);
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.m_36334_();
        }
        if (!(livingEntity instanceof Player) || !livingEntity.m_9236_().m_5776_()) {
            ItemToolBaseSpearBase.jerotesLungeForwardMaybe(livingEntity);
        }
        if (bl) {
            this.makeHitSound2((Entity)livingEntity);
        }
        this.makeSound2((Entity)livingEntity);
    }

    public float effectiveMinRange(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_5833_()) {
                return 0.0f;
            }
            return player.m_7500_() ? this.minCreativeRange : this.minRange;
        }
        if (entity instanceof Mob) {
            JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
            Mob mob = (Mob)entity;
            if (entity instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)entity).useSpearAsPlayer()) {
                if (mob.m_5833_()) {
                    return 0.0f;
                }
                return jerotesPlayerBaseEntity.getAbilities() != null && jerotesPlayerBaseEntity.getAbilities().f_35937_ ? this.minCreativeRange : this.minRange;
            }
        }
        return this.minRange * this.mobFactor;
    }

    public float effectiveMaxRange(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return (player.m_7500_() ? this.maxCreativeRange : this.maxRange) + (player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()) != null ? (float)Math.max(0.0, player.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 3.0) : 0.0f);
        }
        if (entity instanceof Mob) {
            JerotesPlayerBaseEntity jerotesPlayerBaseEntity;
            Mob mob = (Mob)entity;
            if (entity instanceof JerotesPlayerBaseEntity && (jerotesPlayerBaseEntity = (JerotesPlayerBaseEntity)entity).useSpearAsPlayer()) {
                return (jerotesPlayerBaseEntity.getAbilities() != null && jerotesPlayerBaseEntity.getAbilities().f_35937_ ? this.maxCreativeRange : this.maxRange) + (mob.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()) != null ? (float)Math.max(0.0, mob.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 3.0) : 0.0f);
            }
        }
        return this.maxRange * this.mobFactor + (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()) != null ? (float)Math.max(0.0, livingEntity.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - 3.0) : 0.0f);
    }

    public static void jerotesLungeForwardMaybe(LivingEntity livingEntity) {
        Level level = livingEntity.m_9236_();
        ItemToolBaseSpearBase.jerotesDoLungeEffects(level, (Entity)livingEntity);
    }

    public static void jerotesDoLungeEffects(Level level, Entity entity) {
        LivingEntity livingEntity;
        ItemStack mainHandItem;
        int lungeLevel;
        if (entity instanceof LivingEntity && (lungeLevel = (mainHandItem = (livingEntity = (LivingEntity)entity).m_21205_()).getEnchantmentLevel((Enchantment)JerotesEnchantments.LUNGE.get())) > 0) {
            if (livingEntity.m_20159_() || livingEntity.m_21255_() || livingEntity.m_20069_()) {
                return;
            }
            if ((entity instanceof JerotesEntity && JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && entity.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK) || entity instanceof Player) && mainHandItem.m_41763_()) {
                mainHandItem.m_41622_(1, livingEntity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                float exhaustion = 4.0f * (float)lungeLevel;
                player.m_36399_(exhaustion);
            }
            float strength = 0.458f * (float)lungeLevel;
            ItemToolBaseSpearBase.RushAttack(livingEntity, strength);
            SoundEvent sound = JerotesSounds.LUNGE_1;
            if (lungeLevel > 1) {
                sound = JerotesSounds.LUNGE_2;
            }
            if (lungeLevel > 2) {
                sound = JerotesSounds.LUNGE_3;
            }
            level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), sound, livingEntity.m_5720_(), 1.0f, 1.0f);
        }
    }

    public static boolean RushAttack(LivingEntity livingEntity, float strength) {
        Vec3 vec3 = livingEntity.m_20154_();
        livingEntity.m_5997_(vec3.f_82479_ * (double)strength, 0.0, vec3.f_82481_ * (double)strength);
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41720_() instanceof ItemToolBaseSpearBase && (enchantment == Enchantments.f_44981_ || enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44982_ || enchantment instanceof DamageEnchantment)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public boolean otherAnimSpear() {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        if (!this.otherAnimSpear()) {
            consumer.accept(new SpearClient());
        } else {
            super.initializeClient(consumer);
        }
    }

    @Override
    public int swingTimes() {
        float f = 20.0f * this.swingTimes;
        return (int)f;
    }

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public boolean test(int n, double d, double d2, double d3) {
            return n <= this.maxDurationTicks && d >= (double)this.minSpeed * d3 && d2 >= (double)this.minRelativeSpeed * d3;
        }

        public static Optional<Condition> ofAttackerSpeed(int n, float f) {
            return Optional.of(new Condition(n, f, 0.0f));
        }

        public static Optional<Condition> ofRelativeSpeed(int n, float f) {
            return Optional.of(new Condition(n, 0.0f, f));
        }
    }

    public static class SpearClient
    implements IClientItemExtensions {
        public static final HumanoidModel.ArmPose SPEAR_POSE = HumanoidModel.ArmPose.create((String)"JEROTES_SPEAR", (boolean)false, (model, entity, arm) -> {});

        public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack stack) {
            if (stack.m_41720_() instanceof ItemToolBaseSpearBase) {
                if (entity.m_6117_()) {
                    if (entity.m_7655_() == hand) {
                        return SPEAR_POSE;
                    }
                    return HumanoidModel.ArmPose.EMPTY;
                }
                if (entity.m_21205_().m_41720_() instanceof ItemToolBaseSpearBase && entity.m_21206_().m_41720_() instanceof ItemToolBaseSpearBase) {
                    if (InteractionHand.MAIN_HAND != hand) {
                        return SPEAR_POSE;
                    }
                    return HumanoidModel.ArmPose.EMPTY;
                }
                return SPEAR_POSE;
            }
            return HumanoidModel.ArmPose.EMPTY;
        }

        private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProcess) {
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProcess * -0.6f), (double)-0.72f);
        }

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            int dir;
            int n = dir = arm == HumanoidArm.RIGHT ? 1 : -1;
            if (player.m_6117_() && player.m_21211_() == itemInHand) {
                float f;
                this.applyItemArmTransform(poseStack, arm, 0.0f);
                float useTicks = (float)itemInHand.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f);
                if (player instanceof JerotesChangeLivingEntity) {
                    JerotesChangeLivingEntity jerotesChangeLivingEntity = (JerotesChangeLivingEntity)player;
                    f = jerotesChangeLivingEntity.getTicksSinceLastKineticHitFeedbackJerotes(partialTick);
                } else {
                    f = 0.0f;
                }
                SpearAnimations.firstPersonUse(f, poseStack, useTicks, arm, itemInHand);
                return true;
            }
            if (swingProcess > 0.0f) {
                this.applyItemArmTransform(poseStack, arm, 0.0f);
                SpearAnimations.firstPersonAttack(swingProcess, poseStack, dir, arm);
                return true;
            }
            this.applyItemArmTransform(poseStack, arm, equipProcess);
            return true;
        }
    }
}

