/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jerotes.jerotes.item.ItemAnesthetized;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.item.MeleeItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;

public class ItemToolBaseTwoHandedHammer
extends TieredItem
implements ItemTwoHanded,
ItemAnesthetized,
ItemSpecialEffect,
MeleeItem,
Vanishable {
    protected static final UUID BASE_ENTITY_REACH_UUID = UUID.fromString("c0b279fb-83be-442f-b062-c577d26065d3");
    protected static final UUID BASE_BLOCK_REACH_UUID = UUID.fromString("2ab44e2a-0eb7-4825-8a10-88709f6e2219");
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ItemToolBaseTwoHandedHammer(Tier tier, int damage, float speed, Item.Properties properties) {
        super(tier, properties);
        this.attackDamage = (float)damage + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ENTITY_REACH_UUID, "Weapon modifier", 0.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(BASE_BLOCK_REACH_UUID, "Weapon modifier", 0.5, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity livingEntity, LivingEntity livingEntity2) {
        itemStack.m_41622_(1, livingEntity2, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (blockState.m_60800_((BlockGetter)level, blockPos) != 0.0f) {
            itemStack.m_41622_(2, livingEntity, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!player.m_21206_().m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    @Override
    public int getAnesthetized() {
        return 12;
    }

    @Override
    public boolean onlyPlayer() {
        return true;
    }

    @Override
    public boolean onlyThrowing() {
        return false;
    }

    @Override
    public int getBlockReduction() {
        return 50;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.m_237115_((String)"item.jerotes.two_handed_hammer").m_130940_(ChatFormatting.YELLOW));
        list.add((Component)Component.m_237110_((String)"item.jerotes.two_handed", (Object[])new Object[]{this.getBlockReduction()}).m_130940_(ChatFormatting.YELLOW));
        list.add((Component)Component.m_237110_((String)"item.jerotes.anesthetized_only_melee", (Object[])new Object[]{this.getAnesthetized()}).m_130940_(ChatFormatting.YELLOW));
    }
}

