/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.mixin;

import com.jerotes.jerotes.entity.BaseEntityAbout;
import com.jerotes.jerotes.entity.CamelAbout;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Camel.class})
public abstract class CamelMixin
extends AbstractHorse
implements CamelAbout,
BaseEntityAbout {
    private static final EntityDataAccessor<Boolean> IS_JEROTES_CAMEL_HUSK = SynchedEntityData.m_135353_(CamelMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected CamelMixin(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isJerotesMobControlled() {
        return this.m_146895_() instanceof Mob;
    }

    @Override
    public boolean isJerotesCamelHusk() {
        return (Boolean)this.m_20088_().m_135370_(IS_JEROTES_CAMEL_HUSK);
    }

    @Override
    public void setJerotesCamelHusk(boolean bl) {
        this.m_20088_().m_135381_(IS_JEROTES_CAMEL_HUSK, (Object)bl);
    }

    @Override
    public float chargeSpeedModifierJerotes() {
        if (this.isJerotesCamelHusk()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128379_("IsJerotesCamelHusk", this.isJerotesCamelHusk());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.setJerotesCamelHusk(compoundTag.m_128471_("IsJerotesCamelHusk"));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void defineSynchedData(CallbackInfo ci) {
        this.m_20088_().m_135372_(IS_JEROTES_CAMEL_HUSK, (Object)false);
    }

    @Inject(method={"isFood"}, at={@At(value="HEAD")}, cancellable=true)
    protected void isFood(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        if (this.isJerotesCamelHusk()) {
            cir.setReturnValue((Object)itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("camel_husk_food"))));
        }
    }

    @Inject(method={"clampRotation"}, at={@At(value="HEAD")}, cancellable=true)
    protected void clampRotation(Entity entity, CallbackInfo ci) {
        if (this.isJerotesCamelHusk()) {
            ci.cancel();
        }
    }

    @Inject(method={"canMate"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canMate(Animal animal, CallbackInfoReturnable<Boolean> cir) {
        if (this.isJerotesCamelHusk()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getControllingPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getControllingPassenger(CallbackInfoReturnable<LivingEntity> cir) {
        Entity entity;
        if (this.isJerotesCamelHusk() && !this.m_20197_().isEmpty() && this.isJerotesMobControlled() && (entity = (Entity)this.m_20197_().get(0)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            cir.setReturnValue((Object)livingEntity);
        }
    }
}

