/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.mixin;

import com.jerotes.jerotes.entity.CamelAbout;
import com.jerotes.jerotes.entity.JerotesChangeLivingEntity;
import com.jerotes.jerotes.entity.StrayAbout;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.item.MeleeItem;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import com.jerotes.jerotes.network.JerotesSpearRushAttackPacket;
import com.jerotes.jerotes.network.PacketHandler;
import com.jerotes.jerotes.util.EntityFactionFind;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements JerotesChangeLivingEntity {
    @Shadow
    protected int f_20936_;
    @Shadow
    protected ItemStack f_20935_;
    @Nullable
    protected Object2LongMap<Entity> recentKineticEnemiesJerotes;
    private long lastKineticHitFeedbackTimeJerotes = Integer.MIN_VALUE;

    protected LivingEntityMixin(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Shadow
    public abstract int m_21212_();

    @Shadow
    protected abstract void m_8095_();

    @Shadow
    public abstract InteractionHand m_7655_();

    @Shadow
    public abstract ItemStack m_21205_();

    @Override
    public boolean canAddPassengerJerotes(Entity entity) {
        return this.m_7310_(entity);
    }

    @Override
    public boolean wasRecentlyStabbedJerotes(Entity entity, int n) {
        if (this.recentKineticEnemiesJerotes == null) {
            return false;
        }
        if (this.recentKineticEnemiesJerotes.containsKey((Object)entity)) {
            return this.m_9236_().m_46467_() - this.recentKineticEnemiesJerotes.getLong((Object)entity) < (long)n;
        }
        return false;
    }

    @Override
    public void rememberStabbedEntityJerotes(Entity entity) {
        if (this.recentKineticEnemiesJerotes != null) {
            this.recentKineticEnemiesJerotes.put((Object)entity, this.m_9236_().m_46467_());
        }
    }

    @Inject(method={"startUsingItem"}, at={@At(value="TAIL")})
    private void startUsingItem(InteractionHand p_21159_, CallbackInfo ci) {
        if (!this.m_9236_().m_5776_() && this.f_20935_.m_41720_() instanceof ItemToolBaseSpearBase) {
            this.recentKineticEnemiesJerotes = new Object2LongOpenHashMap();
        }
    }

    @Override
    public float getTicksSinceLastKineticHitFeedbackJerotes(float f) {
        if (this.lastKineticHitFeedbackTimeJerotes < 0L) {
            return 0.0f;
        }
        return (float)(this.m_9236_().m_46467_() - this.lastKineticHitFeedbackTimeJerotes) + f;
    }

    private void onKineticHitJerotes() {
        if (this.m_9236_().m_46467_() - this.lastKineticHitFeedbackTimeJerotes <= 10L) {
            return;
        }
        this.lastKineticHitFeedbackTimeJerotes = this.m_9236_().m_46467_();
        Item item = this.f_20935_.m_41720_();
        if (!(item instanceof ItemToolBaseSpearBase)) {
            return;
        }
        ItemToolBaseSpearBase kineticWeapon = (ItemToolBaseSpearBase)item;
        kineticWeapon.makeLocalHitSound(this);
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleEntityEvent(byte by, CallbackInfo ci) {
        if (by == 2) {
            this.onKineticHitJerotes();
        }
    }

    @Inject(method={"updateUsingItem"}, at={@At(value="HEAD")})
    private void updateUsingItem(ItemStack itemStack, CallbackInfo ci) {
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolBaseSpearBase) {
            ItemToolBaseSpearBase itemToolBaseSpearBase = (ItemToolBaseSpearBase)item;
            if (this.m_9236_().m_5776_()) {
                PacketHandler.sendToServer(new JerotesSpearRushAttackPacket(itemStack, this.m_21212_(), ((LivingEntity)this).m_19879_()));
            }
        }
    }

    @Inject(method={"getVisibilityPercent"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVisibilityPercent(Entity entity, CallbackInfoReturnable<Double> cir) {
        if (entity != null && this.m_21023_((MobEffect)JerotesMobEffects.CLOAKING.get())) {
            int cloakingLevel = Objects.requireNonNull(this.m_21124_((MobEffect)JerotesMobEffects.CLOAKING.get())).m_19564_() + 1;
            if (this.m_20270_(entity) > (float)(48 - cloakingLevel * 8)) {
                cir.setReturnValue((Object)0.0);
            }
        }
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canAttack(LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction(self, livingEntity)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"getCurrentSwingDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void getCurrentSwingDuration(CallbackInfoReturnable<Integer> cir) {
        Item item = this.m_21205_().m_41720_();
        if (item instanceof MeleeItem) {
            MeleeItem itemToolBaseSpearBase = (MeleeItem)item;
            int n = itemToolBaseSpearBase.swingTimes();
            if (MobEffectUtil.m_19584_((LivingEntity)((LivingEntity)this))) {
                cir.setReturnValue((Object)(n - (1 + MobEffectUtil.m_19586_((LivingEntity)((LivingEntity)this)))));
            } else {
                cir.setReturnValue((Object)(this.m_21023_(MobEffects.f_19599_) ? n + (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2 : n));
            }
            cir.cancel();
        }
    }

    @Inject(method={"getMobType"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getMobType(CallbackInfoReturnable<MobType> cir) {
        CamelAbout camelAbout;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof CamelAbout && (camelAbout = (CamelAbout)((Object)livingEntityMixin)).isJerotesCamelHusk() && camelAbout.isJerotesMobControlled()) {
            cir.setReturnValue((Object)MobType.f_21641_);
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void canBeAffected(MobEffectInstance mobEffectInstance, CallbackInfoReturnable<Boolean> cir) {
        StrayAbout strayAbout;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof StrayAbout && (strayAbout = (StrayAbout)((Object)livingEntityMixin)).isJerotesParched() && mobEffectInstance.m_19544_() == MobEffects.f_19613_) {
            cir.setReturnValue((Object)false);
        }
    }
}

