/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.network;

import com.jerotes.jerotes.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(modid="jerotes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class JerotesPlayerData {
    public static final Capability<PlayerVariables> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariables {
        public String MainSpellTarget = "";
        public int MainSpellTargetLevel = 1;
        public int MainSpellUseCoolDownTick = 0;
        public int MainSpellUseCoolDownTickMax = 0;
        public String AddSpellTarget = "";
        public int AddSpellTargetLevel = 1;
        public int AddSpellUseCoolDownTick = 0;
        public int AddSpellUseCoolDownTickMax = 0;

        public void setMainSpellTarget(String string) {
            this.MainSpellTarget = string;
        }

        public void setMainSpellTargetLevel(int n) {
            this.MainSpellTargetLevel = n;
        }

        public void setMainSpellUseCoolDownTick(int n) {
            this.MainSpellUseCoolDownTick = n;
        }

        public void setMainSpellUseCoolDownTickMax(int n) {
            this.MainSpellUseCoolDownTickMax = n;
        }

        public void setAddSpellTarget(String string) {
            this.AddSpellTarget = string;
        }

        public void setAddSpellTargetLevel(int n) {
            this.AddSpellTargetLevel = n;
        }

        public void setAddSpellUseCoolDownTick(int n) {
            this.AddSpellUseCoolDownTick = n;
        }

        public void setAddSpellUseCoolDownTickMax(int n) {
            this.AddSpellUseCoolDownTickMax = n;
        }

        public void syncPlayerVariables(Entity entity) {
            if (!entity.m_9236_().m_5776_() && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.NETWORK_WRAPPER.sendTo((Object)new PlayerVariablesSyncMessage(this.writeNBT()), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }

        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("JerotesMainSpellTarget", this.MainSpellTarget);
            nbt.m_128405_("JerotesMainSpellTargetLevel", this.MainSpellTargetLevel);
            nbt.m_128405_("JerotesMainSpellUseCoolDownTick", this.MainSpellUseCoolDownTick);
            nbt.m_128405_("JerotesMainSpellUseCoolDownTickMax", this.MainSpellUseCoolDownTickMax);
            nbt.m_128359_("JerotesAddSpellTarget", this.AddSpellTarget);
            nbt.m_128405_("JerotesAddSpellTargetLevel", this.AddSpellTargetLevel);
            nbt.m_128405_("JerotesAddSpellUseCoolDownTick", this.AddSpellUseCoolDownTick);
            nbt.m_128405_("JerotesAddSpellUseCoolDownTickMax", this.AddSpellUseCoolDownTickMax);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.MainSpellTarget = nbt.m_128461_("JerotesMainSpellTarget");
            this.MainSpellTargetLevel = nbt.m_128451_("JerotesMainSpellTargetLevel");
            this.MainSpellUseCoolDownTick = nbt.m_128451_("JerotesMainSpellUseCoolDownTick");
            this.MainSpellUseCoolDownTickMax = nbt.m_128451_("JerotesMainSpellUseCoolDownTickMax");
            this.AddSpellTarget = nbt.m_128461_("JerotesAddSpellTarget");
            this.AddSpellTargetLevel = nbt.m_128451_("JerotesAddSpellTargetLevel");
            this.AddSpellUseCoolDownTick = nbt.m_128451_("JerotesAddSpellUseCoolDownTick");
            this.AddSpellUseCoolDownTickMax = nbt.m_128451_("JerotesAddSpellUseCoolDownTickMax");
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final CompoundTag data;

        public PlayerVariablesSyncMessage(CompoundTag nbt) {
            this.data = nbt;
        }

        public static void encode(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data);
        }

        public static PlayerVariablesSyncMessage decode(FriendlyByteBuf buffer) {
            return new PlayerVariablesSyncMessage(buffer.m_130260_());
        }

        public static void consume(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> context) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null) {
                minecraft.f_91074_.getCapability(CAPABILITY).ifPresent(cap -> cap.readNBT((Tag)message.data));
            }
            context.get().setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                event.addCapability(new ResourceLocation("jerotes", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.MainSpellTarget = original.MainSpellTarget;
            clone.MainSpellTargetLevel = original.MainSpellTargetLevel;
            clone.MainSpellUseCoolDownTick = original.MainSpellUseCoolDownTick;
            clone.MainSpellUseCoolDownTickMax = original.MainSpellUseCoolDownTickMax;
            clone.AddSpellTarget = original.AddSpellTarget;
            clone.AddSpellTargetLevel = original.AddSpellTargetLevel;
            clone.AddSpellUseCoolDownTick = original.AddSpellUseCoolDownTick;
            clone.AddSpellUseCoolDownTickMax = original.AddSpellUseCoolDownTickMax;
            clone.syncPlayerVariables((Entity)event.getEntity());
        }
    }
}

