/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.network;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MobSendEffectsPacket {
    public int mob;

    public MobSendEffectsPacket(int id) {
        this.mob = id;
    }

    public static void encode(MobSendEffectsPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.mob);
    }

    public static MobSendEffectsPacket decode(FriendlyByteBuf buffer) {
        return new MobSendEffectsPacket(buffer.readInt());
    }

    public static void consume(MobSendEffectsPacket message, Supplier<NetworkEvent.Context> context) {
        ServerPlayer playerEntity = context.get().getSender();
        if (playerEntity != null) {
            Entity entity = playerEntity.m_9236_().m_6815_(message.mob);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!playerEntity.m_9236_().m_5776_()) {
                    playerEntity.m_213846_((Component)Component.m_237115_((String)"message.jerotes.effect").m_130940_(ChatFormatting.DARK_GREEN));
                    Collection effects = livingEntity.m_21220_();
                    if (!effects.isEmpty()) {
                        for (MobEffectInstance effect : effects) {
                            ChatFormatting color = effect.m_19544_().m_19486_() ? ChatFormatting.GREEN : ChatFormatting.YELLOW;
                            playerEntity.m_213846_((Component)Component.m_237115_((String)effect.m_19576_()).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"message.jerotes.effect_level", (Object[])new Object[]{effect.m_19564_() + 1})).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"message.jerotes.effect_second", (Object[])new Object[]{MobEffectUtil.m_267641_((MobEffectInstance)effect, (float)1.0f)})).m_130940_(color));
                        }
                    }
                }
            }
            context.get().setPacketHandled(true);
        }
    }
}

