/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.spell;

import com.jerotes.jerotes.spell.SpellType;
import com.jerotes.jerotes.spell.SpellTypeInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SpellRegistry {
    private static final Map<String, SpellTypeInterface> REGISTRY = new HashMap<String, SpellTypeInterface>();

    public static void register(SpellTypeInterface spellType) {
        if (REGISTRY.containsKey(spellType.getId())) {
            throw new IllegalArgumentException("\u91cd\u590d\u7684\u6cd5\u672fID: " + spellType.getId());
        }
        REGISTRY.put(spellType.getId(), spellType);
    }

    public static SpellTypeInterface getSpellTypeById(String id) {
        SpellTypeInterface type = REGISTRY.get(id);
        if (type == null) {
            throw new IllegalArgumentException("\u672a\u77e5\u6cd5\u672f\u7c7b\u578b: " + id);
        }
        return type;
    }

    public static boolean spellExists(String id) {
        return REGISTRY.containsKey(id);
    }

    public static Collection<String> getRegisteredSpellIds() {
        return REGISTRY.keySet();
    }

    static {
        for (SpellType type : SpellType.values()) {
            SpellRegistry.register(type);
        }
    }
}

