/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.util;

import com.jerotes.jerotes.entity.CanBeIllagerFactionEntity;
import com.jerotes.jerotes.entity.CanBeSerponFactionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.forge.JerotesFactionEvent;
import com.jerotes.jerotes.util.AttackFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityFactionFind {
    public static boolean isThisEntity(EntityType type, String string) {
        return type.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(string)));
    }

    public static boolean isHumanoid(LivingEntity hummanoid) {
        return hummanoid instanceof Player || hummanoid instanceof AbstractVillager || hummanoid instanceof AbstractIllager || hummanoid instanceof AbstractPiglin || hummanoid instanceof Witch || hummanoid instanceof EnderMan || EntityFactionFind.isHumanoid(hummanoid.m_6095_()) && hummanoid.m_6336_() != MobType.f_21641_;
    }

    public static boolean isDragon(LivingEntity dragon) {
        return dragon instanceof EnderDragon || EntityFactionFind.isDragon(dragon.m_6095_()) && dragon.m_6336_() != MobType.f_21641_;
    }

    public static boolean isTrueDragon(LivingEntity trueDragon) {
        return trueDragon instanceof EnderDragon || EntityFactionFind.isTrueDragon(trueDragon.m_6095_()) && trueDragon.m_6336_() != MobType.f_21641_;
    }

    public static boolean isFey(LivingEntity fey) {
        return fey instanceof Allay || fey instanceof Vex || EntityFactionFind.isFey(fey.m_6095_()) && fey.m_6336_() != MobType.f_21641_;
    }

    public static boolean isOoze(LivingEntity ooze) {
        return ooze instanceof Slime || EntityFactionFind.isOoze(ooze.m_6095_()) && ooze.m_6336_() != MobType.f_21641_;
    }

    public static boolean isPlant(LivingEntity plant) {
        return EntityFactionFind.isPlant(plant.m_6095_()) && plant.m_6336_() != MobType.f_21641_;
    }

    public static boolean isElemental(LivingEntity elemental) {
        return elemental instanceof Blaze || EntityFactionFind.isElemental(elemental.m_6095_()) && elemental.m_6336_() != MobType.f_21641_;
    }

    public static boolean isAberration(LivingEntity aberration) {
        return EntityFactionFind.isAberration(aberration.m_6095_()) && aberration.m_6336_() != MobType.f_21641_;
    }

    public static boolean isCelestial(LivingEntity celestial) {
        return EntityFactionFind.isCelestial(celestial.m_6095_()) && celestial.m_6336_() != MobType.f_21641_;
    }

    public static boolean isFiend(LivingEntity fiend) {
        return EntityFactionFind.isFiend(fiend.m_6095_()) && fiend.m_6336_() != MobType.f_21641_;
    }

    public static boolean isMachine(LivingEntity livingEntity) {
        return EntityFactionFind.isMachine(livingEntity.m_6095_());
    }

    public static boolean isConstruct(LivingEntity livingEntity) {
        return livingEntity instanceof AbstractGolem || EntityFactionFind.isConstruct(livingEntity.m_6095_());
    }

    public static boolean isHumanoid(EntityType hummanoid) {
        return hummanoid.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "humanoid")));
    }

    public static boolean isFey(EntityType fey) {
        return fey.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "fey")));
    }

    public static boolean isOoze(EntityType ooze) {
        return ooze.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "ooze")));
    }

    public static boolean isPlant(EntityType plant) {
        return plant.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "plant")));
    }

    public static boolean isElemental(EntityType elemental) {
        return elemental.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "elemental")));
    }

    public static boolean isAberration(EntityType aberration) {
        return aberration.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "aberration")));
    }

    public static boolean isCelestial(EntityType celestial) {
        return celestial.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "celestial")));
    }

    public static boolean isFiend(EntityType fiend) {
        return fiend.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "fiend")));
    }

    public static boolean isMachine(EntityType machine) {
        return machine.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "machine")));
    }

    public static boolean isDragon(EntityType dragon) {
        return dragon.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "dragon")));
    }

    public static boolean isTrueDragon(EntityType trueDragon) {
        return trueDragon.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "true_dragon")));
    }

    public static boolean isConstruct(EntityType construct) {
        return construct.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "construct")));
    }

    public static boolean isRaider(LivingEntity entity) {
        CanBeIllagerFactionEntity canBeIllagerFactionEntity;
        return entity instanceof Raider || entity.m_6336_() == MobType.f_21643_ || entity.m_6095_().m_204039_(EntityTypeTags.f_13121_) || entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft:illager"))) || entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft:illager_friends"))) || entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "illager"))) || entity instanceof CanBeIllagerFactionEntity && (canBeIllagerFactionEntity = (CanBeIllagerFactionEntity)entity).isIllagerFaction();
    }

    public static boolean isPiglin(LivingEntity livingEntity) {
        return livingEntity instanceof AbstractPiglin || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "piglin")));
    }

    public static boolean isEnderman(LivingEntity livingEntity) {
        return livingEntity instanceof EnderMan || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "enderman")));
    }

    public static boolean isVillager(LivingEntity livingEntity) {
        return livingEntity instanceof AbstractVillager || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "villager")));
    }

    public static boolean isIllager(LivingEntity livingEntity) {
        return livingEntity instanceof AbstractIllager || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft:illager"))) || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "illager")));
    }

    public static boolean isWitch(LivingEntity livingEntity) {
        return livingEntity instanceof Witch || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "witch")));
    }

    public static boolean isFaction(LivingEntity livingEntity, LivingEntity livingEntity2) {
        if (livingEntity == null || livingEntity2 == null) {
            return false;
        }
        JerotesFactionEvent event = new JerotesFactionEvent(livingEntity, livingEntity2);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isFriend();
    }

    public static boolean isHateFaction(LivingEntity livingEntity, LivingEntity livingEntity2) {
        if (livingEntity == null || livingEntity2 == null) {
            return false;
        }
        JerotesFactionEvent event = new JerotesFactionEvent(livingEntity, livingEntity2);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isEnemy();
    }

    public static String getTrueFaction(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return "";
        }
        String base = "";
        if (AttackFind.getOwnerTrue((Entity)livingEntity) != null) {
            return EntityFactionFind.getTrueFaction(AttackFind.getOwnerTrue((Entity)livingEntity));
        }
        if (!livingEntity.getPersistentData().m_128461_("jerotes_mob_faction").isEmpty()) {
            return livingEntity.getPersistentData().m_128461_("jerotes_mob_faction");
        }
        if (livingEntity instanceof JerotesEntity) {
            JerotesEntity jerotes = (JerotesEntity)livingEntity;
            return jerotes.getFactionTypeName();
        }
        return base;
    }

    public static String getTrueMobTypeNameModId(LivingEntity livingEntity) {
        JerotesEntity jerotes;
        if (livingEntity == null) {
            return "";
        }
        String base = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)livingEntity.m_6095_())).m_135827_();
        if (AttackFind.getOwnerTrue((Entity)livingEntity) != null) {
            return EntityFactionFind.getTrueMobTypeNameModId(AttackFind.getOwnerTrue((Entity)livingEntity));
        }
        if (!livingEntity.getPersistentData().m_128461_("jerotes_mob_faction_mod_id").isEmpty()) {
            return livingEntity.getPersistentData().m_128461_("jerotes_mob_faction_mod_id");
        }
        if (livingEntity instanceof JerotesEntity && !(jerotes = (JerotesEntity)livingEntity).getMobTypeNameModId().isEmpty()) {
            return jerotes.getMobTypeNameModId();
        }
        return base;
    }

    public static boolean isCarved(EntityType type) {
        return type.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "carved")));
    }

    public static boolean isSerponFaction(EntityType type) {
        return type.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotes", "serpon_faction")));
    }

    public static boolean isFactionSerponCombatTeam(LivingEntity livingEntity) {
        CanBeSerponFactionEntity canBeSerponFaction;
        return EntityFactionFind.isSerponFaction(livingEntity.m_6095_()) && (!(livingEntity instanceof CanBeSerponFactionEntity) || !(canBeSerponFaction = (CanBeSerponFactionEntity)livingEntity).isNotSerpon()) || EntityFactionFind.getTrueFaction(livingEntity).equals("serpon_combat_team");
    }

    public static String getFindFaction(LivingEntity livingEntity) {
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_true_dragon")) {
            return "true_dragon";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_ender")) {
            return "ender";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_sculk")) {
            return "sculk";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_piglin")) {
            return "piglin";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_undead")) {
            return "undead";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_illager")) {
            return "illager";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_villager")) {
            return "villager";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_witch")) {
            return "witch";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_raider")) {
            return "raider";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_ooze")) {
            return "ooze";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_plant")) {
            return "plant";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_fey")) {
            return "fey";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_elemental")) {
            return "elemental";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/aberration")) {
            return "aberration";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_celestial")) {
            return "celestial";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_fiend")) {
            return "fiend";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_humanoid")) {
            return "humanoid";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_dragon")) {
            return "dragon";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_arthropod")) {
            return "arthropod";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_water_animal")) {
            return "water_animal";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_animal")) {
            return "animal";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_construct")) {
            return "construct";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_machine")) {
            return "machine";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_monster")) {
            return "monster";
        }
        if (EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_water")) {
            return "water";
        }
        if (EntityFactionFind.isTrueDragon(livingEntity)) {
            return "true_dragon";
        }
        if (EntityFactionFind.isEnderman(livingEntity) || livingEntity instanceof EnderMan || livingEntity instanceof EnderDragon || livingEntity instanceof Endermite || livingEntity instanceof Shulker) {
            return "ender";
        }
        if (livingEntity instanceof Warden) {
            return "sculk";
        }
        if (EntityFactionFind.isPiglin(livingEntity) || livingEntity instanceof AbstractPiglin) {
            return "piglin";
        }
        if (livingEntity.m_6336_() == MobType.f_21641_) {
            return "undead";
        }
        if (EntityFactionFind.isIllager(livingEntity) || livingEntity instanceof AbstractIllager) {
            return "illager";
        }
        if (EntityFactionFind.isVillager(livingEntity) || livingEntity instanceof AbstractVillager) {
            return "villager";
        }
        if (EntityFactionFind.isWitch(livingEntity) || livingEntity instanceof Witch) {
            return "witch";
        }
        if (EntityFactionFind.isRaider(livingEntity) || livingEntity instanceof Raider) {
            return "raider";
        }
        if (EntityFactionFind.isOoze(livingEntity)) {
            return "ooze";
        }
        if (EntityFactionFind.isPlant(livingEntity)) {
            return "plant";
        }
        if (EntityFactionFind.isFey(livingEntity)) {
            return "fey";
        }
        if (EntityFactionFind.isElemental(livingEntity)) {
            return "elemental";
        }
        if (EntityFactionFind.isAberration(livingEntity)) {
            return "aberration";
        }
        if (EntityFactionFind.isCelestial(livingEntity)) {
            return "celestial";
        }
        if (EntityFactionFind.isFiend(livingEntity)) {
            return "fiend";
        }
        if (EntityFactionFind.isHumanoid(livingEntity)) {
            return "humanoid";
        }
        if (EntityFactionFind.isDragon(livingEntity)) {
            return "dragon";
        }
        if (livingEntity.m_6336_() == MobType.f_21642_ || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft:arthropod")))) {
            return "arthropod";
        }
        if (livingEntity instanceof WaterAnimal || livingEntity instanceof Animal && livingEntity.m_6336_() == MobType.f_21644_) {
            return "water_animal";
        }
        if (livingEntity instanceof Animal) {
            return "animal";
        }
        if (EntityFactionFind.isConstruct(livingEntity)) {
            return "construct";
        }
        if (EntityFactionFind.isMachine(livingEntity)) {
            return "machine";
        }
        if (livingEntity instanceof Monster) {
            return "monster";
        }
        if (livingEntity.m_6336_() == MobType.f_21644_) {
            return "water";
        }
        return "other";
    }

    public static List<String> getAllFindFaction(LivingEntity livingEntity) {
        return EntityFactionFind.getAllFindFaction(livingEntity, false);
    }

    public static List<String> getAllFindFaction(LivingEntity livingEntity, boolean bl) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (bl || EntityFactionFind.isTrueDragon(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_true_dragon")) {
            stringList.add("true_dragon");
        }
        if (bl || EntityFactionFind.isEnderman(livingEntity) || livingEntity instanceof EnderMan || livingEntity instanceof EnderDragon || livingEntity instanceof Endermite || livingEntity instanceof Shulker || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_ender")) {
            stringList.add("ender");
        }
        if (bl || livingEntity instanceof Warden || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_sculk")) {
            stringList.add("sculk");
        }
        if (bl || EntityFactionFind.isPiglin(livingEntity) || livingEntity instanceof AbstractPiglin || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_piglin")) {
            stringList.add("piglin");
        }
        if (bl || livingEntity.m_6336_() == MobType.f_21641_ || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "minecraft:undead") || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_undead")) {
            stringList.add("undead");
        }
        if (bl || EntityFactionFind.isIllager(livingEntity) || livingEntity instanceof AbstractIllager || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_illager")) {
            stringList.add("illager");
        }
        if (bl || EntityFactionFind.isVillager(livingEntity) || livingEntity instanceof AbstractVillager || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_villager")) {
            stringList.add("villager");
        }
        if (bl || EntityFactionFind.isWitch(livingEntity) || livingEntity instanceof Witch || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_witch")) {
            stringList.add("witch");
        }
        if (bl || EntityFactionFind.isRaider(livingEntity) || livingEntity instanceof Raider || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_raider")) {
            stringList.add("raider");
        }
        if (bl || EntityFactionFind.isHumanoid(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_humanoid")) {
            stringList.add("humanoid");
        }
        if (bl || EntityFactionFind.isOoze(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_ooze")) {
            stringList.add("ooze");
        }
        if (bl || EntityFactionFind.isPlant(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_plant")) {
            stringList.add("plant");
        }
        if (bl || EntityFactionFind.isFey(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_fey")) {
            stringList.add("fey");
        }
        if (bl || EntityFactionFind.isElemental(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_elemental")) {
            stringList.add("elemental");
        }
        if (bl || EntityFactionFind.isAberration(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_aberration")) {
            stringList.add("aberration");
        }
        if (bl || EntityFactionFind.isCelestial(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_celestial")) {
            stringList.add("celestial");
        }
        if (bl || EntityFactionFind.isFiend(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_fiend")) {
            stringList.add("fiend");
        }
        if (bl || EntityFactionFind.isDragon(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_dragon")) {
            stringList.add("dragon");
        }
        if (bl || livingEntity.m_6336_() == MobType.f_21642_ || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft:arthropod"))) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_arthropod")) {
            stringList.add("arthropod");
        }
        if (bl || livingEntity instanceof WaterAnimal || livingEntity instanceof Animal && livingEntity.m_6336_() == MobType.f_21644_ || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_water_animal")) {
            stringList.add("water_animal");
        }
        if (bl || livingEntity instanceof Animal || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_animal")) {
            stringList.add("animal");
        }
        if (bl || EntityFactionFind.isConstruct(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_construct")) {
            stringList.add("construct");
        }
        if (bl || EntityFactionFind.isMachine(livingEntity) || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_machine")) {
            stringList.add("machine");
        }
        if (bl || livingEntity instanceof Monster || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_monster")) {
            stringList.add("monster");
        }
        if (bl || livingEntity.m_6336_() == MobType.f_21644_ || EntityFactionFind.isThisEntity(livingEntity.m_6095_(), "jerotes:used_faction/stress_water")) {
            stringList.add("water");
        }
        if (bl || stringList.isEmpty()) {
            stringList.add("other");
        }
        return stringList;
    }
}

