/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage;

import com.jerotes.jerotes.spell.SpellRegistry;
import com.jerotes.jerotes.spell.SpellTypeInterface;
import com.jerotes.jerotesvillage.client.CilentInit;
import com.jerotes.jerotesvillage.compat.tacz.MerorsResourceManager;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Other.WonderlinPainting.WonderlinPaintingVariants;
import com.jerotes.jerotesvillage.init.JerotesVillageBlockEntities;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageDecoratedPotPatterns;
import com.jerotes.jerotesvillage.init.JerotesVillageEnchantments;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMenus;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillagePotions;
import com.jerotes.jerotesvillage.init.JerotesVillageRaider;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeSerializers;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeType;
import com.jerotes.jerotesvillage.init.JerotesVillageSpawnPlacements;
import com.jerotes.jerotesvillage.init.JerotesVillageTabs;
import com.jerotes.jerotesvillage.init.JerotesVillageVillagerProfessions;
import com.jerotes.jerotesvillage.network.OtherPacketHandler;
import com.jerotes.jerotesvillage.spell.OtherSpellType;
import com.jerotes.jerotesvillage.util.ViewerNameManager;
import com.jerotes.jerotesvillage.world.features.StructureFeature;
import com.mojang.logging.LogUtils;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="jerotesvillage")
public class JerotesVillage {
    public static final String MODID = "jerotesvillage";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final RecipeBookType TABLET_PRESS_MACHINE = RecipeBookType.create((String)"TABLET_PRESS_MACHINE");

    public JerotesVillage() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        JerotesVillageItems.REGISTRY.register(modEventBus);
        JerotesVillageBlocks.REGISTRY.register(modEventBus);
        JerotesVillageBlockEntities.REGISTRY.register(modEventBus);
        JerotesVillageEntityType.REGISTRY.register(modEventBus);
        JerotesVillageTabs.REGISTRY.register(modEventBus);
        JerotesVillageVillagerProfessions.PROFESSIONS.register(modEventBus);
        JerotesVillageMobEffects.REGISTRY.register(modEventBus);
        JerotesVillageParticleTypes.REGISTRY.register(modEventBus);
        JerotesVillagePotions.REGISTRY.register(modEventBus);
        JerotesVillageEnchantments.REGISTRY.register(modEventBus);
        JerotesVillageMenus.REGISTRY.register(modEventBus);
        JerotesVillageRecipeType.REGISTRY.register(modEventBus);
        JerotesVillageRecipeSerializers.REGISTRY.register(modEventBus);
        JerotesVillageDecoratedPotPatterns.REGISTRY.register(modEventBus);
        StructureFeature.REGISTRY.register(modEventBus);
        WonderlinPaintingVariants.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::initClient);
        modEventBus.addListener(this::commonSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)OtherMainConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)OtherMainConfig.CLIENT_SPEC);
        for (OtherSpellType type : OtherSpellType.values()) {
            SpellRegistry.register((SpellTypeInterface)type);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(OtherPacketHandler::register);
        event.enqueueWork(JerotesVillageItems::setup);
        event.enqueueWork(JerotesVillagePotions::init);
        event.enqueueWork(JerotesVillageSpawnPlacements::init);
        event.enqueueWork(JerotesVillageRaider::addRaiders);
        event.enqueueWork(JerotesVillageDecoratedPotPatterns::expandVanillaDefinitions);
        event.enqueueWork(() -> {
            if (ModList.get().isLoaded("tacz")) {
                if (MerorsResourceManager.needsUpdate()) {
                    LOGGER.info("Updating MerorsEnergeticGun resources...");
                    MerorsResourceManager.initializeResources();
                } else {
                    LOGGER.info("MerorsEnergeticGun resources are up to date");
                }
            }
        });
    }

    private void initClient(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        event.enqueueWork(CilentInit::clientInit);
    }

    @SubscribeEvent
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ViewerNameManager.getInstance());
    }
}

