/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.block.DroughtFire;

import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageDimensions;
import com.jerotes.jerotesvillage.world.teleporter.PiglinSecondRoundWorldPortalShape;
import com.jerotes.jerotesvillage.world.teleporter.PiglinSecondRoundWorldTeleporter;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class PiglinSecondRoundWorldPortalBlock
extends NetherPortalBlock {
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;

    public PiglinSecondRoundWorldPortalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60977_().m_278166_(PushReaction.BLOCK).m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60953_(s -> 15).m_222994_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HATCH});
    }

    public int getPortalType(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)HATCH);
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        super.m_213898_(blockState, level, pos, randomSource);
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        boolean south;
        super.m_213897_(blockState, level, pos, randomSource);
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == JerotesVillageBlocks.SECOND_ROUND_WORLD_BLOCK.get();
        boolean below = level.m_8055_(pos.m_7495_()).m_60734_() == JerotesVillageBlocks.SECOND_ROUND_WORLD_BLOCK.get();
        boolean east = level.m_8055_(pos.m_122029_()).m_60734_() == JerotesVillageBlocks.SECOND_ROUND_WORLD_BLOCK.get();
        boolean west = level.m_8055_(pos.m_122024_()).m_60734_() == JerotesVillageBlocks.SECOND_ROUND_WORLD_BLOCK.get();
        boolean north = level.m_8055_(pos.m_122012_()).m_60734_() == JerotesVillageBlocks.SECOND_ROUND_WORLD_BLOCK.get();
        boolean bl = south = level.m_8055_(pos.m_122019_()).m_60734_() == JerotesVillageBlocks.SECOND_ROUND_WORLD_BLOCK.get();
        if (above || below || east || west || north || south) {
            if (this.getPortalType(blockState) != 1) {
                level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(1)), 2);
            }
        } else if (this.getPortalType(blockState) != 0) {
            level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)), 2);
        }
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 1);
    }

    public static boolean portalSpawn(Level world, BlockPos pos) {
        Optional<PiglinSecondRoundWorldPortalShape> optional = PiglinSecondRoundWorldPortalShape.findEmptyPortalShape((LevelAccessor)world, pos, Direction.Axis.X);
        if (optional.isPresent()) {
            optional.get().createPortalBlocks();
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        Direction.Axis axis = direction.m_122434_();
        Direction.Axis axis1 = (Direction.Axis)blockState.m_61143_((Property)f_54904_);
        boolean flag = axis1 != axis && axis.m_122479_();
        return !flag && !blockState1.m_60713_((Block)this) && !new PiglinSecondRoundWorldPortalShape(levelAccessor, blockPos, axis1).isComplete() ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState1, levelAccessor, blockPos, blockPos1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() + random.m_188500_();
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            double d3 = ((double)random.m_188501_() - 0.5) * 0.5;
            double d4 = ((double)random.m_188501_() - 0.5) * 0.5;
            double d5 = ((double)random.m_188501_() - 0.5) * 0.5;
            int j = random.m_188503_(2) * 2 - 1;
            if (!world.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !world.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = random.m_188501_() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = random.m_188501_() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_6072_() && !entity.m_9236_().m_5776_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else if (entity.m_9236_().m_46472_() == Level.f_46429_) {
                entity.m_20091_();
                this.teleportToDimension(entity, pos, JerotesVillageDimensions.SECOND_ROUND_WORLD);
            } else if (entity.m_9236_().m_46472_() == JerotesVillageDimensions.SECOND_ROUND_WORLD) {
                entity.m_20091_();
                this.teleportToDimension(entity, pos, (ResourceKey<Level>)Level.f_46429_);
            }
        }
    }

    private void teleportToDimension(Entity entity, BlockPos pos, ResourceKey<Level> destinationType) {
        entity.changeDimension(Objects.requireNonNull(Objects.requireNonNull(entity.m_20194_()).m_129880_(destinationType)), (ITeleporter)new PiglinSecondRoundWorldTeleporter(entity.m_20194_().m_129880_(destinationType), pos));
    }
}

