/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.block.HarmoniousWonderland;

import com.jerotes.jerotesvillage.entity.Animal.WonderlandGiantFrogTadpoleEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WonderlandGiantFrogFrogspawnBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty FROG_TYPE = BlockStateProperties.f_61411_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
    private static int minHatchTickDelay = 3600;
    private static int maxHatchTickDelay = 12000;

    public WonderlandGiantFrogFrogspawnBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60966_().m_60955_().m_60910_().m_60918_(SoundType.f_222466_).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public WonderlandGiantFrogFrogspawnBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FROG_TYPE, WATERLOGGED});
    }

    public static int getFrogType(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)FROG_TYPE);
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos;
        Level level;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf((level = blockPlaceContext.m_43725_()).m_6425_(blockPos = blockPlaceContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return WonderlandGiantFrogFrogspawnBlock.mayPlaceOn((BlockGetter)levelReader, blockPos.m_7495_());
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        level.m_186460_(blockPos, (Block)this, WonderlandGiantFrogFrogspawnBlock.getFrogspawnHatchDelay(level.m_213780_()));
    }

    private static int getFrogspawnHatchDelay(RandomSource randomSource) {
        return randomSource.m_216339_(minHatchTickDelay, maxHatchTickDelay);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!this.m_7898_(blockState, (LevelReader)serverLevel, blockPos)) {
            this.destroyBlock((Level)serverLevel, blockPos);
            return;
        }
        this.hatchFrogspawn(serverLevel, blockPos, randomSource);
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (entity.m_6095_().equals(EntityType.f_20450_)) {
            this.destroyBlock(level, blockPos);
        }
    }

    public static boolean mayPlaceOn(BlockGetter blockGetter, BlockPos blockPos) {
        FluidState fluidState = blockGetter.m_6425_(blockPos);
        return fluidState.m_76152_() == Fluids.f_76193_;
    }

    private void hatchFrogspawn(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        this.destroyBlock((Level)serverLevel, blockPos);
        serverLevel.m_5594_(null, blockPos, SoundEvents.f_215687_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.spawnTadpoles(serverLevel, blockPos, randomSource);
    }

    private void destroyBlock(Level level, BlockPos blockPos) {
        level.m_46961_(blockPos, false);
    }

    private void spawnTadpoles(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        int n = randomSource.m_216339_(1, 4);
        for (int i = 1; i <= n; ++i) {
            WonderlandGiantFrogTadpoleEntity tadpole = (WonderlandGiantFrogTadpoleEntity)((EntityType)JerotesVillageEntityType.WONDERLAND_GIANT_FROG_TADPOLE.get()).m_20615_((Level)serverLevel);
            if (tadpole == null) continue;
            double d = (double)blockPos.m_123341_() + this.getRandomTadpolePositionOffset(randomSource);
            double d2 = (double)blockPos.m_123343_() + this.getRandomTadpolePositionOffset(randomSource);
            int n2 = randomSource.m_216339_(1, 361);
            tadpole.setFrogType(WonderlandGiantFrogFrogspawnBlock.getFrogType(serverLevel.m_8055_(blockPos)));
            tadpole.m_7678_(d, (double)blockPos.m_123342_() - 0.5, d2, n2, 0.0f);
            tadpole.m_21530_();
            serverLevel.m_7967_((Entity)tadpole);
        }
    }

    private double getRandomTadpolePositionOffset(RandomSource randomSource) {
        double d = Tadpole.f_218681_ / 2.0f;
        return Mth.m_14008_((double)randomSource.m_188500_(), (double)d, (double)(1.0 - d));
    }
}

