/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.block.PurpleDesert;

import com.jerotes.jerotesvillage.entity.Monster.Elite.BigWitchEntity;
import com.jerotes.jerotesvillage.entity.Monster.Hag.CohortHagEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.recipes.HagReplacementRecipe;
import com.jerotes.jerotesvillage.util.IngredientGet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class NewHagsCauldron
extends Block
implements WorldlyContainerHolder {
    private static final VoxelShape INSIDE = AbstractCauldronBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)AbstractCauldronBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{AbstractCauldronBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), AbstractCauldronBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.f_82685_);

    public NewHagsCauldron() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(50.0f, 10000.0f).m_278166_(PushReaction.BLOCK).m_60955_());
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return INSIDE;
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 1);
    }

    public boolean isPotion(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)JerotesVillageItems.EVIL_POTION.get())}).test(stack);
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        super.m_213898_(blockState, level, pos, randomSource);
        level.m_186460_(pos, (Block)this, 1);
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack hands;
        super.m_6227_(blockstate, world, pos, player, hand, hit);
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.isPotion(player.m_21120_(hand))) {
            return InteractionResult.PASS;
        }
        player.m_21120_(hand);
        if (!this.isPotion(player.m_21120_(hand)) && !(hands = player.m_21120_(hand)).m_150930_(Items.f_41852_)) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                NewHagsCauldron.change(hands, serverLevel, pos);
                if (!player.m_150110_().f_35937_) {
                    hands.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    static void change(ItemStack itemStacks, ServerLevel serverLevel, BlockPos blockPos) {
        serverLevel.m_254849_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 4.0f, Level.ExplosionInteraction.NONE);
        String id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStacks.m_41720_())).m_135827_();
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStacks.m_41720_())).m_135815_();
        boolean bl = false;
        HagReplacementRecipe recipe = NewHagsCauldron.findMatchingRecipe((Level)serverLevel, itemStacks);
        for (ItemStack itemStack : Objects.requireNonNull(serverLevel.m_7654_()).m_278653_().m_278676_(new ResourceLocation("jerotesvillage", "gameplay/jerotesvillage_hag_replacement/" + id + "_" + name)).m_287195_(new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81461_, (Object)serverLevel.m_8055_(blockPos)).m_287289_(LootContextParams.f_81462_, (Object)serverLevel.m_7702_(blockPos)).m_287235_(LootContextParamSets.f_81410_))) {
            BigWitchEntity witch;
            if (!itemStack.m_41619_()) {
                bl = true;
            }
            if (itemStack.m_41720_() == JerotesVillageItems.BIG_WITCH_SPAWN_EGG.get() && (witch = (BigWitchEntity)((EntityType)JerotesVillageEntityType.BIG_WITCH.get()).m_262496_(serverLevel, blockPos, MobSpawnType.EVENT)) != null) {
                witch.m_20334_(0.0, 0.0, 0.0);
                serverLevel.m_7967_((Entity)witch);
            }
            if (itemStack.m_41720_() == JerotesVillageItems.COHORT_HAG_SPAWN_EGG.get()) {
                for (int i = 0; i < 3; ++i) {
                    CohortHagEntity witch2 = (CohortHagEntity)((EntityType)JerotesVillageEntityType.COHORT_HAG.get()).m_262496_(serverLevel, blockPos, MobSpawnType.EVENT);
                    if (witch2 == null) continue;
                    witch2.m_20334_(0.0, 0.0, 0.0);
                    serverLevel.m_7967_((Entity)witch2);
                }
                continue;
            }
            NewHagsCauldron.summonItem(itemStack, serverLevel, blockPos);
        }
        if (!bl) {
            if (NewHagsCauldron.isChangeable((Level)serverLevel, itemStacks) && recipe != null) {
                ItemStack itemStack;
                NonNullList<Ingredient> result = recipe.getResult();
                itemStack = IngredientGet.getRandomItemFromIngredients(result);
                if (itemStack.m_41720_() == JerotesVillageItems.BIG_WITCH_SPAWN_EGG.get()) {
                    BigWitchEntity witch = (BigWitchEntity)((EntityType)JerotesVillageEntityType.BIG_WITCH.get()).m_262496_(serverLevel, blockPos, MobSpawnType.EVENT);
                    if (witch != null) {
                        witch.m_20334_(0.0, 0.0, 0.0);
                        serverLevel.m_7967_((Entity)witch);
                    }
                } else {
                    NewHagsCauldron.summonItem(itemStack, serverLevel, blockPos);
                }
            } else {
                NewHagsCauldron.summonItem(itemStacks.m_255036_(1), serverLevel, blockPos);
            }
        }
    }

    private static boolean isChangeable(Level level, ItemStack items) {
        HagReplacementRecipe recipe = NewHagsCauldron.findMatchingRecipe(level, items);
        return recipe != null;
    }

    @Nullable
    private static HagReplacementRecipe findMatchingRecipe(Level level, ItemStack base) {
        return level.m_7465_().m_44013_((RecipeType)JerotesVillageRecipeType.HAG_REPLACEMENT.get()).stream().filter(recipe -> NewHagsCauldron.matchesIngredients(recipe.getBase(), base)).findFirst().orElse(null);
    }

    private static boolean matchesIngredients(NonNullList<Ingredient> ingredients, ItemStack itemStack) {
        return ingredients.stream().anyMatch(ingredient -> ingredient.test(itemStack));
    }

    static void summonItem(ItemStack itemStack, ServerLevel serverLevel, BlockPos blockPos) {
        ItemEntity entityToSpawn0 = new ItemEntity((Level)serverLevel, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.25, (double)blockPos.m_123343_() + 0.5, itemStack);
        entityToSpawn0.m_32010_(0);
        CompoundTag compoundTag0 = new CompoundTag();
        entityToSpawn0.m_7380_(compoundTag0);
        compoundTag0.m_128376_("Health", (short)10000);
        entityToSpawn0.m_7378_(compoundTag0);
        entityToSpawn0.m_149678_();
        serverLevel.m_7967_((Entity)entityToSpawn0);
        if (serverLevel.m_213780_().m_216339_(1, 10) == 10) {
            serverLevel.m_5594_(null, BlockPos.m_274561_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), JerotesVillageSounds.PURPLE_SAND_HAG_LAUGH_1, SoundSource.NEUTRAL, 5.0f, 1.0f);
        }
    }

    public WorldlyContainer m_5840_(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
        return new InputContainer(blockState, levelAccessor, blockPos);
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public InputContainer(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
            super(1);
            this.state = blockState;
            this.level = levelAccessor;
            this.pos = blockPos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction direction) {
            int[] arrn2;
            int[] arrn = arrn2 = new int[1];
            arrn2[0] = 0;
            return arrn;
        }

        public boolean m_7155_(int n, ItemStack itemStack, @Nullable Direction direction) {
            return !this.changed && !itemStack.m_41619_() && !Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)JerotesVillageItems.EVIL_POTION.get())}).test(itemStack);
        }

        public boolean m_7157_(int n, ItemStack itemStack, Direction direction) {
            return false;
        }

        public void m_6596_() {
            ItemStack itemStack = this.m_8020_(0);
            if (!itemStack.m_41619_()) {
                this.changed = true;
                LevelAccessor levelAccessor = this.level;
                if (levelAccessor instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)levelAccessor;
                    NewHagsCauldron.change(itemStack, serverLevel, this.pos);
                }
                this.m_8016_(0);
            }
        }
    }
}

