/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.particle;

import com.jerotes.jerotesvillage.init.JerotesVillageParticleRenderTypes;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class ContinuousCutLeafAttackParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private float baseScale;
    private float yaw;
    private float pitch;
    private final Quaternionf rotationQuaternion;

    protected ContinuousCutLeafAttackParticle(ClientLevel level, double x, double y, double z, float yaw, float pitch, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.m_108339_(sprites);
        this.yaw = yaw;
        this.pitch = pitch;
        this.rotationQuaternion = new Quaternionf().rotationY(-yaw * ((float)Math.PI / 180)).mul((Quaternionfc)new Quaternionf().rotationY(-1.5707963f)).mul((Quaternionfc)new Quaternionf().rotationX(1.5707963f));
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107230_ = 0.9f;
        this.baseScale = 2.5f;
        this.f_107225_ = 25;
        this.f_107219_ = false;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        float progress = (float)this.f_107224_ / (float)this.f_107225_;
        float easeOut = 1.0f - (float)Math.pow(1.0f - progress, 4.0);
        this.f_107663_ = this.baseScale * (1.0f + easeOut * 1.5f);
        this.f_107230_ = 0.9f * (1.0f - progress);
    }

    public ParticleRenderType m_7556_() {
        return JerotesVillageParticleRenderTypes.CUSTOM_TRANSLUCENT_SHOCKWAVE;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        this.f_107230_ = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + partialTick) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        Vec3 cameraPos = camera.m_90583_();
        float posX = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float posY = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float posZ = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTick);
        int light = this.m_6355_(partialTick);
        Quaternionf rotation = new Quaternionf((Quaternionfc)this.rotationQuaternion);
        this.renderQuad(vertexConsumer, vertices, rotation, posX, posY, posZ, size, light);
        Quaternionf backRotation = new Quaternionf((Quaternionfc)rotation);
        backRotation.mul((Quaternionfc)new Quaternionf().rotationZ((float)Math.PI));
        this.renderQuad(vertexConsumer, vertices, backRotation, posX, posY, posZ, size, light);
    }

    private void renderQuad(VertexConsumer vertexConsumer, Vector3f[] vertices, Quaternionf rotation, float posX, float posY, float posZ, float size, int light) {
        Vector3f[] transformed = new Vector3f[4];
        for (int i = 0; i < 4; ++i) {
            transformed[i] = new Vector3f((Vector3fc)vertices[i]);
            transformed[i].rotate((Quaternionfc)rotation);
            transformed[i].mul(size);
            transformed[i].add(posX, posY, posZ);
        }
        this.makeCornerVertex(vertexConsumer, transformed[0], this.m_5952_(), this.m_5950_(), light);
        this.makeCornerVertex(vertexConsumer, transformed[1], this.m_5952_(), this.m_5951_(), light);
        this.makeCornerVertex(vertexConsumer, transformed[2], this.m_5970_(), this.m_5951_(), light);
        this.makeCornerVertex(vertexConsumer, transformed[0], this.m_5952_(), this.m_5950_(), light);
        this.makeCornerVertex(vertexConsumer, transformed[2], this.m_5970_(), this.m_5951_(), light);
        this.makeCornerVertex(vertexConsumer, transformed[3], this.m_5970_(), this.m_5950_(), light);
    }

    private void makeCornerVertex(VertexConsumer vertexConsumer, Vector3f position, float u, float v, int light) {
        vertexConsumer.m_5483_((double)position.x(), (double)position.y(), (double)position.z()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public void setYaw(float newYaw) {
        this.yaw = newYaw;
        this.rotationQuaternion.rotationY(-newYaw).mul((Quaternionfc)new Quaternionf().rotationYXZ(0.0f, 1.5707963f, 0.0f));
    }

    public float getYaw() {
        return this.yaw;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new ContinuousCutLeafAttackParticle(level, x, y, z, (float)xd, (float)yd, this.sprites);
        }
    }
}

