/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RedstoneDustParticle
extends TextureSheetParticle {
    private static final Vector3f ROTATION_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private final SpriteSet spriteSet;

    public static DisplayParticleProvider provider(SpriteSet spriteSet) {
        return new DisplayParticleProvider(spriteSet);
    }

    protected RedstoneDustParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.5f, 0.5f);
        this.f_107663_ = 1.0f;
        this.f_107225_ = 20;
        this.f_107226_ = 0.0f;
        this.f_107219_ = false;
        this.f_107215_ = vx * 1.0;
        this.f_107216_ = vy * 1.0;
        this.f_107217_ = vz * 1.0;
        this.m_108335_(spriteSet);
    }

    public float m_5902_(float f) {
        return this.f_107663_ * (1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + f) / (float)this.f_107225_ * 0.6f), (float)0.0f, (float)1.0f));
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float f) {
        this.f_107230_ = 1.0f;
        this.renderRotatedParticle(vertexConsumer, camera, f, quaternionf -> quaternionf.mul((Quaternionfc)new Quaternionf().rotationYXZ(0.0f, 1.5707963f, 0.0f)));
    }

    private void renderRotatedParticle(VertexConsumer vertexConsumer, Camera camera, float f, Consumer<Quaternionf> consumer) {
        int n;
        Vec3 vec3 = camera.m_90583_();
        float f2 = (float)(Mth.m_14139_((double)f, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f3 = (float)(Mth.m_14139_((double)f, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f4 = (float)(Mth.m_14139_((double)f, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
        consumer.accept(quaternionf);
        quaternionf.transform(TRANSFORM_VECTOR);
        Vector3f[] arrvector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f5 = this.m_5902_(f);
        for (n = 0; n < 4; ++n) {
            Vector3f vector3f = arrvector3f[n];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f5);
            vector3f.add(f2, f3, f4);
        }
        n = this.m_6355_(f);
        this.makeCornerVertex(vertexConsumer, arrvector3f[0], this.m_5952_(), this.m_5950_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[1], this.m_5952_(), this.m_5951_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[2], this.m_5970_(), this.m_5951_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[3], this.m_5970_(), this.m_5950_(), n);
    }

    private void makeCornerVertex(VertexConsumer vertexConsumer, Vector3f vector3f, float f, float f2, int n) {
        vertexConsumer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(f, f2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(n).m_5752_();
    }

    public int m_6355_(float f) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.spriteSet);
    }

    public static class DisplayParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public DisplayParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RedstoneDustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

