/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.particle;

import com.jerotes.jerotesvillage.init.JerotesVillageParticleRenderTypes;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ReturnShockwaveParticle
extends TextureSheetParticle {
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private final SpriteSet sprites;
    private float baseScale;
    private float distortionProgress;
    private static final Vector3f ROTATION_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();

    protected ReturnShockwaveParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.m_108339_(sprites);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107230_ = 0.9f;
        this.baseScale = 2.0f;
        this.f_107225_ = 25;
        this.f_107219_ = false;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        float progress = (float)this.f_107224_ / (float)this.f_107225_;
        float easeOut = 1.0f - (float)Math.pow(1.0f - progress, 4.0);
        this.f_107663_ = this.baseScale * (1.0f + easeOut * 2.0f);
        this.f_107230_ = 0.9f * (1.0f - progress);
        this.distortionProgress = easeOut;
    }

    public ParticleRenderType m_7556_() {
        return JerotesVillageParticleRenderTypes.CUSTOM_TRANSLUCENT_SHOCKWAVE;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float f) {
        this.f_107230_ = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + f) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        this.renderRotatedParticle(vertexConsumer, camera, f, quaternionf -> quaternionf.mul((Quaternionfc)new Quaternionf().rotationYXZ(0.0f, 1.5707963f, 0.0f)));
        this.renderRotatedParticleDown(vertexConsumer, camera, f, quaternionf -> quaternionf.mul((Quaternionfc)new Quaternionf().rotationYXZ(0.0f, 1.5707963f, 0.0f)));
    }

    private void renderRotatedParticle(VertexConsumer vertexConsumer, Camera camera, float f, Consumer<Quaternionf> consumer) {
        int n;
        Vec3 vec3 = camera.m_90583_();
        float f2 = (float)(Mth.m_14139_((double)f, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f3 = (float)(Mth.m_14139_((double)f, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f4 = (float)(Mth.m_14139_((double)f, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
        consumer.accept(quaternionf);
        Vector3f[] arrvector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f5 = this.m_5902_(f);
        for (n = 0; n < 4; ++n) {
            Vector3f vector3f = arrvector3f[n];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f5);
            vector3f.add(f2, f3, f4);
        }
        n = this.m_6355_(f);
        this.makeCornerVertex(vertexConsumer, arrvector3f[0], this.m_5952_(), this.m_5950_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[1], this.m_5952_(), this.m_5951_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[2], this.m_5970_(), this.m_5951_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[3], this.m_5970_(), this.m_5950_(), n);
    }

    private void renderRotatedParticleDown(VertexConsumer vertexConsumer, Camera camera, float f, Consumer<Quaternionf> consumer) {
        int n;
        Vec3 vec3 = camera.m_90583_();
        float f2 = (float)(Mth.m_14139_((double)f, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f3 = (float)(Mth.m_14139_((double)f, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f4 = (float)(Mth.m_14139_((double)f, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
        consumer.accept(quaternionf);
        quaternionf.transform(TRANSFORM_VECTOR);
        Vector3f[] arrvector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f5 = this.m_5902_(f);
        for (n = 0; n < 4; ++n) {
            Vector3f vector3f = arrvector3f[n];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f5);
            vector3f.add(f2, f3, f4);
        }
        n = this.m_6355_(f);
        this.makeCornerVertex(vertexConsumer, arrvector3f[0], this.m_5952_(), this.m_5950_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[1], this.m_5952_(), this.m_5951_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[2], this.m_5970_(), this.m_5951_(), n);
        this.makeCornerVertex(vertexConsumer, arrvector3f[3], this.m_5970_(), this.m_5950_(), n);
    }

    private void makeCornerVertex(VertexConsumer vertexConsumer, Vector3f vector3f, float f, float f2, int n) {
        vertexConsumer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(f, f2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(n).m_5752_();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new ReturnShockwaveParticle(level, x, y, z, this.sprites);
        }
    }
}

