/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.renderer;

import com.jerotes.jerotesvillage.entity.Animal.WonderlandLiCatEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CatCollarLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Cat;

public class WonderlandLiCatRenderer
extends MobRenderer<Cat, CatModel<Cat>> {
    private static final ResourceLocation BROWN_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/brown.png");
    private static final ResourceLocation ORANGE_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/orange.png");
    private static final ResourceLocation BLACK_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/black.png");
    private static final ResourceLocation WHITE_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/white.png");
    private static final ResourceLocation CALICO_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/calico.png");
    private static final ResourceLocation COW_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/cow.png");
    private static final ResourceLocation TORTOISESHELL_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/tortoiseshell.png");
    private static final ResourceLocation YELLOW_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/wonderland_li_cat/yellow.png");

    public WonderlandLiCatRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CatModel(context.m_174023_(ModelLayers.f_171272_)), 0.4f);
        this.m_115326_((RenderLayer)new CatCollarLayer((RenderLayerParent)this, context.m_174027_()));
    }

    protected void scale(Cat cat, PoseStack poseStack, float f) {
        if (cat instanceof WonderlandLiCatEntity) {
            WonderlandLiCatEntity wonderlandLiCatEntity = (WonderlandLiCatEntity)cat;
            poseStack.m_85841_(0.8f + (float)wonderlandLiCatEntity.getCatWild() * 0.05f, 0.8f + (float)wonderlandLiCatEntity.getCatWild() * 0.05f, 0.8f + (float)wonderlandLiCatEntity.getCatWild() * 0.05f);
        }
        super.m_7546_((LivingEntity)cat, poseStack, f);
    }

    public void render(Cat cat, float f, float f2, PoseStack poseStack, MultiBufferSource multiBufferSource, int n) {
        if (cat instanceof WonderlandLiCatEntity) {
            WonderlandLiCatEntity wonderlandLiCatEntity = (WonderlandLiCatEntity)cat;
            this.f_114477_ = 0.4f + (float)wonderlandLiCatEntity.getCatWild() * 0.025f;
        }
        super.m_7392_((Mob)cat, f, f2, poseStack, multiBufferSource, n);
    }

    public ResourceLocation getTextureLocation(Cat cat) {
        if (cat instanceof WonderlandLiCatEntity) {
            WonderlandLiCatEntity wonderlandLiCatEntity = (WonderlandLiCatEntity)cat;
            if (wonderlandLiCatEntity.getCatColor() == 1) {
                return BROWN_LOCATION;
            }
            if (wonderlandLiCatEntity.getCatColor() == 2) {
                return BLACK_LOCATION;
            }
            if (wonderlandLiCatEntity.getCatColor() == 3) {
                return ORANGE_LOCATION;
            }
            if (wonderlandLiCatEntity.getCatColor() == 4) {
                return CALICO_LOCATION;
            }
            if (wonderlandLiCatEntity.getCatColor() == 5) {
                return COW_LOCATION;
            }
            if (wonderlandLiCatEntity.getCatColor() == 6) {
                return TORTOISESHELL_LOCATION;
            }
            if (wonderlandLiCatEntity.getCatColor() == 7) {
                return YELLOW_LOCATION;
            }
            return WHITE_LOCATION;
        }
        return BROWN_LOCATION;
    }
}

