/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.compat.jei.categories;

import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.recipes.HagReplacementRecipe;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HagReplacementRecipeCategory
implements IRecipeCategory<HagReplacementRecipe> {
    public static final RecipeType<HagReplacementRecipe> HAG_REPLACEMENT = RecipeType.create((String)"jerotesvillage", (String)"hag_replacement", HagReplacementRecipe.class);
    private final Component title = Component.m_237115_((String)"gui.jerotesvillage.hag_replacement");
    private final IDrawable background;
    private final IDrawable icon;

    public HagReplacementRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("jerotesvillage", "textures/gui/container/hag_replacement.png");
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)JerotesVillageItems.NEW_HAGS_CAULDRON.get()));
        this.background = helper.createDrawable(backgroundImage, 7, 9, 162, 72);
    }

    public RecipeType<HagReplacementRecipe> getRecipeType() {
        return HAG_REPLACEMENT;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 72;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HagReplacementRecipe recipe, IFocusGroup focusGroup) {
        NonNullList<Ingredient> base = recipe.getBase();
        NonNullList<Ingredient> result = recipe.getResult();
        for (Ingredient ingredient : base) {
            if (ingredient.m_43947_()) continue;
            for (Ingredient value : base) {
                ItemStack[] itemStacks = value.m_43908_();
                builder.addSlot(RecipeIngredientRole.INPUT, 9, 19).addItemStacks(Arrays.asList(itemStacks));
            }
        }
        for (Ingredient ingredient : result) {
            if (ingredient.m_43947_()) continue;
            for (int row = 0; row < 4; ++row) {
                for (int column = 0; column < 6; ++column) {
                    int inputIndex = row * 6 + column;
                    if (inputIndex >= result.size()) continue;
                    ItemStack[] itemStacks = ((Ingredient)result.get(inputIndex)).m_43908_();
                    builder.addSlot(RecipeIngredientRole.OUTPUT, 55 + column * 18, 1 + row * 18).addItemStacks(Arrays.asList(itemStacks));
                }
            }
        }
    }

    public void draw(HagReplacementRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
    }
}

