/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.compat.jei.categories;

import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.recipes.TabletPressingRecipe;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TabletPressingRecipeCategory
implements IRecipeCategory<TabletPressingRecipe> {
    public static final RecipeType<TabletPressingRecipe> TABLET_PRESSING = RecipeType.create((String)"jerotesvillage", (String)"tablet_pressing", TabletPressingRecipe.class);
    protected final IDrawableAnimated arrow;
    private final Component title = Component.m_237115_((String)"gui.jerotesvillage.tablet_pressing");
    private final IDrawable background;
    private final IDrawable icon;

    public TabletPressingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("jerotesvillage", "textures/gui/container/tablet_press_machine.png");
        ResourceLocation arrowImage = new ResourceLocation("jerotesvillage", "textures/gui/sprites/container/tablet_press_machine/tablet_press_machine_progress_other.png");
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_BLOCK_PHYSICIAN.get()));
        this.background = helper.createDrawable(backgroundImage, 55, 16, 64, 59);
        this.arrow = helper.drawableBuilder(arrowImage, 0, 0, 64, 32).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, false);
    }

    public RecipeType<TabletPressingRecipe> getRecipeType() {
        return TABLET_PRESSING;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 64;
    }

    public int getHeight() {
        return 59;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TabletPressingRecipe recipe, IFocusGroup focusGroup) {
        ItemStack[] itemStacks;
        ItemStack result = recipe.getResult();
        NonNullList<Ingredient> base = recipe.getBase();
        NonNullList<Ingredient> addition = recipe.getAddition();
        for (Ingredient ingredient : addition) {
            if (ingredient.m_43947_()) continue;
            for (Ingredient value : addition) {
                itemStacks = value.m_43908_();
                builder.addSlot(RecipeIngredientRole.INPUT, 24, 1).addItemStacks(Arrays.asList(itemStacks));
            }
        }
        for (Ingredient ingredient : base) {
            if (ingredient.m_43947_()) continue;
            for (Ingredient value : base) {
                itemStacks = value.m_43908_();
                builder.addSlot(RecipeIngredientRole.CATALYST, 1, 42).addItemStacks(Arrays.asList(itemStacks));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 24, 42).addItemStack(result);
    }

    public void draw(TabletPressingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.arrow.draw(guiGraphics, 0, 10);
    }
}

