/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.compat.tacz;

import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.resource.CommonAssetsManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MerorsResourceManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Instant FIXED_TIME = Instant.parse("2024-01-01T00:00:00.000Z");
    private static final Path BACKUP_PATH = FMLPaths.GAMEDIR.get().resolve("tacz_backup");
    private static final SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private static final int MAX_BACKUP_COUNT = 5;
    private static final String MOD_RESOURCE_FOLDER = "MerorsEnergeticGun1.20.1";

    private MerorsResourceManager() {
    }

    public static void initializeResources() {
        try {
            Path targetDir = FMLPaths.GAMEDIR.get().resolve("tacz").resolve(MOD_RESOURCE_FOLDER);
            Path sourcePath = Paths.get(MOD_RESOURCE_FOLDER, new String[0]);
            LOGGER.info("Initializing MerorsEnergeticGun resources...");
            LOGGER.info("Source: {}", (Object)sourcePath);
            LOGGER.info("Target: {}", (Object)targetDir);
            MerorsResourceManager.copyModDirectory(sourcePath.toString(), targetDir.getParent(), MOD_RESOURCE_FOLDER);
            MerorsResourceManager.reloadTaczResources();
            LOGGER.info("Resources initialized successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize resources", (Throwable)e);
        }
    }

    private static void reloadTaczResources() {
        try {
            LOGGER.info("Reloading Tacz resources...");
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> MerorsResourceManager::reloadClient);
            DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> MerorsResourceManager::reloadServer);
            LOGGER.info("Tacz resources reloaded successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to reload Tacz resources", (Throwable)e);
        }
    }

    private static void reloadClient() {
        try {
            ClientAssetsManager.reloadAllPack();
            LOGGER.info("ClientAssetsManager.reloadAllPack() called successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to call ClientAssetsManager.reloadAllPack()", (Throwable)e);
            MerorsResourceManager.fallbackReload();
        }
    }

    private static void reloadServer() {
        try {
            CommonAssetsManager.reloadAllPack();
            LOGGER.info("CommonAssetsManager.reloadAllPack() called successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to call CommonAssetsManager.reloadAllPack()", (Throwable)e);
        }
    }

    private static void fallbackReload() {
        LOGGER.warn("Using fallback reload method");
        try {
            Class<?> reloadClass = Class.forName("com.tacz.guns.ReloadCommand");
            Method reloadMethod = reloadClass.getMethod("reloadClient", new Class[0]);
            reloadMethod.invoke(null, new Object[0]);
            LOGGER.info("Fallback reload via reflection successful");
        }
        catch (Exception e) {
            LOGGER.error("Fallback reload via reflection failed", (Throwable)e);
        }
    }

    public static void copyModDirectory(String srcPath, Path root, String path) {
        String correctedPath = "/MerorsEnergeticGun1.20.1";
        LOGGER.info("Using corrected path: {}", (Object)correctedPath);
        URL url = MerorsResourceManager.class.getResource(correctedPath);
        if (url == null) {
            LOGGER.error("Resource not found with corrected path: {}", (Object)correctedPath);
            return;
        }
        try {
            MerorsResourceManager.copyFolder(url.toURI(), root.resolve(path));
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Failed to copy directory", (Throwable)e);
        }
    }

    public static void copyModFile(String srcPath, Path root, String path) {
        URL url = MerorsResourceManager.class.getResource(srcPath);
        if (url == null) {
            LOGGER.warn("File not found in JAR: {}", (Object)srcPath);
            return;
        }
        try {
            File targetFile = root.resolve(path).toFile();
            FileUtils.copyURLToFile((URL)url, (File)targetFile);
            LOGGER.debug("Copied file: {} -> {}", (Object)srcPath, (Object)targetFile);
        }
        catch (IOException e) {
            LOGGER.error("Failed to copy file: {}", (Object)srcPath, (Object)e);
        }
    }

    @Nullable
    public static InputStream readModFile(String filePath) {
        URL url = MerorsResourceManager.class.getResource(filePath);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            LOGGER.error("Failed to read file: {}", (Object)filePath, (Object)e);
            return null;
        }
    }

    public static boolean needsUpdate() {
        Path targetDir = FMLPaths.GAMEDIR.get().resolve("tacz").resolve(MOD_RESOURCE_FOLDER);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            return true;
        }
        Path versionFile = targetDir.resolve(".version");
        if (!Files.exists(versionFile, new LinkOption[0])) {
            return true;
        }
        try {
            String currentVersion = MerorsResourceManager.getCurrentModVersion();
            String installedVersion = Files.readString(versionFile).trim();
            return !currentVersion.equals(installedVersion);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to read version file", (Throwable)e);
            return true;
        }
    }

    private static void copyFolder(URI sourceURI, Path targetPath) throws IOException {
        LOGGER.info("Copying folder from {} to {}", (Object)sourceURI, (Object)targetPath);
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            LOGGER.info("Target directory exists, creating backup...");
            MerorsResourceManager.backupDirectory(targetPath);
            MerorsResourceManager.deleteDirectory(targetPath);
            LOGGER.info("Old directory removed");
        }
        Files.createDirectories(targetPath, new FileAttribute[0]);
        try (Stream<Path> stream = Files.walk(Paths.get(sourceURI), Integer.MAX_VALUE, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    String relativePath = sourceURI.relativize(source.toUri()).toString();
                    Path target = targetPath.resolve(relativePath);
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                        LOGGER.debug("Copied: {} -> {}", (Object)relativePath, (Object)target);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error copying file", (Throwable)e);
                }
            });
        }
        MerorsResourceManager.writeVersionFile(targetPath);
    }

    private static void backupDirectory(Path targetPath) throws IOException {
        String dirName = targetPath.getFileName().toString();
        Path backupDir = BACKUP_PATH.resolve(dirName);
        if (!Files.exists(backupDir, new LinkOption[0])) {
            Files.createDirectories(backupDir, new FileAttribute[0]);
        }
        MerorsResourceManager.cleanupOldBackups(backupDir);
        String timestamp = BACKUP_DATE_FORMAT.format(new Date());
        Path backupFile = backupDir.resolve(String.format("%s-%s.zip", dirName, timestamp));
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile.toFile()));){
            FileTime fixedTime = FileTime.from(FIXED_TIME);
            Files.walk(targetPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    String relativePath = targetPath.relativize((Path)file).toString();
                    ZipEntry entry = new ZipEntry(relativePath);
                    entry.setLastModifiedTime(fixedTime);
                    zos.putNextEntry(entry);
                    Files.copy(file, zos);
                    zos.closeEntry();
                    LOGGER.debug("Backed up: {}", (Object)relativePath);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to backup file: {}", file, (Object)e);
                }
            });
        }
        LOGGER.info("Backup created: {}", (Object)backupFile);
    }

    private static void cleanupOldBackups(Path backupDir) {
        try {
            File[] backupFiles = backupDir.toFile().listFiles((dir, name) -> name.endsWith(".zip"));
            if (backupFiles == null || backupFiles.length <= 5) {
                return;
            }
            Arrays.sort(backupFiles, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
            for (int i = 0; i < backupFiles.length - 5; ++i) {
                File oldBackup = backupFiles[i];
                if (!FileUtils.deleteQuietly((File)oldBackup)) continue;
                LOGGER.info("Deleted old backup: {}", (Object)oldBackup.getName());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to cleanup old backups", (Throwable)e);
        }
    }

    private static void deleteDirectory(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void writeVersionFile(Path targetDir) throws IOException {
        String version = MerorsResourceManager.getCurrentModVersion();
        Path versionFile = targetDir.resolve(".version");
        Files.writeString(versionFile, (CharSequence)version, new OpenOption[0]);
    }

    private static String getCurrentModVersion() {
        return "1.0.0";
    }

    public static List<String> listResources() {
        ArrayList<String> resources = new ArrayList<String>();
        String resourcePath = "/MerorsEnergeticGun1.20.1";
        try {
            URL url = MerorsResourceManager.class.getResource(resourcePath);
            if (url == null) {
                return resources;
            }
            try (Stream<Path> stream = Files.walk(Paths.get(url.toURI()), Integer.MAX_VALUE, new FileVisitOption[0]);){
                stream.map(path -> resourcePath + "/" + path.getFileName().toString()).forEach(resources::add);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to list resources", (Throwable)e);
        }
        return resources;
    }
}

