/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal.Fish;

import com.jerotes.jerotes.entity.CatchEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotesvillage.entity.Boss.Biome.GemstoneMalignasaurEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AbyssalerEntity
extends AbstractFish
implements NeutralMob,
JerotesEntity {
    public AnimationState attackAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(AbyssalerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(AbyssalerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int airTick = 0;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public AbyssalerEntity(EntityType<? extends AbyssalerEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, false);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)JerotesVillageItems.ABYSSALER_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.ABYSSALER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.ABYSSALER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.ABYSSALER_HURT;
    }

    protected SoundEvent m_5501_() {
        return JerotesVillageSounds.ABYSSALER_SWIM;
    }

    protected SoundEvent m_5699_() {
        return JerotesVillageSounds.ABYSSALER_FLOP;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (this.m_21223_() < this.m_21233_() / 2.0f) {
            return Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public static AttributeSupplier.Builder m_27495_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 1.5);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, GemstoneMalignasaurEntity.class, 32.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Pufferfish.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(4, (Goal)new AbyssalerSwimGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Guardian.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AbyssalerEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean downFish() {
        return this.airTick >= 150;
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(6);
            this.setAnimationState("attack");
        }
        if ((bl = super.m_7327_(entity)) && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.ABYSSALER_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (!this.m_20069_() && this.airTick < 200) {
            this.airTick += Math.min(200, this.airTick + 1);
        }
        if (this.m_20069_() && this.airTick > 0) {
            this.airTick = Math.max(0, this.airTick - 5);
        }
    }

    public int getAirTick() {
        return this.airTick;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("AirTick", this.airTick);
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.airTick = compoundTag.m_128451_("AirTick");
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_6872_(ItemStack itemStack) {
        CatchEntity.saveDefaultDataToCatchTag((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        this.m_7380_(compoundTag);
        itemStack.m_41739_(compoundTag);
    }

    public void m_142278_(CompoundTag compoundTag) {
        CatchEntity.loadDefaultDataFromCatchTag((Mob)this, (CompoundTag)compoundTag);
        this.m_7378_(compoundTag);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec3);
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    static class AbyssalerSwimGoal
    extends RandomSwimmingGoal {
        private final AbstractFish fish;

        public AbyssalerSwimGoal(AbstractFish abstractFish) {
            super((PathfinderMob)abstractFish, 1.0, 40);
            this.fish = abstractFish;
        }
    }
}

