/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ArmorEntity;
import com.jerotes.jerotes.entity.CanBeIllagerFactionEntity;
import com.jerotes.jerotes.entity.HornableEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesIllagerFactionEntityHelpIllagerGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.ItemBaseGiantBeastArmor;
import com.jerotes.jerotes.item.ItemBeastArmor;
import com.jerotes.jerotes.item.ItemGiantBeastArmor;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CorrosiverEntity;
import com.jerotes.jerotesvillage.entity.Monster.Elite.FrostYetiEntity;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowParentGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeTemptGoal;
import com.jerotes.jerotesvillage.goal.GiantMonsterWrestleAttackGoal;
import com.jerotes.jerotesvillage.goal.GiantMonsterWrestleTargetGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.item.BitterColdBell;
import com.jerotes.jerotesvillage.item.SpirvePincer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GiantMonsterEntity
extends BaseTamableAnimalEntity
implements CanBeIllagerFactionEntity,
HornableEntity,
NeutralMob,
ArmorEntity,
Saddleable,
ContainerListener,
HasCustomInventoryScreen,
Shearable,
IForgeShearable {
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HAIR_TICK = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HORN_TICK = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WRESTLE_COOLDOWN = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> NO_HAIR = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_HORN = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_CHAIN = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BELL = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BITTER_COLD_BELL = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ILLAGER_FACTION = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("BDBEC7F5-C1AE-B628-0905-EBFCCB94B1E3");
    private static final UUID ARMOR_TOUGHNESS_MODIFIER_UUID = UUID.fromString("6E83DF5F-4A12-6F5F-7DC8-CFC26367E728");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("115D4DA3-C3D2-8031-E678-918AADADF94C");
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50126_), new ItemStack((ItemLike)Blocks.f_50354_), new ItemStack((ItemLike)Blocks.f_50449_), new ItemStack((ItemLike)Blocks.f_50568_), new ItemStack((ItemLike)JerotesVillageItems.ICE_ROCK.get())});
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(GiantMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private int sitTick = 0;
    private int bellTick = 0;
    @Nullable
    private LivingEntity notAttackTarget;
    @Nullable
    private UUID notAttackTargetUUID;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public SimpleContainer inventory() {
        return this.inventory;
    }

    public GiantMonsterEntity(EntityType<? extends GiantMonsterEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.6f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
        this.createInventory();
    }

    public int getInventorySize() {
        return 2;
    }

    protected void m_8022_() {
        boolean bl = !(this.m_6688_() instanceof Mob) || this.m_6688_().m_6095_().m_204039_(EntityTypeTags.f_13121_);
        boolean bl2 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, bl);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, bl && bl2);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, bl);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, bl);
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
        this.setArmorEquipment(this.inventory.m_8020_(1));
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_5757_(Container p_30548_) {
        ItemStack itemStack = this.getArmor();
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
        ItemStack itemStack2 = this.getArmor();
        if (this.f_19797_ > 20 && this.isArmor(itemStack2) && itemStack != itemStack2) {
            this.m_5496_(JerotesSounds.USE_BEAST_ARMOR, 0.5f, 1.0f);
        }
    }

    public SoundEvent m_246265_() {
        return JerotesSounds.USE_SADDLE;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 110.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.9);
        builder = builder.m_22268_(Attributes.f_22281_, 12.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.85);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CorrosiverEntity.class, 32.0f, 1.4, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new GiantMonsterWrestleAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new JerotesAnimalChangeTemptGoal(this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new JerotesAnimalChangeFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Animal.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesIllagerFactionEntityHelpIllagerGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new GiantMonsterWrestleTargetGoal<GiantMonsterEntity>(this, GiantMonsterEntity.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((GiantMonsterEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.GIANT_MONSTER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.GIANT_MONSTER_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.GIANT_MONSTER_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        if (this.isBells()) {
            ++this.bellTick;
            if (this.bellTick >= 10) {
                this.bellTick = 0;
            }
        }
        if (this.isBells() && this.bellTick == 0) {
            this.bellUse(blockPos);
        }
        this.m_5496_(JerotesVillageSounds.GIANT_MONSTER_WALK, 0.15f, 1.0f);
    }

    public int m_8100_() {
        return 600;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.4f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public void bellUse(BlockPos blockPos) {
        Level level;
        this.m_5496_(SoundEvents.f_11699_, 8.0f, 1.0f);
        this.m_9236_().m_142346_((Entity)this, GameEvent.f_157792_, blockPos);
        if (this.isBell() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.m_8843_(blockPos)) {
                List list = serverLevel.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
                for (LivingEntity villager : list) {
                    if (villager == null || !villager.m_6084_() || villager.m_213877_() || !blockPos.m_203195_((Position)villager.m_20182_(), 32.0)) continue;
                    villager.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)serverLevel.m_46467_());
                }
            }
            List listIllager = serverLevel.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(48.0, 48.0, 48.0));
            listIllager.removeIf(livingEntityDeter -> !livingEntityDeter.m_6084_() || livingEntityDeter.m_213877_() || !blockPos.m_203195_((Position)livingEntityDeter.m_20182_(), 32.0) || !livingEntityDeter.m_6095_().m_204039_(EntityTypeTags.f_13121_));
            for (LivingEntity livingEntityDeter2 : listIllager) {
                if (livingEntityDeter2 == null || !livingEntityDeter2.m_6084_() || livingEntityDeter2.m_213877_() || !blockPos.m_203195_((Position)livingEntityDeter2.m_20182_(), 32.0) || !livingEntityDeter2.m_6095_().m_204039_(EntityTypeTags.f_13121_) || livingEntityDeter2.m_9236_().f_46443_) continue;
                livingEntityDeter2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60));
            }
            if (!listIllager.isEmpty()) {
                serverLevel.m_5594_(null, blockPos, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            int n = (int)listIllager.stream().filter(livingEntity -> blockPos.m_203195_((Position)livingEntity.m_20182_(), 48.0)).count();
            int n2 = Mth.m_14045_((int)((n - 21) / -2), (int)3, (int)15);
            for (int i = 0; i < n2; ++i) {
                MutableInt mutableInt = new MutableInt(16700985);
                int n3 = mutableInt.addAndGet(5);
                double d4 = (double)FastColor.ARGB32.m_13665_((int)n3) / 255.0;
                double d5 = (double)FastColor.ARGB32.m_13667_((int)n3) / 255.0;
                double d6 = (double)FastColor.ARGB32.m_13669_((int)n3) / 255.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175827_, this.m_20208_(1.2), this.m_20187_(), this.m_20262_(1.2), 0, d4, d5, d6, 0.0);
            }
        }
        if (this.isBitterColdBell() && this.m_9236_() instanceof ServerLevel) {
            BitterColdBell.YetiAway((LivingEntity)this);
        }
    }

    @Nullable
    public GiantMonsterEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        GiantMonsterEntity giantMonster = (GiantMonsterEntity)((EntityType)JerotesVillageEntityType.GIANT_MONSTER.get()).m_20615_((Level)serverLevel);
        if (giantMonster != null && (uUID = this.m_21805_()) != null) {
            giantMonster.m_21816_(uUID);
            giantMonster.m_7105_(true);
        }
        return giantMonster;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)JerotesVillageItems.GIANT_MONSTER_HORN.get(), 2);
        }
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -48000 : 0);
    }

    public boolean isHorn() {
        return !this.m_6162_() && !this.isNoHorn();
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    public boolean canWearArmor() {
        return true;
    }

    public void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            double n3;
            double n2;
            ItemGiantBeastArmor armor;
            int n;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22120_(ARMOR_TOUGHNESS_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof ItemGiantBeastArmor && (n = (armor = (ItemGiantBeastArmor)item).getProtection()) != 0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Giant Beast Armor bonus", (double)n, AttributeModifier.Operation.ADDITION));
            }
            if ((item = itemStack.m_41720_()) instanceof ItemBeastArmor && (n2 = (armor = (ItemBeastArmor)item).getToughness()) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22118_(new AttributeModifier(ARMOR_TOUGHNESS_MODIFIER_UUID, "Giant Beast Armor toughness bonus", n2, AttributeModifier.Operation.ADDITION));
            }
            if ((item = itemStack.m_41720_()) instanceof ItemBeastArmor && (n3 = (armor = (ItemBeastArmor)item).getKnockbackResistance() * 0.1) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Giant Beast Armor knockback resistance bonus", n3, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float forward = passenger.f_20902_;
                float strafe = passenger.f_20900_ / 2.0f;
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public boolean isNoHair() {
        return (Boolean)this.m_20088_().m_135370_(NO_HAIR);
    }

    public boolean isNoHorn() {
        return (Boolean)this.m_20088_().m_135370_(NO_HORN);
    }

    public boolean isChain() {
        return (Boolean)this.m_20088_().m_135370_(IS_CHAIN);
    }

    public boolean isBells() {
        return (Boolean)this.m_20088_().m_135370_(IS_BELL) != false || (Boolean)this.m_20088_().m_135370_(IS_BITTER_COLD_BELL) != false;
    }

    public boolean isBell() {
        return (Boolean)this.m_20088_().m_135370_(IS_BELL);
    }

    public boolean isBitterColdBell() {
        return (Boolean)this.m_20088_().m_135370_(IS_BITTER_COLD_BELL);
    }

    public boolean isIllagerFaction() {
        return (Boolean)this.m_20088_().m_135370_(IS_ILLAGER_FACTION);
    }

    public void setNoHair(boolean bl) {
        this.m_20088_().m_135381_(NO_HAIR, (Object)bl);
    }

    public void setNoHorn(boolean bl) {
        this.m_20088_().m_135381_(NO_HORN, (Object)bl);
    }

    public void setChain(boolean bl) {
        this.m_20088_().m_135381_(IS_CHAIN, (Object)bl);
    }

    public void setBell(boolean bl) {
        this.m_20088_().m_135381_(IS_BELL, (Object)bl);
    }

    public void setBitterColdBell(boolean bl) {
        this.m_20088_().m_135381_(IS_BITTER_COLD_BELL, (Object)bl);
    }

    public void setIllagerFaction(boolean bl) {
        this.m_20088_().m_135381_(IS_ILLAGER_FACTION, (Object)bl);
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.setIllagerFaction(false);
            this.m_21051_(Attributes.f_22276_).m_22100_(135.0);
            this.m_21153_(135.0f);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
            this.m_21051_(Attributes.f_22277_).m_22100_(48.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(110.0);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
            this.m_21051_(Attributes.f_22277_).m_22100_(24.0);
        }
    }

    protected void setFlag(int n, boolean n2) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (n2) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | n)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~n)));
        }
    }

    protected boolean getFlag(int n) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & n) != 0;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void setHairTick(int n) {
        this.m_20088_().m_135381_(HAIR_TICK, (Object)n);
    }

    public int getHairTick() {
        return (Integer)this.m_20088_().m_135370_(HAIR_TICK);
    }

    public void setHornTick(int n) {
        this.m_20088_().m_135381_(HORN_TICK, (Object)n);
    }

    public int getHornTick() {
        return (Integer)this.m_20088_().m_135370_(HORN_TICK);
    }

    public void setWrestleCooldown(int n) {
        this.m_20088_().m_135381_(WRESTLE_COOLDOWN, (Object)n);
    }

    public int getWrestleCooldown() {
        return (Integer)this.m_20088_().m_135370_(WRESTLE_COOLDOWN);
    }

    public boolean isWearingArmor() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isWarBeastArmor() {
        return false;
    }

    public boolean isGiantBeastArmor() {
        return true;
    }

    public boolean isArmor(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ItemBaseGiantBeastArmor;
    }

    @Nullable
    public LivingEntity getNotAttackTarget() {
        Entity entity;
        if (this.notAttackTarget == null && this.notAttackTargetUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.notAttackTargetUUID)) instanceof LivingEntity) {
            this.notAttackTarget = (LivingEntity)entity;
        }
        return this.notAttackTarget;
    }

    public void setNotAttackTarget(@Nullable LivingEntity livingEntity) {
        this.notAttackTarget = livingEntity;
        this.notAttackTargetUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SitTick", this.sitTick);
        compoundTag.m_128405_("BellTick", this.bellTick);
        compoundTag.m_128405_("HairTick", this.getHairTick());
        compoundTag.m_128405_("HornTick", this.getHornTick());
        compoundTag.m_128405_("WrestleCooldown", this.getWrestleCooldown());
        compoundTag.m_128379_("IsNoHair", this.isNoHair());
        compoundTag.m_128379_("IsNoHorn", this.isNoHorn());
        compoundTag.m_128379_("IsChain", this.isChain());
        compoundTag.m_128379_("IsBell", this.isBell());
        compoundTag.m_128379_("IsBitterColdBell", this.isBitterColdBell());
        compoundTag.m_128379_("IsIllagerFaction", this.isIllagerFaction());
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        if (this.notAttackTargetUUID != null) {
            compoundTag.m_128362_("NotAttackTarget", this.notAttackTargetUUID);
        }
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemStack;
        ItemStack itemstack;
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.bellTick = compoundTag.m_128451_("BellTick");
        this.setHairTick(compoundTag.m_128451_("HairTick"));
        this.setHornTick(compoundTag.m_128451_("HornTick"));
        this.setWrestleCooldown(compoundTag.m_128451_("WrestleCooldown"));
        if (compoundTag.m_128441_("IsNoHair")) {
            this.setNoHair(compoundTag.m_128471_("IsNoHair"));
        }
        if (compoundTag.m_128441_("IsNoHorn")) {
            this.setNoHorn(compoundTag.m_128471_("IsNoHorn"));
        }
        if (compoundTag.m_128441_("IsChain")) {
            this.setChain(compoundTag.m_128471_("IsChain"));
        }
        if (compoundTag.m_128441_("IsBell")) {
            this.setBell(compoundTag.m_128471_("IsBell"));
        }
        if (compoundTag.m_128441_("IsBitterColdBell")) {
            this.setBitterColdBell(compoundTag.m_128471_("IsBitterColdBell"));
        }
        if (compoundTag.m_128441_("IsIllagerFaction")) {
            this.setIllagerFaction(compoundTag.m_128471_("IsIllagerFaction"));
        }
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack);
        }
        if (compoundTag.m_128403_("NotAttackTarget")) {
            this.notAttackTargetUUID = compoundTag.m_128342_("NotAttackTarget");
        }
        this.m_147285_(this.m_9236_(), compoundTag);
        this.updateContainerEquipment();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(HAIR_TICK, (Object)0);
        this.m_20088_().m_135372_(HORN_TICK, (Object)0);
        this.m_20088_().m_135372_(WRESTLE_COOLDOWN, (Object)0);
        this.m_20088_().m_135372_(NO_HAIR, (Object)false);
        this.m_20088_().m_135372_(NO_HORN, (Object)false);
        this.m_20088_().m_135372_(IS_CHAIN, (Object)false);
        this.m_20088_().m_135372_(IS_BELL, (Object)false);
        this.m_20088_().m_135372_(IS_BITTER_COLD_BELL, (Object)false);
        this.m_20088_().m_135372_(IS_ILLAGER_FACTION, (Object)false);
        this.m_20088_().m_135372_(DATA_ID_FLAGS, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_6220_() && (item instanceof ShearsItem || itemStack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge:shears"))))) {
            return InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(5.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                if (this.m_21830_((LivingEntity)player)) {
                    if (item instanceof SpirvePincer || item instanceof ShearsItem || itemStack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge:shears")))) {
                        if (this.isBell()) {
                            this.setBell(false);
                            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, player.m_5720_(), 1.0f, 1.0f);
                            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11664_, this.m_5720_(), 1.0f, 1.0f);
                            ItemStack getItems = new ItemStack((ItemLike)Items.f_42777_, 1);
                            if (!player.m_150109_().m_36054_(getItems)) {
                                player.m_36176_(getItems, false);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (this.isBitterColdBell()) {
                            this.setBitterColdBell(false);
                            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, player.m_5720_(), 1.0f, 1.0f);
                            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11664_, this.m_5720_(), 1.0f, 1.0f);
                            ItemStack getItems = new ItemStack((ItemLike)JerotesVillageItems.BITTER_COLD_BELL.get(), 1);
                            if (!player.m_150109_().m_36054_(getItems)) {
                                player.m_36176_(getItems, false);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (this.isChain()) {
                            this.setChain(false);
                            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, player.m_5720_(), 1.0f, 1.0f);
                            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11794_, this.m_5720_(), 1.0f, 1.0f);
                            ItemStack getItems = new ItemStack((ItemLike)Items.f_42026_, 1);
                            if (!player.m_150109_().m_36054_(getItems)) {
                                player.m_36176_(getItems, false);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (!this.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, player.m_5720_(), 1.0f, 1.0f);
                            ItemStack getItems = this.m_6844_(EquipmentSlot.CHEST);
                            if (!player.m_150109_().m_36054_(getItems)) {
                                player.m_36176_(getItems, false);
                            }
                            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_41852_));
                            return InteractionResult.SUCCESS;
                        }
                    }
                    if (this.canWearArmor() && this.isArmor(itemStack) && !this.isWearingArmor()) {
                        this.equipArmor(player, itemStack);
                        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                    }
                    if (item == Items.f_42026_ && !this.isChain() && this.m_21830_((LivingEntity)player)) {
                        this.setChain(true);
                        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11745_, this.m_5720_(), 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (item == Items.f_42777_ && !this.isBells() && this.isChain() && this.m_21830_((LivingEntity)player)) {
                        this.setBell(true);
                        this.setBitterColdBell(false);
                        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11669_, this.m_5720_(), 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (item == JerotesVillageItems.BITTER_COLD_BELL.get() && !this.isBells() && this.isChain() && this.m_21830_((LivingEntity)player)) {
                        this.setBell(false);
                        this.setBitterColdBell(true);
                        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11669_, this.m_5720_(), 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
                if (!(this.m_6898_(itemStack) || !this.m_6254_() || this.m_20160_() || player.m_36341_() || this.m_21827_())) {
                    if (!this.m_9236_().f_46443_) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack) || this.m_21660_()) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(64) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean swapItem(Player player, EquipmentSlot equipmentSlot, ItemStack itemStack, InteractionHand interactionHand) {
        ItemStack itemStack2 = this.m_6844_(equipmentSlot);
        if (player.m_150110_().f_35937_ && itemStack2.m_41619_() && !itemStack.m_41619_()) {
            this.m_8061_(equipmentSlot, itemStack.m_255036_(1));
            return true;
        }
        if (!itemStack.m_41619_() && itemStack.m_41613_() > 1) {
            if (!itemStack2.m_41619_()) {
                return false;
            }
            this.m_8061_(equipmentSlot, itemStack.m_41620_(1));
            return true;
        }
        this.m_8061_(equipmentSlot, itemStack);
        player.m_21008_(interactionHand, itemStack2);
        return true;
    }

    public void m_5851_(SoundSource soundSource) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, soundSource, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            this.setNoHair(true);
            this.setHairTick(0);
        }
        int n = Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)3);
        for (int i = 0; i < n; ++i) {
            ItemEntity itemEntity = this.m_19998_((ItemLike)JerotesVillageItems.GIANT_MONSTER_HAIR.get());
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (player != null && player != this.m_269323_() && this.m_5448_() == null && player.m_20270_((Entity)this) < 4.0f) {
            this.m_7327_((Entity)player);
        }
        if (!world.f_46443_) {
            if (!this.m_9236_().m_5776_()) {
                this.setNoHair(true);
                this.setHairTick(0);
            }
            int n = Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < n; ++j) {
                items.add(new ItemStack((ItemLike)JerotesVillageItems.GIANT_MONSTER_HAIR.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isNoHair() && !this.m_6162_() && !this.isChain() && !this.isBells() && !this.isBitterColdBell() && this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.m_6220_();
    }

    public void m_8119_() {
        double d3;
        double d2;
        double d;
        int i;
        super.m_8119_();
        if (this.isNoHair()) {
            if (!this.m_9236_().m_5776_()) {
                this.setHairTick(Math.min(24000, this.getHairTick() + 1));
            }
            if (this.getHairTick() >= 24000) {
                if (!this.m_9236_().m_5776_()) {
                    this.setNoHair(false);
                    this.setHairTick(0);
                }
                for (i = 0; i < 20; ++i) {
                    d = this.f_19796_.m_188583_() * 0.02;
                    d2 = this.f_19796_.m_188583_() * 0.02;
                    d3 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, d2, d3);
                }
            }
        }
        if (this.isNoHorn()) {
            if (!this.m_9236_().m_5776_()) {
                this.setHornTick(Math.min(24000, this.getHairTick() + 1));
            }
            if (this.getHornTick() >= 24000) {
                if (!this.m_9236_().m_5776_()) {
                    this.setNoHorn(false);
                    this.setHornTick(0);
                }
                for (i = 0; i < 20; ++i) {
                    d = this.f_19796_.m_188583_() * 0.02;
                    d2 = this.f_19796_.m_188583_() * 0.02;
                    d3 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, d2, d3);
                }
            }
        }
    }

    @Override
    public void m_8107_() {
        GiantMonsterEntity giantMonster;
        Object object;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-10, this.getAttackTick() - 1));
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (this.m_21825_()) {
            this.idleAnimationState.m_216973_();
        } else {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_21825_() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.m_21825_() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if (this.isIllagerFaction() && this.f_19797_ % 10 == 1 && this.m_20197_().isEmpty()) {
            List listRaider = this.m_9236_().m_45976_(AbstractIllager.class, this.m_20191_().m_82377_(2.0, 2.0, 2.0));
            listRaider.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (entity.m_6336_() != MobType.f_21643_ || this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
            if (this.m_20197_().isEmpty()) {
                object = listRaider.iterator();
                while (object.hasNext()) {
                    LivingEntity raider = (LivingEntity)object.next();
                    if (raider == null || raider.m_20363_((Entity)this) || raider.m_20160_() || raider.m_20159_() || !Main.mobSizeSmall((Entity)raider) && !Main.mobSizeMedium((Entity)raider)) continue;
                    raider.m_20329_((Entity)this);
                }
            }
        }
        if (!(this.getWrestleCooldown() >= 2000 && this.isHorn() || this.getNotAttackTarget() == null)) {
            if (!this.m_9236_().m_5776_()) {
                this.setNotAttackTarget(null);
            }
            if ((object = this.getNotAttackTarget()) instanceof GiantMonsterEntity) {
                giantMonster = (GiantMonsterEntity)object;
                if (!this.m_9236_().m_5776_()) {
                    giantMonster.setNotAttackTarget(null);
                }
            }
        }
        if (this.m_5448_() != null && this.getNotAttackTarget() != null) {
            if (!this.m_9236_().m_5776_()) {
                this.setNotAttackTarget(null);
            }
            if ((object = this.getNotAttackTarget()) instanceof GiantMonsterEntity) {
                giantMonster = (GiantMonsterEntity)object;
                if (!this.m_9236_().m_5776_()) {
                    giantMonster.setNotAttackTarget(null);
                }
            }
        }
        if (this.getWrestleCooldown() > 0) {
            this.setWrestleCooldown(this.getWrestleCooldown() - 1);
        } else if (this.getNotAttackTarget() != null) {
            if (!this.m_9236_().m_5776_()) {
                this.setNotAttackTarget(null);
            }
            if ((object = this.getNotAttackTarget()) instanceof GiantMonsterEntity) {
                giantMonster = (GiantMonsterEntity)object;
                if (!this.m_9236_().m_5776_()) {
                    giantMonster.setNotAttackTarget(null);
                }
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.getAttackTick() > -10) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(0);
            this.setAnimTick(10);
            this.setAnimationState("attack");
        }
        if (bl = super.m_7327_(entity)) {
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GIANT_MONSTER_ATTACK, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            List list = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(0.5, 0.2, 0.5));
            for (LivingEntity hurt : list) {
                GiantMonsterEntity giantMonster;
                if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt, (Entity)entity) || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof GiantMonsterEntity && (giantMonster = (GiantMonsterEntity)hurt).m_5448_() != this && this.m_5448_() != giantMonster) continue;
                AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
                AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.5f, (float)0.5f, (boolean)false, (float)0.0f);
            }
            Main.sweepAttack((Entity)this);
            if (this.isBells()) {
                this.bellUse(this.m_20097_());
            }
            if (this.isBitterColdBell() && entity instanceof FrostYetiEntity) {
                FrostYetiEntity frostYetiEntity = (FrostYetiEntity)entity;
                if (!frostYetiEntity.m_9236_().f_46443_) {
                    frostYetiEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80));
                }
            }
        }
        return bl;
    }

    public boolean wrestleTarget(LivingEntity entity) {
        float damage = 0.0f;
        DamageSource damageSources = this.m_9236_().m_269111_().m_269364_((LivingEntity)this);
        AttackFind.attackBegin((LivingEntity)this, (Entity)entity);
        boolean bl = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)entity, (DamageSource)damageSources, (float)0.0f, (float)1.0f, (boolean)true, (float)damage);
        if (bl && this.m_217043_().m_188501_() > 0.9f && !this.isNoHorn()) {
            if (!this.m_9236_().m_5776_()) {
                this.setNoHorn(true);
                this.setHornTick(0);
            }
            int n = Main.randomReach((RandomSource)this.m_217043_(), (int)0, (int)2);
            for (int i = 0; i < n; ++i) {
                ItemEntity itemEntity = this.m_19998_((ItemLike)JerotesVillageItems.GIANT_MONSTER_HORN.get());
                if (itemEntity == null) continue;
                itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
            }
        }
        return bl;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        int freezeAmount = 2;
        if (this.isBitterColdBell()) {
            freezeAmount = 5;
        }
        if (this.isNoHair()) {
            freezeAmount = 1;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268419_)) {
            amount /= (float)freezeAmount;
        }
        return super.m_6469_(damageSource, amount);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return GiantMonsterEntity.this.inventory.m_8020_(p_149503_);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                GiantMonsterEntity.this.inventory.m_6836_(p_149503_, p_149528_);
                GiantMonsterEntity.this.updateContainerEquipment();
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int n) {
        int j;
        int i = n - this.getAddNumber();
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = n - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(n);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        if (this.isChain()) {
            this.m_19998_((ItemLike)Items.f_42026_);
        }
        if (this.isBell()) {
            this.m_19998_((ItemLike)Items.f_42777_);
        }
        if (this.isBitterColdBell()) {
            this.m_19998_((ItemLike)JerotesVillageItems.BITTER_COLD_BELL.get());
        }
    }

    public ResourceLocation m_7582_() {
        if (!this.isNoHorn()) {
            return this.m_6095_().m_20677_();
        }
        return new ResourceLocation("jerotesvillage", "entities/giant_monster_no_horn");
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void equipArmor(Player player, ItemStack itemStack) {
        if (this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack.m_255036_(1));
            if (player != null && !player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
        }
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openSuchInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        if (this.isIllagerFaction() && livingEntity instanceof AbstractIllager && (this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_())) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

