/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ArmorEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesTryFindWaterGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GemstoneMalignasaurMoveControl;
import com.jerotes.jerotesvillage.control.GiantBodyRotationControl;
import com.jerotes.jerotesvillage.control.GiantLookControl;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.entity.Animal.MalialosaurEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.GemstoneMalignasaurEntity;
import com.jerotes.jerotesvillage.entity.Part.MalignasaurPart;
import com.jerotes.jerotesvillage.entity.in.StopLook;
import com.jerotes.jerotesvillage.goal.WaterSitWhenOrderedToGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.navigation.GemstoneMalignasaurPathNavigation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class MalignasaurEntity
extends BaseTamableAnimalEntity
implements NeutralMob,
StopLook,
Saddleable,
ArmorEntity,
ContainerListener,
HasCustomInventoryScreen {
    public AnimationState landAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState headAttack1AnimationState = new AnimationState();
    public AnimationState headAttack2AnimationState = new AnimationState();
    public AnimationState headAttack3AnimationState = new AnimationState();
    public AnimationState tailAttack1AnimationState = new AnimationState();
    public AnimationState tailAttack2AnimationState = new AnimationState();
    public AnimationState tailAttack3AnimationState = new AnimationState();
    public AnimationState breathAnimationState = new AnimationState();
    public AnimationState whirlpoolAnimationState = new AnimationState();
    public AnimationState jumpAnimationState = new AnimationState();
    public AnimationState armorAnimationState = new AnimationState();
    public AnimationState controlAnimationState = new AnimationState();
    public AnimationState deterAnimationState = new AnimationState();
    public AnimationState bombAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_TICK = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_USE_TICK = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> JUMP_SOUND = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("jerotes", "animal_foods/meat_and_fish_foods")));
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(MalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    public final MalignasaurPart head1;
    public final MalignasaurPart tail1;
    public final MalignasaurPart[] allParts;
    public double blockDestroyTick;
    private int sitTick = 0;
    @Nullable
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public SimpleContainer inventory() {
        return this.inventory;
    }

    public MalignasaurEntity(EntityType<? extends MalignasaurEntity> type, Level world) {
        super(type, world);
        this.m_274367_(3.1f);
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new GemstoneMalignasaurMoveControl((Mob)this, 85, 85, 0.02f, 0.15f, false);
        this.f_21365_ = new GiantLookControl((Mob)this, 1);
        this.createInventory();
        this.head1 = new MalignasaurPart(this, "head1", 2.625f, 2.625f);
        this.tail1 = new MalignasaurPart(this, "tail1", 3.0f, 3.0f);
        this.allParts = new MalignasaurPart[]{this.head1, this.tail1};
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.allParts != null) {
            for (MalignasaurPart part : this.allParts) {
                part.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public boolean isWearingArmor() {
        return false;
    }

    public boolean isWarBeastArmor() {
        return false;
    }

    public boolean isGiantBeastArmor() {
        return false;
    }

    public int getInventorySize() {
        return 2;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_5757_(Container p_30548_) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
    }

    public SoundEvent m_246265_() {
        return JerotesSounds.USE_SADDLE;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new WaterSitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new JerotesTryFindWaterGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 32));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((MalignasaurEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 270.0);
        builder = builder.m_22268_(Attributes.f_22281_, 15.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22279_, 1.2);
        builder = builder.m_22268_(Attributes.f_22282_, 2.5);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_6162_()) {
            return super.m_7515_();
        }
        return JerotesVillageSounds.MALIGNASAUR_AMBIENT;
    }

    public int m_8100_() {
        return 600;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.MALIGNASAUR_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.MALIGNASAUR_HURT;
    }

    protected SoundEvent m_5501_() {
        return JerotesVillageSounds.MALIGNASAUR_SWIM;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.MALIGNASAUR_WALK, 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public int m_21529_() {
        return 5;
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (!(this instanceof GemstoneMalignasaurEntity)) {
            if (bl) {
                this.m_21051_(Attributes.f_22276_).m_22100_(300.0);
                this.m_21153_(300.0f);
                this.m_21051_(Attributes.f_22281_).m_22100_(16.0);
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(270.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(15.0);
            }
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GiantBodyRotationControl((Mob)this);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GemstoneMalignasaurPathNavigation((Mob)this, level);
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -288000 : 0);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 1.35f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return this.m_21824_() || this.m_6162_() || super.m_6573_(player);
    }

    @Nullable
    public MalignasaurEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        MalignasaurEntity malialosaurEntity = (MalignasaurEntity)((EntityType)JerotesVillageEntityType.MALIGNASAUR.get()).m_20615_((Level)serverLevel);
        if (malialosaurEntity != null && (uUID = this.m_21805_()) != null) {
            malialosaurEntity.m_21816_(uUID);
            malialosaurEntity.m_7105_(true);
        }
        return malialosaurEntity;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    protected int getMaxPassengers() {
        if (!this.m_6254_()) {
            return 1;
        }
        return 2;
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    @Override
    public boolean stopLookTime() {
        return this.specialAction() || this.getAttackTick() > 0 && this.getAttackTick() < 15;
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public void setJumpTick(int n) {
        this.m_20088_().m_135381_(JUMP_TICK, (Object)n);
    }

    public int getJumpTick() {
        return (Integer)this.m_20088_().m_135370_(JUMP_TICK);
    }

    public void setJumpUseTick(int n) {
        this.m_20088_().m_135381_(JUMP_USE_TICK, (Object)n);
    }

    public int getJumpUseTick() {
        return (Integer)this.m_20088_().m_135370_(JUMP_USE_TICK);
    }

    public void setJumpSound(boolean bl) {
        this.m_20088_().m_135381_(JUMP_SOUND, (Object)bl);
    }

    public boolean isJumpSound() {
        return (Boolean)this.m_20088_().m_135370_(JUMP_SOUND);
    }

    public boolean specialAction() {
        return this.getJumpUseTick() > 0;
    }

    protected void setFlag(int n, boolean n2) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (n2) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | n)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~n)));
        }
    }

    protected boolean getFlag(int n) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & n) != 0;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public boolean isArmor(ItemStack itemStack) {
        return false;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "headAttack1")) {
            return 4;
        }
        if (Objects.equals(animation, "headAttack2")) {
            return 5;
        }
        if (Objects.equals(animation, "headAttack3")) {
            return 6;
        }
        if (Objects.equals(animation, "tailAttack1")) {
            return 7;
        }
        if (Objects.equals(animation, "tailAttack2")) {
            return 8;
        }
        if (Objects.equals(animation, "tailAttack3")) {
            return 9;
        }
        if (Objects.equals(animation, "breath")) {
            return 10;
        }
        if (Objects.equals(animation, "whirlpool")) {
            return 11;
        }
        if (Objects.equals(animation, "jump")) {
            return 12;
        }
        if (Objects.equals(animation, "armor")) {
            return 13;
        }
        if (Objects.equals(animation, "control")) {
            return 14;
        }
        if (Objects.equals(animation, "deter")) {
            return 15;
        }
        if (Objects.equals(animation, "bomb")) {
            return 16;
        }
        if (Objects.equals(animation, "dead")) {
            return 17;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.headAttack1AnimationState);
        list.add(this.headAttack2AnimationState);
        list.add(this.headAttack3AnimationState);
        list.add(this.tailAttack1AnimationState);
        list.add(this.tailAttack2AnimationState);
        list.add(this.tailAttack3AnimationState);
        list.add(this.breathAnimationState);
        list.add(this.whirlpoolAnimationState);
        list.add(this.jumpAnimationState);
        list.add(this.armorAnimationState);
        list.add(this.controlAnimationState);
        list.add(this.deterAnimationState);
        list.add(this.bombAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception || state == this.jumpAnimationState || state == this.armorAnimationState || state == this.controlAnimationState) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == this.jumpAnimationState || state == this.armorAnimationState || state == this.controlAnimationState) continue;
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        compoundTag.m_128405_("JumpTick", this.getJumpTick());
        compoundTag.m_128405_("JumpUseTick", this.getJumpUseTick());
        compoundTag.m_128379_("JumpSound", this.isJumpSound());
        compoundTag.m_128405_("SitTick", this.sitTick);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemStack;
        ItemStack itemstack;
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.setJumpTick(compoundTag.m_128451_("JumpTick"));
        this.setJumpUseTick(compoundTag.m_128451_("JumpUseTick"));
        this.setJumpSound(compoundTag.m_128471_("JumpSound"));
        this.sitTick = compoundTag.m_128451_("SitTick");
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack);
        }
        this.m_147285_(this.m_9236_(), compoundTag);
        this.updateContainerEquipment();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(JUMP_TICK, (Object)0);
        this.m_20088_().m_135372_(JUMP_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(JUMP_SOUND, (Object)false);
        this.m_20088_().m_135372_(DATA_ID_FLAGS, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.headAttack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.headAttack1AnimationState);
                    break;
                }
                case 5: {
                    this.headAttack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.headAttack2AnimationState);
                    break;
                }
                case 6: {
                    this.headAttack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.headAttack3AnimationState);
                    break;
                }
                case 7: {
                    this.tailAttack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.tailAttack1AnimationState);
                    break;
                }
                case 8: {
                    this.tailAttack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.tailAttack2AnimationState);
                    break;
                }
                case 9: {
                    this.tailAttack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.tailAttack3AnimationState);
                    break;
                }
                case 10: {
                    this.breathAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.breathAnimationState);
                    break;
                }
                case 11: {
                    this.whirlpoolAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.whirlpoolAnimationState);
                    break;
                }
                case 12: {
                    this.jumpAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.jumpAnimationState);
                    break;
                }
                case 13: {
                    this.armorAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.armorAnimationState);
                    break;
                }
                case 14: {
                    this.controlAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.controlAnimationState);
                    break;
                }
                case 15: {
                    this.deterAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deterAnimationState);
                    break;
                }
                case 16: {
                    this.bombAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.bombAnimationState);
                    break;
                }
                case 17: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public MalignasaurPart[] getSubEntities() {
        return this.allParts;
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        MalignasaurPart[] malignasaurParts = this.getSubEntities();
        for (int i = 0; i < malignasaurParts.length; ++i) {
            malignasaurParts[i].m_20234_(i + 1 + clientboundAddEntityPacket.m_131496_());
        }
    }

    private void tickMultipart() {
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
        float scale = 1.0f;
        if (this instanceof GemstoneMalignasaurEntity) {
            scale = 1.3333334f;
        }
        if (this.m_6162_()) {
            scale *= 0.5f;
        }
        this.head1.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, (double)(5.25f * scale)), this.m_146909_() / 2.0f * ((float)this.getWaterAnim() / 40.0f), this.f_20883_).m_82549_(center));
        this.tail1.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, (double)(-6.75f * scale)), this.m_146909_() / 2.0f * ((float)this.getWaterAnim() / 40.0f), this.f_20883_).m_82549_(center));
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    private Vec3 rotateOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.m_82496_(-xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    public void m_8119_() {
        block8: {
            block7: {
                this.tickMultipart();
                super.m_8119_();
                if (!(this instanceof GemstoneMalignasaurEntity)) break block7;
                if (this.head1 != null && this.head1.scale != 0.6666667f && this.m_6162_() && this.allParts != null) {
                    for (MalignasaurPart part : this.allParts) {
                        part.scale = 0.6666667f;
                        part.m_6210_();
                    }
                }
                if (this.head1 == null || this.head1.scale == 1.3333334f || this.m_6162_() || this.allParts == null) break block8;
                for (MalignasaurPart part : this.allParts) {
                    part.scale = 1.3333334f;
                    part.m_6210_();
                }
                break block8;
            }
            if (this.head1 != null && (double)this.head1.scale != 0.5 && this.m_6162_() && this.allParts != null) {
                for (MalignasaurPart part : this.allParts) {
                    part.scale = 0.5f;
                    part.m_6210_();
                }
            }
            if (this.head1 != null && this.head1.scale != 1.0f && !this.m_6162_() && this.allParts != null) {
                for (MalignasaurPart part : this.allParts) {
                    part.scale = 1.0f;
                    part.m_6210_();
                }
            }
        }
    }

    @Override
    public void m_8107_() {
        double distanceXZ;
        double blockDestroyTickUse;
        LivingEntity headParts6;
        int cooldown;
        ServerLevel serverLevel;
        Level level;
        BlockState blockState;
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.getJumpUseTick() <= 0 && this.jumpAnimationState.m_216984_()) {
            this.jumpAnimationState.m_216973_();
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.specialAction() || this.getAttackTick() > 15) {
            this.m_21573_().m_26573_();
            if (this.m_5448_() != null && !this.stopLookTime()) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 10.0f, 10.0f);
                this.m_21391_((Entity)this.m_5448_(), 10.0f, 10.0f);
            }
        }
        if (this.m_6084_()) {
            this.landAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.m_21825_()) {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_21825_() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.m_21825_() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n = 0; n < 18; ++n) {
                level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
        int n = cooldown = this instanceof GemstoneMalignasaurEntity ? (int)(OtherMainConfig.GemstoneMalignasaurMeleeAttackCooldown * 20.0) : 5;
        if ((this.getAttackTick() == 10 && this.getAttackUse() != 3 || (this.getAttackTick() == 12 || this.getAttackTick() == 8) && this.getAttackUse() == 3) && this.m_6084_()) {
            if (this.getAttackUse() == 1) {
                if (this.head1 != null) {
                    MalignasaurPart[] headParts2 = new MalignasaurPart[]{this.head1};
                    this.trueHurt(headParts2);
                } else {
                    MalignasaurPart[] headParts3 = new MalignasaurPart[]{};
                    this.trueHurt(headParts3);
                }
            }
            if (this.getAttackUse() == 4) {
                if (this.head1 != null) {
                    MalignasaurPart[] headParts4 = new MalignasaurPart[]{this.head1};
                    this.trueHurt(headParts4);
                } else {
                    MalignasaurPart[] headParts5 = new MalignasaurPart[]{};
                    this.trueHurt(headParts5);
                }
            }
            if (this.getAttackUse() == 3) {
                if (this.tail1 != null) {
                    MalignasaurPart[] tailParts = new MalignasaurPart[]{this.tail1};
                    this.trueHurt(tailParts);
                } else {
                    MalignasaurPart[] tailParts = new MalignasaurPart[]{};
                    this.trueHurt(tailParts);
                }
            }
            if (this.getAttackUse() == 2) {
                MalignasaurPart[] headParts6 = new MalignasaurPart[]{};
                this.trueHurt(headParts6);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-cooldown, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() <= -cooldown && this.m_5448_() != null && this.m_6084_() && !this.specialAction()) {
            if (this.head1 != null && this.head1.m_20191_().m_82400_(0.0).m_82381_(this.m_5448_().m_20191_()) && Main.canSee((Entity)this.m_5448_(), (Entity)this)) {
                this.doHurtTargetHead(this.m_5448_());
            } else if (this.tail1 != null && this.tail1.m_20191_().m_82400_(0.0).m_82381_(this.m_5448_().m_20191_()) && !Main.canSee((Entity)this.m_5448_(), (Entity)this)) {
                this.doHurtTargetTail(this.m_5448_());
            }
        }
        if (this.m_5448_() != null && this.m_6084_()) {
            Vec3 vec3 = this.m_20184_();
            if (this.m_20069_() && this.m_5448_().m_20188_() > this.m_20188_() + 3.0 && this.m_5448_().m_20069_() && this.m_6779_(this.m_5448_())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (0.3 - vec3.f_82480_) * 0.3, 0.0));
                this.f_19812_ = true;
            }
        }
        if ((headParts6 = this.m_6688_()) instanceof Player) {
            Player player = (Player)headParts6;
            if (this.m_20160_()) {
                if (!this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && this.m_20069_() && this.f_19862_) {
                    for (int n2 = 0; n2 < 18; ++n2) {
                        level = this.m_9236_();
                        if (!(level instanceof ServerLevel)) continue;
                        serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
                    }
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
                }
                if ((this.f_19790_ != this.m_20185_() || this.f_19792_ != this.m_20189_()) && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                    double d = Math.abs(this.m_20185_() - this.f_19790_);
                    double d2 = Math.abs(this.m_20189_() - this.f_19792_);
                    if ((d >= 0.003 || d2 >= 0.003) && this.m_20184_().f_82480_ < (double)0.8f && this.m_20184_().f_82480_ > (double)-0.8f) {
                        float headXRot = player.m_146909_();
                        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(headXRot / 2.0f * -0.0035f), 0.0));
                    }
                }
            }
        }
        double d = blockDestroyTickUse = this instanceof GemstoneMalignasaurEntity ? OtherMainConfig.GemstoneMalignasaurBreakBlockCooldown * 20.0 : 60.0;
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        } else if (this.f_19862_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)5.0f);
            if (blockDestroy) {
                this.blockDestroyTick = blockDestroyTickUse;
            }
            if (!this.m_9236_().f_46443_ && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
        cooldown = this instanceof GemstoneMalignasaurEntity ? (int)(OtherMainConfig.GemstoneMalignasaurJumpAttackCooldown * 20.0) : 600;
        Vec3 vec3 = this.m_20184_();
        if (this.m_5448_() != null && !this.m_20096_() && !this.m_5448_().m_20069_() && this.spellNeed(4.0f, 17.0f, 1, true) && !this.m_20160_() && !this.m_20096_() && this.getJumpTick() >= cooldown && (distanceXZ = this.m_20275_(this.m_5448_().m_20185_(), this.m_20186_(), this.m_5448_().m_20189_())) < 300.0) {
            if (!this.m_9236_().m_5776_()) {
                this.setJumpUseTick(120);
                this.setJumpSound(true);
            }
            this.jumpToTarget(this.m_5448_());
        }
        if (this.getJumpUseTick() > 0) {
            GemstoneMalignasaurEntity gemstoneMalignasaur;
            MalignasaurEntity malignasaurEntity;
            if (!this.m_20069_() && this.isJumpSound()) {
                if (this instanceof GemstoneMalignasaurEntity) {
                    this.m_5496_(JerotesVillageSounds.GEMSTONE_MALIGNASAUR_JUMP, 5.0f, 1.0f);
                } else {
                    this.m_5496_(JerotesVillageSounds.MALIGNASAUR_JUMP, 1.0f, 1.0f);
                }
                for (int i = 0; i < 20; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.8), this.m_20187_(), this.m_20262_(0.8), 0.0, 0.0, 0.0);
                }
                if (!this.m_9236_().m_5776_()) {
                    this.setJumpSound(false);
                }
            }
            if (this.m_5448_() != null && this.m_5448_().m_20188_() < this.m_20188_() && (malignasaurEntity = this) instanceof GemstoneMalignasaurEntity && (gemstoneMalignasaur = (GemstoneMalignasaurEntity)malignasaurEntity).m_20285_() && !gemstoneMalignasaur.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
                this.f_19812_ = true;
            }
            if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 5.0f && this.m_5448_().m_6084_() && !this.m_9236_().m_5776_()) {
                this.setAttackTick(6);
                this.setAttackUse(4);
                this.setJumpUseTick(0);
            }
        }
        if (this.getJumpUseTick() == 1) {
            if (this instanceof GemstoneMalignasaurEntity) {
                if (!this.m_9236_().m_5776_()) {
                    this.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 120, 3), (Entity)this);
                    this.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, 3), (Entity)this);
                    this.setJumpUseTick(0);
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setJumpUseTick(0);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setJumpTick(Math.min(cooldown, this.getJumpTick() + 1));
            this.setJumpUseTick(Math.max(0, this.getJumpUseTick() - 1));
        }
    }

    public boolean spellNeed(float min, float max, int time, boolean bl) {
        return !this.specialAction() && this.m_6084_() && !this.m_21525_() && this.getAttackTick() <= 0 && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_().m_20270_((Entity)this) > min && this.m_5448_().m_20270_((Entity)this) < max && this.m_217043_().m_188503_(time * 20) == 1;
    }

    public boolean jumpToTarget(LivingEntity target) {
        GemstoneMalignasaurEntity gemstoneMalignasaur;
        this.m_21563_().m_24960_((Entity)target, 360.0f, 360.0f);
        this.m_21391_((Entity)target, 360.0f, 360.0f);
        double smoothX = Mth.m_14008_((double)Math.abs(target.m_20185_() - this.m_20185_()), (double)0.0, (double)1.0);
        double smoothZ = Mth.m_14008_((double)Math.abs(target.m_20189_() - this.m_20189_()), (double)0.0, (double)1.0);
        double d0 = (target.m_20185_() - this.m_20185_()) * 0.3 * smoothX;
        double d2 = (target.m_20189_() - this.m_20189_()) * 0.3 * smoothZ;
        float up = 1.5f + this.m_217043_().m_188501_() * 1.25f;
        MalignasaurEntity malignasaurEntity = this;
        this.m_20256_(this.m_20184_().m_82520_(d0 * 0.3, (double)(malignasaurEntity instanceof GemstoneMalignasaurEntity && (gemstoneMalignasaur = (GemstoneMalignasaurEntity)malignasaurEntity).m_20285_() && !gemstoneMalignasaur.m_20069_() ? up / 5.0f : up), d2 * 0.3));
        this.m_21573_().m_5624_((Entity)target, 1.0);
        if (!this.m_9236_().m_5776_()) {
            this.setJumpTick(0);
            this.setAnimTick(30);
            this.setAnimationState("jump");
        }
        return true;
    }

    public boolean trueHurt(MalignasaurPart[] area) {
        if (!this.m_20067_()) {
            if (this.getAttackUse() == 1) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MALIGNASAUR_HEAD, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            } else if (this.getAttackUse() == 2) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MALIGNASAUR_ATTACK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            } else if (this.getAttackUse() == 3) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MALIGNASAUR_TAIL, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            } else if (this.getAttackUse() == 4) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MALIGNASAUR_ATTACK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        int levels = 1;
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82377_(0.75, 0.75, 0.75));
        for (MalignasaurPart part : area) {
            List add = this.m_9236_().m_45976_(LivingEntity.class, part.m_20191_().m_82377_(0.25, 0.25, 0.25));
            list.addAll(add);
        }
        for (LivingEntity hurt : list) {
            MalialosaurEntity malialosaurEntity;
            MalignasaurEntity malignasaur;
            if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof MalignasaurEntity && (malignasaur = (MalignasaurEntity)hurt).m_5448_() != this && this.m_5448_() != malignasaur || hurt instanceof MalialosaurEntity && (malialosaurEntity = (MalialosaurEntity)hurt).m_5448_() != this && this.m_5448_() != malialosaurEntity) continue;
            double d = 0.0;
            if (hurt.m_21051_(Attributes.f_22278_) != null) {
                d = hurt.m_21133_(Attributes.f_22278_);
            }
            double d3 = Math.max(0.3, 1.3 - d);
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl2 = false;
            if (this.getAttackUse() == 1) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)0.5f, (boolean)false, (float)0.0f);
            } else if (this.getAttackUse() == 2) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.5f, (boolean)false, (float)0.0f);
            } else if (this.getAttackUse() == 3) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
            } else if (this.getAttackUse() == 4) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.0f, (float)0.5f, (boolean)true, (float)(levels * 8));
            }
            if (!bl2) continue;
            if (this.getAttackUse() == 1 && !hurt.m_9236_().f_46443_) {
                hurt.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.BLEEDING.get(), 60, 0, false, false), (Entity)this);
            }
            if (this.getAttackUse() == 3) {
                if ((Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) {
                    hurt.m_20256_(hurt.m_20184_().m_82520_(-(this.m_20185_() - hurt.m_20185_()) * 0.2 * d3, -(this.m_20186_() - hurt.m_20186_()) * 0.2 * d3, -(this.m_20189_() - hurt.m_20189_()) * 0.2 * d3));
                }
                hurt.m_147240_(0.8, (double)Mth.m_14031_((float)(this.m_146908_() * 0.08f)), (double)(-Mth.m_14089_((float)(this.m_146908_() * 0.08f))));
            }
            if (this.getJumpUseTick() <= 0) continue;
            if (!hurt.m_9236_().f_46443_) {
                hurt.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 60, 1), (Entity)this);
                hurt.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 60, 1), (Entity)this);
            }
            if (this.m_9236_().m_5776_()) continue;
            this.setJumpUseTick(0);
        }
        if (this.getAttackUse() == 3 || this.getAttackUse() == 4) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        Main.sweepAttack((Entity)this);
        Level hurt = this.m_9236_();
        if (hurt instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)hurt;
            if ((this.getAttackUse() == 3 || this.getAttackUse() == 4) && this.tail1 != null) {
                AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.tail1.m_20185_(), this.tail1.m_20186_() - 1.0, this.tail1.m_20189_()), (double)(Main.mobWidth((Entity)this.tail1) / 2.0f + 2.0f), (double)0.0, (double)(Main.mobWidth((Entity)this.tail1) / 2.0f + 2.0f));
                for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
                }
            }
        }
        return true;
    }

    public boolean doHurtTargetHead(LivingEntity entity) {
        if (this.getAttackTick() > -5 || this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            this.setAnimTick(20);
            this.setAttackUse(1);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                this.setAnimationState("headAttack1");
            } else if (attackRandom < 10) {
                this.setAnimationState("headAttack2");
            } else {
                this.setAnimationState("headAttack3");
            }
        }
        return true;
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() > -5 || this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            this.setAnimTick(20);
            this.setAttackUse(2);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                this.setAnimationState("attack1");
            } else if (attackRandom < 10) {
                this.setAnimationState("attack2");
            } else {
                this.setAnimationState("attack3");
            }
        }
        return true;
    }

    public boolean doHurtTargetTail(LivingEntity entity) {
        if (this.getAttackTick() > -5 || this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            this.setAnimTick(20);
            this.setAttackUse(3);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                this.setAnimationState("tailAttack1");
            } else if (attackRandom < 10) {
                this.setAnimationState("tailAttack2");
            } else {
                this.setAnimationState("tailAttack3");
            }
        }
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean hurtByPart(MalignasaurPart malignasaurPart, DamageSource damageSource, float f) {
        return this.m_6469_(damageSource, f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(8.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                if (!this.m_6898_(itemStack) && this.m_6254_() && this.m_20197_().size() < this.getMaxPassengers() && !player.m_36341_() && !this.m_21827_()) {
                    if (!this.m_9236_().m_5776_()) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack) || this.m_21660_()) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(16) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return MalignasaurEntity.this.inventory.m_8020_(p_149503_);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                MalignasaurEntity.this.inventory.m_6836_(p_149503_, p_149528_);
                MalignasaurEntity.this.updateContainerEquipment();
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int p_149514_) {
        int j;
        int i = p_149514_ - this.getAddNumber();
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = p_149514_ - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(p_149514_);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    public boolean canWearArmor() {
        return false;
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openSuchInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        float scale = 1.0f;
        if (this instanceof GemstoneMalignasaurEntity) {
            scale = 1.3333334f;
        }
        if (!this.m_6254_()) {
            return -1.85f * scale;
        }
        return -1.55f * scale;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        int i = this.m_20197_().indexOf(entity);
        if (!this.m_6254_()) {
            return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
        }
        if (i == 0) {
            float f2 = 2.5f;
            float f3 = 0.0f;
            return new Vector3f(f3, entityDimensions.f_20378_, f2);
        }
        if (i == 1) {
            float f2 = 0.5f;
            float f3 = 0.0f;
            return new Vector3f(f3, entityDimensions.f_20378_, f2);
        }
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public void m_21391_(Entity entity, float f, float f2) {
        if (!this.stopLookTime()) {
            super.m_21391_(entity, f, f2);
        }
    }

    public void m_146926_(float f) {
        if (!this.stopLookTime()) {
            super.m_146926_(f);
        }
    }

    public void m_146922_(float f) {
        if (!this.stopLookTime()) {
            super.m_146922_(f);
        }
    }

    public void m_5618_(float f) {
        if (!this.stopLookTime()) {
            super.m_5618_(f);
        }
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                if (this.m_6109_() && this.m_20069_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 0.25f);
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    this.m_19920_(this.m_6113_(), new Vec3((double)strafe, 0.0, (double)forward));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.7));
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                } else {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 0.15f);
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
                }
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            if (this.specialAction() && this.getJumpUseTick() <= 0) {
                this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
            }
            return;
        }
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), dir);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(dir);
        }
        if (this.specialAction() && this.getJumpUseTick() <= 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

