/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ArmorEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesTameBreathAirGoal;
import com.jerotes.jerotes.goal.JerotesTameTryFindWaterGoal;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.ItemBeastArmor;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.GemstoneMalignasaurEntity;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowParentGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeTemptGoal;
import com.jerotes.jerotesvillage.goal.PrancedDolphinJumpGoal;
import com.jerotes.jerotesvillage.goal.WaterSitWhenOrderedToGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.navigation.CanGroundWaterBoundPathNavigation;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.joml.Vector3f;

public class PrancedDolphinEntity
extends BaseTamableAnimalEntity
implements NeutralMob,
Saddleable,
ArmorEntity,
ContainerListener,
HasCustomInventoryScreen {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    private static final EntityDataAccessor<BlockPos> TREASURE_POS = SynchedEntityData.m_135353_(PrancedDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> GOT_FISH = SynchedEntityData.m_135353_(PrancedDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MOISTNESS_LEVEL = SynchedEntityData.m_135353_(PrancedDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && item.m_20069_();
    static final TargetingConditions SWIM_WITH_PLAYER_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("jerotes", "animal_foods/fish_foods")));
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("f357ce9b-19a0-44f0-b43e-0f7b1f3b763b");
    private static final UUID ARMOR_TOUGHNESS_MODIFIER_UUID = UUID.fromString("c0a9c25d-6fc4-488c-b659-221917ee2edc");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("0e96085a-b936-487d-98b1-3a0ecd567778");
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(PrancedDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(PrancedDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(PrancedDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private int sitTick = 0;
    @Nullable
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public SimpleContainer inventory() {
        return this.inventory;
    }

    public PrancedDolphinEntity(EntityType<? extends PrancedDolphinEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.1f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 1.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.2f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.createInventory();
        this.m_21553_(true);
    }

    public boolean isWarBeastArmor() {
        return true;
    }

    public boolean isGiantBeastArmor() {
        return false;
    }

    public int getInventorySize() {
        return 2;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
        this.setArmorEquipment(this.inventory.m_8020_(1));
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_5757_(Container p_30548_) {
        ItemStack itemStack = this.getArmor();
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
        ItemStack itemStack2 = this.getArmor();
        if (this.f_19797_ > 20 && this.isArmor(itemStack2) && itemStack != itemStack2) {
            this.m_5496_(JerotesSounds.USE_BEAST_ARMOR, 0.5f, 1.0f);
        }
    }

    public SoundEvent m_246265_() {
        return JerotesSounds.USE_SADDLE;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22276_, 35.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new WaterSitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesTameBreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesTameTryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, GemstoneMalignasaurEntity.class, 32.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(2, (Goal)new DolphinSwimToTreasureGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DolphinSwimWithPlayerGoal(this, 4.0));
        this.f_21345_.m_25352_(4, (Goal)new JerotesAnimalChangeTemptGoal(this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new JerotesAnimalChangeFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new PrancedDolphinJumpGoal(this, 10));
        this.f_21345_.m_25352_(8, (Goal)new PlayWithItemsGoal());
        this.f_21345_.m_25352_(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((PrancedDolphinEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_11800_ : SoundEvents.f_11799_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11804_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11802_;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_11807_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11808_;
    }

    protected boolean closeToNextPos() {
        BlockPos $$0 = this.m_21573_().m_26567_();
        return $$0 != null ? $$0.m_203195_((Position)this.m_20182_(), 12.0) : false;
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    @Nullable
    public PrancedDolphinEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        PrancedDolphinEntity prancedDolphinEntity = (PrancedDolphinEntity)((EntityType)JerotesVillageEntityType.PRANCED_DOLPHIN.get()).m_20615_((Level)serverLevel);
        if (prancedDolphinEntity != null && (uUID = this.m_21805_()) != null) {
            prancedDolphinEntity.m_21816_(uUID);
            prancedDolphinEntity.m_7105_(true);
        }
        return prancedDolphinEntity;
    }

    public int m_6062_() {
        return 4800;
    }

    protected int m_7305_(int p_28389_) {
        return this.m_6062_();
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 0.6f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    protected void handleAirSupply(int n) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(n - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
            }
        } else {
            this.m_20301_(300);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new CanGroundWaterBoundPathNavigation((Mob)this, level);
    }

    public boolean m_7066_(ItemStack itemStack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
        if (!this.m_6844_(equipmentSlot).m_41619_()) {
            return false;
        }
        return equipmentSlot == EquipmentSlot.MAINHAND && super.m_7066_(itemStack);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemStack;
        if (this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && this.m_7252_(itemStack = itemEntity.m_32055_())) {
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_7938_((Entity)itemEntity, itemStack.m_41613_());
            itemEntity.m_146870_();
        }
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.9f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.m_21051_(Attributes.f_22276_).m_22100_(45.0);
            this.m_21153_(45.0f);
            this.m_21051_(Attributes.f_22277_).m_22100_(48.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(35.0);
            this.m_21051_(Attributes.f_22277_).m_22100_(24.0);
        }
    }

    public void setTreasurePos(BlockPos p_28385_) {
        this.f_19804_.m_135381_(TREASURE_POS, (Object)p_28385_);
    }

    public BlockPos getTreasurePos() {
        return (BlockPos)this.f_19804_.m_135370_(TREASURE_POS);
    }

    public boolean gotFish() {
        return (Boolean)this.f_19804_.m_135370_(GOT_FISH);
    }

    public void setGotFish(boolean p_28394_) {
        this.f_19804_.m_135381_(GOT_FISH, (Object)p_28394_);
    }

    public int getMoistnessLevel() {
        return (Integer)this.f_19804_.m_135370_(MOISTNESS_LEVEL);
    }

    public void setMoisntessLevel(int p_28344_) {
        this.f_19804_.m_135381_(MOISTNESS_LEVEL, (Object)p_28344_);
    }

    protected void setFlag(int n, boolean n2) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (n2) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | n)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~n)));
        }
    }

    protected boolean getFlag(int n) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & n) != 0;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public boolean isWearingArmor() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isArmor(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof HorseArmorItem;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SitTick", this.sitTick);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128405_("TreasurePosX", this.getTreasurePos().m_123341_());
        compoundTag.m_128405_("TreasurePosY", this.getTreasurePos().m_123342_());
        compoundTag.m_128405_("TreasurePosZ", this.getTreasurePos().m_123343_());
        compoundTag.m_128379_("GotFish", this.gotFish());
        compoundTag.m_128405_("Moistness", this.getMoistnessLevel());
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemStack;
        ItemStack itemstack;
        int x = compoundTag.m_128451_("TreasurePosX");
        int y = compoundTag.m_128451_("TreasurePosY");
        int z = compoundTag.m_128451_("TreasurePosZ");
        this.setTreasurePos(new BlockPos(x, y, z));
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.sitTick = compoundTag.m_128451_("SitTick");
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack);
        }
        this.m_147285_(this.m_9236_(), compoundTag);
        this.setGotFish(compoundTag.m_128471_("GotFish"));
        this.setMoisntessLevel(compoundTag.m_128451_("Moistness"));
        this.updateContainerEquipment();
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(TREASURE_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(GOT_FISH, (Object)false);
        this.f_19804_.m_135372_(MOISTNESS_LEVEL, (Object)2400);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_6075_() {
        int $$0 = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply($$0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        } else {
            if (this.m_20071_()) {
                this.setMoisntessLevel(2400);
            } else {
                this.setMoisntessLevel(this.getMoistnessLevel() - 1);
                if (this.m_20096_() && !this.m_21824_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.5, 0.0));
                    this.m_6853_(false);
                    this.f_19812_ = true;
                }
            }
            if (this.m_9236_().f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.03) {
                Vec3 $$0 = this.m_20252_(0.0f);
                float $$1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float $$2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float $$3 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
                for (int $$4 = 0; $$4 < 2; ++$$4) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - $$0.f_82479_ * (double)$$3 + (double)$$1, this.m_20186_() - $$0.f_82480_, this.m_20189_() - $$0.f_82481_ * (double)$$3 + (double)$$2, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - $$0.f_82479_ * (double)$$3 - (double)$$1, this.m_20186_() - $$0.f_82480_, this.m_20189_() - $$0.f_82481_ * (double)$$3 - (double)$$2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void m_8107_() {
        BlockState blockState;
        ServerLevel serverLevel;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_21825_()) {
            this.idleAnimationState.m_216973_();
        } else {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_21825_() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.m_21825_() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if ((livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && this.m_20069_() && this.f_19862_) {
                for (int n = 0; n < 18; ++n) {
                    Level level = this.m_9236_();
                    if (!(level instanceof ServerLevel)) continue;
                    serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
                }
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
            }
            if ((this.f_19790_ != this.m_20185_() || this.f_19792_ != this.m_20189_()) && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                double d = Math.abs(this.m_20185_() - this.f_19790_);
                double d2 = Math.abs(this.m_20189_() - this.f_19792_);
                if ((d >= 0.003 || d2 >= 0.003) && this.m_20184_().f_82480_ < 1.0 && this.m_20184_().f_82480_ > -1.0) {
                    float headXRot = player.m_146909_();
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(headXRot / 2.0f * -0.0035f), 0.0));
                }
            }
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n = 0; n < 18; ++n) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(5.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    return InteractionResult.SUCCESS;
                }
                if (!itemStack.m_41619_() && itemStack.m_204117_(ItemTags.f_13156_)) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_5496_(SoundEvents.f_11803_, 1.0f, 1.0f);
                    }
                    this.setGotFish(true);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (this.m_21830_((LivingEntity)player) && this.canWearArmor() && this.isArmor(itemStack) && !this.isWearingArmor()) {
                    this.equipArmor(player, itemStack);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (!(this.m_6898_(itemStack) || !this.m_6254_() || this.m_20160_() || player.m_36341_() || this.m_21827_())) {
                    if (!this.m_9236_().f_46443_) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack) || this.m_21660_()) {
            if (!itemStack.m_41619_() && itemStack.m_204117_(ItemTags.f_13156_)) {
                if (!this.m_9236_().f_46443_) {
                    this.m_5496_(SoundEvents.f_11803_, 1.0f, 1.0f);
                }
                this.setGotFish(true);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(16) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("attack");
        }
        if (Main.isInFluid((LivingEntity)this)) {
            this.RushAttack();
        }
        if (bl = super.m_7327_(entity)) {
            this.m_5496_(SoundEvents.f_11801_, 1.0f, 1.0f);
        }
        return bl;
    }

    public boolean RushAttack() {
        float f = this.m_146908_();
        float f2 = this.m_146909_();
        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = 0.5f;
        float f8 = f4 *= f7 / f6 * 2.0f;
        this.m_20256_(this.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), (double)f8, (double)(f5 *= f7 / f6 * 2.0f)));
        return true;
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - 10;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_7822_(byte by) {
        if (by == 38) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        } else {
            super.m_7822_(by);
        }
    }

    private void addParticlesAroundSelf(ParticleOptions p_28338_) {
        for (int $$1 = 0; $$1 < 7; ++$$1) {
            double $$2 = this.f_19796_.m_188583_() * 0.01;
            double $$3 = this.f_19796_.m_188583_() * 0.01;
            double $$4 = this.f_19796_.m_188583_() * 0.01;
            this.m_9236_().m_7106_(p_28338_, this.m_20208_(1.0), this.m_20187_() + 0.2, this.m_20262_(1.0), $$2, $$3, $$4);
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return PrancedDolphinEntity.this.inventory.m_8020_(p_149503_);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                PrancedDolphinEntity.this.inventory.m_6836_(p_149503_, p_149528_);
                PrancedDolphinEntity.this.updateContainerEquipment();
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int p_149514_) {
        int j;
        int i = p_149514_ - this.getAddNumber();
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = p_149514_ - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(p_149514_);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    public boolean canWearArmor() {
        return true;
    }

    public void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            double n3;
            double n2;
            HorseArmorItem armor;
            int n;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22120_(ARMOR_TOUGHNESS_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof HorseArmorItem && (n = (armor = (HorseArmorItem)item).m_41368_()) != 0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "War Beast Armor bonus", (double)n, AttributeModifier.Operation.ADDITION));
            }
            if ((item = itemStack.m_41720_()) instanceof ItemBeastArmor && (n2 = (armor = (ItemBeastArmor)item).getToughness()) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22118_(new AttributeModifier(ARMOR_TOUGHNESS_MODIFIER_UUID, "War Beast Armor toughness bonus", n2, AttributeModifier.Operation.ADDITION));
            }
            if ((item = itemStack.m_41720_()) instanceof ItemBeastArmor && (n3 = (armor = (ItemBeastArmor)item).getKnockbackResistance() * 0.1) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "War Beast Armor knockback resistance bonus", n3, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void equipArmor(Player player, ItemStack itemStack) {
        if (this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack.m_255036_(1));
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
        }
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openSuchInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (!this.m_9236_().f_46443_) {
            player.m_147207_(new MobEffectInstance(MobEffects.f_19593_, 20, 0), (Entity)this);
            player.m_147207_(new MobEffectInstance(MobEffects.f_19608_, 20, 0), (Entity)this);
        }
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                if (this.m_6109_() && this.m_20069_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    this.m_19920_(this.m_6113_(), new Vec3((double)strafe, 0.0, (double)forward));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.75));
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                } else {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_) / 2.0f);
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
                }
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), dir);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(dir);
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_) / 2.0f);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28332_, DifficultyInstance p_28333_, MobSpawnType p_28334_, @Nullable SpawnGroupData p_28335_, @Nullable CompoundTag p_28336_) {
        this.m_20301_(this.m_6062_());
        this.m_146926_(0.0f);
        return super.m_6518_(p_28332_, p_28333_, p_28334_, p_28335_, p_28336_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    private static class DolphinSwimToTreasureGoal
    extends Goal {
        private final PrancedDolphinEntity dolphin;
        private boolean stuck;

        DolphinSwimToTreasureGoal(PrancedDolphinEntity p_28402_) {
            this.dolphin = p_28402_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            if (this.dolphin.m_21824_()) {
                return false;
            }
            return this.dolphin.gotFish() && this.dolphin.m_20146_() >= 100;
        }

        public boolean m_8045_() {
            if (this.dolphin.m_21824_()) {
                return false;
            }
            BlockPos $$0 = this.dolphin.getTreasurePos();
            return !BlockPos.m_274561_((double)$$0.m_123341_(), (double)this.dolphin.m_20186_(), (double)$$0.m_123343_()).m_203195_((Position)this.dolphin.m_20182_(), 4.0) && !this.stuck && this.dolphin.m_20146_() >= 100;
        }

        public void m_8056_() {
            if (this.dolphin.m_9236_() instanceof ServerLevel) {
                ServerLevel $$0 = (ServerLevel)this.dolphin.m_9236_();
                this.stuck = false;
                this.dolphin.m_21573_().m_26573_();
                BlockPos $$1 = this.dolphin.m_20183_();
                BlockPos $$2 = $$0.m_215011_(StructureTags.f_215883_, $$1, 50, false);
                if ($$2 != null) {
                    this.dolphin.setTreasurePos($$2);
                    $$0.m_7605_((Entity)this.dolphin, (byte)38);
                } else {
                    this.stuck = true;
                }
            }
        }

        public void m_8041_() {
            BlockPos $$0 = this.dolphin.getTreasurePos();
            if (BlockPos.m_274561_((double)$$0.m_123341_(), (double)this.dolphin.m_20186_(), (double)$$0.m_123343_()).m_203195_((Position)this.dolphin.m_20182_(), 4.0) || this.stuck) {
                this.dolphin.setGotFish(false);
            }
        }

        public void m_8037_() {
            Level $$0 = this.dolphin.m_9236_();
            if (this.dolphin.closeToNextPos() || this.dolphin.m_21573_().m_26571_()) {
                BlockPos $$3;
                Vec3 $$1 = Vec3.m_82512_((Vec3i)this.dolphin.getTreasurePos());
                Vec3 $$2 = DefaultRandomPos.m_148412_((PathfinderMob)this.dolphin, (int)16, (int)1, (Vec3)$$1, (double)0.3926991f);
                if ($$2 == null) {
                    $$2 = DefaultRandomPos.m_148412_((PathfinderMob)this.dolphin, (int)8, (int)4, (Vec3)$$1, (double)1.5707963705062866);
                }
                if (!($$2 == null || $$0.m_6425_($$3 = BlockPos.m_274446_((Position)$$2)).m_205070_(FluidTags.f_13131_) && $$0.m_8055_($$3).m_60647_((BlockGetter)$$0, $$3, PathComputationType.WATER))) {
                    $$2 = DefaultRandomPos.m_148412_((PathfinderMob)this.dolphin, (int)8, (int)5, (Vec3)$$1, (double)1.5707963705062866);
                }
                if ($$2 == null) {
                    this.stuck = true;
                    return;
                }
                this.dolphin.m_21563_().m_24950_($$2.f_82479_, $$2.f_82480_, $$2.f_82481_, (float)(this.dolphin.m_8085_() + 20), (float)this.dolphin.m_8132_());
                this.dolphin.m_21573_().m_26519_($$2.f_82479_, $$2.f_82480_, $$2.f_82481_, 1.3);
                if ($$0.f_46441_.m_188503_(this.m_183277_(80)) == 0) {
                    $$0.m_7605_((Entity)this.dolphin, (byte)38);
                }
            }
        }
    }

    static class DolphinSwimWithPlayerGoal
    extends Goal {
        private final PrancedDolphinEntity dolphin;
        private final double speedModifier;
        @Nullable
        private Player player;

        DolphinSwimWithPlayerGoal(PrancedDolphinEntity p_28413_, double p_28414_) {
            this.dolphin = p_28413_;
            this.speedModifier = p_28414_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.dolphin.m_21824_()) {
                return false;
            }
            this.player = this.dolphin.m_9236_().m_45946_(SWIM_WITH_PLAYER_TARGETING, (LivingEntity)this.dolphin);
            if (this.player == null) {
                return false;
            }
            return this.player.m_6069_() && this.dolphin.m_5448_() != this.player;
        }

        public boolean m_8045_() {
            if (this.dolphin.m_21824_()) {
                return false;
            }
            return this.player != null && this.player.m_6069_() && this.dolphin.m_20280_((Entity)this.player) < 256.0;
        }

        public void m_8056_() {
            this.player.m_147207_(new MobEffectInstance(MobEffects.f_19593_, 100), (Entity)this.dolphin);
        }

        public void m_8041_() {
            this.player = null;
            this.dolphin.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.dolphin.m_21563_().m_24960_((Entity)this.player, (float)(this.dolphin.m_8085_() + 20), (float)this.dolphin.m_8132_());
            if (this.dolphin.m_20280_((Entity)this.player) < 6.25) {
                this.dolphin.m_21573_().m_26573_();
            } else {
                this.dolphin.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
            if (this.player.m_6069_() && this.player.m_9236_().f_46441_.m_188503_(6) == 0) {
                this.player.m_147207_(new MobEffectInstance(MobEffects.f_19593_, 100), (Entity)this.dolphin);
            }
        }
    }

    private class PlayWithItemsGoal
    extends Goal {
        private int cooldown;

        PlayWithItemsGoal() {
        }

        public boolean m_8036_() {
            if (PrancedDolphinEntity.this.m_21827_()) {
                return false;
            }
            if (this.cooldown > PrancedDolphinEntity.this.f_19797_) {
                return false;
            }
            List $$0 = PrancedDolphinEntity.this.m_9236_().m_6443_(ItemEntity.class, PrancedDolphinEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !$$0.isEmpty() || !PrancedDolphinEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        public boolean m_8045_() {
            if (PrancedDolphinEntity.this.m_21827_()) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            List $$0 = PrancedDolphinEntity.this.m_9236_().m_6443_(ItemEntity.class, PrancedDolphinEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!$$0.isEmpty()) {
                PrancedDolphinEntity.this.m_21573_().m_5624_((Entity)$$0.get(0), (double)1.2f);
                PrancedDolphinEntity.this.m_5496_(SoundEvents.f_11806_, 1.0f, 1.0f);
            }
            this.cooldown = 0;
        }

        public void m_8041_() {
            ItemStack $$0 = PrancedDolphinEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (!$$0.m_41619_()) {
                this.drop($$0);
                PrancedDolphinEntity.this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.cooldown = PrancedDolphinEntity.this.f_19797_ + PrancedDolphinEntity.this.f_19796_.m_188503_(100);
            }
        }

        public void m_8037_() {
            List $$0 = PrancedDolphinEntity.this.m_9236_().m_6443_(ItemEntity.class, PrancedDolphinEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack $$1 = PrancedDolphinEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (!$$1.m_41619_()) {
                this.drop($$1);
                PrancedDolphinEntity.this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            } else if (!$$0.isEmpty()) {
                PrancedDolphinEntity.this.m_21573_().m_5624_((Entity)$$0.get(0), (double)1.2f);
            }
        }

        private void drop(ItemStack p_28429_) {
            if (!p_28429_.m_41619_()) {
                double $$1 = PrancedDolphinEntity.this.m_20188_() - (double)0.3f;
                ItemEntity $$2 = new ItemEntity(PrancedDolphinEntity.this.m_9236_(), PrancedDolphinEntity.this.m_20185_(), $$1, PrancedDolphinEntity.this.m_20189_(), p_28429_);
                $$2.m_32010_(40);
                $$2.m_32052_(PrancedDolphinEntity.this.m_20148_());
                float $$3 = 0.3f;
                float $$4 = PrancedDolphinEntity.this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float $$5 = 0.02f * PrancedDolphinEntity.this.f_19796_.m_188501_();
                $$2.m_20334_((double)(0.3f * -Mth.m_14031_((float)(PrancedDolphinEntity.this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(PrancedDolphinEntity.this.m_146909_() * ((float)Math.PI / 180))) + Mth.m_14089_((float)$$4) * $$5), (double)(0.3f * Mth.m_14031_((float)(PrancedDolphinEntity.this.m_146909_() * ((float)Math.PI / 180))) * 1.5f), (double)(0.3f * Mth.m_14089_((float)(PrancedDolphinEntity.this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(PrancedDolphinEntity.this.m_146909_() * ((float)Math.PI / 180))) + Mth.m_14031_((float)$$4) * $$5));
                PrancedDolphinEntity.this.m_9236_().m_7967_((Entity)$$2);
            }
        }
    }
}

