/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesFollowParentGoal;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotesvillage.entity.Other.PurpleSandGeckoTailEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;

public class PurpleSandGeckoEntity
extends Animal
implements JerotesEntity {
    public AnimationState wallAnimationState = new AnimationState();
    public AnimationState hurtAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(PurpleSandGeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(PurpleSandGeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TAIL_TICK = SynchedEntityData.m_135353_(PurpleSandGeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(PurpleSandGeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> NO_TAIL = SynchedEntityData.m_135353_(PurpleSandGeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_, Items.f_42592_});
    private static final Ingredient LUCK_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_, Items.f_151079_, (ItemLike)JerotesVillageItems.SECOND_ROUND_NIGRUM.get(), (ItemLike)JerotesVillageItems.COOKED_SECOND_ROUND_NIGRUM.get()});

    public PurpleSandGeckoEntity(EntityType<? extends PurpleSandGeckoEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new JerotesFollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public boolean isNoTail() {
        return (Boolean)this.m_20088_().m_135370_(NO_TAIL);
    }

    public void setNoTail(boolean bl) {
        this.m_20088_().m_135381_(NO_TAIL, (Object)bl);
    }

    public void setTailTick(int n) {
        this.m_20088_().m_135381_(TAIL_TICK, (Object)n);
    }

    public int getTailTick() {
        return (Integer)this.m_20088_().m_135370_(TAIL_TICK);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "hurt")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.hurtAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsNoTail", this.isNoTail());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("TailTick", this.getTailTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("IsNoTail")) {
            this.setNoTail(compoundTag.m_128471_("IsNoTail"));
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setTailTick(compoundTag.m_128451_("TailTick"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(NO_TAIL, (Object)false);
        this.m_20088_().m_135372_(TAIL_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.hurtAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.hurtAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (this.isNoTail()) {
            if (!this.m_9236_().m_5776_()) {
                this.setTailTick(Math.min(72000, this.getTailTick() + 1));
            }
            if (this.getTailTick() >= 72000) {
                if (!this.m_9236_().m_5776_()) {
                    this.setNoTail(false);
                    this.setTailTick(0);
                }
                for (int i = 0; i < 7; ++i) {
                    double d = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    double d3 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123767_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, d2, d3);
                }
            }
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.isClimbing()) {
            this.wallAnimationState.m_216977_(this.f_19797_);
        } else {
            this.wallAnimationState.m_216973_();
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(2.0f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - 12;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        LivingEntity livingEntity;
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (!this.m_9236_().f_46443_) {
            Projectile projectile;
            Entity entity;
            Entity entity2;
            if (damagesource.m_7639_() != null && (entity2 = damagesource.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity2;
                livingEntity2.m_21195_(MobEffects.f_19621_);
                if (!livingEntity2.m_9236_().f_46443_) {
                    livingEntity2.m_147207_(new MobEffectInstance(MobEffects.f_19590_, 6000, 0), (Entity)this);
                }
            }
            if (damagesource.m_7639_() != null && (entity = damagesource.m_7639_()) instanceof Projectile && (projectile = (Projectile)entity).m_19749_() != null && (entity = projectile.m_19749_()) instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                livingEntity.m_21195_(MobEffects.f_19621_);
                if (!livingEntity.m_9236_().f_46443_) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19590_, 6000, 0), (Entity)this);
                }
            }
        }
        if (EntityAndItemFind.isMeleeDamage((DamageSource)damagesource) && !this.isNoTail()) {
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(20);
                this.setAnimationState("hurt");
            }
            if ((double)this.f_19796_.m_188501_() > 0.3 && this.m_6084_()) {
                if (!this.m_9236_().m_5776_()) {
                    this.setNoTail(true);
                }
                if ((livingEntity = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)livingEntity;
                    PurpleSandGeckoTailEntity tail = (PurpleSandGeckoTailEntity)((EntityType)JerotesVillageEntityType.PURPLE_SAND_GECKO_TAIL.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), MobSpawnType.MOB_SUMMONED);
                    PlayerTeam teams = (PlayerTeam)this.m_5647_();
                    if (tail != null) {
                        if (teams != null) {
                            serverLevel.m_6188_().m_6546_(tail.m_20149_(), teams);
                        }
                        if (this.m_6162_()) {
                            tail.m_6863_(true);
                        }
                        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(1.5, 1.3, 1.5));
                        for (LivingEntity entity : list) {
                            Mob mob;
                            if (entity == null || entity == this || (double)this.m_20270_((Entity)entity) > 32.0) continue;
                            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == this) {
                                mob.m_6710_((LivingEntity)tail);
                            }
                            if (entity.m_21214_() != this) continue;
                            entity.m_21335_((Entity)tail);
                        }
                    }
                }
                if (!this.m_9236_().f_46443_) {
                    this.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 1200, 0), (Entity)this);
                }
                this.setAnimationState(0);
                if (!this.m_9236_().m_5776_()) {
                    this.setTailTick(0);
                }
            }
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean bl) {
        byte by = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)by);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 6.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.PURPLE_SAND_GECKO_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.PURPLE_SAND_GECKO_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.PURPLE_SAND_GECKO_DEATH;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public boolean isLuck(ItemStack itemStack) {
        return LUCK_ITEMS.test(itemStack);
    }

    @Nullable
    public PurpleSandGeckoEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (PurpleSandGeckoEntity)((EntityType)JerotesVillageEntityType.PURPLE_SAND_GECKO.get()).m_20615_((Level)serverLevel);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (this.isLuck(itemStack)) {
            player.m_5496_(JerotesVillageSounds.PURPLE_SAND_GECKO_AMBIENT, 2.0f, 1.0f);
            if (!player.m_9236_().f_46443_) {
                player.m_147207_(new MobEffectInstance(MobEffects.f_19621_, 6000, 0), (Entity)this);
            }
            for (int i = 0; i < 7; ++i) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                double d3 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, d2, d3);
            }
            if (this.isNoTail() && !this.m_9236_().m_5776_()) {
                this.setTailTick(this.getTailTick() + 7200);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 0.3f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }
}

